// * File:     MultiSaver\uTriangleSaver.pas
// * Created:  2001-06-01
// * Modified: 2010-12-29
// * Version:  1.1.47.72
// * Author:   David Safranek (Safrad)
// * E-Mail:   safrad at email.cz
// * Web:      http://safrad.own.cz

unit uTriangleSaver;

interface

uses
	uSaver, uTypes,
	Graphics;

const
	PointCount = 5;
	PolygonCount = 8;
type
	TCurvePoint = record
		XYZ: array[0..2] of TFlo;
		VXYZ: array[0..2] of TFlo;
	end;
	TCurve = record
		Points: array[0..PointCount - 1] of TCurvePoint;
		Color: TColor;
	end;

	TTriangleSaver = class(TSaver)
	private
		SpectrumC: SG;
		Curves: array[0..7] of TCurve;
		LookAngleX, LookAngleY: TFlo;
	public
		constructor Create; override;
		destructor Destroy; override;
		procedure Draw; override;
		procedure Step; override;
	end;

implementation

uses
	uMath, uColor,
	OpenGL12;

{ TTriangleSaver }

constructor TTriangleSaver.Create;
begin
	inherited;

end;

destructor TTriangleSaver.Destroy;
begin

	inherited;
end;

procedure TTriangleSaver.Draw;
begin
	inherited;
	glClear(GL_COLOR_BUFFER_BIT);

	glScalef(7, 7, 1);
	glTranslatef(0,0,-5 {+ LinearMax(16 * fMain.DTimer.Clock div PerformanceFrequency, 32)});
	glRotatef(2 * LookAngleX,0,1,0);
//	glRotatef(Angle,1,0,0);
	glRotatef(LookAngleX,0,0,1);
	glRotatef(30,1,0,0);      // do another rotation for better view (accumulates to first rot.)
//	glScalef(1, sin(CubeAngleX * pi / 90), 1); // simulate bumping

	DrawTetrahedron;

	glLoadIdentity;

	glScalef(7, 7, 1);
	glRotatef(LookAngleX, 1, 0, 0);
	glRotatef(LookAngleY, 0, 1, 0);
	glRotatef(30, 1, 0, 0);
//	glScalef(2, 2 * Sin(CubeAngleX * pi / 90), 2); // simulate bumping

	DrawTetrahedron;
end;

procedure TTriangleSaver.Step;
var
	C: TColor;
	i, j, k: SG;
	t: TFlo;
	VXYZ: array[0..2] of TFlo;
begin
	inherited;
	Mode2D := True;
	LookAngleX := LookAngleX + 128 * ElapsedTime / PerformanceFrequency;
	LookAngleY := LookAngleY + 128 * ElapsedTime / PerformanceFrequency;
	if SpectrumC > MaxSpectrum then SpectrumC := 0 else Inc(SpectrumC);
	for i := 6 downto 0 do
	begin
		Curves[i + 1] := Curves[i];
	end;
	for i := 0 to 0 do
	begin
		C := SpectrumColor(SpectrumC);
		Curves[i].Color := C;
		t := 16 * ElapsedTime / PerformanceFrequency;
		for j := 0 to PointCount - 1 do
		begin
			for k := 0 to 2 do
			begin
				VXYZ[k] := t * (Random2(2) / 100 {- (Curves[i].Points[j].XYZ[k]) / 100});

				Curves[i].Points[j].XYZ[k] := Curves[i].Points[j].XYZ[k] + t * (Curves[i].Points[j].VXYZ[k] + 0.5 * VXYZ[k]);

				Curves[i].Points[j].VXYZ[k] := Curves[i].Points[j].VXYZ[k] + VXYZ[k];

				if Curves[i].Points[j].XYZ[k] > 5 then
				begin
					Curves[i].Points[j].XYZ[k] := 5;
					Curves[i].Points[j].VXYZ[k] := -Curves[i].Points[j].VXYZ[k];
				end
				else if Curves[i].Points[j].XYZ[k] < -5 then
				begin
					Curves[i].Points[j].XYZ[k] := -5;
					Curves[i].Points[j].VXYZ[k] := -Curves[i].Points[j].VXYZ[k];
				end
			end;
		end;
	end;
end;

end.
