// * File:     MultiSaver\uPlanetsSaver.pas
// * Created:  2001-06-01
// * Modified: 2011-01-18
// * Version:  1.1.47.72
// * Author:   David Safranek (Safrad)
// * E-Mail:   safrad at email.cz
// * Web:      http://safrad.own.cz

unit uPlanetsSaver;

interface

uses uTypes, uSaver, uStarsSaver;

type
	TPlanet = (
		plSun,
		plMercury,
		plVenus,
		plEarth,
		plMars,
		plJupiter,
		plSaturn,
		plSatini, // Uran
		plNeptune,
		plPluto);

	TPlanetR = record
		RX, RY, RZ: TFlo;
		VX, VY, VZ: TFlo;
//		AX, AY, AZ: TFlo;
		FX, FY, FZ: TFlo;
		m: TFlo;
	end;

	TPlanetsSaver = class(TStarsSaver)
	private
		LocalTexturesInitialized: BG;
		PlanetAngleX, PlanetAngleY: TFlo;
		Planets: array[TPlanet] of TPlanetR;
	public
		constructor Create; override;
		destructor Destroy; override;
		procedure Initialize; override;
		procedure Draw; override;
		procedure SetCamera; override;
		procedure Step; override;
	end;

implementation

uses
	uDBitmap, uDrawStyle,
	uFiles, uMath, uColor,
	Math, OpenGL12, Graphics, SysUtils;

var
	TexturesInitialized: BG;

const
	ColorOnly = False;
const
	Kapa = 0.0000000000000003;
	Zoom = 0.0000005;
	PlanetNames: array[TPlanet] of string = (
		'Sun',
		'Mercury',
		'Venus',
		'Earth',
		'Mars',
		'Jupiter',
		'Saturn',
		'Uran',
		'Neptune',
		'Pluto');

{	PlanetRadius: array[TPlanet] of Integer = ( // orig km
		5000000 div 2,
		4878 div 2,
		12104 div 2,
		12756 div 2,
		6796 div 2,
		142796 div 2,
		120660 div 2,
		52400 div 2,
		48600 div 2,
		2400 div 2);}
	PlanetRadius: array[TPlanet] of Integer = ( // km
		5000000 div 2,
		487800 div 2,
		1210400 div 2,
		1275600 div 2,
		679600 div 2,
		1427960 div 2,
		1206600 div 2,
		524000 div 2,
		486000 div 2,
		240000 div 2);

	PlanetRinglet: array[TPlanet] of Integer = ( // km
		0,
		0,
		0,
		0,
		0,
		258400 div 2,
		272400 div 2,
		102400 div 2,
		0,
		0);

{	SunLength: array[TPlanet] of TFlo = ( // orig km
		0000000000,
		0057900000,
		0108200000,
		0149600000,
		0227900000,
		0778300000,
		1429200000,
		2875000000,
		4504000000,
		5900000000);}
	SunLength: array[TPlanet] of TFlo = ( // km
		000000000,
		005790000,
		010820000,
		014960000,
		022790000,
		077830000,
		142920000,
		287500000,
		450400000,
		590000000);

var
	Map: array[TPlanet] of TDBitmap;
	TexPlanets: array[TPlanet] of GLUint;

function Len(O1, O2: TPlanetR): TFlo;
begin
	Result := (Sqr(O1.RX - O2.RX) + Sqr(O1.RY - O2.RY) + Sqr(O1.RZ - O2.RZ));
end;

(*
procedure CreatePlanet(Id: SG; Planet: TPlanet);
const
	Heig = 31;
	Frag = 32;
var
	dx, dy, dz: array[0..Heig - 1, 0..Frag - 1] of TFlo;
	d: TFlo;
	i, j, k, l: SG;
	x, y: SG;
	C: TRColor;
begin
		for j := 0 to Heig - 1 do
		begin
			d := Sin(pi * ((Heig div 2 - Abs(Heig div 2 - j)) / (Heig div 1)));

			for i := 0 to Frag - 1 do
			begin
	{			if j = 1 then
				begin}
	//        d := (Heig div 2 - Abs(Heig div 2 - j)) / (Heig div 2);
					dx[j, i] := Zoom * PlanetRadius[Planet] * d * Cos(2 * i / Frag * pi) {+ Random(10) / 100};
					dy[j, i] := Zoom * PlanetRadius[Planet] * d * Sin(2 * i / Frag * pi) {+ Random(10) / 100};
	{			end
				else
				begin
					dx[j, i] := 0;
					dy[j, i] := 0;
				end;}
//				dz[j, i] := 2 * j / Heig;
//				dz[j, i] := 2 * Sin(pi * j / (2 * Heig));
//				dz[j, i] := 1 * Cos(pi * ((Heig div 2 - Abs(Heig div 2 - j)) / Heig));
				dz[j, i] := Zoom * PlanetRadius[Planet] * Sin(pi * (Heig div 2 - j) / Heig);

			end;

		end;

		for j := 0 to Heig - 2 do
		for i := 0 to Frag - 1 do
		begin
				glBegin(GL_POLYGON);
					k := i mod Frag;

					if Id <> 0 then
						glColor3ub(255, 223, 0);

					if Id = 0 then
					begin
						x := k * SG(Map24[Planet].Width) div Frag;
						y := j * SG(Map24[Planet].Height) div Heig;
						C := TRColor(GetPix(Map24[Planet].PData, Map24[Planet].ByteX, x, y));
						glColor3ub(C.B, C.G, C.R);
					end
					else
						glColor3ub(255, 255 * j div Heig, 0);

					glNormal3f(dx[j, k], dy[j, k], dz[j, k]);
					glVertex3f(dx[j, k], dy[j, k], dz[j, k]);

//					glColor3ub(0, 255, 0);
					k := (i + 1) mod Frag;
					if Id = 0 then
					begin
						x := k * SG(Map24[Planet].Width) div Frag;
						y := j * SG(Map24[Planet].Height) div Heig;
						C := TRColor(GetPix(Map24[Planet].PData, Map24[Planet].ByteX, x, y));
						glColor3ub(C.B, C.G, C.R);
					end;
					glVertex3f(dx[j, k], dy[j, k], dz[j, k]);

//					glColor3ub(0, 255, 0);
					k := (i + 1) mod Frag;
					l := j + 1;
					if Id = 0 then
					begin
						x := k * SG(Map24[Planet].Width) div Frag;
						y := l * SG(Map24[Planet].Height) div Heig;
						C := TRColor(GetPix(Map24[Planet].PData, Map24[Planet].ByteX, x, y));
						glColor3ub(C.B, C.G, C.R);
					end
					else
						glColor3ub(255, 255 * (j + 1) div Heig, 0);
					glVertex3f(dx[l, k], dy[l, k], dz[l, k]);

//					glColor3ub(0, 0, 255);
					k := i mod Frag;
					l := j + 1;
					if Id = 0 then
					begin
						x := k * SG(Map24[Planet].Width) div Frag;
						y := l * SG(Map24[Planet].Height) div Heig;
						C := TRColor(GetPix(Map24[Planet].PData, Map24[Planet].ByteX, x, y));
						glColor3ub(C.B, C.G, C.R);
					end;
					glVertex3f(dx[l, k], dy[l, k], dz[l, k]);
				glEnd;
		end;
end;
*)

{ TPlanetsSaver }

constructor TPlanetsSaver.Create;
var
	Planet: TPlanet;
begin
	inherited;
	if Map[plSun] = nil then
		for Planet := Low(TPlanet) to High(TPlanet) do
		begin
			Map[Planet] := TDBitmap.Create;
			Map[Planet].LoadFromFile(GraphDir + 'Planets' + PathDelim + PlanetNames[Planet] + '.jpg');
			Map[Planet].GLSetSize;
		end;
end;

procedure FreePlanets;
var Planet: TPlanet;
begin
	if not TexturesInitialized then Exit;
	for Planet := Low(PlanetNames) to High(PlanetNames) do
	begin
		FreeAndNil(Map[Planet]);
	end;
	glDeleteTextures(Length(TexPlanets), @TexPlanets[TPlanet(0)]);
end;

destructor TPlanetsSaver.Destroy;
begin
	inherited;
end;

procedure TPlanetsSaver.Draw;
var
	Obj: PGLUquadricObj;
	Planet: TPlanet;
	C: TRGBA;
	L: SG;
	Len: TFlo;
begin
	inherited;
	if not TexturesInitialized then
	begin
		TexturesInitialized := True;
		glGenTextures(Length(TexPlanets), @TexPlanets[TPlanet(0)]);
	end;
	if not LocalTexturesInitialized then
	begin
		LocalTexturesInitialized := True;
		for Planet := Low(TPlanet) to High(TPlanet) do
		begin
			if Planet <> plSun then
			begin
				glBindTexture(GL_TEXTURE_2D, TexPlanets[Planet]);
				glTexImage2D(GL_TEXTURE_2D, 0, GL_FORMAT, Map[Planet].Width,
					Map[Planet].Height, 0, GL_FORMAT, GL_UNSIGNED_BYTE,
					Map[Planet].GLData);
				glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
				glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
				glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
				glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
			end;
		end;
	end;
		{	glLightf(GL_LIGHT0, GL_SPOT_CUTOFF, 90);}

//	glMaterialfv(GL_FRONT, GL_AMBIENT_AND_DIFFUSE, @glfMaterialColor[0]);


	// Sun
{	glColor3ub(255, 128, 64);
	glTranslatef(0, 0, 0);

	glScalef(1 + Random(2) / 100, 1 + Random(2) / 100, 1 + Random(2) / 100);

	glTexImage2D(GL_TEXTURE_2D, 0, GL_FORMAT, Map[plSun].Width,
		Map[plSun].Height, 0, GL_FORMAT, GL_UNSIGNED_BYTE,
		Map[plSun].ScanLine[Map[plSun].Height - 1]);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
	glEnable(GL_TEXTURE_2D);

	Obj := gluNewQuadric;
	gluQuadricDrawStyle(Obj, GLU_FILL);
	gluQuadricTexture(Obj, GL_TRUE);
	gluQuadricNormals(Obj, GLU_SMOOTH);
	gluSphere(Obj, 1, 32, 32);}

	// L0
	glEnable(GL_LIGHT0);
	LightPos[0] := Zoom * Planets[plSun].RX;
	LightPos[1] := Zoom * Planets[plSun].RY;
	LightPos[2] := Zoom * Planets[plSun].RZ;
	glLightfv(GL_LIGHT0, GL_AMBIENT, @glfLightAmbient[0]);
//	glLightfv(GL_LIGHT0, GL_AMBIENT, @glfBlackColor[0]);
//	glLightfv(GL_LIGHT0, GL_DIFFUSE, @glfLightDiffuse[0]);
	glLightfv(GL_LIGHT0, GL_DIFFUSE, @glfWhiteColor[0]);
//	glLightfv(GL_LIGHT0, GL_SPECULAR, @glfSilverColor[0]);
	glLightfv(GL_LIGHT0, GL_SPECULAR, @glfBlackColor[0]);
	glLightfv(GL_LIGHT0, GL_POSITION, @LightPos[0]);
	glLightf(GL_LIGHT0, GL_SPOT_CUTOFF, 180);
{	glLightf(GL_LIGHT0, GL_CONSTANT_ATTENUATION, 2.0);
	glLightf(GL_LIGHT0, GL_LINEAR_ATTENUATION, 1.0);
	glLightf(GL_LIGHT0, GL_QUADRATIC_ATTENUATION, 0.5);}
//	glLightfv(GL_LIGHT0, GL_SPOT_DIRECTION, @glfDirect[0]);

	Obj := gluNewQuadric;
	for Planet := Low(TPlanet) to High(TPlanet) do
	begin
//		if Planet = plSun then Continue;

{		LightPos[0] := Planets[Planet].X;
		LightPos[1] := Planets[Planet].Y;
		LightPos[2] := Planets[Planet].Z;
		glLightfv(GL_LIGHT0, GL_POSITION, @LightPos[0]);}

		glLoadIdentity;
		glTranslatef(Zoom * Planets[Planet].RX, Zoom * Planets[Planet].RY, Zoom * Planets[Planet].RZ);
		if Planet <> plSun then
		begin
			glRotatef(Integer(Planet) * PlanetAngleX / 10, 1, 0, 0);
			glRotatef(Integer(Planet) * PlanetAngleY / 10, 0, 1, 0);
		end
		else
		begin
			glScalef(1 + Random(2) / 100, 1 + Random(2) / 100, 1 + Random(2) / 100);
		end;


{		if Planet = plEarth then
		begin
			CreatePlanet(0, Planet);
		end
		else}
		if Map[Planet] <> nil then
		begin
			C.L := clWhite;
			glColor3ubv(@TRGBA(C).R);
			if ColorOnly = False then
			begin
				glEnable(GL_TEXTURE_2D);
				if Planet = plSun then
				begin
					glTexImage2D(GL_TEXTURE_2D, 0, GL_FORMAT, Map[Planet].Width,
						Map[Planet].Height, 0, GL_FORMAT, GL_UNSIGNED_BYTE,
						Map[Planet].GLData);
					glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
					glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
					glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
					glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
					glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
				end
				else
				begin
					glBindTexture(GL_TEXTURE_2D, TexPlanets[Planet]);
					glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
				end;
			end;

			gluQuadricDrawStyle(Obj, GLU_FILL);
			if ColorOnly then
				gluQuadricTexture(Obj, GL_FALSE)
			else
				gluQuadricTexture(Obj, GL_TRUE);
			gluQuadricNormals(Obj, GLU_SMOOTH);

			Len := UserLen(Planets[Planet].RX, Planets[Planet].RY, Planets[Planet].RZ) / (PlanetRadius[Planet]);
			if Abs(Len) < 1 then
				L := 32
			else
				L := Round(1600 / Len);
			if L < 4 then L := 4;
			if L > 32 then L := 32;
			gluSphere(Obj, Zoom * PlanetRadius[Planet], L, L);

			if ColorOnly = False then
			begin
				glDisable(GL_TEXTURE_2D);
			end;
		end;
		if PlanetRinglet[Planet] > 0 then
		begin
//			glDisable(GL_LIGHTING);
			glEnable(GL_BLEND);
//			glBlendFunc(GL_ONE, GL_SRC_COLOR);
			glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
			glColor4ub(127, 127, 127, 127);

//			Obj := gluNewQuadric;
			gluQuadricDrawStyle(Obj, GLU_FILL);
			gluQuadricTexture(Obj, GL_FALSE);
			gluQuadricNormals(Obj, GLU_FLAT);
			gluDisk(Obj, Zoom * 1.1 * PlanetRadius[Planet],
				Zoom * (1.1 * PlanetRadius[Planet] + PlanetRinglet[Planet]), 64, 1);

			glColor4ub(127, 127, 127, 255);
			glDisable(GL_BLEND);
//			glEnable(GL_LIGHTING);
		end;
	end;
	gluDeleteQuadric(Obj);
end;

procedure TPlanetsSaver.Initialize;
var
	i: SG;
	Planet: TPlanet;
begin
	inherited;
	PlanetAngleX := 0;
	PlanetAngleY := 0;

	for Planet := Low(TPlanet) to High(TPlanet) do
	begin
		Planets[Planet].m := (4 / 3) * pi * IntPower(PlanetRadius[Planet], 3);
		Planets[Planet].RX := SunLength[Planet];
		Planets[Planet].RY := 0;
		Planets[Planet].RZ := 0;

		Planets[Planet].VX := 0;
		if Planets[Planet].RX <= 0 then
			Planets[Planet].VY := 0
		else
		begin
//			if Planet = plMercury then
			Planets[Planet].VY := Sqrt(IntPower((1/3), SG(Planet) - 1) * Kapa * Planets[plSun].m * Planets[Planet].RX)
{			else if Planet = plVenus then
				Planets[Planet].VY := Sqrt(0.3 * Kapa * Planets[plSun].m * Planets[Planet].RX)
			else
				Planets[Planet].VY := Sqrt(0.1 * Kapa * Planets[plSun].m * Planets[Planet].RX)}
		end;
		Planets[Planet].VZ := 0;

		Planets[Planet].FX := 0;
		Planets[Planet].FY := 0;
		Planets[Planet].FZ := 0;
	end;

	for i := 0 to StarsCount - 1 do
	begin
		stX[i] := Random2(255);
		stY[i] := Random2(255);
		stZ[i] := Random2(255);
	end;
end;

procedure TPlanetsSaver.SetCamera;
begin
	inherited;
	Mode2D := False;
	UserX := -20 * Sin(0.5 * Clock / PerformanceFrequency);
	UserZ := 20 * Cos(0.5 * Clock / PerformanceFrequency) - 5;
	UserY := 0;
{				AngleXZ := 0.5 * fMain.Timer1.Clock / PerformanceFrequency;
	AngleY := 0;}
	LookTo(Zoom * Planets[plSun].RX, Zoom * Planets[plSun].RY, Zoom * Planets[plSun].RZ);
end;

procedure TPlanetsSaver.Step;
var
	i, j: SG;
	C: TRGBA;
	Planet, Planet1: TPlanet;
	k: TFlo;
	Le: TFlo;
	t: TFlo;
	VX, VY, VZ: TFlo;
begin
//	inherited; Disable star movement.
	for j := 0 to Map[plSun].Height - 1 do
	for i := 0 to Map[plSun].Width - 1 do
	begin
		C.L := FireColor(Random(2 * MaxFireColor div 3));
		C.L := ColorRB(NegColor(C.L));
		Pix(Map[plSun].Data, Map[plSun].ByteX, i, j, @C, ef01);
	end;

	for Planet := Low(TPlanet) to High(TPlanet) do
	begin
		Planets[Planet].FX := 0;
		Planets[Planet].FY := 0;
		Planets[Planet].FZ := 0;
	end;

	for Planet := Low(TPlanet) to High(TPlanet) do
		for Planet1 := Low(TPlanet) to High(TPlanet) do
			if Planet <> Planet1 then
//			if (Planet1 = plSun) and (Planet <> plSun) then
			begin
				k := Kapa * Planets[Planet].m * Planets[Planet1].m;
				Le := Len(Planets[Planet], Planets[Planet1]);
				if Sqrt(Le) >= (PlanetRadius[Planet] + PlanetRadius[Planet1]) then
				begin
					Le := 0.00000000000003 * Le * Sqrt(Le);
//        if Abs(O[i].rx - O[i2].rx) > 100 then
				begin
					Planets[Planet].FX := Planets[Planet].FX + k * (Planets[Planet1].RX - Planets[Planet].RX) / Le;
//          O[i].fx := O[i].fx + l * Sqr(O[i].vx) / (O[i2].rx - O[i].rx);
				end;
//        if Abs(O[i].ry - O[i2].ry) > 100 then
				begin
					Planets[Planet].FY := Planets[Planet].FY + k * (Planets[Planet1].RY - Planets[Planet].RY) / Le;
//          O[i].fy := O[i].fy + l * Sqr(O[i].vy) / (O[i2].ry - O[i].ry);
				end;
//        if Abs(O[i].rz - O[i2].rz) > 100 then
				begin
					Planets[Planet].FZ := Planets[Planet].FZ + k * (Planets[Planet1].RZ - Planets[Planet].RZ) / Le;
//          O[i].fz := O[i].fz + l * Sqr(O[i].vz) / (O[i2].rz - O[i].rz);
				end;
				end
				else
				begin // Crash
{							Planets[Planet].VX := 0;
					Planets[Planet].VY := 0;
					Planets[Planet].VZ := 0;
					Planets[Planet].FX := 0;
					Planets[Planet].FY := 0;
					Planets[Planet].FZ := 0;}
				end;
			end;

			t := 64 * ElapsedTime / PerformanceFrequency;
			for Planet := Low(TPlanet) to High(TPlanet) do
			begin
				VX := t * (Planets[Planet].FX / Planets[Planet].m + Random2(1));
				VY := t * (Planets[Planet].FY / Planets[Planet].m + Random2(1));
				VZ := t * (Planets[Planet].FZ / Planets[Planet].m + Random2(1));
				Planets[Planet].RX := Planets[Planet].RX + t * (Planets[Planet].VX + 0.5 * VX);
				Planets[Planet].RY := Planets[Planet].RY + t * (Planets[Planet].VY + 0.5 * VY);
				Planets[Planet].RZ := Planets[Planet].RZ + t * (Planets[Planet].VZ + 0.5 * VZ);

				Planets[Planet].VX := Planets[Planet].VX + VX;
				Planets[Planet].VY := Planets[Planet].VY + VY;
				Planets[Planet].VZ := Planets[Planet].VZ + VZ;

		//    if Abs(O[i].rz) > 10000 then
{						Planets[Planet].RX := 0;
				Planets[Planet].RY := 0;
				Planets[Planet].RZ := 0;}
			end;

(*			for Planet := Low(TPlanet) to High(TPlanet) do
	begin
		if Planet <> plSun then
		begin
			Planets[Planet].X := 0.001 * Zoom * SunLength[Planet] * Sin({(SG(Planet) + 1) *} 0.1 * fMain.Timer1.Clock / PerformanceFrequency + 0 + SG(Planet));
			Planets[Planet].Y := 0.001 * Zoom * SunLength[Planet] * Sin({(SG(Planet) + 1) *} 0.1 * fMain.Timer1.Clock / PerformanceFrequency + pi / 4 + SG(Planet) / 10);
			Planets[Planet].Z := 0.001 * Zoom * SunLength[Planet] * Sin({(SG(Planet) + 1) *} 0.1 * fMain.Timer1.Clock / PerformanceFrequency + pi / 2 + SG(Planet) / 3)
		end;

	end;  *)

	PlanetAngleX := PlanetAngleX + 64 * ElapsedTime / PerformanceFrequency;
	PlanetAngleY := PlanetAngleY + 32 * ElapsedTime / PerformanceFrequency;
{			EarthX := 3 * Cos(0.3 * fMain.Timer1.Clock / PerformanceFrequency);
	EarthY := 3 * Sin(0.3 * fMain.Timer1.Clock / PerformanceFrequency);}
end;

initialization
finalization
	FreePlanets;
end.
