// * File:     MultiSaver\uCurvesSaver.pas
// * Created:  2007-05-06
// * Modified: 2011-01-06
// * Version:  1.1.47.72
// * Author:   David Safranek (Safrad)
// * E-Mail:   safrad at email.cz
// * Web:      http://safrad.own.cz

unit uCurvesSaver;

interface

uses
	uTypes, uSaver,
	Graphics;

const
	CurveSpeed = 10;
type
	TCurvePoint2 = record
		X, Y: TFlo;
		DX, DY: TFlo;
		C: TColor;
	end;

	TCurvesSaver = class(TSaver)
	private
		CurvePoints: array[0..3] of TCurvePoint2;
		Id: SG;
		Element: SG;
	public
		constructor Create; override;
		destructor Destroy; override;
		procedure Initialize; override;
		procedure Draw; override;
		procedure Step; override;
	end;

implementation

uses uSGL, uColor, uMath, uMain;

{ TCurvesSaver }

constructor TCurvesSaver.Create;
begin
	inherited;
	Id := -1;
	Mode2D := True;
end;

destructor TCurvesSaver.Destroy;
begin
	sglDestroyDrawable(Id);
	inherited;
end;

procedure TCurvesSaver.Draw;
var
	i: SG;
begin
	inherited;
	sglSetDrawable(Id);
	sglRecreateDrawable(Id, TfMain(ParentForm).BmpD.Width, TfMain(ParentForm).BmpD.Height, TfMain(ParentForm).BmpD.Data);
	sglClear(0, 0, 0, 0);

	sglBegin(sglEElementType(SG(sglBezierGCurve) + Element));
//		if E <> sglFergusonCurve then
	for i := 0 to Length(CurvePoints) - 1 do
	begin
//		if (i = Length(CurvePoints) - 1) and (j <> 1) then Break;
		sglColor(CurvePoints[i].C);
		sglVertex(CurvePoints[i].X, CurvePoints[i].Y);

		if Element = 2 then
		begin
			if (i = Length(CurvePoints) - 1) then
				sglVertex(0, 0)
			else
				sglVertex(2 * (-CurvePoints[i].X + TfMain(ParentForm).BmpD.Width div 2), 2 * (-CurvePoints[i].Y + TfMain(ParentForm).BmpD.Height div 2));
//				sglVertex(100, 100)
//				sglVertex(CurvePoints[i].X - BmpD.Width div 2, CurvePoints[i].Y - BmpD.Height div 2);
		end;
//			sglVertex(0, -1000);
//		CurvePoints[i].C.L := SpectrumColor(Random(MaxSpectrum + 1));
	end;
	sglEnd;
end;

procedure TCurvesSaver.Initialize;
var
	i: SG;
begin
	inherited;
	sglDestroyDrawable(Id);
	Id := sglCreateDrawable(TfMain(ParentForm).BmpD.Width, TfMain(ParentForm).BmpD.Height, TfMain(ParentForm).BmpD.Data);
	sglSetDrawable(Id);
	for i := 0 to Length(CurvePoints) - 1 do
	begin
		CurvePoints[i].X := Random(TfMain(ParentForm).BmpD.Width);
		CurvePoints[i].Y := Random(TfMain(ParentForm).BmpD.Height);
		CurvePoints[i].DX := Random(CurveSpeed);
		CurvePoints[i].DY := Random(CurveSpeed);
		CurvePoints[i].C :=  SpectrumColor(MaxSpectrum * i div Length(CurvePoints));  // SpectrumColor(Random(MaxSpectrum + 1));
	end;
	Element := Random(3);
end;

procedure TCurvesSaver.Step;
var i: SG;
begin
	inherited;
	for i := 0 to Length(CurvePoints) - 1 do
	begin
		CurvePoints[i].DX := CurvePoints[i].DX + Random2(1);
		CurvePoints[i].DY := CurvePoints[i].DY + Random2(1);
		CurvePoints[i].X := CurvePoints[i].X + 25 * ElapsedTime * CurvePoints[i].DX / PerformanceFrequency;
		if CurvePoints[i].X < 0 then
		begin
			CurvePoints[i].X := 0;
			CurvePoints[i].DX := -3 * CurvePoints[i].DX / 4;
		end;
		if CurvePoints[i].X > TfMain(ParentForm).BmpD.Width - 1 then
		begin
			CurvePoints[i].X := TfMain(ParentForm).BmpD.Width - 1;
			CurvePoints[i].DX := -3 * CurvePoints[i].DX / 4;
		end;

		CurvePoints[i].Y := CurvePoints[i].Y + 25 * ElapsedTime * CurvePoints[i].DY / PerformanceFrequency;
		if CurvePoints[i].Y > TfMain(ParentForm).BmpD.Height - 1 then
		begin
			CurvePoints[i].Y := TfMain(ParentForm).BmpD.Height - 1;
			CurvePoints[i].DY := -3 * CurvePoints[i].DY / 4;
		end;
		if CurvePoints[i].Y < 0 then
		begin
			CurvePoints[i].Y := 0;
			CurvePoints[i].DY := -3 * CurvePoints[i].DY / 4;
		end;
//		CurvePoints[i].C.L := SpectrumColor(Random(MaxSpectrum + 1));
	end;
end;

end.
