// * File:     MultiSaver\uCubeSaver.pas
// * Created:  2001-06-01
// * Modified: 2010-12-29
// * Version:  1.1.47.72
// * Author:   David Safranek (Safrad)
// * E-Mail:   safrad at email.cz
// * Web:      http://safrad.own.cz

unit uCubeSaver;

interface

uses
	uSaver, uTypes,
	Graphics;

const
	PointCount = 5;
	PolygonCount = 8;
type
	TCurvePoint = record
		XYZ: array[0..2] of TFlo;
		VXYZ: array[0..2] of TFlo;
	end;
	TCurve = record
		Points: array[0..PointCount - 1] of TCurvePoint;
		Color: TColor;
	end;

	TCubeSaver = class(TSaver)
	private
		LookAngleX, LookAngleY: TFlo;
		Curves: array[0..7] of TCurve;
		SpectrumC: SG;
	public
		constructor Create; override;
		destructor Destroy; override;
		procedure Draw; override;
		procedure Step; override;
	end;

implementation

uses
	OpenGL12,
	uColor, uMath;

{ TCubeSaver }

constructor TCubeSaver.Create;
begin
	inherited;
	Mode2D := False;
	LookAngleX := 0;
	LookAngleY := 0;
end;

destructor TCubeSaver.Destroy;
begin

	inherited;
end;

procedure TCubeSaver.Draw;
const
	C: array[0..7] of TColor = (clYellow, clWhite, clRed, clLime, clWhite, clBlue, clPurple, clAqua);
begin
	inherited;
	glClear(GL_COLOR_BUFFER_BIT);
	glEnable(GL_COLOR_MATERIAL);
	glMaterialfv(GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE, @glfMaterialColor[0]);
	glMaterialfv(GL_FRONT_AND_BACK, GL_SPECULAR, @glfSilverColor[0]);

	LightPos[0] := UserX;
	LightPos[1] := UserY;
	LightPos[2] := UserZ;

	glEnable(GL_LIGHT0);
	glLightfv(GL_LIGHT0, GL_AMBIENT, @glfLightAmbient[0]);
	glLightfv(GL_LIGHT0, GL_DIFFUSE, @glfLightDiffuse[0]);
	glLightfv(GL_LIGHT0, GL_SPECULAR, @glfLightSpecular[0]);
	glLightfv(GL_LIGHT0, GL_POSITION, @LightPos[0]);
	glLightf(GL_LIGHT0, GL_SPOT_CUTOFF, 60);
	glfDirect[0] := Sin(UserAngleXZ);
	glfDirect[1] := UserAngleY;
	glfDirect[2] := -Cos(UserAngleXZ);
	glLightfv(GL_LIGHT0, GL_SPOT_DIRECTION, @glfDirect[0]);

	glLoadIdentity;
	glScalef(4, 4, 4);

	glRotatef(LookAngleX, 1, 0, 0);
	glRotatef(LookAngleY, 0, 1, 0);
	glRotatef(30, 1, 0, 0);

	glNormal3f(0.0, 0.0, -1.0);
	glBegin(GL_QUADS);
		glColor3ubv(@TRGBA(C[1]).R);
		glVertex3f(1.0, 1.0, 1.0);
		glColor3ubv(@TRGBA(C[3]).R);
		glVertex3f(-1.0, 1.0, 1.0);
		glColor3ubv(@TRGBA(C[0]).R);
		glVertex3f(-1.0, -1.0, 1.0);
		glColor3ubv(@TRGBA(C[6]).R);
		glVertex3f(1.0, -1.0, 1.0);
	glEnd;

	glNormal3f(0.0, 0.0, 1.0);
	glBegin(GL_QUADS);
		glColor3ubv(@TRGBA(C[2]).R);
		glVertex3f(1.0, 1.0, -1.0);
		glColor3ubv(@TRGBA(C[7]).R);
		glVertex3f(1.0, -1.0, -1.0);
		glColor3ubv(@TRGBA(C[4]).R);
		glVertex3f(-1.0, -1.0, -1.0);
		glColor3ubv(@TRGBA(C[5]).R);
		glVertex3f(-1.0, 1.0, -1.0);
	glEnd;

	glNormal3f(1.0, 0.0, 0.0);
	glBegin(GL_QUADS);
		glColor3ubv(@TRGBA(C[3]).R);
		glVertex3f(-1.0, 1.0, 1.0);
		glColor3ubv(@TRGBA(C[5]).R);
		glVertex3f(-1.0, 1.0, -1.0);
		glColor3ubv(@TRGBA(C[4]).R);
		glVertex3f(-1.0, -1.0, -1.0);
		glColor3ubv(@TRGBA(C[0]).R);
		glVertex3f(-1.0, -1.0, 1.0);
	glEnd;

	glNormal3f(-1.0, 0.0, 0.0);
	glBegin(GL_QUADS);
		glColor3ubv(@TRGBA(C[1]).R);
		glVertex3f(1.0, 1.0, 1.0);
		glColor3ubv(@TRGBA(C[6]).R);
		glVertex3f(1.0, -1.0, 1.0);
		glColor3ubv(@TRGBA(C[7]).R);
		glVertex3f(1.0, -1.0, -1.0);
		glColor3ubv(@TRGBA(C[2]).R);
		glVertex3f(1.0, 1.0, -1.0);
	glEnd;

	glNormal3f(0.0, -1.0, 0.0);
	glBegin(GL_QUADS);
		glColor3ubv(@TRGBA(C[5]).R);
		glVertex3f(-1.0, 1.0, -1.0);
		glColor3ubv(@TRGBA(C[3]).R);
		glVertex3f(-1.0, 1.0, 1.0);
		glColor3ubv(@TRGBA(C[1]).R);
		glVertex3f(1.0, 1.0, 1.0);
		glColor3ubv(@TRGBA(C[2]).R);
		glVertex3f(1.0, 1.0, -1.0);
	glEnd;

	glNormal3f(0.0, 1.0, 0.0);
	glBegin(GL_QUADS);
		glColor3ubv(@TRGBA(C[4]).R);
		glVertex3f(-1.0, -1.0, -1.0);
		glColor3ubv(@TRGBA(C[7]).R);
		glVertex3f(1.0, -1.0, -1.0);
		glColor3ubv(@TRGBA(C[6]).R);
		glVertex3f(1.0, -1.0, 1.0);
		glColor3ubv(@TRGBA(C[0]).R);
		glVertex3f(-1.0, -1.0, 1.0);
	glEnd;
end;

procedure TCubeSaver.Step;
var
	C: TColor;
	i, j, k: SG;
	t: TFlo;
	VXYZ: array[0..2] of TFlo;
begin
	inherited;
	LookAngleX := LookAngleX + 128 * ElapsedTime / PerformanceFrequency;
	LookAngleY := LookAngleY + 128 * ElapsedTime / PerformanceFrequency;
	if SpectrumC > MaxSpectrum then SpectrumC := 0 else Inc(SpectrumC);
	for i := 6 downto 0 do
	begin
		Curves[i + 1] := Curves[i];
	end;
	for i := 0 to 0 do
	begin
		C := SpectrumColor(SpectrumC);
		Curves[i].Color := C;
		t := 16 * ElapsedTime / PerformanceFrequency;
		for j := 0 to PointCount - 1 do
		begin
			for k := 0 to 2 do
			begin
				VXYZ[k] := t * (Random2(2) / 100 {- (Curves[i].Points[j].XYZ[k]) / 100});

				Curves[i].Points[j].XYZ[k] := Curves[i].Points[j].XYZ[k] + t * (Curves[i].Points[j].VXYZ[k] + 0.5 * VXYZ[k]);

				Curves[i].Points[j].VXYZ[k] := Curves[i].Points[j].VXYZ[k] + VXYZ[k];

				if Curves[i].Points[j].XYZ[k] > 5 then
				begin
					Curves[i].Points[j].XYZ[k] := 5;
					Curves[i].Points[j].VXYZ[k] := -Curves[i].Points[j].VXYZ[k];
				end
				else if Curves[i].Points[j].XYZ[k] < -5 then
				begin
					Curves[i].Points[j].XYZ[k] := -5;
					Curves[i].Points[j].VXYZ[k] := -Curves[i].Points[j].VXYZ[k];
				end
			end;
		end;
	end;
end;

end.
