// * File:     MultiSaver\MultiSaver.dpr
// * Created:  2003-03-03
// * Modified: 2011-01-18
// * Version:  1.1.47.72
// * Author:   David Safranek (Safrad)
// * E-Mail:   safrad at email.cz
// * Web:      http://safrad.own.cz

program MultiSaver;

uses
	Forms,
	Windows,
	Dialogs,
	SysUtils,
	Math,
	Registry,
	uTypes,
	uFiles,
	uMsg,
	uCommon,
	uParams,
	uInputFormat,
	uOutputFormat,
	uMenus,
	uStrings,
	uMsgDlg,
	uDForm,
	uDBitmap,
	uDictionary,
	uMain in 'uMain.pas' {fMain},
	uSaver in 'uSaver.pas',
	uBlankSaver in 'uBlankSaver.pas',
	uFaderSaver in 'uFaderSaver.pas',
	uCurvesSaver in 'uCurvesSaver.pas',
	uLinesSaver in 'uLinesSaver.pas',
	uCubeSaver in 'uCubeSaver.pas',
	uTriangleSaver in 'uTriangleSaver.pas',
	uStarsSaver in 'uStarsSaver.pas',
	uPlanetsSaver in 'uPlanetsSaver.pas',
	uLabirinthSaver in 'uLabirinthSaver.pas',
	uBallSaver in 'uBallSaver.pas',
	uElementsSaver in 'uElementsSaver.pas',
	uTVSaver in 'uTVSaver.pas',
	uPicturesSaver in 'uPicturesSaver.pas',
	uClockSaver in 'uClockSaver.pas';

procedure SetParamHandle(const Value: string);
begin
	ParamHandle := StrToValI(Value, False, 0, 0, MaxInt, 1);
end;

procedure ParamConfiguration(const Value: string);
begin
	RunMode := rmConfigure;
	ConfigParent := GetForegroundWindow;
end;

procedure ParamSetPassword(const Value: string);
begin
	RunMode := rmSetPwd;
	if ParamCount >= 2 then
		SetParamHandle(ParamStr(2));
end;

procedure ParamPreview(const Value: string);
begin
	RunMode := rmPreview;
end;

procedure ParamNumber(const Value: string);
begin
	SetParamHandle(Value);
end;

procedure ParamExecute(const Value: string);
begin
	RunMode := rmExecute;
	ConfigParent := GetForegroundWindow;
end;

{$R *.RES}
var
	TargetExeFileName: TFileName;
	Res: BG;
	Reg: TRegistry;
	i: SG;
	fMainX: TfMain;
begin
//	IsLibrary := True;
	Application.Title := 'Multi Saver';
	Sleep(100); // Required because "preview" run before "small preview" finished (so log sharing problem). 

	ConfigParent := 0;
	ParamHandle := 0;
	RunMode := rmNone;
	RegisterParam('c', 'Configuration', ParamConfiguration);
	RegisterParam('a', 'Set password', ParamSetPassword);
	RegisterParam('p', 'Preview', ParamPreview);
	RegisterParam(paNumber, 'Preview window handle', ParamNumber);
	RegisterParam('s', 'Execute saver', ParamExecute);
	ReadCommandLine(GetCommandLine); // Called also in CommonForm, disadventage is only duplicit line in log

	CommonCreate(RunMode = rmPreview);

	// For Delphi GUI only
	if False then
	begin
		Application.Initialize;
		Application.CreateForm(TfMain, fMainX);
	end;
	fMainX := nil;

	if RunMode = rmNone then
		case MsgDlg('Select next action.', [''], False, mlConfirmation, ['Run', 'Install', 'Uninstall', 'Cancel'], DlgWait) of
		0: RunMode := rmExecute;
		1: RunMode := rmInstall;
		2: RunMode := rmUninstall;
		else RunMode := rmNone;
		end;
	if RunMode = rmExecute then
	begin
		Application.Initialize;
		if GetDesktop then
		begin
			try
				BackBmp := TDBitmap.Create;
				DesktopRect := Screen.DesktopRect;
				BackBmp.SetSize(DesktopRect.Right - DesktopRect.Left, DesktopRect.Bottom - DesktopRect.Top);
				BitBlt(BackBmp.Canvas.Handle, 0, 0, BackBmp.Width, BackBmp.Height,
					DesktopDC, DesktopRect.Left, DesktopRect.Top, SRCCOPY);
			finally
				ReleaseDesktop;
			end;
		end;
{		Application.CreateForm(TfMain, fMainX);
		fMainX.Visible := False;}
{		for i := 0 to 1 do
		begin
			Application.CreateForm(TfMain, fMain[i]);
			fMain[i].Caption := fMain[i].Caption + CharSpace + '[' + NToS(i + 1) + ']';
			CommonForm(fMain[i]);
		end;}
		if DisplayParams[doOnAllMonitors].Bool then
		begin
			for i := 0 to Max(MonitorLimit, Screen.MonitorCount) - 1 do
			begin
				Application.CreateForm(TfMain, fMain[i]);
				fMain[i].Tag := i;
				fMain[i].Caption := fMain[i].Caption + CharSpace + '[' + NToS(i + 1) + ']';
				CommonForm(fMain[i]);
			end;
		end
		else
		begin
			Application.CreateForm(TfMain, fMain[0]);
			CommonForm(fMain[0]);
		end;
		Application.Run;
		if (RunMode = rmExecute) and (ConfigParent <> 0) then
			SetForegroundWindow(ConfigParent);
	end
	else if RunMode = rmConfigure then
	begin
		Application.Initialize;
		Application.CreateForm(TfMain, fMain[0]);
		CommonForm(fMain[0]);
		Application.Run;
	end
	else if (RunMode = rmPreview) and (ParamHandle <> 0) then
	begin
		FillPreview;
	end
	else if RunMode = rmSetPwd then
		ExecSetPwd
	else if RunMode = rmInstall then
	begin
		TargetExeFileName := SysDir + 'ssMulti' + '.scr';
		Res := CopyFile(ExeFileName, TargetExeFileName, False);
		Res := Res and CopyDir(WorkDir + 'Languages\', SysDir + 'Languages\');
		Res := Res and CopyDir(WorkDir + 'Sounds\', SysDir + 'Sounds\');
		Res := Res and CopyDir(WorkDir + 'Graphics\', SysDir + 'Graphics\');
		Reg := TRegistry.Create(KEY_SET_VALUE);
		try
			Reg.RootKey := HKEY_CURRENT_USER;
			if Reg.OpenKey('Control Panel' + PathDelim + 'Desktop' + PathDelim, False) then
			begin
				Reg.WriteString('SCRNSAVE.EXE', TargetExeFileName);
			end;
		finally
			Reg.Free;
		end;
		if Res then
			Information(Application.Title + CharSpace + Translate('successfully installed.'));
	end
	else if RunMode = rmUninstall then
	begin
		Res := DeleteFileEx(SysDir + 'ss' + Application.Title + '.scr');
		Res := Res and RemoveDirsEx(SysDir + 'Sounds\', True);
		Res := Res and RemoveDirsEx(SysDir + 'Graphics\', True);
		if Res then
				Information(Application.Title + CharSpace + Translate('successfully uninstalled.'));
	end;
	CommonFree;
end.
