// * File:     Motor\uMain.pas
// * Created:  2001-12-23
// * Modified: 2009-09-18
// * Version:  1.0.47.21
// * Author:   David Safranek (Safrad)
// * E-Mail:   safrad at email.cz
// * Web:      http://safrad.own.cz

unit uMain;

interface

uses
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
	StdCtrls, ComCtrls, ExtCtrls, uDLabel, uDButton, Menus, uDForm, uDEdit,
	uDWinControl;

type
	TfMain = class(TDForm)
		ButtonFeedback: TDButton;
		ComboBoxRPS: TComboBox;
		DLabel1: TDLabel;
		DLabel2: TDLabel;
		ComboBoxCrumb: TComboBox;
		Bevel1: TBevel;
		TrackBarPower: TTrackBar;
		Bevel2: TBevel;
		DLabel3: TDLabel;
		ButtonAuto: TDButton;
		ComboBoxF: TComboBox;
		EditRPS: TDEdit;
		EditF: TDEdit;
		MainMenu1: TMainMenu;
		File1: TMenuItem;
		Help1: TMenuItem;
		Bevel3: TBevel;
		ButtonRun: TDButton;
		ButtonScreen: TDButton;
		DLabel6: TDLabel;
		PanelCount: TDLabel;
		DLabel7: TDLabel;
		PanelTime: TDLabel;
		DLabel34: TDLabel;
		ComboBoxComAddr: TComboBox;
		DLabel9: TDLabel;
		ComboBoxInt: TComboBox;
		DLabel5: TDLabel;
		LabelStatCount: TDLabel;
		EditDif: TDEdit;
		DLabel4: TDLabel;
		Options1: TMenuItem;
		procedure ButtonAutoClick(Sender: TObject);
		procedure ButtonFeedbackClick(Sender: TObject);
		procedure FormCreate(Sender: TObject);
		procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
		procedure ComboBoxComAddrChange(Sender: TObject);
		procedure ButtonRunClick(Sender: TObject);
		procedure ComboBoxIntChange(Sender: TObject);
		procedure ComboBoxFChange(Sender: TObject);
		procedure ComboBoxCrumbChange(Sender: TObject);
		procedure TrackBarPowerChange(Sender: TObject);
		procedure ComboBoxRPSChange(Sender: TObject);
	private
		{ Private declarations }
		procedure InitComboCrumb;
		procedure InitTrackCrumb;
		procedure InitMenu;
		procedure RWOptions(const Save: Boolean);
	public
		{ Public declarations }
	end;

var
	fMain: TfMain;

implementation

{$R *.DFM}
uses
	Math,
	uTypes, uRS232, uDIniFile, uAbout, uInputFormat, uMath, uOutputFormat, uSimulation;

var
	FullF, Crumb: Extended;
	GeneratorRun: Boolean;
	IntF: Extended;
	IntTime: Integer;
	RPSTime: U8;

procedure TfMain.InitMenu;
begin
{	ComboBoxCrumb.Enabled := not ButtonFeedback.Down;
	TrackBarPower.Enabled := not ButtonFeedback.Down;}
	ComboBoxRPS.Enabled := ButtonFeedback.Down;
	EditRPS.Enabled := ButtonFeedback.Down;
	ComboBoxF.Enabled := not ButtonAuto.Down;
	EditF.Enabled := ButtonAuto.Down;
end;

procedure TfMain.InitComboCrumb;
begin
	ComboBoxCrumb.OnChange := nil;
	ComboBoxCrumb.Text := FloatToStr(Crumb * 100);
	ComboBoxCrumb.OnChange := ComboBoxCrumbChange;
end;

procedure TfMain.InitTrackCrumb;
begin
	TrackBarPower.OnChange := nil;
	TrackBarPower.Position := Round(100 * Crumb);
	TrackBarPower.OnChange := TrackBarPowerChange;
end;

procedure TfMain.ButtonAutoClick(Sender: TObject);
begin
	InitMenu;
	if ButtonAuto.Down then
	begin

	end
	else
	begin
		ComboBoxFChange(Sender);
	end;
end;

procedure TfMain.ButtonFeedbackClick(Sender: TObject);
begin
	InitMenu;
end;

procedure TfMain.RWOptions(const Save: Boolean);
begin
	MainIni.RWFormPos(Self, Save);

	ComboBoxComAddr.ItemIndex := MainIni.RWSGF('Options', 'ComAddr', ComboBoxComAddr.ItemIndex, 0, Save);
	ComboBoxInt.Text := MainIni.RWStringF('Options', 'Interrupt', ComboBoxInt.Text, ComboBoxInt.Text , Save);
	ButtonScreen.Down := MainIni.RWBGF('Options', 'Screen', ButtonScreen.Down, ButtonScreen.Down, Save);
	ButtonFeedBack.Down := MainIni.RWBGF('Options', 'FeedBack', ButtonFeedBack.Down, ButtonFeedBack.Down, Save);
	ButtonAuto.Down := MainIni.RWBGF('Options', 'Auto', ButtonAuto.Down, ButtonAuto.Down, Save);

	ComboBoxCrumb.Text := MainIni.RWStringF('Options', 'Crumb', ComboBoxCrumb.Text, ComboBoxCrumb.Text, Save);
	ComboBoxF.Text := MainIni.RWStringF('Options', 'Frequency', ComboBoxF.Text, '10', Save);
	ComboBoxRPS.Text := MainIni.RWStringF('Options', 'RPS', ComboBoxRPS.Text, '10', Save);
end;

procedure TfMain.FormCreate(Sender: TObject);
var
	i: SG;
	s: string;
begin
	Background := baGradient;

	ComboBoxComAddr.Items.BeginUpdate;
	try
		for i := 0 to 3 do
		begin
			FmtStr(s, '%s%.4x', [HexDisplayPrefix, ComAddr[i]]);
			ComboBoxComAddr.Items.Add(s + ' (Com' + IntToStr(i + 1) + ')');
		end;
	finally
		ComboBoxComAddr.Items.EndUpdate;
	end;

	RWOptions(False);
	SetCom(ComboBoxComAddr.ItemIndex);

	ComboBoxIntChange(Sender);
	ComboBoxFChange(Sender);
	ComboBoxCrumbChange(Sender);
	ComboBoxRPS.OnChange(Sender);
	InitMenu;
end;

procedure TfMain.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
	CanClose := GeneratorRun = False;
	if CanClose then
	begin
		RWOptions(True);
	end;
end;

procedure TfMain.ComboBoxComAddrChange(Sender: TObject);
begin
	SetCom(ComboBoxComAddr.ItemIndex);
end;

procedure TfMain.ButtonRunClick(Sender: TObject);
var
	TickCount, LTickCount, StartCount, NextTick: Int64;
	Loop: Int64;
	SPPCount: Integer;
	PerT: array[0..1] of Int64;

	procedure InitData;
	begin
{		PerT[0] := Round(PerformanceFrequency / ((1 + 1 / Crumb) * FullF));
		PerT[1] := Round(PerformanceFrequency / FullF) - PerT[0];}
		PerT[0] := Round(Crumb * PerformanceFrequency / FullF);
		PerT[1] := Round(PerformanceFrequency / FullF) - PerT[0];
		SPPCount := 2;
	end;

	var
		LDCD, LRI, LDSR, LCTS: Boolean;
		Changes: array[0..3] of SG;
		StatCount: SG;
		ElapsedTime, LElapsedTime: U8;
		RotTime, RotTime2, LRotTime: U8;
		Dif: S8;
		Dif2: Double;
begin
	if GeneratorRun = False then
	begin
		if (FullF = 0) {or (Crumb = 0)} then Exit;

		GeneratorRun := True;
		try
			ButtonRun.Down := True;
			Application.ProcessMessages;

			InitData;

			RTS := False;
			DTR := False;
			TxD := True;
			SetOut;

			GetIn;
			LDCD := DCD;
			LRI := RI;
			LDSR := DSR;
			LCTS := CTS;

			StatCount := 0;
			FillChar(Changes[0], SizeOf(Changes), 0);

			Loop := 0;
			LTickCount := PerformanceCounter;
			StartCount := LTickCount;
			NextTick := LTickCount;

			TickCount := LTickCount;
			LElapsedTime := LTickCount;
			RotTime := 0;
	//		RotTime2 := 0;
			LRotTime := LTickCount;
			Dif2 := 0;
			while GeneratorRun do
			begin
				RTS := not RTS;
				DTR := not DTR;
				SetOut;

				if ButtonAuto.Down then
				begin
					FullF := 100 + Random(100);
					EditF.Text := FloatToStr(FullF);
					InitData;
				end;

				begin
					GetIn;
					RotTime2 := TimeDifference(TickCount, LRotTime);
					if {(LDCD <> DCD) or}
					(LRI <> RI) {or
					(LDSR <> DSR) or
					(LCTS <> CTS)} then
					begin
						if RI = True then
						begin
							ElapsedTime := TimeDifference(TickCount, LElapsedTime);
							LElapsedTime := TickCount;
							if ElapsedTime > PerformanceFrequency div 50 then
							begin
								RotTime := TimeDifference(TickCount, LRotTime);
								LRotTime := TickCount;
								Inc(StatCount);
							end;
						end;


						if LDCD <> DCD then Inc(Changes[0]);
						if LRI <> RI then Inc(Changes[1]);
						if LDSR <> DSR then Inc(Changes[2]);
						if LCTS <> CTS then Inc(Changes[3]);

						LDCD := DCD;
						LRI := RI;
						LDSR := DSR;
						LCTS := CTS;
					end;

	{				if Chan = False then}
					begin
								Dif := Max(RotTime, RotTime2) - RPSTime;
								if Abs(Dif) > RPSTime div 20 then // 5% tolerance
								begin
									Dif2 := 0.01 * Dif / PerformanceFrequency;
	//								if Dif2 > 0.05 then Dif2 := 0.05;
									if ButtonFeedback.Down then
									if Dif > 0 then
									begin
										Crumb := Crumb + Dif2;
										if Crumb > 1 then Crumb := 1;
									end
									else
									begin
										Crumb := Crumb + Dif2;
										if Crumb < 0 then Crumb := 0;
									end;
								end;
					end;

				end;

				NextTick := NextTick + PerT[Loop and (SPPCount - 1)];
				repeat
					TickCount := PerformanceCounter;
				until TickCount >= NextTick;

				Inc(Loop);

				if (IntTime > 0) and (TickCount > LTickCount + IntTime) then
				begin
					if GetAsyncKeyState(VK_ESCAPE) <> 0 then ButtonRun.Click;
					if ButtonScreen.Down then
					begin
						PanelCount.Caption := IntToStr(Loop);
						PanelTime.Caption := NToS(RoundDivS8(1000000 * (TimeDifference(TickCount, StartCount)), PerformanceFrequency), 6);
						LabelStatCount.Caption := IntToStr(StatCount);
						if RotTime > 0 then
							EditRPS.Text := FloatToStr(PerformanceFrequency / RotTime);
						EditDif.Text := FloatToStr(Dif2 / PerformanceFrequency);
						InitComboCrumb;
						InitTrackCrumb;
						Application.ProcessMessages;
					end;
					InitData;
					Inc(LTickCount, IntTime);
				end;
				if ButtonAuto.Down then
				begin
					FullF := 100;
				end;
			end;
			RTS := False;
			DTR := False;
			SetOut;
		finally
			GeneratorRun := False;
			ButtonRun.Down := False;
			Application.ProcessMessages;
		end;
	end
	else
	begin
		GeneratorRun := False;
	end;
end;

procedure TfMain.ComboBoxIntChange(Sender: TObject);
begin
	IntF := StrToValE(ComboBoxInt.Text, True, 0.01, 25, 100);
	IntTime := Round(PerformanceFrequency / IntF)
end;

procedure TfMain.ComboBoxFChange(Sender: TObject);
begin
	FullF := StrToValE(ComboBoxF.Text, True, 0.01, 25, 100);
end;

procedure TfMain.ComboBoxCrumbChange(Sender: TObject);
begin
	Crumb := StrToValE(ComboBoxCrumb.Text, True, 0.01, 50, 100) / 100;
	InitTrackCrumb;
end;

procedure TfMain.TrackBarPowerChange(Sender: TObject);
begin
	Crumb := TrackBarPower.Position / 100;
//	if Crumb < 0.01 then Crumb := 0.01;
	InitComboCrumb;
end;

procedure TfMain.ComboBoxRPSChange(Sender: TObject);
begin
	RPSTime := Round(PerformanceFrequency / StrToValE(ComboBoxRPS.Text, True, 1, 5, 100));
end;

end.
