// * File:     MandelbrotSet\uVisual.pas
// * Created:  2007-03-31
// * Modified: 2009-09-02
// * Version:  1.2.47.30
// * Author:   David Safranek (Safrad)
// * E-Mail:   safrad at email.cz
// * Web:      http://safrad.own.cz

unit uVisual;

interface

uses
	uDForm, uTypes,
	Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
	uDImage, uDWinControl;

type
	TfVisual = class(TDForm)
		ImageM: TDImage;
		procedure ImageMMouseMove(Sender: TObject; Shift: TShiftState; X,
			Y: Integer);
		procedure ImageMMouseDown(Sender: TObject; Button: TMouseButton;
			Shift: TShiftState; X, Y: Integer);
		procedure ImageMFill(Sender: TObject);
		procedure FormCreate(Sender: TObject);
		procedure FormHide(Sender: TObject);
		procedure FormShow(Sender: TObject);
		procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
	private
		{ Private declarations }
		procedure UpdatePos(const X, Y: SG);
		procedure RWOptions(const Save: BG);
	public
		{ Public declarations }
	end;

var
	fVisual: TfVisual;

implementation

{$R *.dfm}
uses
	Math,
	uMain,
	uOutputFormat, uDBitmap, uInputFormat, uGraph, uMath, uDIniFile, uColor, uDrawStyle;

procedure TfVisual.UpdatePos(const X, Y: SG);
begin
	if TPos(Db.DbItems[0].PData^).Zoom <> 0 then
	begin
		COfsX := TPos(Db.DbItems[0].PData^).OfsX + (X / ImageM.Width - 0.5) / TPos(Db.DbItems[0].PData^).Zoom;
		COfsY := TPos(Db.DbItems[0].PData^).OfsY - (Y / ImageM.Height - 0.5) / TPos(Db.DbItems[0].PData^).Zoom;
		fMain.EditX.Text := FToS(COfsX);
		fMain.EditX.Update;
		fMain.EditY.Text := FToS(COfsY);
		fMain.EditY.Update;
	end;
end;

procedure TfVisual.ImageMMouseMove(Sender: TObject; Shift: TShiftState; X,
	Y: Integer);
begin
	if Db.DbItemCount > 0 then
	begin
		if TPos(Db.DbItems[0].PData^).Zoom = 0 then Exit;
		UpdatePos(X, Y);
	end;
end;

procedure TfVisual.ImageMMouseDown(Sender: TObject; Button: TMouseButton;
	Shift: TShiftState; X, Y: Integer);
begin
	if Db.DbItemCount > 0 then
	begin
		Db.DbNew;
		UpdatePos(X, Y);
		TPos(Db.DbItems[0].PData^).OfsX := COfsX;
		TPos(Db.DbItems[0].PData^).OfsY := COfsY;
		case Button of
		mbLeft:
		begin
			TPos(Db.DbItems[0].PData^).Zoom := TPos(Db.DbItems[0].PData^).Zoom * 2;
		end;
		mbRight:
		begin
			TPos(Db.DbItems[0].PData^).Zoom := TPos(Db.DbItems[0].PData^).Zoom / 2;
			if TPos(Db.DbItems[0].PData^).Zoom <= 0 then TPos(Db.DbItems[0].PData^).Zoom := 1;
		end;
		end;
		UpdatePos(X, Y);
		fMain.InitXY;
		fMain.InitZoom;

		ImageM.Invalidate;
	end;
end;

procedure Calc0;
type
	TFlo = Single;
{$I Calc.inc}

procedure Calc1;
type
	TFlo = Double;
{$I Calc.inc}

procedure Calc2;
type
	TFlo = Extended;
{$I Calc.inc}

procedure TfVisual.ImageMFill(Sender: TObject);
begin
//	SetRoundMode(rmTruncate);
	case fMain.ComboBoxPrecision.ItemIndex of
	0:
	begin
		SetPrecisionMode(pmSingle);
		Calc0;
	end;
	1:
	begin
		SetPrecisionMode(pmDouble);
		Calc1;
	end;
	2:
	begin
		SetPrecisionMode(pmExtended);
		Calc2;
	end;
	end;
	SetPrecisionMode(pmExtended);
//	SetRoundMode(rmNearest);
end;

procedure TfVisual.FormCreate(Sender: TObject);
begin
	Background := baGradient;
	RWOptions(False);
{	ImageM.CreateZoom(nil);
	Bmp := TDBitmap.Create;
	ImageM.UserBitmap := Bmp;}
end;

procedure TfVisual.FormHide(Sender: TObject);
begin
	fMain.Visual1.Checked := False;
end;

procedure TfVisual.FormShow(Sender: TObject);
begin
	fMain.Visual1.Checked := True;
	ImageM.Invalidate;
end;

procedure TfVisual.RWOptions(const Save: BG);
begin
	MainIni.RWFormPos(Self, Save);
end;

procedure TfVisual.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
	RWOptions(True);
end;

end.

