// * File:     MandelbrotSet\Calc.inc
// * Created:  2008-06-03
// * Modified: 2009-09-02
// * Version:  1.2.47.30
// * Author:   David Safranek (Safrad)
// * E-Mail:   safrad at email.cz
// * Web:      http://safrad.own.cz

label LRestart;
var
	Level: Integer;

	i, j, Count: Integer;
	Bmp: TDBitmap;
	Color: array of TRGBA;
	C: TRGBA;
	LTickCount, TickCount: LongWord;

	cr, ci, zr, zi, zr2, zi2: TFlo;
	OfsX, OfsY, Zoom, Distance, StepX, StepY, x, y: TFlo;
	SetKind: TSetKind;
	Col: SG;
begin
	if fMain.Run then
	begin
		fMain.Status := stRestart;
		Exit;
	end;

	Bmp := fVisual.ImageM.Bitmap;
//	Bmp.SetSize(fVisual.ImageM.Width, fVisual.ImageM.Height);
	fMain.Run := True;
	try
		fMain.GaugeStatus.Max := Bmp.Height - 1;
		LRestart:
		fMain.Status := stNone;
		Zoom := TPos(Db.DbItems[0].PData^).Zoom;
		if Zoom <= 0 then Zoom := 1;
		StepX := 1 / (Zoom * Bmp.Width);
		StepY := 1 / (Zoom * Bmp.Height);
		OfsX := TPos(Db.DbItems[0].PData^).OfsX - Integer(Bmp.Width) * StepX / 2;
		OfsY := TPos(Db.DbItems[0].PData^).OfsY - Integer(Bmp.Height) * StepY / 2;
		SetKind := TPos(Db.DbItems[0].PData^).SetKind;

		Level := TPos(Db.DbItems[0].PData^).Level; if Level < 1 then Level := 1;
		Distance := StrToValE(fMain.ComboBoxDistance.Text, True, 0, 1, MaxInt);
		Col := fMain.ComboBoxGradient.ItemIndex;
		SetLength(Color, Level);
		if Level > 1 then
		begin
			case Col of
			0:
			for i := 0 to Level - 1 do
			begin
				j := $ff * i div (Level - 1);
				Color[i].A := 0;
				Color[i].R := j;
				Color[i].G := j;
				Color[i].B := j;
			end;
			1:
			for i := 0 to Level - 1 do
			begin
				Color[i].L := SpectrumColor(510 * i div (Level - 1));
			end;
			2:
			for i := 0 to Level - 1 do
			begin
				Color[i].L := FireColor(MaxFireColor * i div (Level - 1));
			end;
			3:
			for i := 0 to Level - 1 do
			begin
				Color[i].L := SpectrumColor(MaxSpectrum * i div (Level - 1));
			end;
			end;
		end
		else
			Color[0].L := ColorToRGB(clBtnFace);
		y := StepY * (Integer(Bmp.Height) - 1);
		LTickCount := 0;
		for j := 0 to Integer(Bmp.Height) - 1 do
		begin
			if j and 32 = 0 then
			begin
				Application.ProcessMessages;
				case fMain.Status of
				stStop: Break;
				stRestart: goto LRestart;
				end;
				TickCount := GetTickCount;
				if LTickCount + 100 <= TickCount then
				begin
					fMain.GaugeStatus.Position := j;
					LTickCount := TickCount;
				end;
			end;
			ci := OfsY + y;
			x := 0;
			for i := 0 to Integer(Bmp.Width) - 1 do
			begin
				cr := OfsX + x;

				case SetKind of
				skJuliet:
				begin
					cr := 0.3;
					ci := 0.6;
					zr := OfsY + y;
					zi := OfsX + x;
					zr2 := zr * zr;
					zi2 := zi * zi;
				end;
				else // skMandelbrot:
				begin
					zr := 0;
					zi := 0;
					zr2 := 0;
					zi2 := 0;
				end;
				end;
				
				Count := 0;
				repeat
					zi := 2 * zr * zi + ci;
					zr := zr2 - zi2 + cr;
					zr2 := zr * zr;
					zi2 := zi * zi;
					Inc(Count);
				until ((Count >= Level) or ((zr2 + zi2) >= Distance));

				C := Color[Count - 1];
				Exchange(C.R, C.B);
				Pix(Bmp.Data, Bmp.ByteX, i, j, @C, ef16);
				x := x + StepX;
			end;
			y := y - StepY;
		end;
		if fMain.Cross1.Checked then
		begin
			Bmp.Line(Integer(Bmp.Width div 2) - 16, Bmp.Height div 2, Bmp.Width div 2 + 16, Bmp.Height div 2, clWhite, efNeg);
			Bmp.Line(Bmp.Width div 2, Integer(Bmp.Height div 2) - 16, Bmp.Width div 2, Bmp.Height div 2 + 16, clWhite, efNeg);
		end;
		fMain.GaugeStatus.Position := Bmp.Height - 1;
	finally
		SetLength(Color, 0);
		fMain.Run := False;
	end;
end;
