// * File:     ICQ\uUser.pas
// * Created:  2010-01-01
// * Modified: 2010-09-19
// * Version:  1.0.47.32
// * Author:   David Safranek (Safrad)
// * E-Mail:   safrad at email.cz
// * Web:      http://safrad.own.cz

unit uUser;

interface

uses
	SysUtils,
	uTypes, uData;

type
	PEvent = ^TEvent;
	TEvent = packed record // 20
		Typ: S4;
		Incoming: U4;
		Time: U4; // To year 2038
		Text: UTF8String; // 4
		Data: string; // 4
	end;

	TUserEvent = class
		Incoming: BG;
		Time: TDateTime;
		Text: UTF8String;
	end;

	TUser = class
	private
		FId: U8;
		FName: string;
		FEvents: TData;
	public
		constructor Create(const Id: U8; const Name: string);
		destructor Destroy; override;
		procedure AddEvent(const NewEvent: TUserEvent);
		procedure FromQIP(const FileName: TFileName);
		function ToQIP: string; overload;
		procedure ToQIP(const FileName: string); overload;
		property Id: U8 read FId;
	end;

var
	UserName: string;

function RepairText(const Text: string): string;

implementation

uses
	uInputFormat, uStrings, uFile, uFiles;

const
	IncomingStr = '--------------------------------------<-';
	OutcomingStr = '-------------------------------------->-';

{ TUser }

procedure TUser.AddEvent(const NewEvent: TUserEvent);
var
	Index: SG;
	Event: TUserEvent;
begin
	if FEvents = nil then
	begin
		FEvents := TData.Create;
//		FEvents.ItemSize := SizeOf(TEvent);
	end;
	NewEvent.Text := RepairText(NewEvent.Text);
	Index := 0;
	Event := TUserEvent(FEvents.First);
	while Event <> nil do
	begin
		if NewEvent.Time = Event.Time then
		begin
			// Duplicate
			if (NewEvent.Incoming = Event.Incoming) and
				(NewEvent.Text = Event.Text) then
				Exit;
		end;
		if NewEvent.Time < Event.Time then
		begin
			Index := Index;
			Break;
		end;
		Inc(Index);
		Event := TUserEvent(FEvents.Next);
	end;

	FEvents.Insert(Index, NewEvent);
end;

constructor TUser.Create(const Id: U8; const Name: string);
begin
	inherited Create;

	FId := Id;
	FName := Name;
end;

destructor TUser.Destroy;
begin
	FreeAndNil(FEvents);
	FId := 0;
	inherited;
end;

procedure TUser.FromQIP(const FileName: TFileName);
var
	F: TFile;
	Event: TUserEvent;
	Line: string;
	InLineIndex: SG;
	Fitst: BG;
begin
	F := TFile.Create;
	Event := nil;
	try
		if F.Open(FileName, fmReadOnly) then
		begin
			Fitst := True;
			while not F.Eof do
			begin
				F.Readln(Line);
				if Line = IncomingStr then
				begin
					if Event <> nil then
						AddEvent(Event);
					Event := TUserEvent.Create;
					Event.Incoming := True;
					Fitst := True;
				end
				else if Line = OutcomingStr then
				begin
					if Event <> nil then
						AddEvent(Event);
					Event := TUserEvent.Create;
					Event.Incoming := False;
					Fitst := True;
				end
				else if Fitst then
				begin
					Fitst := False;
//					InLineIndex := 1;
//					ReadToChar(Line, InLineIndex, '(');  fd
					InLineIndex := PosEx('(', Line, Length(Line), 1);
					Event.Time := SToTime(ReadToChar(Line, InLineIndex, CharSpace), ifIO);
					Event.Time := Event.Time + SToDate(ReplaceF(ReadToChar(Line, InLineIndex, ')'), '/', '.'), ifIO);
				end
				else
				begin
					Event.Text := Event.Text + Line + FullSep;
				end;
			end;
			if Event <> nil then
				AddEvent(Event);
			F.Close;
		end;
	finally
		F.Free;
	end;
end;

procedure TUser.ToQIP(const FileName: string);
var
	Data: string;
begin
	Data := ToQIP;
	if Data <> '' then
		WriteStringToFile(FileName, Data, False, fcAnsi);
end;

function DateTimeToStringF(const DateTime: TDateTime): string;
begin
	DateTimeToString(Result, 'D/MM/YYYY', DateTime);
	Replace(Result, '.', '/');
end;

function TUser.ToQIP: string;
var
	Event: TUserEvent;
begin
	Result := '';
	if FEvents = nil then
		Exit;

	Event := TUserEvent(FEvents.First);
	while Event <> nil do
	begin
		if Event.Incoming then
		begin
			Result := Result + IncomingStr + FileSep;
			if FName <> '' then
				Result := Result + FName + CharSpace
			else
				Result := Result + IntToStr(FId) + CharSpace;
		end
		else
		begin
			Result := Result + OutcomingStr + FileSep;
			if UserName <> '' then
				Result := Result + UserName + CharSpace;
		end;
		Result := Result + '(' + TimeToStr(Event.Time) + CharSpace + DateTimeToStringF(Event.Time) + ')' + FileSep;
		Result := Result + Event.Text + FileSep;
		Result := Result + FileSep;
		Event := TUserEvent(FEvents.Next);
	end;
end;

function RepairText(const Text: string): string;
begin
	if Text = CharTab then
		Result := ''
	else
	begin
		Result := DelEndSpaceF((AddFullEnter(Text)));
	end;
end;

end.
