// * File:     ICQ\uMain.pas
// * Created:  2005-04-17
// * Modified: 2010-11-12
// * Version:  1.0.47.32
// * Author:   David Safranek (Safrad)
// * E-Mail:   safrad at email.cz
// * Web:      http://safrad.own.cz

unit uMain;

interface

uses
	uTypes, uDForm,
	Menus, Controls, StdCtrls, Classes, Graphics, Windows, ExtCtrls, SysUtils,
	Dialogs, uDMemo;

type
	TfMain = class(TDForm)
		Memo: TDMemo;
		Label1: TLabel;
		OpenDialog1: TOpenDialog;
		MainMenu1: TMainMenu;
		File1: TMenuItem;
		SourceDBF1: TMenuItem;
		SourceXML1: TMenuItem;
		TargetXML1: TMenuItem;
		Run1: TMenuItem;
		Help1: TMenuItem;
		StartDBFXML1: TMenuItem;
		EditSourceDBF: TLabeledEdit;
		EditSourceXML: TLabeledEdit;
		EditTargetXML: TLabeledEdit;
		MergeXMLXML1: TMenuItem;
		DefaultSourceDBF1: TMenuItem;
		DefaultTargetXML1: TMenuItem;
		N2: TMenuItem;
		N3: TMenuItem;
		Options1: TMenuItem;
		StartDBFTXT1: TMenuItem;
		EditTargetTXT: TLabeledEdit;
		argetTXTQIP1: TMenuItem;
		DefaultTargetTXT1: TMenuItem;
		MergeSourceQIPTXTtoTargetQIPTXT1: TMenuItem;
		EditSourceTXT: TLabeledEdit;
		SourceTXTQIP1: TMenuItem;
		DefaultSourceTXT1: TMenuItem;
		EditContactList: TLabeledEdit;
		ContactList1: TMenuItem;
		DefaultContactList1: TMenuItem;
		procedure FormResize(Sender: TObject);
		procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
		procedure StartDBFXML1Click(Sender: TObject);
		procedure FormCreate(Sender: TObject);
		procedure TargetXML1Click(Sender: TObject);
		procedure SourceDBF1Click(Sender: TObject);
		procedure SourceXML1Click(Sender: TObject);
		procedure EditTargetXMLChange(Sender: TObject);
		procedure EditSourceXMLChange(Sender: TObject);
		procedure EditSourceDBFChange(Sender: TObject);
		procedure DefaultSourceDBF1Click(Sender: TObject);
		procedure DefaultTargetXML1Click(Sender: TObject);
		procedure argetTXTQIP1Click(Sender: TObject);
		procedure DefaultTargetTXT1Click(Sender: TObject);
		procedure EditTargetTXTChange(Sender: TObject);
		procedure EditSourceTXTChange(Sender: TObject);
		procedure MergeSourceQIPTXTtoTargetQIPTXT1Click(Sender: TObject);
		procedure SourceTXTQIP1Click(Sender: TObject);
		procedure DefaultSourceTXT1Click(Sender: TObject);
		procedure DefaultContactList1Click(Sender: TObject);
		procedure ContactList1Click(Sender: TObject);
		procedure EditContactListChange(Sender: TObject);
	private
		{ Private declarations }
		procedure RWOptions(const Save: BG);
		procedure InitEdits;
		procedure InitMenu;
		procedure InitAll;
		procedure OnAddFile(FileName: TFileName);
		procedure SetDefaultContactList;
	public
		{ Public declarations }
	end;

var
	fMain: TfMain;

implementation

{$R *.DFM}

uses
	uAbout, uDIniFile, uStrings, uData, uXML, uInputFormat, uHTML, uFiles, uDBF, uDEdit,
	uReg, uMenus, uOutputFormat, uSystem, uMath, uToHTML, uLog, uMsg, uUser, uCSVFile,
	uParserMsg, uFolder, uGetStr,
	Forms;

var
	DefDBFSource, DBFSource: TFileName;
	XMLSource, DefTargetDir, TargetDir: string;
	DefSourceDirTXT, SourceDirTXT: string;
	DefTargetDirTXT, TargetDirTXT: string;
	ContactList: TFileName;

procedure AddMessage(const Text: string; const Params: array of string;
	const MessageLevel: TMessageLevel);
var
	LogTime: TDateTime;
	Line: string;
begin
	LogTime := Now;
	Line := ReplaceParam(Text, Params);
	MainLog.Add(LogTime, Line, MessageLevel);
	if Assigned(fMain) then
		fMain.Memo.Lines.Add(DateTimeToS(LogTime, 3, ofIO) + CharTab + MessageLevelStr[MessageLevel]
				+ CharTab + Line);
end;

procedure TfMain.FormResize(Sender: TObject);
begin
	Memo.SetBounds(Memo.Left, Memo.Top, ClientWidth - 2 * Memo.Left,
		ClientHeight - Memo.Top - FormBorder);
	EditSourceDBF.Width := ClientWidth - FormBorder - EditSourceDBF.Left;
	EditSourceXML.Width := ClientWidth - FormBorder - EditSourceXML.Left;
	EditTargetXML.Width := ClientWidth - FormBorder - EditTargetXML.Left;
	EditSourceTXT.Width := ClientWidth - FormBorder - EditSourceTXT.Left;
	EditTargetTXT.Width := ClientWidth - FormBorder - EditTargetTXT.Left;
	EditContactList.Width := ClientWidth - FormBorder - EditContactList.Left;
end;

procedure TfMain.RWOptions(const Save: BG);
var
	Section: string;
begin
	MainIni.RWFormPos(Self, Save);
	Section := 'Options';
	if Save = False then
		DBFSource := DefDBFSource;
	MainIni.RWFileName(Section, 'DBFSource', DBFSource, Save);
	if Save = False then
		XMLSource := '';
	MainIni.RWString(Section, 'XMLSource', XMLSource, Save);
	if Save = False then
	begin
		TargetDir := DefTargetDir;
		SourceDirTXT := DefSourceDirTXT;
		TargetDirTXT := DefTargetDirTXT;
	end;
	MainIni.RWString(Section, 'TargetDir', TargetDir, Save);
	MainIni.RWString(Section, 'SourceDirTXT', SourceDirTXT, Save);
	MainIni.RWString(Section, 'TargetDirTXT', TargetDirTXT, Save);
	MainIni.RWFileName(Section, 'ContactList', ContactList, Save);
	if Save = False then
		UserName := GetEnvironmentVariable('USERNAME');
	MainIni.RWString(Section, 'UserName', UserName, Save);
end;

procedure TfMain.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
	RWOptions(True);
end;

var
	AddedEvent, Skipped, Readed, Copied: UG;

function GetICQ(FileName: TFileName): string;
var
	i: SG;
begin
	FileName := DelFileExt(FileName);
	i := Length(FileName);
	while i >= 1 do
	begin
		if not CharInSet(FileName[i], ['0'..'9']) then
			Break;
		Dec(i);
	end;
	Result := Copy(FileName, i + 1, MaxInt);
end;

type
	TSection = packed record // 32
		UID: U8; // DBF -> XML
		Year: U1; // DBF -> XML
		Month: U1; // DBF -> XML
		Changed: B2;
		FileName: TFileName; // XML -> XML
		Version: U4;
		Events: TData; // array of TEvent;
		Res: array [0 .. 7] of U1;
	end;

var
	Users: TData;
	Sections: array of TSection;
	SectionCount: SG;

function GetUser(const Id: U8): TUser;
var
	User: TUser;
begin
	User := TUser(Users.First);
	while User <> nil do
	begin
		if User.Id = Id then
		begin
			Result := User;
			Exit;
		end;
		User := TUser(Users.Next);
	end;
	Result := TUser.Create(Id, '');
	Users.Add(Result);
end;

procedure ReadAllQIPTXT;
var
	Folder: TFolder;
begin
	Folder := TFolder.Create;
	try
		Folder.SortBy := fsFileName;
		Folder.Path := SourceDirTXT;
		Folder.OnAddFile := fMain.OnAddFile;
		Folder.Mask := '*.TXT';
		Folder.Read;
	finally
		Folder.Free;
	end;
end;

procedure WriteAllQIPTXT;
var
	WriteCount: UG;
	FileName: TFileName;
	User: TUser;
begin
	WriteCount := 0;
	User := TUser(Users.First);
	while User <> nil do
	begin
		FileName := TargetDirTXT + IntToStr(User.Id) + '.txt';
		if FileExists(FileName) then
			User.FromQIP(FileName);
		User.ToQIP(FileName);
		User := TUser(Users.Next);
		Inc(WriteCount);
	end;
	AddMessage('Writing ' + NToS(WriteCount) + ' txt files to ' + TargetDirTXT, [], mlInformation);
end;

procedure FreeAll;
var
	i, k: SG;
	P: PEvent;
begin
	for i := 0 to SectionCount - 1 do
	begin
		P := Sections[i].Events.GetFirst;
		for k := 0 to SG(Sections[i].Events.Count) - 1 do
		begin
			P.Text := '';
			P.Data := '';
			Inc(SG(P), Sections[i].Events.ItemMemSize);
		end;
		FreeAndNil(Sections[i].Events);
	end;
	SetLength(Sections, 0);
end;

var
	MyICQ: string;

procedure ReadContactList(const FileName: TFileName);
var
	Line: TArrayOfString;
	User: TUser;
	CSVFile: TCSVFile;
begin
	if FileName = '' then Exit;

	AddMessage('Reading contact list in file %1.', [FileName], mlInformation);
	CSVFile := TCSVFile.Create(4);
	try
		if CSVFile.Open(FileName) then
		begin
			while not CSVFile.EOF do
			begin
				Line := CSVFile.ReadLine;
				if Length(Line) >= 3 then
				begin
					User := TUser.Create(StrToValS8(Line[1], False, 0, 0, High(S8), 1), Line[2]);
					Users.Add(User);
				end;
			end;
		end;
		CSVFile.Close;
	finally
		CSVFile.Free;
	end;
end;

procedure TfMain.SetDefaultContactList;
var
	Folder: TFolder;
begin
	Folder := TFolder.Create;
	try
		Folder.SortBy := fsDateTime;
		Folder.SortOrder := soDescending; // Newest file first
		Folder.Path := ParentDirF(ParentDirF(ExtractFilePath(DBFSource))) + 'Contact List' + PathDelim;
		Folder.Mask := MyICQ + '*.*';
		Folder.Read;

		if Folder.Count > 0 then
		begin
			ContactList := Folder.FirstFileName;
			InitEdits;
		end;
	finally
		Folder.Free;
	end;
end;


procedure TfMain.StartDBFXML1Click(Sender: TObject);
const
	XMLSep = FullSep;

	function SectionToFileName(Section: TSection): string;
	begin
		Result := IntToStr(Section.UID) + PathDelim + IntToStr(Section.UID) + '-' + NToS
			(Section.Month, '00') + NToS(Section.Year, '00') + '.xml';
	end;

	function CheckSection(var Section: TSection): BG;
	var
		P: PEvent;
		Tim: U4;
		k: SG;
	begin
		Result := True;
		P := Section.Events.GetFirst;
		Tim := 0;
		for k := 0 to SG(Section.Events.Count) - 1 do
		begin
			if P.Time < Tim then
			begin
				Result := False;
				Exit;
			end
			else
				Tim := P.Time;
			Inc(SG(P), Section.Events.ItemMemSize);
		end;
	end;

	procedure ReadXML(FileName: TFileName; var Section: TSection);
	var
		XML: TXML;
		E: TEvent;
		E2: PEvent;
	begin
		XML := TXML.Create(FileName);
		try
			FillChar(E, SizeOf(E), 0);
			while True do
			begin
				XML.ReadElement;
				case XML.ElementType of
				xeEOI:
					Break;
				xeStartTag:
					begin
						if XML.Element = 'root' then
						else if XML.Element = 'version' then
						begin
							XML.ReadElement;
							if XML.ElementType = xeDataValue then
								Section.Version := StrToValI(XML.Element, False, 0, 0, High(U4), 1)
						end
						else if XML.Element = 'event' then
						else if XML.Element = 'type' then
						begin
							XML.ReadElement;
							if XML.ElementType = xeDataValue then
								E.Typ := StrToValI(XML.Element, False, 0, 0, High(U4), 1);
						end
						else if XML.Element = 'incoming' then
						begin
							XML.ReadElement;
							if XML.ElementType = xeDataValue then
								if UpperCase(XML.Element) = 'YES' then
									E.Incoming := 1
								else
									E.Incoming := 0;
						end
						else if XML.Element = 'time' then
						begin
							XML.ReadElement;
							if XML.ElementType = xeDataValue then
								E.Time := StrToValS8(XML.Element, False, 0, 0, High(U8), 1);
						end
						else if XML.Element = 'text' then
						begin
							XML.ReadElement;
							if XML.ElementType = xeDataValue then
							begin
								E.Text := RemoveSuffixF(XMLSep, XML.Element); // DelEndSpaceF(XML.Element);
							end;
						end
						else if XML.Element = 'data' then
						begin
							XML.ReadElement;
							if XML.ElementType = xeDataValue then
								E.Data := XML.Element;
						end
						else
							AddMessage('Unknown tag %1 if file %2.', [XML.Element, FileName], mlError);
					end;
				xeEndTag:
					begin
						if XML.Element = 'event' then
						begin
							E2 := Section.Events.Add;
							E2^ := E;
							FillChar(E, SizeOf(E), 0);
						end;
					end;
				end;
			end;

			if CheckSection(Section) = False then
				AddMessage('XML time not organised in file %1.', [FileName], mlError);
		finally
			XML.Free;
		end;
	end;

	procedure WriteXML(FileName: TFileName; var Section: TSection);
	var
		k: SG;
		Data: string;
		P: PEvent;
	begin
		Data := '';
		Data := Data + '<root>' + XMLSep;
		Data := Data + '<version>' + '0x' + IntToHex(Section.Version, 8) + '</version>' + XMLSep;
		{ 20.32.Build.0 }
		P := Section.Events.GetFirst;
		for k := 0 to Section.Events.Count - 1 do
		begin
			Data := Data + '<event>' + XMLSep;
			Data := Data + CharTab + '<type>' + IntToStr(P.Typ) + '</type>' + XMLSep;
			Data := Data + CharTab + '<incoming>' + NoYes[P.Incoming] + '</incoming>' + XMLSep;
			Data := Data + CharTab + '<time>' + IntToStr(P.Time) + '</time>' + XMLSep;
			if P.Text <> '' then
				Data := Data + CharTab + '<text>' + P.Text + XMLSep + '</text>' + XMLSep;
			if P.Data <> '' then
				Data := Data + CharTab + '<data>' + P.Data + '</data>' + XMLSep;
			Data := Data + '</event>' + XMLSep;

			Inc(SG(P), Section.Events.ItemMemSize);
		end;
		Data := Data + '</root>' + XMLSep;
		WriteStringToFile(FileName, Data, False);
	end;

var
	TargetDirExp: string;
	Section: TSection; // XML -> XML

	procedure WriteAllXML;
	var
		WriteCount: UG;
		i: SG;
		FileName: TFileName;
	begin
		WriteCount := 0;
		if CreateDirEx(TargetDirExp) then
			for i := 0 to SectionCount - 1 do
			begin
				if Sections[i].Changed then
				begin
					if Tag and 1 = 0 then
						FileName := TargetDirExp + SectionToFileName(Sections[i])
					else
						FileName := TargetDirExp + Sections[i].FileName;
					CreateDirEx(ExtractFilePath(FileName));
					WriteXML(FileName, Sections[i]);
					Inc(WriteCount);
				end;
			end;
		AddMessage('Writing ' + NToS(WriteCount) + '/' + NToS(SectionCount)
				+ ' xml files to ' + TargetDirExp, [], mlInformation);
	end;

	procedure AddEvent(UserId: U8; Event: TUserEvent);
	var
		User: TUser;
	begin
		User := GetUser(UserId);
		User.AddEvent(Event);
	end;


var
	DBF: TDBF;
	FileName: TFileName;
	i, j, k: SG;
	Id, UserId, SUBJECT, FOLDERID, GUID, EXTID, Time, UNREAD, ALL, ALL2: PColumn;
	Year, Month, Day, Hour, Minute, Sec, MSec: U2;
	sa: AnsiString;
	s2: AnsiString;
	s: string;
	ws: UnicodeString;
	Len: U4;

	UserIdI: U8;
	UserIdS: string;

	Found, FoundE: SG;
	NewSize: SG;
	P, PS: PEvent;
	E: TEvent;
	E2: PEvent;

	Tag: SG;

	FileNames: TFileNames;
	FileNameCount: SG;

	UserEvent: TUserEvent;
	Messages: TParserMessages;
	D: TDate;
	T: TTime;
begin
	Tag := TMenuItem(Sender).Tag;
	if Tag = 2 then
	begin
		if not GetStr('Your User Name', UserName, GetEnvironmentVariable('USERNAME')) then Exit;
	end;
	Messages := TParserMessages.Create;
	MyICQ := GetICQ(DBFSource);
	if Tag = 2 then
	begin
		Users := TData.Create;
		ReadContactList(ContactList);
	end;
	BeginLongOperation;
	try
		SectionCount := 0;
		Sections := nil;
		AddedEvent := 0;
		Skipped := 0;
		Readed := 0;
		if Tag and 1 = 0 then
		begin
			FileName := DBFSource;
			TargetDirExp := DelFileExt(ExtractFileName(FileName));
			if Copy(TargetDirExp, 1, Length('Messages')) = 'Messages' then
				Delete(TargetDirExp, 1, Length('Messages'));
			TargetDirExp := TargetDir + TargetDirExp + PathDelim;
			AddMessage('Reading %1.', [FileName], mlInformation);
			DBF := TDBF.Create;
			try
				DBF.LoadFromFile(FileName);
				AddMessage('Readed %1 messages.', [NToS(DBF.Count)], mlInformation);

				Id := DBF.FindColumn('ID');
				UserId := DBF.FindColumn('USERID');
				SUBJECT := DBF.FindColumn('SUBJECT');
				FOLDERID := DBF.FindColumn('FOLDERID');
				GUID := DBF.FindColumn('GUID'); // ?
				EXTID := DBF.FindColumn('EXTID'); // ?
				Time := DBF.FindColumn('TIME');
				UNREAD := DBF.FindColumn('UNREAD');
				ALL := DBF.FindColumn('ALL');
				ALL2 := DBF.FindColumn('ALL2');

				for i := 0 to SG(DBF.Count) - 1 do
				begin
					if i + 1 <> Id.Items[i] then
						AddMessage('Bad Id (%2) in row %1.', [NToS(i + 1), Id.Items[i]], mlWarning);
					if DBF.Rows[i] = False then
						Continue;
					UserIdS := DelEndSpaceF(UserId.Items[i]);

{					if Length(UserIdS) > 9 then
					begin
						UserIdI := 0;
						AddMessage('UserId (%2) too long in row %1.', [NToS(i + 1), UserIdS], mlWarning);
					end
					else
					begin}
						UserIdI := StrToValS8(UserIdS, False, 0, 0, High(S8), 1, Messages);
//						if UserIdI <= 0 then
						if Messages.Count > 0 then
							AddMessage('Bad UserId (%2) in row %1.', [NToS(i + 1), UserIdS], mlWarning);
//					end;
					Messages.Clear;

					if Length(SUBJECT.Items[i]) = 0 then
						AddMessage('Empty Message in row %1.', [NToS(i + 1)], mlWarning);

					s := ALL2.Items[i];
					ws := '';
					Len := Length(s) div 2;
					SetLength(ws, Len);
					for j := 1 to Len do
					begin
						ws[j] := WideChar(Ord(s[2 * j - 1]) + Ord(s[2 * j]) shl 8);
					end;

					(* if ws = '' then
						begin *)
					sa := ALL.Items[i];
					if Length(sa) >= 69 then
					begin
						Len := PU4(@sa[43])^;
						if Len <= UG(Length(sa) - 47) then
						begin
							SetLength(s2, Len);
							if Len > 0 then
							begin
								Move(sa[47], s2[1], Len);
								ws := s2;
							end;
						end
						else
						begin
							Len := PU4(@sa[62])^;
							if Len <= UG(Length(sa) - 65) then
							begin
								SetLength(s2, Len);
								if Len > 0 then
								begin
									Move(sa[66], s2[1], Len);
									ws := s2;
								end;
							end
							else // RTF
							begin
								(* Len := PU4(@s[59])^;
									if Len <= UG(Length(s) - 62) then
									begin
									SetLength(s2, Len);
									if Len > 0 then
									Move(s[63], s2[1], Len);
									end
									else
									begin
									if Length(s) >= 82 then
									begin
									Len := PU4(@s[78])^;
									if Len <= UG(Length(s) - 81) then
									begin
									SetLength(s2, Len);
									if Len > 0 then
									Move(s[82], s2[1], Len);
									end
									else
									begin
									s2 := '';
									end;
									end;
									end;
									InLineIndex := 1;
									ReadToString(s2, InLineIndex, '\fs2');
									Inc(InLineIndex, 2);
									s2 := ReadToString(s2, InLineIndex, '\par');
									Replace(s2, '<##icqimage0000>', ':-)');
									fdsf *)

							end;
						end;
					end;
					// end;*)
					{ if Length(DeleteLastEnter(s2)) > Length(ws) then
						AssMes; }

					FillChar(E, SizeOf(E), 0);
					E.Text := AnsiToUtf8(StrToXML(ws));
{$IFOPT d+}
{					if AnsiToUtf8(StrToXML(Copy(ws, 1, 126))) <> AnsiToUtf8(StrToXML(SUBJECT.Items[i])) then
					begin
						// Synchronization problem
						AddMessage('Bad Message Text in row %1.', [NToS(i + 1)], mlWarning);
					end;}
{$ENDIF}
					E.Text := RepairText(E.Text);

					if FOLDERID.Items[i] = '4' then
						E.Incoming := 0
					else if FOLDERID.Items[i] = '5' then
						E.Incoming := 1
					else if FOLDERID.Items[i] = '1' then
						E.Incoming := 1 // 2
					else
					begin
						E.Incoming := 0; // 3
						AddMessage('Bad Message Type (%2) in row %1.', [NToS(i + 1), FOLDERID.Items[i]], mlWarning);
					end;

					E.Typ := 0;
					if FOLDERID.Items[i] = '1' then
					begin
						if EXTID.Items[i] = '0' then
							E.Typ := 1
							// You have recive an autorize request.
						else if EXTID.Items[i] = '1' then
							// The user has accepted your request to add you to his/her Contact List
							E.Typ := 2
						else if EXTID.Items[i] = '3' then
							// The user has added you to his/her Contact List/
							E.Typ := 3
						else if EXTID.Items[i] = '4' then
							// The user has denied your request to add him/her to yout Contact List/No reason was given
							E.Typ := 4
						else if EXTID.Items[i] = '6' then
							// The user had registered to the ICQ network./
						else
							AddMessage('Bad ExtId (%2) in row %1.', [NToS(i + 1), EXTID.Items[i]], mlWarning);
					end
					else
					begin
						if EXTID.Items[i] <> '0' then
							AddMessage('Bad ExtId (%2) in row %1.', [NToS(i + 1), EXTID.Items[i]], mlWarning);
					end;


					s := Time.Items[i];
					E.Time := 0;
					Year := 2000;
					Month := 0;
					D := 0;
					T := 0;
					if (Length(s) <> 20) or (s = StringOfChar(CharTab, 20)) then
					begin
						AddMessage('Bad Time (%2) in row %1.', [NToS(i + 1), s], mlWarning);
					end
					else
					begin
						try
							Year := StrToIntDef(Copy(s, 1, 4), 2000);
							Month := StrToIntDef(Copy(s, 5, 2), 0);
							Day := StrToIntDef(Copy(s, 7, 2), 0);
							Hour := StrToIntDef(Copy(s, 9, 2), 0);
							Minute := StrToIntDef(Copy(s, 12, 2), 0);
							Sec := StrToIntDef(Copy(s, 15, 2), 0);
							MSec := StrToIntDef(Copy(s, 18, 3), 0);
							Assert(MSec = 0);

							D := EncodeDate(Year, Month, Day);
							T := EncodeTime(Hour, Minute, Sec, MSec);
							E.Time := (Round(D) - UnixDateDelta)
								* SecsPerDay + SecsPerMin * SecsPerMin * Hour + SecsPerMin * Minute + Sec;
						except
							on E: Exception do
								AddMessage('Bad Time (%2) in row %1.', [NToS(i + 1), E.Message], mlError);
						end;
					end;

					if Tag = 2 then
					begin
						UserEvent := TUserEvent.Create;
						UserEvent.Incoming := E.Incoming <> 0;
						UserEvent.Time := D + T;
						UserEvent.Text := E.Text;
						AddEvent(UserIdI, UserEvent);
						Continue;
					end;
					Year := Year - 2000;

					Found := -1;
					for j := 0 to SectionCount - 1 do
					begin
						if Sections[j].UID = UserIdI then
							if (Sections[j].Year = Year) and (Sections[j].Month = Month) then
							begin
								Found := j;
								Break;
							end;
					end;

					if Found = -1 then
					begin
						// Load
						NewSize := SectionCount + 1;
						if AllocByExp(Length(Sections), NewSize) then
							SetLength(Sections, NewSize);
						Sections[SectionCount].UID := UserIdI;
						Sections[SectionCount].Year := Year mod 100;
						Sections[SectionCount].Month := Month;
						Sections[SectionCount].Version := $00140020;
						Sections[SectionCount].Events := TData.Create;
						Sections[SectionCount].Events.ItemSize := SizeOf(TEvent);
						Sections[SectionCount].Changed := False;

						FileName := TargetDirExp + SectionToFileName(Sections[SectionCount]);
						if FileExists(FileName) then
						begin
							ReadXML(FileName, Sections[SectionCount]);
							Inc(Readed);
						end;

						Found := SectionCount;
						Inc(SectionCount);
					end;

					P := Sections[Found].Events.GetFirst;
					FoundE := Sections[Found].Events.Count;
					for k := 0 to SG(Sections[Found].Events.Count) - 1 do
					begin
						if P.Time = E.Time then
						begin
							if P.Text = E.Text then
							begin
								Inc(Skipped);
								FoundE := -1;
								Break;
							end
							else
							begin
								// AddMessage('?'); // TODO : ?
							end;
						end
						else if P.Time > E.Time then
						begin
							FoundE := k;
							Break;
						end;

						Inc(SG(P), Sections[Found].Events.ItemMemSize);
					end;
					if FoundE >= 0 then
					begin
						Sections[Found].Changed := True;
						E2 := Sections[Found].Events.Insert(FoundE);
						E2^ := E;
						FillChar(E, SizeOf(E), 0);
						Inc(AddedEvent);
					end;
					// E.Text := '';
					// E.Data := '';
				end;
			finally
				FreeAndNil(DBF);
			end;
		end
		else
		begin
			// Read All XML from XMLSource + read same from TargetDir
			Copied := 0;
			TargetDirExp := TargetDir;
			FileNameCount := 0;
			Section.Events := TData.Create;
			Section.Events.ItemSize := SizeOf(TEvent);

			FileNameCount := 0;
			ReadDir(FileNames, FileNameCount, XMLSource, ['xml'], True, False, True, False);
			for i := 0 to FileNameCount - 1 do
			begin
				FileName := TargetDir + FileNames[i];
				if FileExists(FileName) then
				begin
					// Combine Files

					// Target
					NewSize := SectionCount + 1;
					if AllocByExp(Length(Sections), NewSize) then
						SetLength(Sections, NewSize);
					Sections[SectionCount].FileName := FileNames[i];
					Sections[SectionCount].Version := 0;
					Sections[SectionCount].Events := TData.Create;
					Sections[SectionCount].Events.ItemSize := SizeOf(TEvent);
					Inc(SectionCount);
					ReadXML(FileName, Sections[SectionCount - 1]);
					Inc(Readed);

					// Source
					FileName := XMLSource + FileNames[i];
					Section.FileName := FileNames[i];
					Section.Version := 0;
					ReadXML(FileName, Section);

					// Combine
					Found := SectionCount - 1;

					PS := Section.Events.GetFirst;
					for j := 0 to SG(Section.Events.Count) - 1 do
					begin
						P := Sections[Found].Events.GetFirst;
						FoundE := Sections[Found].Events.Count;
						for k := 0 to SG(Sections[Found].Events.Count) - 1 do
						begin
							if P.Time = PS.Time then
							begin
								if P.Text = PS.Text then
								begin
									Inc(Skipped);
									FoundE := -1;
									Break;
								end
								else
								begin
									// AddMessage('?'); // TODO : ?
								end;
							end
							else if P.Time > PS.Time then
							begin
								FoundE := k;
								Break;
							end;

							Inc(SG(P), Sections[Found].Events.ItemMemSize);
						end;
						if FoundE >= 0 then
						begin
							Sections[Found].Changed := True;
							E2 := Sections[Found].Events.Insert(FoundE);
							E2^ := PS^;
							Inc(AddedEvent);
						end;
						PS.Text := '';
						PS.Data := '';
						Inc(SG(PS), Section.Events.ItemMemSize);
					end;

					// Free
					Section.Events.Clear;
					Section.FileName := '';
				end
				else
				begin
					// Copy File
					CreateDirEx(ExtractFilePath(FileName));
					uFiles.CopyFile(XMLSource + FileNames[i], FileName, True);
					Inc(Copied);
				end;
			end;
			SetLength(FileNames, 0);
			FreeAndNil(Section.Events);
			AddMessage('%1 files copied.', [NToS(Copied)], mlInformation);
		end;
		AddMessage('%1 files readed from %2.', [NToS(Readed), TargetDirExp], mlInformation);
		if Skipped > 0 then
			AddMessage('%1 duplicate messages skipped', [NToS(Skipped)], mlWarning);
		AddMessage('Added %1 messages', [NToS(AddedEvent)], mlInformation);

		if Tag = 2 then
			WriteAllQIPTXT
		else
			WriteAllXML;

		AddMessage('Done' + FullSep, [], mlInformation);
	finally
		EndLongOperation;
		if Tag = 2 then
			FreeAndNil(Users);
		FreeAll;
		Messages.Free;
	end;
end;

procedure TfMain.FormCreate(Sender: TObject);
begin
	Background := baGradient;

	DefDBFSource := ProgramFilesDir + 'ICQ' + PathDelim + '2003b' + PathDelim + 'Messages*.dbf';
	DefTargetDir := ShellFolder('AppData') + 'ICQLite' + PathDelim + 'HistoryDB' + PathDelim;
	DefTargetDirTXT := ProgramFilesDir + 'QIP' + PathDelim + 'Users' + PathDelim + '*' + PathDelim +
		'History';

	RWOptions(False);

	InitAll;
end;

procedure TfMain.SourceDBF1Click(Sender: TObject);
begin
	OpenDialog1.Filter := GetFileNameFilter('ICQ 2003b Messages', ['Messages*.dbf'])
		+ '|' + GetFileNameFilter('Database file', ['dbf']) + '|' + AllFiles;
	OpenDialog1.FilterIndex := 1;
	OpenDialog1.FileName := '';
	if ExecuteDialog(OpenDialog1, DBFSource) then
	begin
		InitAll;
	end;
end;

procedure TfMain.SourceTXTQIP1Click(Sender: TObject);
begin
	if SelectFolder(SourceDirTXT, 'that contains TXT source files') then
		InitAll;
end;

procedure TfMain.InitEdits;
begin
	EditSourceDBF.Text := DBFSource;
	EditSourceXML.Text := XMLSource;
	EditTargetXML.Text := TargetDir;
	EditSourceTXT.Text := SourceDirTXT;
	EditTargetTXT.Text := TargetDirTXT;
	EditContactList.Text := ContactList;
end;

procedure TfMain.InitMenu;
begin
	StartDBFXML1.Enabled := FileExists(DBFSource) and DirectoryExists(TargetDir);
	MergeXMLXML1.Enabled := DirectoryExists(XMLSource) and DirectoryExists(TargetDir);
	StartDBFTXT1.Enabled := FileExists(DBFSource) and DirectoryExists(TargetDirTXT);
	MergeSourceQIPTXTtoTargetQIPTXT1.Enabled := DirectoryExists(SourceDirTXT) and DirectoryExists(TargetDirTXT);

	SetControlDesign(TEdit(EditSourceDBF), not FileExists(DBFSource));
	SetControlDesign(TEdit(EditSourceXML), not DirectoryExists(XMLSource));

	SetControlDesign(TEdit(EditTargetXML), not DirectoryExists(TargetDir));

	SetControlDesign(TEdit(EditSourceTXT), not DirectoryExists(SourceDirTXT));
	SetControlDesign(TEdit(EditTargetTXT), not DirectoryExists(TargetDirTXT));

	SetControlDesign(TEdit(EditContactList), not FileExists(ContactList));
end;

procedure TfMain.EditContactListChange(Sender: TObject);
begin
	ContactList := EditContactList.Text;
	InitMenu;
end;

procedure TfMain.MergeSourceQIPTXTtoTargetQIPTXT1Click(Sender: TObject);
begin
	BeginLongOperation;
	try
		Users := TData.Create;
		ReadContactList(ContactList);
		ReadAllQIPTXT;
		WriteAllQIPTXT;
	finally
		FreeAll;
		EndLongOperation;
	end;
end;

procedure TfMain.OnAddFile(FileName: TFileName);
var
	User: TUser;
begin
	User := GetUser(StrToIntDef(DelFileExt(ExtractFileName(FileName)), 0));
	User.FromQIP(SourceDirTXT + FileName);
end;

procedure TfMain.InitAll;
begin
	InitEdits;
	InitMenu;
end;

procedure TfMain.SourceXML1Click(Sender: TObject);
begin
	if SelectFolder(XMLSource, 'that contains XML source files') then
		InitAll;
end;

procedure TfMain.TargetXML1Click(Sender: TObject);
begin
	if SelectFolder(TargetDir, 'where XML files will be saved') then
		InitAll;
end;

procedure TfMain.EditTargetTXTChange(Sender: TObject);
begin
	TargetDirTXT := EditTargetTXT.Text;
	InitMenu;
end;

procedure TfMain.EditTargetXMLChange(Sender: TObject);
begin
	TargetDir := EditTargetXML.Text;
	InitMenu;
end;

procedure TfMain.EditSourceXMLChange(Sender: TObject);
begin
	XMLSource := EditSourceXML.Text;
	InitMenu;
end;

procedure TfMain.EditSourceDBFChange(Sender: TObject);
begin
	DBFSource := EditSourceDBF.Text;
	InitMenu;
end;

procedure TfMain.EditSourceTXTChange(Sender: TObject);
begin
	SourceDirTXT := EditSourceTXT.Text;
	InitMenu;
end;

procedure TfMain.argetTXTQIP1Click(Sender: TObject);
begin
	if SelectFolder(TargetDirTXT, 'where TXT files will be saved') then
		InitAll;
end;

procedure TfMain.ContactList1Click(Sender: TObject);
begin
	OpenDialog1.Filter := GetFileNameFilter('ICQ 2003b Contact List', ['clb'])
		+ '|' + GetFileNameFilter('QIP Contact List', ['cl']) + '|' +
		GetFileNameFilter('Contact List', ['clb', 'cl']) + '|' +
		AllFiles;
	OpenDialog1.FilterIndex := 3;
	OpenDialog1.FileName := '';

	if ExecuteDialog(OpenDialog1, ContactList) then
	begin
		InitAll;
	end;
end;

procedure TfMain.DefaultContactList1Click(Sender: TObject);
begin
	SetDefaultContactList;
	InitAll;
end;

procedure TfMain.DefaultSourceDBF1Click(Sender: TObject);
begin
	DBFSource := DefDBFSource;
	InitAll;
end;

procedure TfMain.DefaultSourceTXT1Click(Sender: TObject);
begin
	SourceDirTXT := DefSourceDirTXT;
	InitAll;
end;

procedure TfMain.DefaultTargetTXT1Click(Sender: TObject);
begin
	TargetDirTXT := DefTargetDirTXT;
	InitAll;
end;

procedure TfMain.DefaultTargetXML1Click(Sender: TObject);
begin
	TargetDir := DefTargetDir;
	InitAll;
end;

end.
