// * File:     FileExtensions\uMain.pas
// * Created:  1999-11-28
// * Modified: 2008-09-13
// * Version:  1.0.47.21
// * Author:   David Safranek (Safrad)
// * E-Mail:   safrad at email.cz
// * Web:      http://safrad.own.cz

unit uMain;

interface

uses
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
	StdCtrls, uDButton, uDForm, Menus, ComCtrls;

type
	TfMain = class(TDForm)
		MainMenu1: TMainMenu;
		File1: TMenuItem;
		Options1: TMenuItem;
		Help1: TMenuItem;
		FileExtensions1: TMenuItem;
		EditExtensions1: TMenuItem;
		procedure FormCreate(Sender: TObject);
		procedure FileExtensions1Click(Sender: TObject);
		procedure FormShow(Sender: TObject);
		procedure FormClose(Sender: TObject; var Action: TCloseAction);
		procedure EditExtensions1Click(Sender: TObject);
	private
		{ Private declarations }
	public
		{ Public declarations }
	end;

var
	fMain: TfMain;

implementation

{$R *.DFM}
uses
	uTypes, uFiles, uReg, uSplash, uAbout, uDBitmap, uProjectInfo, uOutputFormat, uFileExt, uCSVFile, uWatch, uDIniFile,
	uAPI, uStart;
var
	CSVFileName: TFileName;
{
type
	TAction = class
		Name: string;
		FileName: TFileName;
	end;
	TFileExtension = record
		Extension: string;
		Description: string;
		IconFileName: string;
		Action: TAction;
	end;
var
	FileExtensions: array of TFileExtension;
	FileExtensionCount: SG;
}

procedure ReadFromCSV(const FileName: TFileName);
var
	CSV: TCSVFile;
	Row: TArrayOfString;
begin
	FreeFileExt;

	Row := nil;
	CSV := TCSVFile.Create(5);
	try
		if CSV.Open(FileName) then
		begin
			while not CSV.EOF do
			begin
				Row := CSV.ReadLine;
				AddFileType(Row[0], Row[1], Row[2], [Row[3]], [Row[4]]);
			end;
			CSV.Close;
		end;
	finally
		CSV.Free;
	end;
//	AddFileType(
// Graphics
{	for i := 0 to Length(AllPictureExt) - 1 do
	begin
		Inc(FileExtensionCount);
		Result := Result and
			CustomFileType(
				FileTypesOperation,
				AllPictureExt[i],
				AllPictureDes[i],
				'',
				['ACDSee', 'Paint Shop', 'Photo Editor'],
				[ACDSee, PaintShop, PhotoEd]);}
end;
(*
function RegExt(const FileTypesOperation: TFileTypesOperation): Boolean;
const
	AudioDir = 'C' + DriveDelim + PathDelim + 'Utils' + PathDelim + 'Audio' + PathDelim;
	VideoDir = 'C' + DriveDelim + PathDelim + 'Utils' + PathDelim + 'Video' + PathDelim;
	CoolTitle = 'Cool Edit Pro';
var
	i: SG;
	Editor,

	IconBasic,
	Shell32,
	MorIcons,
	PifMgr,
	IconDir,
	Delphi,
	ImageEditorP,
	ImageEditorI,
	BP,
	ACDSee,
	PhotoEd,
	PaintShop,
	Cool,
{	PV, Smack,} MAngelo: string;
	ExistsCount: SG;
begin
	Editor := 'C' + DriveDelim + '\Utils\Files\PSPad\PSPad.exe "%1"';

	IconBasic := SysDir + 'Shell32.dll,0';
	Shell32 := SysDir + 'Shell32.dll';
	MorIcons := SysDir + 'MorIcons.dll';
	PifMgr := SysDir + 'PifMg	r.dll';
	IconDir := MyDocuments + 'Icons' + PathDelim;
	Delphi := '"' + ProgramFilesDir + 'Borland\Delphi7\Bin\Delphi32.exe" "%1"';
	ImageEditorP := '"' + ProgramFilesDir + 'Borland\Delphi7\Bin\Imagedit.exe" "%1"';
	ImageEditorI := ProgramFilesDir +'Borland\Delphi7\Bin\Imagedit.exe,0';
	BP := 'C'+ DriveDelim + '\Utils\Develop\Bp\Bin\Bp.exe /R+ /T- %1';

	ACDSee := '"' + ProgramFilesDir + 'ACD Systems\ACDSee\5.0\ACDSee5.exe" "%1"';
	PhotoEd := '"' + ProgramFilesDir + 'Common Files\Microsoft Shared\PhotoEd\PHOTOED.EXE" "%1"';
	PaintShop := '"' + VideoDir + 'Paint Shop Pro 7\Psp.exe" "%1"';
	Cool := AudioDir + 'CoolPro\CoolPro2.exe';
//	PV := '"' + VideoDir + 'PV\PV.EXE" %1';
//	Smack := '"' + VideoDir + 'Smack.exe" %1';
	MAngelo := '"' + VideoDir + 'MicroAngelo\MUEdit.exe" %1';

{	ExistsCount := 0;
	for i := 0 to FileExtensionCount - 1 do
	begin
		if CustomFileType(
			FileTypesOperation,
			FileExtensions[i].Extension,
			FileExtensions[i].Description,
			FileExtensions[i].IconFileName,
			[FileExtensions[i].Action.Name],
			[FileExtensions[i].Action.FileName]) then
		begin
			Inc(ExistsCount);
		end;
	end;
	fMain.StatusBar1.Panels[0].Text := NToS(ExistsCount) + '/' + NToS(FileExtensionCount);
}

(*	Result :=
// Main
		CustomFileType(
			FileTypesOperation,
			'Directory',
			'',
			'',
			['Total Commander'],
			['C:\Utils\Files\WinCmd\TotalCmd.exe "%1"'])
	and
// Text
		CustomFileType(
			FileTypesOperation, 'log', 'Record of operation', MorIcons + ',64',
			['open'],
			[Editor])
	and
		CustomFileType(
			FileTypesOperation, 'txt', 'Text File Type', IconDir + 'Txt.ico',
			['open'],
			[Editor])
	and
		CustomFileType(
			FileTypesOperation, 'csv', 'Comma Separated Values', '',
			['CSV Editor'],
			['C' + DriveDelim + '\Utils\Files\CSVed\CSVed.exe "%1"'])
	and
		CustomFileType(
			FileTypesOperation, 'dat', 'Data', MorIcons + ',65',
			['open'],
			[Editor])
	and
		CustomFileType(
			FileTypesOperation, 'dbf', 'DataBase File', 'C' + DriveDelim + '\Utils\Files\DBFRead\DBFRead.exe,0',
			['DBFRead'],
			['C' + DriveDelim + '\Utils\Files\DBFRead\DBFRead.exe "%1"'])
	and
		CustomFileType(
			FileTypesOperation, 'clp', 'ClipBoard', WinDir + 'ClipBrd.exe,0',
			['ClipBoard', 'open'],
			[WinDir + 'ClipBrd.exe "%1"', Editor])
	and
		CustomFileType(
			FileTypesOperation, 'cfg', 'Configuration', MorIcons + ',105',
			['open'],
			[Editor])
	and
		CustomFileType(
			FileTypesOperation, 'con', 'Configuration', MorIcons + ',104',
			['open'],
			[Editor])
	and
		CustomFileType(
			FileTypesOperation, 'diz', 'VendInfo', MorIcons + ',52',
			['open'],
			[Editor])
	and
		CustomFileType(
			FileTypesOperation, 'nfo', 'Information', MorIcons + ',102',
			['open'],
			[Editor])
	and
		CustomFileType(
			FileTypesOperation, '602', 'T602', ProgramFilesDir + 'Microsoft Office 2000\WinWord.exe,0',
			['WinWord'],
			['"' + ProgramFilesDir + 'Microsoft Office 2000\WinWord.exe" "%1"'])
	and
		CustomFileType(
			FileTypesOperation,
			'pdf',
			'Acrobat Reader File',
			'C' + DriveDelim + '\Utils\Files\Acrobat\Reader\AcroRd32.exe,0',
			['open'],
			['"C' + DriveDelim + '\Utils\Files\Acrobat\Reader\AcroRd32.exe" "%1"'])
	and
		CustomFileType(FileTypesOperation, 'bin', 'Binary file', MorIcons + ',89',
			['open'],
			[Editor])
	and
		CustomFileType(FileTypesOperation, 'tmp', 'Temporary file', MorIcons + ',34',
			['open'],
			[Editor])
	and
		CustomFileType(
			FileTypesOperation,
			'bak',
			'BAcKup',
			Shell32 + ',54',
			['open'],
			[Editor])
	and
{		CustomFileType(
			FileTypesOperation,
			'bat',
			'',
			'',
			['open'],
			[Editor])
	and}
		CustomFileType(
			FileTypesOperation,
			'gid',
			'help hlp file',
			'WinHlp32.exe,0',
			['open'],
			[Editor])
	and
		CustomFileType(
			FileTypesOperation,
			'chk',
			'Clusters',
			'C' + DriveDelim + '\Utils\Files\PSPad\PSPad.exe,2',
			['open'],
			[Editor])
	and
// Chess
		CustomFileType(
			FileTypesOperation, 'pgn', 'Portable Game Notation', IconDir + 'Moves.ico',
			['open'],
			[Editor])
	and
		CustomFileType(
			FileTypesOperation, 'epd', 'Enhaced Position Describe', IconDir + 'BoardY.ico',
			// Extended Position Description
			['open'],
			[Editor])
	and
		CustomFileType(
			FileTypesOperation, 'fen', 'Forsyth-Eward Notation', IconDir + 'BoardY.ico',
			// Fortyshe Position
			['open'],
			[Editor])
	and
// Audio
		CustomFileType(
			FileTypesOperation,
			'wav',
			'sound Wave',
			SysDir + 'SndRec32.exe,1',
			[CoolTitle],
			['"' + Cool + '" "%1"'])
	and
		CustomFileType(
			FileTypesOperation,
			'raw',
			'Raw audio data',
			Cool + ',0',
			[CoolTitle],
			['"' + Cool + '" "%1"'])
	and
		CustomFileType(
			FileTypesOperation,
			'voc',
			'', {'sound Voice',}
			Cool + ',0',
			[CoolTitle],
			['"' + Cool + '" "%1"'])
	and
{		CustomFileType(
			FileTypesOperation,
			'rss',
			'Raw BM sound',
			Cool + ',0',
			[CoolTitle],
			['"' + Cool + '" "%1"'])
	and}
		CustomFileType(
			FileTypesOperation,
			'ico',
			'Icon',
			'',
			['ACDSee', 'MAngelo'],
			[ACDSee, MAngelo])
	and
		CustomFileType(
			FileTypesOperation,
			'tif',
			'Tagged Image File Format',
			'',
			['ACDSee', 'Paint Shop', 'Photo Editor'],
			[ACDSee, PaintShop, PhotoEd])
	and
		CustomFileType(
			FileTypesOperation,
			'tiff',
			'Tagged Image File Format',
			'',
			['ACDSee', 'Paint Shop', 'Photo Editor'],
			[ACDSee, PaintShop, PhotoEd])
	and
// Video
		CustomFileType(
			FileTypesOperation,
			'avi',
			'',
			'',
			['MPlayer',
			'bsplay',
			'MicroDVD',
			'Jamp',
			'ThePlaya'],
			['"' + ProgramFilesDir + 'Windows Media Player\mplayer2.exe" "%1"',
			'"' + VideoDir + 'bsplay\bplay.exe" "%1"',
			'"' + VideoDir + 'MicroDVD\MDVDP.exe" "%1"',
			'"' + VideoDir + 'MPlayerSubt\jamp.exe" "%1"',
			'"' + VideoDir + 'The Playa\ThePlaya.exe" "%1"'])
	and
		CustomFileType(
			FileTypesOperation,
			'mpeg',
			'',
			'',
			['MPlayer',
			'bsplay',
			'MicroDVD',
			'Jamp'],
			['"' + ProgramFilesDir + 'Windows Media Player\mplayer2.exe" "%1"',
			'"' + VideoDir + 'bsplay\bplay.exe" "%1"',
			'"' + VideoDir + 'MicroDVD\MDVDP.exe" "%1"',
			'"' + VideoDir + 'MPlayerSubt\jamp.exe" "%1"'])
	and
		CustomFileType(
			FileTypesOperation,
			'mpg',
			'',
			'',
			['MPlayer',
			'bsplay',
			'MicroDVD',
			'Jamp'],
			[
			'"' + ProgramFilesDir + 'Windows Media Player\mplayer2.exe" "%1"',
			'"' + VideoDir + 'bsplay\bplay.exe" "%1"',
			'"' + VideoDir + 'MicroDVD\MDVDP.exe" "%1"',
			'"' + VideoDir + 'MPlayerSubt\jamp.exe" "%1"'])
	and
		CustomFileType(
			FileTypesOperation,
			'ini',
			'Configuration',
			MyDocuments + 'Icons\INI.ico',// 145
			['open',
			'bsplay',
			'MicroDVD'],
			[Editor,
			'"' + VideoDir + 'bsplay\bplay.exe" "%1"',
			'"' + VideoDir + 'MicroDVD\MDVDP.exe" "%1"'])
	and
		CustomFileType(
			FileTypesOperation,
			'qt',
			'',
			VideoDir + 'QuickTime\QuickTimePlayer.exe,0',
			['play'],
			['"' + VideoDir + 'QuickTime\QuickTimePlayer.exe" "%1"'])
	and
		CustomFileType(
			FileTypesOperation,
			'mov',
			'',
			VideoDir + 'QuickTime\QuickTimePlayer.exe,0',
			['play'],
			['"' + VideoDir + 'QuickTime\QuickTimePlayer.exe" "%1"'])
	and
// Program Languages
		CustomFileType(
			FileTypesOperation,
			'asm',
			'source Assembler',
			MorIcons + ',85',
			['QAsm', 'open'],
			['C' + DriveDelim + '\Utils\Develop\QAsm\QAsm.exe %1', Editor])
	and
		CustomFileType(
			FileTypesOperation,
			'bas',
			'source Basic',
			MorIcons + ',15',
			['Quick Basic', 'open'],
			['C' + DriveDelim + '\Utils\Develop\QB45\QB.exe %1 /h', Editor])
	and
		CustomFileType(
			FileTypesOperation,
			'c',
			'source C',
			MorIcons + ',3',
			['open'],
			[Editor])
	and
		CustomFileType(
			FileTypesOperation,
			'pas',
			'Pascal Source',
			'',
			['BP'],
			[BP])
	and
		CustomFileType(FileTypesOperation, 'dcu', 'Delphi compiled unit', IconDir + 'Dcu.ico,0',
			['open'],
			[Editor])
	and
		CustomFileType(FileTypesOperation, 'dfm', 'Delphi form', '',
			['open'],
			[Editor])
	and
		CustomFileType(FileTypesOperation, 'dsk', 'Delphi desktop', IconDir + '3 blue.ico,0',
			['open'],
			[Editor])
	and
		CustomFileType(FileTypesOperation, 'dof', 'Delphi options file', IconDir + '3 red.ico,0',
			['open'],
			[Editor])
	and
		CustomFileType(FileTypesOperation, 'rc', 'Resource source', ImageEditorI,
			['open'],
			[Editor])
	and
		CustomFileType(FileTypesOperation, 'res', 'Resource compiled', ImageEditorI,
			['Image editor'],
			[ImageEditorP])
	and
		CustomFileType(FileTypesOperation, 'ico', 'Icon', '',
			['Image editor'],
			[ImageEditorP])
	and
		CustomFileType(
			FileTypesOperation,
			'jar',
			'',
			'',
			['WinZip'],
			['"C' + DriveDelim + '\Utils\Packers\WinZip\WinZip32.exe" "%1"']);

// Graphics
	for i := 0 to Length(AllPictureExt) - 1 do
		Result := Result and
			CustomFileType(
				FileTypesOperation,
				AllPictureExt[i],
				AllPictureDes[i],
				'',
				['ACDSee', 'Paint Shop', 'Photo Editor'],
				[ACDSee, PaintShop, PhotoEd]);
end; *)
(*
procedure TfMain.InitReg;
begin
	ButtonRegister.Down := RegExt(foExists);
	ButtonUnregister.Down := not ButtonRegister.Down;
end;

procedure TfMain.ButtonRegisterClick(Sender: TObject);
begin
	RegExt(foCreate);
	InitReg;
end;

procedure TfMain.ButtonUnregisterClick(Sender: TObject);
begin
	RegExt(foDelete);
	InitReg;
end;
*)
procedure TfMain.FormCreate(Sender: TObject);
var
	Name: string;
begin
	Background := baGradient;
	MainIni.RWFormPos(Self, False);
	Name := GetProjectInfo(piInternalName) + '.csv';
	CSVFileName := AppDataDir + Name;
	if RunFirstTime then
	begin
		uFiles.CopyFile(WorkDir + 'Sample\' + Name, CSVFileName, True);
	end;
	WatchAddFile(CSVFileName, ReadFromCSV);
	ReadFromCSV(CSVFileName);
//	InitReg;
end;

procedure TfMain.FileExtensions1Click(Sender: TObject);
begin
	FormFileExt;
end;

procedure TfMain.FormShow(Sender: TObject);
begin
	FormFileExt;
end;

procedure TfMain.FormClose(Sender: TObject; var Action: TCloseAction);
begin
	MainIni.RWFormPos(Self, True);
	WatchRemoveFile(CSVFileName);
	FreeFileExt;
end;

procedure TfMain.EditExtensions1Click(Sender: TObject);
begin
	APIOpen(CSVFileName);
end;

end.
