// * File:     EventScheduler\ufWall.pas
// * Created:  1999-08-01
// * Modified: 2010-02-01
// * Version:  2.4.47.112
// * Author:   David Safranek (Safrad)
// * E-Mail:   safrad at email.cz
// * Web:      http://safrad.own.cz

unit ufWall;

interface

uses
	uTypes, uDForm, uFiles, uFileList,
	Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
	StdCtrls, uDButton, uDImage, uDView, uDWinControl;

type
	TfWall = class(TDForm)
		DViewW: TDView;
		procedure FormCreate(Sender: TObject);
		procedure FormDestroy(Sender: TObject);
		procedure FormShow(Sender: TObject);
		procedure DViewWGetData(Sender: TObject; var Data: String; ColIndex,
			RowIndex: Integer; Rect: TRect);
		procedure DViewWDblClick(Sender: TObject);
		procedure DViewWColumnClick(Sender: TObject; Column: TColumn);
	private
		{ Private declarations }
		procedure RWOptions(const Save: Boolean);
	public
		{ Public declarations }
	end;

var
	fWall: TfWall;

implementation

uses
	uDIniFile, uOutputFormat, uMath, uSorts, uWallpaper, uDictionary, uAPI;

{$R *.dfm}

procedure TfWall.RWOptions(const Save: Boolean);
begin
	MainIni.RWFormPos(Self, Save);
	DViewW.Serialize(MainIni, Save);
end;

procedure TfWall.FormCreate(Sender: TObject);
begin
	Background := baNone;

	DViewW.AddColumn('#', 48);
	DViewW.AddColumn('File Name', 128);
	DViewW.AddColumn('Count On', 64, taRightJustify);
	DViewW.AddColumn('Time On', 64, taRightJustify);
//	DViewW.AddColumn('Exists', 32);

	RWOptions(False);
	Dictionary.TranslateForm(Self);
end;

procedure TfWall.FormDestroy(Sender: TObject);
begin
	RWOptions(True);
end;

procedure TfWall.FormShow(Sender: TObject);
begin
	DViewW.RowCount := Wallpapers.FileList.WDCount;
	DViewW.DataChanged;
end;

procedure TfWall.DViewWGetData(Sender: TObject; var Data: String; ColIndex,
	RowIndex: Integer; Rect: TRect);
var WD: PWD;
begin
	if Wallpapers.FileList.IsWDSelected(RowIndex) then
	begin
//		DViewW.Bitmap.Canvas.Brush.Color := clActiveCaption;
//		DViewW.Bitmap.Canvas.Font.Color := clCaptionText;
		DViewW.Bitmap.Canvas.Font.Style := [fsBold];
	end
	else if not Wallpapers.FileList.IsWDExists(RowIndex) then
		DViewW.Bitmap.Canvas.Font.Style := [fsStrikeOut]
	else
	begin
		DViewW.Bitmap.Canvas.Font.Style := [];
	end;
//	WD := Wallpapers.FileList.FindPWDByFileName(ExtractFileName(Wallpapers.FileList.GetFileNameFromIndex(RowIndex)));
	WD := Wallpapers.FileList.GetPWD(RowIndex);
	if WD <> nil then
		case ColIndex of
		0: Data := NToS(RowIndex + 1);
		1: Data := WD.Name;
		2: Data := NToS(WD.CountOn);
		3: Data := MsToStr(WD.TimeOn, diDHMSD, 3, False);
//		4: Data := NToS(SG(WD.Exists));
		end;
end;

procedure TfWall.DViewWDblClick(Sender: TObject);
var PathFileName: TPathFileName;
begin
	if DViewW.Where = vaRow then
	begin
		PathFileName := Wallpapers.FileList.GetPathFileNameFromWDIndex(DViewW.ActualRow);
		if PathFileName <> nil then
		begin
			APIOpen(Wallpapers.FileList.Path + PathFileName.FileName);
		end;
	end;
end;

procedure TfWall.DViewWColumnClick(Sender: TObject; Column: TColumn);
var
	i: SG;
	WD: PWD;
	ASG: array of SG;
	AStr: array of string;
begin
//	FillOrderU4(DViewW.RowOrder[0], DViewW.RowCount);
	case DViewW.SortBy of
	0, 2, 3: SetLength(ASG, Wallpapers.FileList.WDCount);
	1: SetLength(AStr, Wallpapers.FileList.WDCount);
	end;
	for i := 0 to Wallpapers.FileList.WDCount - 1 do
	begin
		WD := Wallpapers.FileList.GetPWD(i);
//		WD := Wallpapers.FileList.FindPWDByFileName(ExtractFileName(Wallpapers.FileList.GetFileNameFromIndex(i)));

		case DViewW.SortBy of
		1: AStr[i] := WD.Name;
		2: ASG[i] := WD.CountOn;
		3: ASG[i] := WD.TimeOn;
		end;
	end;
	if Length(ASG) > 0 then SortS4(False, False, PArraySG(DViewW.RowOrder), PArrayS4(ASG), DViewW.RowCount);
	if Length(AStr) > 0 then SortStr(PArraySG(DViewW.RowOrder), PArrayString(AStr), DViewW.RowCount);
	SetLength(AStr, 0);
	SetLength(ASG, 0);
end;

end.
