// * File:     EventScheduler\uIcons.pas
// * Created:  2007-05-27
// * Modified: 2009-09-02
// * Version:  2.4.47.112
// * Author:   David Safranek (Safrad)
// * E-Mail:   safrad at email.cz
// * Web:      http://safrad.own.cz

unit uIcons;

interface

uses
	uTypes,
	Graphics;

type
	TIconType = (
		itCP,
		itPM,
		itVM,
		itMessage {and Main icon if all others are hiden});

var
//	StatusStep: array[TIconType] of SG;
	IconTypeStr: array[TIconType] of string;
	ActualValue: array[TIconType] of SG;

function GetIcon(const IconType: TIconType; const Value: SG): TIcon;
procedure FreeIconBuffer;

implementation

uses
	Types,
	SysUtils,
	uMsg,
	uFiles,
	uStrings,
	uDBitmap,
	uColor,
	uMath,
	uOutputFormat,
	uDrawStyle;

const
	MaxIcon = 10;
const
	IconNames: array[0..MaxIcon] of string = ('Red', 'Orange', 'Yellow', 'Lime',
		'Aqua', 'Mes0', 'Mes1', 'Mes2', 'EventScheduler', 'Win', 'WinX');

var
	IconBuffer: array[TIconType, 0..100] of TIcon;

function GetIcon(const IconType: TIconType; const Value: SG): TIcon;
var
	Bmp: TDBitmap;
	C: TColor;
	s: string;
begin
{	if Value < 0 then
	begin
		if Icons[IconIndex] = nil then
		begin
		try
			Icons[IconIndex] := TIcon.Create;
			Icons[IconIndex].LoadFromFile(GraphDir + IconNames[IconIndex] + '.ico');
		except
			on E: Exception do
				ErrorMsg(E.Message);
		end;
		end;
		TrayIcons[i].Icon := Icons[IconIndex];
		TrayIcons[i].Active := True;
	end;}
	if IconBuffer[IconType, Value] = nil then
	begin
		if IconType = itMessage then
		begin
			try
				IconBuffer[IconType, Value] := TIcon.Create;
				IconBuffer[IconType, Value].LoadFromFile(GraphDir + IconNames[Value] + '.ico');
			except
				on E: Exception do
					ErrorMsg(E.Message);
			end;
		end
		else
		begin
			// Generate Icon
			Bmp := TDBitmap.Create;
			try
				Bmp.SetSize(16, 16);
				case IconType of
				itCP:
				begin
					C := SpectrumColor(RoundDiv(MaxSpectrum2 * (100 - Value), 2 * 100));
					Bmp.Bar(DarkerColor(C), ef16);
				end;
				itPM, itVM:
				begin
					C := GrayColor(RoundDiv(255 * (100 - Value), 100));
					Bmp.Bar(C, ef16);
				end;
				else
					C := clWhite;
				end;
	{				if IconIndex >= -101 then
					Bmp.Border(clBlack, clWhite, 2, ef08)
				else
					Bmp.Border(clWhite, clBlack, 2, ef16);}
				case IconType of
				itCP, itPM, itVM:
				begin
					Bmp.Border(clBlack, clWhite, 1, ef08);

					Bmp.Canvas.Brush.Style := bsClear;
//					if Value <> 0 then
					begin
						if Value = 100 then
							s := '!!'
						else
							s := NToS(Value, '#0');
		//						s := NToS(RoundDiv(100 * CPU, 100{StatusCPUUsage}), '#0');
		{					if IconIndex >= -101 then
							Bmp.Canvas.Font.Color := MixColors(C, clWhite) // ColorDiv(C, 5 * 65536 div 3); //$00efaf9f;
						else}
							Bmp.Canvas.Font.Color := NegMonoColor(C);

						Bmp.FTextOut(
							2,
							0,
							fs6x8,
							Bmp.Canvas.Font.Color,
							clNone,
							ef16,
							IconTypeStr[IconType]);
						Bmp.FTextOut(
							2,
							8,
							fs6x8,
							Bmp.Canvas.Font.Color,
							clNone,
							ef16,
							s);
		{					Bmp.Canvas.TextOut(
							(Bmp.Width - Bmp.Canvas.TextWidth(s)) div 2,
							(Bmp.Height - Bmp.Canvas.TextHeight(s)) div 2,
							s); }
					end;
					end;
				end;
				IconBuffer[IconType, Value] := Bmp.CreateIcon(16, 16);
			finally
				Bmp.Free; // Must be after TrayIcon.Icon := Icon !!!
			end;
		end;
	end;
	Result := IconBuffer[IconType, Value];
end;

procedure FreeIconBuffer;
var
	i: SG;
	j: TIconType;
begin
	for j := Low(j) to High(j) do
		for i := 0 to 100 do
			FreeAndNil(IconBuffer[j, i]);
end;

initialization
	EnumToStr(TypeInfo(TIconType), IconTypeStr);
finalization
	FreeIconBuffer;
end.
