// * File:     EventScheduler\ufZoomer.pas
// * Created:  1999-08-01
// * Modified: 2010-11-13
// * Version:  2.4.47.112
// * Author:   David Safranek (Safrad)
// * E-Mail:   safrad at email.cz
// * Web:      http://safrad.own.cz

unit ufZoomer;

interface

uses
	uTypes,
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
	ExtCtrls, Menus, uDForm, uDTimer, uDImage, uDWinControl;

type
	TfZoomer = class(TDForm)
		PopupMenu1: TPopupMenu;
		Copy1: TMenuItem;
		RefreshTime1: TMenuItem;
		DTimer1: TDTimer;
		N2: TMenuItem;
		Close1: TMenuItem;
		ImageZoom: TDImage;
		N1: TMenuItem;
		procedure ImageZoomMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState;
			X, Y: Integer);
		procedure ImageZoomMouseUp(Sender: TObject; Button: TMouseButton; Shift: TShiftState;
			X, Y: Integer);
		procedure ImageZoomMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
		procedure FormCreate(Sender: TObject);
		procedure RefreshTime1Click(Sender: TObject);
		procedure FormShow(Sender: TObject);
		procedure FormHide(Sender: TObject);
		procedure PopupMenu1Popup(Sender: TObject);
		procedure DTimer1Timer(Sender: TObject);
		procedure FormResize(Sender: TObject);
		procedure Close1Click(Sender: TObject);
		procedure ImageZoomFill(Sender: TObject);
	private
		{ Private declarations }
		MouseCaptured: Boolean;
		RefreshTime: U4;
		LX, LY, NX, NY: SG;
		procedure RWOptions(const Save: Boolean);
	public
		{ Public declarations }
	end;

var
	fZoomer: TfZoomer;

implementation

{$R *.DFM}

uses
	ClipBrd,
	uGetTime, uGColor, uScreen, uDBitmap, uDIniFile, uOutputFormat, uStrings, uColor, uDrawStyle, uDictionary,
	uMain;

var
	GrateColor: TColor;

procedure TfZoomer.ImageZoomMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState;
	X, Y: Integer);
begin
	if (not MouseCaptured) and (Button = mbLeft) then
	begin
		MouseCaptured := True;
	end;
end;

procedure TfZoomer.ImageZoomMouseUp(Sender: TObject; Button: TMouseButton; Shift: TShiftState;
	X, Y: Integer);
begin
	if MouseCaptured and (Button = mbLeft) then
	begin
		MouseCaptured := False;
	end;
end;

procedure TfZoomer.ImageZoomMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
begin
	if MouseCaptured then
	begin
		// Draw(X + Left + (Width - ClientWidth) div 2, Y + Top + (Height - ClientHeight) - (Width - ClientWidth) div 2);
		NX := Mouse.CursorPos.X;
		NY := Mouse.CursorPos.Y;
		ImageZoom.Invalidate;
	end;
end;

procedure TfZoomer.RWOptions(const Save: Boolean);
const
	Section = 'Zoomer';
begin
	MainIni.RWFormPos(Self, Save);
	ImageZoom.Serialize(MainIni, Save);
	MainIni.RWNum(Section, 'RefreshTime', RefreshTime, Save);
	MainIni.RWNum(Section, 'MouseX', NX, Save);
	MainIni.RWNum(Section, 'MouseY', NY, Save);
	MainIni.RWNum(Section, 'GrateColor', U4(GrateColor), Save);
end;

procedure TfZoomer.FormCreate(Sender: TObject);
begin
	Background := baUser;
	{ ImageMMouseDown(Sender, mbLeft, [], 0, 0);
		ImageMMouseMove(Sender, [], NowWidth div 2, NowHeight div 2);
		ImageMMouseUp(Sender, mbLeft, [], 0, 0); }
	// Zoom := ZoomDiv div 2;
	RWOptions(False);
	ImageZoom.CreateZoom(nil);
	DTimer1.Interval := RefreshTime;
	Dictionary.TranslateForm(Self);
end;

procedure TfZoomer.RefreshTime1Click(Sender: TObject);
begin
	if GetTime('Refresh Time', RefreshTime, 0, 0, 1000 * 60, nil) then
	begin
		if RefreshTime > 0 then
			DTimer1.Interval := RefreshTime;
		DTimer1.Enabled := RefreshTime > 0;
	end;
end;

procedure TfZoomer.FormShow(Sender: TObject);
begin
	fMain.Zoomer1.Checked := True;
	MouseCaptured := False;
	SetCapture(Handle);
	GetDesktop;
	if RefreshTime = 0 then
		ImageZoom.Invalidate;
	DTimer1.Enabled := RefreshTime > 0;
end;

procedure TfZoomer.FormHide(Sender: TObject);
begin
	fMain.Zoomer1.Checked := False;
	RWOptions(True);
	MouseCaptured := False;
	DTimer1.Enabled := False;
	ReleaseCapture;
end;

procedure TfZoomer.PopupMenu1Popup(Sender: TObject);
begin
	RefreshTime1.Caption := 'Refresh Time (' + MsToStr(RefreshTime, diMSD, 3, False)
		+ ')' + cDialogSuffix;
	{ ZoomIn1.Enabled := 256 * Zoom > ZoomDiv;
		ZoomOut1.Enabled :=  Zoom < 32 * ZoomDiv; }
end;

procedure TfZoomer.DTimer1Timer(Sender: TObject);
begin
	NX := Mouse.CursorPos.X;
	NY := Mouse.CursorPos.Y;
	if (NX <> LX) or (NY <> LY) then
		ImageZoom.Invalidate;
end;

procedure TfZoomer.FormResize(Sender: TObject);
begin
	{ if ZoomDiv > Zoom then
		begin
		ClientWidth := (ZoomDiv div Zoom) * RoundDiv(ClientWidth, ZoomDiv  div Zoom);
		ClientHeight := (ZoomDiv div Zoom) * RoundDiv(ClientHeight, ZoomDiv div Zoom);
		end; }
end;

procedure TfZoomer.Close1Click(Sender: TObject);
begin
	Close;
end;

procedure OnApply(Color: TColor);
begin
end;

procedure TfZoomer.ImageZoomFill(Sender: TObject);
var
	ZX, ZY, SX, SY: SG;
	Bmp: TDBitmap;
	s, s2: string;
	// i: SG;
	C: TRGBA;
begin
	LX := NX;
	LY := NY;
	ZX := ImageZoom.Bitmap.Width { * Zoom div ZoomDiv } ;
	ZY := ImageZoom.Bitmap.Height { * Zoom div ZoomDiv } ;
	if ImageZoom.UserBitmap = nil then
	begin
		ImageZoom.UserBitmap := TDBitmap.Create;

	end;
	ImageZoom.UserBitmap.SetSize(ZX, ZY);
	ImageZoom.UserArea := Rect(0, 0, Screen.Width - 1, Screen.Height - 1);

	Bmp := ImageZoom.UserBitmap;

	Bmp.Bar(clBlack, ef16);
	SetStretchBltMode(Bmp.Canvas.Handle, COLORONCOLOR);
	SX := (2 * NX - ZX) div 2;
	SY := (2 * NY - ZY) div 2;
	if Bmp <> nil then
	begin
		StretchBlt(Bmp.Canvas.Handle, 0, 0, Bmp.Width, Bmp.Height, DesktopDC, SX, SY, ZX, ZY, SRCCOPY);
	end;
	ImageZoom.Bitmap.Bmp(0, 0, Bmp, ef16);
	(*
		//	if Grating1.Checked then
		//		if 2 * Zoom < ZoomDiv then
		begin
		i := 0;
		while i < Bmp.Width do
		begin
		Bmp.Line(i, 0, i, Bmp.Height - 1, GrateColor, ef12);
		Inc(i, 1{ZoomDiv div Zoom});
		end;
		i := 0;
		while i < Bmp.Height do
		begin
		Bmp.Line(0, i, Bmp.Width - 1, i, GrateColor, ef12);
		Inc(i, 1{ZoomDiv div Zoom});
		end;
		end;
		*)
	if ImageZoom.Zoom > 1 then
	begin
		s := '1 / ' + NToS(1 { Zoom div ZoomDiv } );
		s2 := '';
	end
	else
	begin
		s := NToS(1 { ZoomDiv div Zoom } );
		if Bmp <> nil then
		begin
			GetPix(Bmp.Data, Bmp.ByteX, 1, 1, C);
			s2 := ', Color: ' + ColorToString(C.L);
		end;
	end;

	Caption := 'Zoom ' + s + CharTimes + ': (' + NToS(SX) + ', ' + NToS(SY)
		+ ') ' + RightArrow + ' (' + NToS(SX + ZX - 1) + ', ' + NToS(SY + ZY - 1) + ') = (' + NToS(ZX)
		+ ' ' + CharTimes + ' ' + NToS(ZY) + ')' + s2;

end;

end.
