// * File:     EventScheduler\ufCapture.pas
// * Created:  1999-08-01
// * Modified: 2009-12-09
// * Version:  2.4.47.112
// * Author:   David Safranek (Safrad)
// * E-Mail:   safrad at email.cz
// * Web:      http://safrad.own.cz

unit ufCapture;

interface

uses
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
	StdCtrls, uDButton, uDLabel, ExtCtrls, uDTimer, uDForm, uDEdit;

type
	TfCapture = class(TDForm)
		LabelPixelFormat: TLabel;
		ButtonCapture: TDButton;
		ComboBoxPF: TComboBox;
		EditX0: TDEdit;
		EditY0: TDEdit;
		EditX1: TDEdit;
		EditY1: TDEdit;
		Timer1: TDTimer;
		ButtonRepetition: TDButton;
		ComboBoxFormat: TComboBox;
		ComboBoxQuality: TComboBox;
		ComboBoxInterval: TComboBox;
		Bevel1: TBevel;
		Bevel2: TBevel;
		LabelX1: TLabel;
		LabelX2: TLabel;
		LabelCaptureInterval: TLabel;
		ButtonChanges: TDButton;
		EditCaptureIndex: TDEdit;
		ButtonCaptureFolder: TDButton;
		Label1: TLabel;
		DButtonAll: TDButton;
		procedure ButtonCaptureClick(Sender: TObject);
		procedure FormCreate(Sender: TObject);
		procedure FormShow(Sender: TObject);
		procedure FormHide(Sender: TObject);
		procedure Timer1Timer(Sender: TObject);
		procedure ButtonCaptureFolderClick(Sender: TObject);
		procedure ComboBoxFormatChange(Sender: TObject);
		procedure ComboBoxIntervalChange(Sender: TObject);
		procedure DButtonAllClick(Sender: TObject);
	private
		{ Private declarations }
		procedure RWOptions(const Save: Boolean);
	public
		{ Public declarations }
	end;

var
	fCapture: TfCapture;

implementation

{$R *.DFM}
uses
	Math,
	uTypes, uFiles, uDIniFile, uGraph, uMain, uDBitmap, uInputFormat, uMath, uOutputFormat, uAPI, uDictionary;

var
	BmpIndex: SG;
	CapBmp: array[0..1] of TDBitmap;
	FileIndex: SG;
	XS0, YS0, XS1, YS1: SG;
	TypStr: string;
	Quality: SG;
	CapDir: string;

procedure InitCapBmp(const DPixelFormat: TPixelFormat);
begin
	CapBmp[0].SetSize(0, 0);
	CapBmp[1].SetSize(0, 0);
	CapBmp[0].PixelFormat := DPixelFormat;
	CapBmp[1].PixelFormat := DPixelFormat;
	CapBmp[0].SetSize(XS1 - XS0 + 1, YS1 - YS0 + 1);
	CapBmp[1].SetSize(XS1 - XS0 + 1, YS1 - YS0 + 1);
end;

procedure Capture;
var
	FName: TFileName;
	DPixelFormat: TPixelFormat;
begin
	case fCapture.ComboBoxPF.ItemIndex of
//	0: DPixelFormat := pfDevice;
	0: DPixelFormat := pf1bit;
	1: DPixelFormat := pf4bit;
	2: DPixelFormat := pf8bit;
//	4: DPixelFormat := pf15bit;
	3: DPixelFormat := pf16bit;
	4: DPixelFormat := pf24bit;
	5: DPixelFormat := pf32bit;
	else DPixelFormat := pf32bit;
	end;
	if (FileIndex = 0) or (DPixelFormat <> CapBmp[BmpIndex].PixelFormat) or
		(CapBmp[BmpIndex].Width <> XS1 - XS0 + 1) or (CapBmp[BmpIndex].Height <> YS1 - YS0 + 1) then
	begin
		InitCapBmp(DPixelFormat);
	end;

	BitBlt(CapBmp[BmpIndex].Canvas.Handle, 0, 0, CapBmp[BmpIndex].Width, CapBmp[BmpIndex].Height,
		DesktopDC, XS0, YS0, SRCCOPY);
	if fCapture.ButtonChanges.Down then
	begin
{		ReadMem(CapBmp[BmpIndex].GLData, CapBmp[BmpIndex].DataSize);
		ReadMem(CapBmp[BmpIndex xor 1].GLData, CapBmp[BmpIndex xor 1].DataSize);}

		if SameData(CapBmp[BmpIndex].GLData, CapBmp[BmpIndex xor 1].GLData, CapBmp[BmpIndex xor 1].DataSize) then
			Exit;
	end;

	FName := CapDir + {NToS(FileIndex, '0000')} '.' + TypStr;
	NewFileOrDirEx(string(FName));
	CapBmp[BmpIndex].SaveToFileEx(FName, Quality);
	Inc(FileIndex);
	BmpIndex := BmpIndex xor 1;
	fCapture.EditCaptureIndex.Text := NToS(FileIndex);
end;

procedure CaptureDone;
begin
	ReleaseDesktop;
	FreeAndNil(CapBmp[1]);
	FreeAndNil(CapBmp[0]);
end;

procedure TfCapture.ButtonCaptureClick(Sender: TObject);
var
	DesktopRect: TRect;
begin
	if ButtonCapture.Down then
	begin
		Timer1.Enabled := False;
		ButtonCapture.Down := False;
		CaptureDone;
		Exit;
	end;

	if GetDesktop then
	begin
		DesktopRect := Screen.DesktopRect;

		// ReadParams
		XS0 := StrToValI(EditX0.Text, True, DesktopRect.Left, DesktopRect.Left, DesktopRect.Right - 1, 1);
		YS0 := StrToValI(EditY0.Text, True, DesktopRect.Top, DesktopRect.Top, DesktopRect.Bottom - 1, 1);
		XS1 := StrToValI(EditX1.Text, True, DesktopRect.Left, DesktopRect.Right - 1, DesktopRect.Right - 1, 1);
		YS1 := StrToValI(EditY1.Text, True, DesktopRect.Top, DesktopRect.Bottom - 1, DesktopRect.Bottom - 1, 1);
	{		if ButtonRepeation.Down then
		begin
			Color := clHighlight;
		end
		else
		begin
			Color := clBtnFace;
		end;}
		FreeAndNil(CapBmp[0]);
		FreeAndNil(CapBmp[1]);
		CapBmp[0] := TDBitmap.Create;
		CapBmp[1] := TDBitmap.Create;
		TypStr := AllPictureExt[ComboBoxFormat.ItemIndex];
		Quality := -StrToValI(ComboBoxQuality.Text, True, SG(0), 90, 100, 1);

		if CapDir = '' then
		begin
			CapDir := AppDataDir + 'Capture' + PathDelim;
			NewFileOrDirEx(CapDir);
			CapDir := CapDir + PathDelim;
			CreateDirEx(CapDir);
		end;

		if ButtonRepetition.Down then
		begin
			BmpIndex := 0;
			Timer1.Enabled := True;
			ButtonCapture.Down := True;
		end
		else
		begin
			Capture;
			CaptureDone;
		end;
	end;
end;

procedure TfCapture.RWOptions(const Save: Boolean);
const
	Section = 'Capture';
begin
	MainIni.RWFormPos(Self, Save);
	MainIni.RWEdit(Section, TEdit(EditX0), Save);
	MainIni.RWEdit(Section, TEdit(EditY0), Save);
	MainIni.RWEdit(Section, TEdit(EditX1), Save);
	MainIni.RWEdit(Section, TEdit(EditY1), Save);
	MainIni.RWButton(Section, ButtonRepetition, Save);
	MainIni.RWButton(Section, ButtonChanges, Save);
	MainIni.RWComboBox(Section, ComboBoxPF, Save);
	MainIni.RWComboBox(Section, ComboBoxQuality, Save);
	MainIni.RWComboBox(Section, ComboBoxFormat, Save);
	MainIni.RWComboBox(Section, ComboBoxInterval, Save);
end;

procedure TfCapture.FormCreate(Sender: TObject);
var i: SG;
begin
	Background := baGradient;
	ComboBoxFormat.Items.BeginUpdate;
	try
		for i := 0 to Length(AllPictureExt) - 1 do
		begin
			ComboBoxFormat.Items.Add(AllPictureExt[i] + ' (' + AllPictureDes[i] + ')');
		end;
		ComboBoxFormat.ItemIndex := 0;
	finally
		ComboBoxFormat.Items.EndUpdate;
	end;

	ComboBoxInterval.Items.BeginUpdate;
	try
		ComboBoxInterval.Items.Add(MsToStr(100, diSD, -3, False));
		ComboBoxInterval.Items.Add(MsToStr(Second, diSD, -3, False));
		ComboBoxInterval.Items.Add(MsToStr(10 * Second, diSD, -3, False));
		ComboBoxInterval.Items.Add(MsToStr(Minute, diSD, -3, False));
		ComboBoxInterval.Items.Add(MsToStr(10 * Minute, diSD, -3, False));
		ComboBoxInterval.Items.Add(MsToStr(Hour, diSD, -3, False));
		ComboBoxInterval.ItemIndex := 0;
	finally
		ComboBoxInterval.Items.EndUpdate;
	end;

	RWOptions(False);
	ComboBoxFormat.OnChange(Sender);
	ComboBoxInterval.OnChange(Sender);
	Dictionary.TranslateForm(Self);
end;

procedure TfCapture.FormShow(Sender: TObject);
begin
	fMain.Capture1.Checked := True;
end;

procedure TfCapture.FormHide(Sender: TObject);
begin
	CapDir := '';
	fMain.Capture1.Checked := False;
	if ButtonCapture.Down then
		ButtonCapture.Click;
	RWOptions(True);
end;

procedure TfCapture.Timer1Timer(Sender: TObject);
begin
	try
		Capture;
	except
		Timer1.Enabled := False;
	end;
end;

procedure TfCapture.ButtonCaptureFolderClick(Sender: TObject);
begin
	APIOpen(RepairDirectory(CapDir));
end;

procedure TfCapture.ComboBoxFormatChange(Sender: TObject);
begin
	ComboBoxQuality.Enabled := Pos('j', AllPictureExt[ComboBoxFormat.ItemIndex]) <> 0;
end;

procedure TfCapture.ComboBoxIntervalChange(Sender: TObject);
begin
	Timer1.Interval := StrToMs(ComboBoxInterval.Text, UG(1), Second, High(Timer1.Interval), True);
end;

procedure TfCapture.DButtonAllClick(Sender: TObject);
begin
	EditX0.Text := 'min';
	EditY0.Text := 'min';
	EditX1.Text := 'max';
	EditY1.Text := 'max';
end;

end.
