// * File:     EventScheduler\uForenames.pas
// * Created:  1999-08-01
// * Modified: 2009-08-14
// * Version:  2.4.47.112
// * Author:   David Safranek (Safrad)
// * E-Mail:   safrad at email.cz
// * Web:      http://safrad.own.cz

unit uForenames;

interface

uses uTypes;

function GetForename(const Day, Month: SG): string;

implementation

uses
	SysUtils,
	uFiles, uStrings;

const
	MonthOfYear = 12;
	DaysOfYear = 366;
var
	Forenames: array of string;
	MonthOffsets: array[0..MonthOfYear - 1] of SG;

procedure ReadNames;
var
	i, j: SG;
	Lines: string;
	InLineIndex: SG;

	FileName: TFileName;
	s: string;
begin
	if Length(Forenames) > 0 then Exit;

	j := 0;
	for i := 0 to MonthOfYear - 1 do
	begin
		MonthOffsets[i] := j;
		Inc(j, MonthDays[True][i + 1]);
	end;

	SetLength(Forenames, DaysOfYear);

	FileName := DataDir + 'Forenames.txt';
	if ReadStringFromFile(FileName, Lines) then
	begin
		InLineIndex := 1;
		i := 0;
		while InLineIndex <= Length(Lines) do
		begin
			s := ReadToNewLine(Lines, InLineIndex);
			RemoveComment(s);
			if (Length(s) > 0) then
			begin
				if i >= Length(Forenames) then Break;
				Forenames[i] := s;
				Inc(i);
			end;
		end;
	end;
end;

function GetForename(const Day, Month: SG): string;
begin
	ReadNames;
	Result := Forenames[MonthOffsets[Month - 1] + Day - 1];
end;

end.
