// * File:     EventScheduler\ufOpen.pas
// * Created:  1999-08-01
// * Modified: 2009-12-08
// * Version:  2.4.47.112
// * Author:   David Safranek (Safrad)
// * E-Mail:   safrad at email.cz
// * Web:      http://safrad.own.cz

unit ufOpen;

interface

uses
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
	uDForm, uDTimer, Menus;

type
	TfOpen = class(TDForm)
		DTimer: TDTimer;
		PopupMenu1: TPopupMenu;
		FullScreen1: TMenuItem;
		N1: TMenuItem;
		Close1: TMenuItem;
		procedure FormCreate(Sender: TObject);
		procedure FormPaint(Sender: TObject);
		procedure DTimerTimer(Sender: TObject);
		procedure FormShow(Sender: TObject);
		procedure FormHide(Sender: TObject);
		procedure FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
		procedure FullScreen1Click(Sender: TObject);
		procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
		procedure Close1Click(Sender: TObject);
	private
		{ Private declarations }
		procedure RWOptions(const Save: Boolean);
	public
		{ Public declarations }
	end;

var
	fOpen: TfOpen;

implementation

{$R *.DFM}

uses
	uTypes, uMain, uMenus, uDIniFile, uMath, uOutputFormat, uSysInfo, uDictionary,
	OpenGL12;

procedure TfOpen.RWOptions(const Save: Boolean);
begin
	MainIni.RWFormPos(Self, Save);
end;

procedure TfOpen.FormCreate(Sender: TObject);
begin
	MenuSet(PopupMenu1);
	Background := baOpenGL;
	RWOptions(False);
	Dictionary.TranslateForm(Self);
end;

procedure TfOpen.FormPaint(Sender: TObject);
var
	Angle: SG;
	// Params: array[0..7] of Double;
begin
	glPushAttrib(GL_ALL_ATTRIB_BITS);
	glPushMatrix;
	ResizeScene;
	Angle := (128 * DTimer.Clock div PerformanceFrequency) mod 360;
	glClearColor(0, 0, 0, 1); // Default scene background.

	glClear(GL_COLOR_BUFFER_BIT or GL_DEPTH_BUFFER_BIT); // clear background and depth buffer
	glMatrixMode(GL_MODELVIEW); // activate the transformation matrix
	glLoadIdentity; // set it to initial state

	// glGetDoublev(GL_CURRENT_RASTER_POSITION, @Params);


	// gluLookAt(0,0,4,0,0,-10,0,1,0); // set up a viewer position and view point
	// glRasterPos4d(-1, 0, 0, 1);

	gluLookAt(0, 0, 10
		{ + LinearMax(16 * DTimer.Clock div PerformanceFrequency, 32) } , 0, 0, -10, 0, 1, 0);
	// set up a viewer position and view point
	glTranslatef(0, 0, 0);
	glRotatef(4 * Angle, 0, 1, 0); // do rotation around axis (x:0;y:1;z:0)
	glRotatef(30, 1, 0, 0); // do another rotation for better view (accumulates to first rot.)
	glScalef(1, sin(Angle * pi / 90), 1); // simulate bumping
	glEnable(GL_DEPTH_TEST); // enable depth testing

	{ glFogi(GL_FOG_MODE, GL_LINEAR);
		glFogi(GL_FOG_COLOR, 10);
		glEnable(GL_FOG); }
	{ glLightf(GL_LIGHT0, GL_LINEAR_ATTENUATION, 0);
		glEnable(GL_LIGHT0); }

	glBegin(GL_TRIANGLE_FAN); // draw a tetrahedron
	glColor3f(1, 1, 1); // color of the upper vertex
	glVertex3f(0, 1, 0); // coordinates of the upper vertex (= center of the fan)
	glColor3f(1, 0, 0); // color left-front vertex
	glVertex3f(-1, 0, 1); // coordinates of the left-front vertex
	glColor3f(0, 1, 0); // right-front
	glVertex3f(1, 0, 1); // right-front
	glColor3f(0, 0, 1); // middle-back
	glVertex3f(0, 0, -1); // middle-back
	glColor3f(1, 0, 0); // left-front again (close fan)
	glVertex3f(-1, 0, 1); // left-front
	glEnd; // finish triangle fan

	Canvas.Font.Color := clWhite;
	Canvas.Brush.Color := clBlack;
	glListBase(FontBase);
	glShadowText(Canvas, 0, 0, 'F/s: ' + NToS(DTimer.FrameRate, 3), clWhite, clBlack, 0);
	glShadowText(Canvas, 0, Canvas.TextHeight('W'), 'CPU in use [%]: ' + NToS(CPUUsage2, 1)
			+ ' (' + NToS(GSysInfo.CPUUsage, 2) + ')', clWhite, clBlack, 0);
	glPopMatrix;
	glPopAttrib;
end;

procedure TfOpen.DTimerTimer(Sender: TObject);
begin
	Repaint;
end;

procedure TfOpen.FormShow(Sender: TObject);
begin
	fMain.OpenGL1.Checked := True;
	DTimer.Enabled := True;
end;

procedure TfOpen.FormHide(Sender: TObject);
begin
	fMain.OpenGL1.Checked := False;
	DTimer.Enabled := False;
end;

procedure TfOpen.FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
	if Key = VK_ESCAPE then
		Close;

	{ if (ssAlt in Shift) and (Key = VK_RETURN) then
		begin
		FullScreen := not FullScreen;
		FullScreen1.Checked := FullScreen;
		end; }
end;

procedure TfOpen.FullScreen1Click(Sender: TObject);
begin
	FullScreen := not FullScreen;
	FullScreen1.Checked := FullScreen;
end;

procedure TfOpen.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
	RWOptions(True);
end;

procedure TfOpen.Close1Click(Sender: TObject);
begin
	Close;
end;

end.
