// * File:     EventScheduler\ufMessages.pas
// * Created:  1999-08-01
// * Modified: 2010-11-12
// * Version:  2.4.47.112
// * Author:   David Safranek (Safrad)
// * E-Mail:   safrad at email.cz
// * Web:      http://safrad.own.cz

unit ufMessages;

interface

uses
	uTypes, uData,
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
	uDTimer, ComCtrls, uDForm, uDImage, uDView, Menus,
	uTask, uDWinControl;

type
	TfMessages = class(TDForm)
		DViewT: TDView;
		PopupMenu1: TPopupMenu;
		Delete1: TMenuItem;
		Done1: TMenuItem;
		Edit1: TMenuItem;
		Add1: TMenuItem;
		N1: TMenuItem;
		Close1: TMenuItem;
		Run1: TMenuItem;
		N2: TMenuItem;
		After1Hour1: TMenuItem;
		After1Day1: TMenuItem;
		After1Week1: TMenuItem;
		After10Minutes1: TMenuItem;
		RerunAfter1: TMenuItem;
		procedure FormCreate(Sender: TObject);
		procedure FormShow(Sender: TObject);
		procedure FormHide(Sender: TObject);
		procedure DViewTGetData(Sender: TObject; var Data: String; ColIndex,
			RowIndex: Integer; Rect: TRect);
		procedure DViewTDblClick(Sender: TObject);
		procedure DoneRun1Click(Sender: TObject);
		procedure AddEdit1Click(Sender: TObject);
		procedure Delete1Click(Sender: TObject);
		procedure PopupMenu1Popup(Sender: TObject);
		procedure Close1Click(Sender: TObject);
		procedure DViewTColumnClick(Sender: TObject; Column: TColumn);
	private
		{ Private declarations }
		procedure RWOptions(const Save: Boolean);
	public
		{ Public declarations }
		procedure InitCaption;
	end;

var
	fMessages: TfMessages;

procedure RWMessages(const Save: Boolean);

const
	AllMessages = -1;

procedure CalcNextRun(const MesIndex: SG);
procedure StartTask(const Task: TTask);

implementation

{$R *.DFM}
uses
	MMSystem, DateUtils, ShellAPI, Math, CoolTrayIcon,
	uSorts, uFiles, uWave, uDIniFile, uMsg, uMenus, uStrings,
		uGraph, uMath, uAPI, uOutputFormat, uSounds, uGetTime, uDictionary, uWebUpdate,
	uMain, ufMessage, uWallpaper;

(*
procedure RunLive;
var
	StartupInfo: TStartupInfo;
	ProcessInfo: TProcessInformation;
	ExitCode: U4;

	function Abort: Boolean;
	var
		i: U4;
	begin
		repeat
			Application.ProcessMessages;
			Result := False;
			if Result then
				TerminateProcess(ProcessInfo.hProcess, 1);
			i := WaitForSingleObject(ProcessInfo.hProcess, LoopSleepTime);
			Sleep(LoopSleepTime);
		until not ((i = WAIT_TIMEOUT) and (Result <> True));
		GetExitCodeProcess(ProcessInfo.hProcess, ExitCode);
	end;
var
	CommandLine, CurDir: string;
begin
	FillChar(StartupInfo, SizeOf(StartupInfo), 0);
	FillChar(ProcessInfo, SizeOf(ProcessInfo), 0);

	StartupInfo.cb := SizeOf(StartupInfo);
	StartupInfo.wShowWindow := SW_SHOW;//NA{SW_SHOWNOACTIVATE};
	StartupInfo.dwFillAttribute := 0;
	StartupInfo.dwFlags := STARTF_USESHOWWINDOW or STARTF_USEFILLATTRIBUTE or STARTF_USEPOSITION;

	CurDir := ProgramFilesDir + 'Creative' + PathDelim + 'SBLive' + PathDelim + 'AudioHQ' + PathDelim;
	CommandLine := '"' + ProgramFilesDir + 'Creative' + PathDelim + 'SBLive' + PathDelim + 'AudioHQ' + PathDelim + 'AudioHQ.exe"';
	if CreateProcess(
		nil,
		PChar(CommandLine),
		nil,
		nil,
		True,
		0,
		nil,
		PChar(CurDir),
		StartupInfo,
		ProcessInfo) then
	begin
		Sleep(1000);
//		Abort;
		TerminateProcess(ProcessInfo.hProcess, 0);
		CommandLine := '"' + ProgramFilesDir + 'Creative' + PathDelim + 'SBLive' + PathDelim + 'AudioHQ' + PathDelim + 'Ahqrun.exe"  "' + ProgramFilesDir + 'Creative' + PathDelim + 'ShareDLL' + PathDelim + 'AHQ' + PathDelim + 'CT8008.AHQ" 2';
		if CreateProcess(
			nil,
			PChar(CommandLine),
			nil,
			nil,
			False,
			0,
			nil,
			PChar(CurDir),
			StartupInfo,
			ProcessInfo) then
		else
			IOError(CommandLine, GetLastError);
	end
	else
		IOError(CommandLine, GetLastError);
end; *)

procedure RWMessages(const Save: Boolean);
var
	MesIni: TDIniFile;
	Id: string;
	i, j: SG;
	M: ^TTask;
	MesCount: SG;
begin
	MesIni := TDIniFile.Create(AppDataDir + 'Messages.ini');
	try
		MesCount := Tasks.Count;
		MesIni.RWNum('Data', 'MesCount', MesCount, Save);
		MesIni.RWNum('Data', 'CurrentId', GTaskId, Save);
		if Save = False then
			GTaskId := Max(GTaskId, MesCount);
		if Save = False then Tasks.Clear;
		for i := 0 to MesCount - 1 do
		begin
			if Save = False then
			begin
				M := Tasks.Add(Pointer(TTask.Create));
			end
			else
			begin
				M := Tasks.Get(i);
			end;

			Id := 'Message' + NToS(i, ofIO);

			MesIni.RWNum(Id, 'Id', M.FId, Save);
			MesIni.RWString(Id, 'Name', M.Name, Save);
			MesIni.RWEnum(Id, TypeInfo(TSchedule), U1(M.Schedule), Save);
			MesIni.RWDateTime(Id, 'Created', M.Created, Save);
			MesIni.RWDateTime(Id, 'Modified', M.Modified, Save);
			MesIni.RWDateTime(Id, 'StartDT', M.StartDT, Save);
			MesIni.RWDateTime(Id, 'EndDT', M.EndDT, Save);
			MesIni.RWNum(Id, 'Duration', M.Duration, Save);
			MesIni.RWEnum(Id, TypeInfo(TTaskAction), U1(M.Action), Save);

			MesIni.RWNum(Id, 'EveryXDay', M.EveryXDay, Save);
			MesIni.RWNum(Id, 'EveryXWeek', M.EveryXWeek, Save);
			MesIni.RWNum(Id, 'EveryXMonth', M.EveryXMonth, Save);
			MesIni.RWNum(Id, 'EveryXYear', M.EveryXYear, Save);
			MesIni.RWNum(Id, 'EveryXIdle', M.EveryXIdle, Save);
			MesIni.RWNum(Id, 'EveryXOverload', M.EveryXOverload, Save);

			for j := 0 to 6 do
				MesIni.RWBool(Id, 'Day' + IntToStr(j), M.WeekDays[j], Save);
			for j := 0 to 11 do
				MesIni.RWBool(Id, 'Month' + IntToStr(j), M.Months[j], Save);


			if Save = False then
			begin
				if FileExists(M.LastRunLogFileName) then
				begin
					M.ReadRunLogFromFile;
				end
				else
				begin
//					MesIni.RWNum(Id, 'LastRunCount', M.LastRunCount, Save);
					SetLength(M.LastRuns, 0);
					M.LastRunCount := 0;
					for j := 0 to MaxInt do
					begin
						if not MesIni.ValueExists(Id, 'LastRun' + IntToStr(j)) then Break;
						SetLength(M.LastRuns, M.LastRunCount + 1);
						MesIni.RWDateTime(Id, 'LastRun' + IntToStr(j), M.LastRuns[j], Save);
						Inc(M.LastRunCount);
					end;
					for j := 0 to M.LastRunCount div 2 - 1 do
					begin
						Exchange(F8(M.LastRuns[j]), F8(M.LastRuns[M.LastRunCount - 1 - j]));
					end;
				end;
			end
			else
			begin
				if MesIni.ValueExists(Id, 'LastRunCount') then
				begin
					MesIni.DeleteValue(Id, 'LastRunCount');
					for j := 0 to M.LastRunCount - 1 do
						MesIni.DeleteValue(Id, 'LastRun' + IntToStr(j));
					M.WriteRunLogToFile;
				end;
			end;

			MesIni.RWDateTime(Id, 'NextRun', M.NextRun, Save);
			MesIni.RWNum(Id, 'RunCount', M.RunCount, Save);
			M.Running := MainIni.RWBGF(Id, 'Running', M.Running, False, Save);
			MesIni.RWBool(Id, 'Active', M.Active, Save);
			MesIni.RWNum(Id, 'MissedCount', M.MissedCount, Save);
			MesIni.RWBool(Id, 'Missed', M.Missed, Save);
			MesIni.RWBool(Id, 'Enabled', M.Enabled, Save);

			MesIni.RWFileName(Id, 'WaveFileName', M.WaveFileName, Save);
			MesIni.RWFileName(Id, 'ProgramFileName', M.ProgramFileName, Save);
			MesIni.RWString(Id, 'Parameters', M.Params, Save);
			// Add message property here.

		end;
	finally
		MesIni.Free;
	end;
end;

procedure CalcNextRun(const MesIndex: SG);
var
	i: SG;
	M: ^TTask;
	LastNextRun: TDateTime;
	FromM, ToM: SG;
begin
	if MesIndex = AllMessages then
	begin
		FromM := 0;
		ToM := Tasks.Count - 1;
	end
	else
	begin
		FromM := MesIndex;
		ToM := MesIndex;
	end;

	for i := FromM to ToM do
	begin
		M := Tasks.Get(i);
		LastNextRun := M.NextRun;
		M.UpdateNextRun;
		if MesIndex = AllMessages then
			if (M.NextRun <> LastNextRun) and (M.Enabled) then
			begin
				M.Missed := True;
				Inc(M.MissedCount);
			end;
	end;
end;

procedure TfMessages.RWOptions(const Save: Boolean);
begin
	MainIni.RWFormPos(Self, Save);
	DViewT.Serialize(MainIni, Save);
end;

procedure TfMessages.FormCreate(Sender: TObject);
const
	Columns: array[0..13] of TColumnOptions = (
		(Caption: '#'; Width: 24; Alignment: taRightJustify),
		(Caption: 'Name'; Width: 48; Alignment: taLeftJustify),
		(Caption: 'File'; Width: 160; Alignment: taLeftJustify),
		(Caption: 'Sound'; Width: 160; Alignment: taLeftJustify),
		(Caption: 'Schedule'; Width: 160; Alignment: taLeftJustify),
		(Caption: 'Duration'; Width: 48; Alignment: taRightJustify),
		(Caption: 'Action'; Width: 48; Alignment: taLeftJustify),
		(Caption: 'Status'; Width: 32; Alignment: taLeftJustify),
		(Caption: 'Next Run Time'; Width: 64; Alignment: taLeftJustify),
		(Caption: 'Last Run Time'; Width: 64; Alignment: taLeftJustify),
		(Caption: 'Run Count'; Width: 32; Alignment: taRightJustify),
		(Caption: 'Missed Count'; Width: 32; Alignment: taRightJustify),
		(Caption: 'Created'; Width: 32; Alignment: taLeftJustify),
		(Caption: 'Modified'; Width: 32; Alignment: taLeftJustify));
begin
	Background := baNone;
	MenuSet(PopupMenu1);

	DViewT.AddColumns(Columns);
	RWOptions(False);
	Dictionary.TranslateForm(Self);
end;

procedure TfMessages.FormShow(Sender: TObject);
begin
	fMain.Messages1.Checked := True;
	DViewT.RowCount := Tasks.Count;
	DViewT.DataChanged;
	InitCaption;
end;

procedure TfMessages.FormHide(Sender: TObject);
begin
	fMain.Messages1.Checked := False;
	RWOptions(True);
	RWMessages(True);
end;

procedure TfMessages.DViewTGetData(Sender: TObject; var Data: string;
	ColIndex, RowIndex: Integer; Rect: TRect);
var
	M: ^TTask;
	i: SG;
begin
	M := Tasks.Get(RowIndex);
	if (M.Enabled = False) and ((ColIndex = 3) or (ColIndex = 4)) then
		DViewT.Bitmap.Canvas.Font.Style := [fsStrikeOut]
//		DViewT.Bitmap.Canvas.Font.Color := clGrayText;
	else
		DViewT.Bitmap.Canvas.Font.Style := [];

	if M.Running then
	begin
		DViewT.Bitmap.Canvas.Font.Style := [fsBold];
	end
	else if M.Active then
	begin
		DViewT.Bitmap.Canvas.Font.Style := [fsUnderline];
	end else if M.Missed then
	begin
		DViewT.Bitmap.Canvas.Font.Style := [fsBold];
	end
	else
		DViewT.Bitmap.Canvas.Font.Style := [];

	case ColIndex of
	0: Data := NToS(M.Id);
	1: Data := M.Name;
	2: Data := M.ProgramFileName;
	3: Data := ExtractFileName(M.WaveFileName);
	4: Data := M.ToString;
	5: Data := MsToStr(M.Duration, diDHMSD, 0, False);
	6: Data := Translate(ActionToStr[M.Action]);
	7:
	begin
		if M.Running then
			Data := 'Running'
		else if M.Active then
			Data := 'Active'
		else if M.Enabled = False then
			Data := 'Disabled'
		else
		begin
			if M.Missed then
				Data := 'Missed'
			else
				Data := 'Ready';
		end;
		Data := Translate(Data);
	end;
	8:
	begin
		Data := M.NextRunToStr;
	end;
	9:
	begin
		Data := '';

		if M.LastRunCount > 0 then
		begin
			for i := 0 to Min(Max(1, RoundDiv(Rect.Right - Rect.Left, DViewT.Bitmap.Canvas.TextWidth(DateTimeToS(37512, 0, ofDisplay)))), M.LastRunCount) - 1 do
			begin
				Data := Data + DateTimeToS(M.LastRuns[M.LastRunCount - 1 - i], 0, ofDisplay);
				if i <> M.LastRunCount - 1 then Data := Data + ListSeparator;
			end;
//			Data := NToS(RoundDiv(Rect.Right - Rect.Left, DViewT.Bitmap.Canvas.TextWidth(DateTimeToS(37512, 0, ofDisplay)))) + '-' + Data;
		end;
	end;
	10: Data := NToS(M.RunCount);
	11: Data := NToS(M.MissedCount);
	12: Data := DateTimeToS(M.Created, 0, ofDisplay);
	13: Data := DateTimeToS(M.Modified, 0, ofDisplay);
	end;
end;

procedure TfMessages.DViewTDblClick(Sender: TObject);
var M: ^TTask;
begin
	if DViewT.Where = vaRow then
	if DViewT.ActualRow >= 0 then
	begin
		M := Tasks.Get(DViewT.ActualRow);
		if M.Running then
			DoneRun1Click(Sender)
		else if M.Missed then
			DoneRun1Click(Sender)
		else
			AddEdit1Click(Sender);
	end;
end;

var
	AdditionalTime: U4;

procedure TfMessages.DoneRun1Click(Sender: TObject);
var
	i, j: SG;
	M: ^TTask;
begin
	for i := 0 to DViewT.RowCount - 1 do
	begin
		j := DViewT.RowOrder[i];
		if DViewT.SelectedRows[j] then
		begin
			M := Tasks.Get(j);
			case TMenuItem(Sender).Tag of
			1: // Run
			begin
				if M.Running = False then
				begin
					StartTask(M^);
				end;
			end;
			0: // Done
			begin
				if M.Running then
				begin
					M.Running := False;
				end
				else if M.Missed then
				begin
					M.Missed := False;
				end;
			end;
			else
			begin
				if M.Running then
				begin
					if TMenuItem(Sender).Tag = -1 then
					begin
						if not GetTime('Re-run after', AdditionalTime, 0, Hour, 14 * Day, nil) then
							Continue;
					end
					else
					begin
						AdditionalTime := Minute * TMenuItem(Sender).Tag;
					end;
					M.Running := False;
					M.NextRun := Now + AdditionalTime / Day;
				end;
			end;
			end;
			CalcNextRun(i);
		end;
	end;
	InitCaption;
	fMain.InitCaption;
	fMain.InitIcon;
	DViewT.Invalidate;
end;

procedure TfMessages.AddEdit1Click(Sender: TObject);
var i, j: SG;
begin
	if not Assigned(fMessage) then fMessage := TfMessage.Create(Self);
	case TMenuItem(Sender).Tag of
	1:
	begin
		fMessage.ActItem := Tasks.Count;
		fMessage.ActiveControl := fMessage.EditName;
		fMessage.ShowModal;
	end;
	0:
	begin
		for i := 0 to DViewT.RowCount - 1 do
		begin
			j := DViewT.RowOrder[i];
			if DViewT.SelectedRows[j] then
			begin
				fMessage.ActItem := j;
				fMessage.ActiveControl := fMessage.EditName;
				fMessage.ShowModal;
				DViewT.SelectedRows[j] := False;
			end;
		end;
	end;
	end;
end;

procedure TfMessages.Delete1Click(Sender: TObject);
var
	i, j: SG;
	k: SG;
	M: ^TTask;
begin
	if DViewT.SelCount > 0 then
	begin
		for i := 0 to DViewT.RowCount - 1 do
		begin
			j := DViewT.RowOrder[i];
			if DViewT.SelectedRows[j] then
			begin
				M := Tasks.Get(j);
				if Confirmation('Delete %1?', [mbYes, mbNo], M.Name) = mbYes then
				begin
					M.MarkAsDeleted := True;
				end;
			end;
		end;
	end;

	k := 0;
	while k < Tasks.Count do
	begin
		M := Tasks.Get(k);
		if M.MarkAsDeleted then
		begin
			M.Free;
			Tasks.Delete(k);
		end
		else
			Inc(k);
	end;
	DViewT.DeselectAll;
	DViewT.RowCount := Tasks.Count;
	DViewT.DataChanged;
	InitCaption;
	fMain.InitCaption;
	fMain.InitIcon;
end;

procedure TfMessages.InitCaption;
var s: string;
begin
	s := 'Messages';
	if GetRunningTaskCount > 0 then
		s := s + ' - ' + NToS(GetRunningTaskCount) + ' run' + Plural(GetRunningTaskCount);
	Caption := s;
end;

procedure TfMessages.PopupMenu1Popup(Sender: TObject);
var
	i, j: SG;
	M: ^TTask;
begin
	Done1.Enabled := False;
	After10Minutes1.Enabled := False;
	After1Hour1.Enabled := False;
	After1Day1.Enabled := False;
	After1Week1.Enabled := False;
	RerunAfter1.Enabled := False;
	Run1.Enabled := False;
	Edit1.Default := True;
	for i := 0 to DViewT.RowCount - 1 do
	begin
		j := DViewT.RowOrder[i];
		if DViewT.SelectedRows[j] then
		begin
			M := Tasks.Get(j);
			if M.Running or M.Missed then
			begin
				Done1.Enabled := True;
				Done1.Default := True;
				After10Minutes1.Enabled := True;
				After1Hour1.Enabled := True;
				After1Day1.Enabled := True;
				After1Week1.Enabled := True;
				RerunAfter1.Enabled := True;
			end
			else
				Run1.Enabled := True;
		end;
	end;
//	Add1.Enabled := DViewT.SelCount > 0;
	Edit1.Enabled := (DViewT.SelCount > 0) and (DViewT.Where = vaRow);
	Delete1.Enabled := Edit1.Enabled;
end;

procedure TfMessages.Close1Click(Sender: TObject);
begin
	Close;
end;

procedure StartTask(const Task: TTask);
var
	DisplayMessage: BG;
	Name, TargetFileName, StoredFileName: TFileName;
	All: TArrayOfString;
begin
	DisplayMessage := True;
	if Task.Action <> taDownloadWebPage then
		if (Task.WaveFileName <> '') or (Task.ProgramFileName <> '') then
		begin
			if Task.ProgramFileName <> '' then
			begin
				if LowerCase(ExtractFileExt(Task.ProgramFileName)) = '.wav' then
					PlayWaveFile(Task.ProgramFileName)
				else
				begin
					DisplayMessage := False;
					APIOpen(Task.ProgramFileName, Task.Params);
					Sleep(1000);
				end;
			end;
			if (Task.WaveFileName <> '') and (Task.Action <> taMore) then
			begin
				PlayWaveFile(Task.WaveFileName);
			end;
		end;

	case Task.Action of
	taNone, taSound:
	begin
		DisplayMessage := False;
	end;
	taChangeWallpaper:
	begin
		DisplayMessage := False;
		Wallpapers.Change;
	end;
	taChangeWindowsColors:
	begin
		DisplayMessage := False;
//					if GSysInfo.CPUUsage < CPUIdleValue * CPUUsageMul then
		if fMain.Change3DObjectsColor1.Checked then
			InitWinColor;
	end;
	taHibernate:
	begin
		if SetSystemPowerState(False, True) = False then
			ErrorMsg(GetLastError);
	end;
	taSuspend:
	begin
		if SetSystemPowerState(True, True) = False then
			ErrorMsg(GetLastError);
	end;
	taPowerOff:
	begin
		if Windows.ExitWindowsEx(8, 0) = False then
			ErrorMsg(GetLastError);
	end;
	taReboot:
	begin
		if Windows.ExitWindowsEx(2, 0) = False then
			ErrorMsg(GetLastError);
	end;
	taShutdown:
	begin
		if Windows.ExitWindowsEx(1, 0) = False then
			ErrorMsg(GetLastError);
	end;
	taLogOff:
	begin
		if Windows.ExitWindowsEx(0, 0) = False then
			ErrorMsg(GetLastError);
	end;
	taDownloadWebPage:
	begin
		Name := ExtractFileName(ReplaceF(Task.ProgramFileName, '/', PathDelim));
		TargetFileName := TempDir + Name;
		try
			DownloadFile(Task.ProgramFileName, TargetFileName);
			StoredFileName := AppDataDir + 'Web\' + Name;
			if (not FileExists(StoredFileName)) or (not SameFiles(TargetFileName, StoredFileName)) then
			begin
				uFiles.CopyFile(TargetFileName, StoredFileName, False);
				All := SplitStr(Task.Params, 2);
				APIOpen(All[0], All[1]);
			end;
		finally
			BackupFile(TargetFileName);
			DeleteFile(TargetFileName);
		end;
		DisplayMessage := False;
	end;
	end;

	if DisplayMessage then
	begin
		Task.Running := True;
		Task.Active := True;
		BalloonHint := BalloonHint + Task.Name + LineSep;
	end;
	Inc(Task.RunCount);
	Task.Missed := False;

	Inc(Task.LastRunCount);
	SetLength(Task.LastRuns, Task.LastRunCount);
	Task.LastRuns[Task.LastRunCount - 1] := Now;

	WriteStringToFile(Task.LastRunLogFileName, DateTimeToS(Task.LastRuns[Task.LastRunCount - 1], -3, ofIO) + FileSep, True);
end;

procedure TfMessages.DViewTColumnClick(Sender: TObject; Column: TColumn);
var
	i: SG;
	M: ^TTask;
	ASG: array of SG;
	AFA: array of FA;
	AStr: array of string;
begin
//	FillOrderU4(DViewT.RowOrder[0], DViewT.RowCount);
	case DViewT.SortBy of
	5, 8, 9, 12, 13: SetLength(AFA, Tasks.Count);
	4, 6, 7, 10, 11: SetLength(ASG, Tasks.Count);
	1, 2, 3: SetLength(AStr, Tasks.Count);
	end;
	for i := 0 to Tasks.Count - 1 do
	begin
		M := Tasks.Get(i);

		case DViewT.SortBy of
		1: AStr[i] := M.Name;
		2: AStr[i] := ExtractFileName(M.ProgramFileName);
		3: AStr[i] := M.WaveFileName;
		4: ASG[i] := SG(M.Schedule);
		5: AFA[i] := M.Duration;
		6: ASG[i] := SG(M.Action) shl 8 + SG(M.Schedule);
		7: ASG[i] :=
			1 * (SG(not M.Enabled) and 1) +
			2 * (SG(not M.Missed) and 1) +
			4 * (SG(not M.Active) and 1) +
			8 * (SG(not M.Running) and 1);
		8: AFA[i] := M.NextRun;
		9: AFA[i] := M.LastRun;
		10: ASG[i] := M.RunCount;
		11: ASG[i] := M.MissedCount;
		12: AFA[i] := M.Created;
		13: AFA[i] := M.Modified;
		end;
	end;
	if Length(AFA) > 0 then SortFA(False, False, PArraySG(DViewT.RowOrder), PArrayFA(AFA), DViewT.RowCount);
	if Length(ASG) > 0 then SortS4(False, False, PArraySG(DViewT.RowOrder), PArrayS4(ASG), DViewT.RowCount);
	if Length(AStr) > 0 then SortStr(PArraySG(DViewT.RowOrder), PArrayString(AStr), DViewT.RowCount);
	SetLength(AStr, 0);
	SetLength(AFA, 0);
	SetLength(ASG, 0);
end;

procedure FreeTasks;
var
	Task: ^TTask;
begin
	Task := Tasks.GetFirst;
	while Task <> nil do
	begin
		FreeAndNil(Task^);
		Tasks.Next(Task);
	end;
	FreeAndNil(Tasks);
end;

initialization
	Tasks := TData.Create;
	Tasks.ItemSize := SizeOf(TTask);
	EnumToStr(TypeInfo(TTaskAction), ActionToStr);
	CreateDirEx(AppDataDir + 'Web');
finalization
	FreeTasks;
end.
