// * File:     EventScheduler\ufMessage.pas
// * Created:  1999-08-01
// * Modified: 2010-01-17
// * Version:  2.4.47.112
// * Author:   David Safranek (Safrad)
// * E-Mail:   safrad at email.cz
// * Web:      http://safrad.own.cz

unit ufMessage;

interface

uses
	uTypes, ufMessages, uDForm, uTask,
	Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
	StdCtrls, ExtCtrls, uDButton, Grids, Calendar, ComCtrls,
	uDLabel, uDEdit, Dialogs;

type
	TfMessage = class(TDForm)
		ButtonOk: TDButton;
		ButtonCancel: TDButton;
		LabelScheduleTask: TLabel;
		ComboBoxSchedule: TComboBox;
		LabelName: TLabel;
		EditName: TDEdit;
		Calendar: TCalendar;
		TimePicker: TDateTimePicker;
		ComboBoxM: TComboBox;
		ComboBoxY: TComboBox;
		Bevel1: TBevel;
		BevelDT: TBevel;
		ButtonEnabled: TDButton;
		EditCreated: TDEdit;
		EditModified: TDEdit;
		EditLastRun: TDEdit;
		EditNextRun: TDEdit;
		EditRunCount: TDEdit;
		EditWofY: TDEdit;
		EditPrename: TDEdit;
		LabelCreated: TLabel;
		LabelModified: TLabel;
		LabelLastRun: TLabel;
		LabelNextRun: TLabel;
		LabelRunCount: TLabel;
		DatePicker: TDateTimePicker;
		LabelEveryText: TLabel;
		LabelEvery: TLabel;
		ComboBoxEvery: TComboBox;
		EditSchedule: TDEdit;
		LabelStartTime: TLabel;
		EditDofY: TDEdit;
		LabelWofY: TLabel;
		LabelDofY: TLabel;
		LabelDuration: TLabel;
		TimePickerDuration: TDateTimePicker;
		ComboBoxAction: TComboBox;
		LabelIntensity: TLabel;
		ComboBoxDuration: TComboBox;
		LabelDurationDays: TLabel;
		ButtonNow: TDButton;
		ButtonLeft: TDButton;
		ButtonRight: TDButton;
		LabelSchedule: TLabel;
		EditIndex: TDEdit;
		Bevel2: TBevel;
		EditWaveFileName: TDEdit;
		LabelFileName: TLabel;
		EditProgramFileName: TDEdit;
		EditParams: TDEdit;
		LabelParameters: TLabel;
		ButtonSelectProgramFileName: TDButton;
		ButtonSelectWaveFileName: TDButton;
		OpenDialog: TOpenDialog;
		LabelSoundName: TLabel;
		procedure FormCreate(Sender: TObject);
		procedure ButtonOkClick(Sender: TObject);
		procedure ButtonCancelClick(Sender: TObject);
		procedure FormShow(Sender: TObject);
		procedure ComboBoxScheduleChange(Sender: TObject);
		procedure TimePickerChange(Sender: TObject);
		procedure CalendarChange(Sender: TObject);
		procedure ComboBoxYChange(Sender: TObject);
		procedure ComboBoxMChange(Sender: TObject);
		procedure ComboBoxEveryChange(Sender: TObject);
		procedure DatePickerChange(Sender: TObject);
		procedure TimePickerDblClick(Sender: TObject);
		procedure TimePickerDurationChange(Sender: TObject);
		procedure ComboBoxActionChange(Sender: TObject);
		procedure ButtonNowClick(Sender: TObject);
		procedure ButtonLeftClick(Sender: TObject);
		procedure EditIndexChange(Sender: TObject);
		procedure ButtonLeftKeyPress(Sender: TObject; var Key: Char);
		procedure ButtonSelectProgramFileNameClick(Sender: TObject);
		procedure EditFileNameChange(Sender: TObject);
		procedure FormDestroy(Sender: TObject);
	private
		{ Private declarations }
		FormMes: TTask;
		DButtonMonth: array[0..11] of TDButton;
		DButtonWeek: array[0..6] of TDButton;
		procedure ButtonClick(Sender: TObject);
		procedure InitNextRun;
		procedure Init;
		procedure InitDate;
		procedure SetCalendarDate(const NewDate: TDate);
	public
		{ Public declarations }
		ActItem: SG;
	end;

var
	fMessage: TfMessage;

implementation

{$R *.dfm}
uses
	uGetTime, uInputFormat, uOutputFormat, uForenames, uStrings, uFiles, uWave, uDictionary,
	DateUtils, TypInfo;

procedure TfMessage.ButtonClick(Sender: TObject);
var i: SG;
begin
	for i := 0 to 6 do
		FormMes.WeekDays[i] := DButtonWeek[i].Down;
	for i := 0 to 11 do
		FormMes.Months[i] := DButtonMonth[i].Down;
	InitNextRun;
end;

procedure TfMessage.FormCreate(Sender: TObject);
var
	i: SG;
	x, y: SG;
	SystemTime: TSystemTime;
begin
	Background := baGradient;

	ComboBoxSchedule.Items.BeginUpdate;
	try
		for i := 0 to SG(High(TSchedule)) do
		begin
			ComboBoxSchedule.Items.Add(AddSpace(Copy(GetEnumName(TypeInfo(TSchedule), i), 3, MaxInt)));
		end;
	finally
		ComboBoxSchedule.Items.EndUpdate;
	end;

	ComboBoxM.Items.BeginUpdate;
	try
		for i := 1 to 12 do
			ComboBoxM.Items.Add(LongMonthNames[i] + ' (' + NToS(i) + ')');
	finally
		ComboBoxM.Items.EndUpdate;
	end;

	GetLocalTime(SystemTime);
	y := SystemTime.wYear;
	ComboBoxY.Items.BeginUpdate;
	try
		ComboBoxY.Items.Add(NToS(y - 1));
		ComboBoxY.Items.Add(NToS(y));
		ComboBoxY.Items.Add(NToS(y + 1));
	finally
		ComboBoxY.Items.EndUpdate;
	end;

	ComboBoxDuration.Items.BeginUpdate;
	try
		for i := 0 to 7 do
			ComboBoxDuration.Items.Add(NToS(i));
	finally
		ComboBoxDuration.Items.EndUpdate;
	end;

	for i := 0 to 11 do
	begin
		DButtonMonth[i] := TDButton.Create(Self);
		DButtonMonth[i].Name := 'ButtonMonth' + IntToStr(i);
		DButtonMonth[i].Caption := LongMonthNames[i + 1];
		x := BevelDT.Left + BevelDT.Width + 12;
		y := 19;
		DButtonMonth[i].SetBounds(x, LabelEveryText.Top + y * i, ClientWidth - x - 16, y);
		DButtonMonth[i].AutoChange := True;
		DButtonMonth[i].OnClick := ButtonClick;
		InsertControl(DButtonMonth[i]);
	end;
	for i := 0 to 6 do
	begin
		DButtonWeek[i] := TDButton.Create(Self);
		DButtonWeek[i].Name := 'ButtonWeek' + IntToStr(i);
		DButtonWeek[i].Caption := LongDayNames[i + 1];
		x := BevelDT.Left + BevelDT.Width + 12;
		y := 19;
		DButtonWeek[i].SetBounds(x, LabelEveryText.Top +  (12 * y div 7) * i, ClientWidth - x - 16, y);
		DButtonWeek[i].AutoChange := True;
		DButtonWeek[i].OnClick := ButtonClick;
		InsertControl(DButtonWeek[i]);
	end;

	ComboBoxAction.Items.BeginUpdate;
	try
		for i := 0 to Length(ActionToStr) - 1 do
			ComboBoxAction.Items.Add(ActionToStr[TTaskAction(i)]);
	finally
		ComboBoxAction.Items.EndUpdate;
	end;
	Dictionary.TranslateForm(Self);
end;

procedure TfMessage.FormDestroy(Sender: TObject);
begin
	FreeAndNil(FormMes);
end;

procedure TfMessage.ButtonCancelClick(Sender: TObject);
begin
	Close;
end;

procedure TfMessage.ButtonOkClick(Sender: TObject);
var
	M: ^TTask;
begin
	if ActItem >= Tasks.Count then
	begin
		M := Tasks.Add(Pointer(TTask.Create));
		M.FId := GTaskId;
		Inc(GTaskId);
	end
	else
	begin
		M := Tasks.Get(ActItem);
	end;
	M.Clone(FormMes);

	M.Enabled := ButtonEnabled.Down;
	M.Name := EditName.Text;

	M.WaveFileName := EditWaveFileName.Text;
	M.ProgramFileName := EditProgramFileName.Text;
	M.Params := EditParams.Text;

	M.Modified := Now;

	CalcNextRun(ActItem);
	fMessages.DViewT.RowCount := Tasks.Count;
	fMessages.DViewT.DataChanged;
	Close;
end;

procedure TfMessage.FormShow(Sender: TObject);
var
	i: SG;
begin
	FormMes.Free;
	FormMes := TTask.Create;
	if ActItem >= Tasks.Count then
	begin
		Caption := Translate('Add New Task');
		EditIndex.Enabled := False;
		FormMes.Created := Now;
	end
	else
	begin
		FormMes.Clone(TTask(Tasks.Get(ActItem)^));
		Caption := Translate('Edit Task') + CharSpace + AddQuoteF(FormMes.Name);
		EditIndex.Enabled := True;
	end;
	ButtonEnabled.Down := FormMes.Enabled;
	EditName.Text := FormMes.Name;

	// ReadOnly
	EditCreated.Text := DateTimeToS(FormMes.Created, 0, ofDisplay);
	EditModified.Text := DateTimeToS(FormMes.Modified, 0, ofDisplay);

	EditLastRun.Text := DateTimeToS(FormMes.LastRun, 0, ofDisplay);

	EditRunCount.Text := NToS(FormMes.RunCount);

	for i := 0 to 6 do
		DButtonWeek[i].Down := FormMes.WeekDays[i];
	for i := 0 to 11 do
		DButtonMonth[i].Down := FormMes.Months[i];

	ComboBoxSchedule.ItemIndex := SG(FormMes.Schedule);
	TimePicker.DateTime := 1 + TimeOf(FormMes.StartDT);
	DatePicker.DateTime := 0.5 + DateOf(FormMes.StartDT);
	TimePickerDuration.DateTime := 1 + TimeOf(FormMes.Duration / MSecsPerDay);
	ComboBoxDuration.Text := NToS(FormMes.Duration div MSecsPerDay);
	ComboBoxAction.ItemIndex := SG(FormMes.Action);
	EditWaveFileName.Text := FormMes.WaveFileName;
	EditFileNameChange(EditWaveFileName);
	EditProgramFileName.Text := FormMes.ProgramFileName;
	EditFileNameChange(EditProgramFileName);
	EditParams.Text := FormMes.Params;
	DatePicker.OnChange(Sender);

	Init;
end;

procedure TfMessage.InitNextRun;
begin
	EditSchedule.Text := FormMes.ToString;
	FormMes.UpdateNextRun;
	EditNextRun.Text := FormMes.NextRunToStr;
end;

procedure TfMessage.Init;
var
	E0, E1, E2, E3: BG;
	i: SG;
begin
	E0 := True;
	E1 := False;
	E2 := False;
	E3 := True;
	case FormMes.Schedule of
	scOnce:
	begin
	end;
	scInterval:
	begin
	end;
	scDaily:
	begin
	end;
	scWeekly:
	begin
		E1 := True;
	end;
	scMonthly:
	begin
		E2 := True;
	end;
	scYearly:
	begin
	end
	else
	begin
		E0 := False;
		E3 := False;
	end;
	end;
	ComboBoxY.Visible := E0;
	ComboBoxM.Visible := E0;
	Calendar.Visible := E0;
	DatePicker.Visible := E0;
	EditWofY.Visible := E0;
	EditDofY.Visible := E0;
	LabelWofY.Visible := E0;
	LabelDofY.Visible := E0;
	EditPrename.Visible := E0;
	BevelDT.Visible := E0;

{	TimePickerDuration.Visible := E0;
	LabelDuration.Visible := E0;
	ComboBoxDuration.Visible := E0;
	LabelDurationDays.Visible := E0;}

	for i := 0 to 6 do
		DButtonWeek[i].Visible := E1;
	for i := 0 to 11 do
		DButtonMonth[i].Visible := E2;

	LabelStartTime.Visible := E3;
	TimePicker.Visible := E3;
	ButtonNow.Visible := E3;

	E0 := FormMes.Schedule in [scInterval, scDaily, scWeekly, scMonthly, scYearly, scWhenIdle, scWhenOverload, scLag];
	LabelEvery.Visible := E0;
	ComboBoxEvery.Visible := E0;
	LabelEveryText.Visible := E0;

	if E0 then
	begin
		ComboBoxEvery.Items.BeginUpdate;
		try
			ComboBoxEvery.Items.Clear;
			case FormMes.Schedule of
			scInterval:
			begin

			end;
			scDaily:
			begin
				LabelEveryText.Caption := 'day(s)';
				for i := 1 to 31 do
					ComboBoxEvery.Items.Add(NToS(i));
				ComboBoxEvery.Text := NToS(FormMes.EveryXDay);
			end;
			scWeekly:
			begin
				LabelEveryText.Caption := 'week(s) on this day(s):';
				for i := 1 to 7 do
					ComboBoxEvery.Items.Add(NToS(i));
				ComboBoxEvery.Text := NToS(FormMes.EveryXWeek);
			end;
			scMonthly:
			begin
				LabelEveryText.Caption := 'year(s) in this month(s):';
				for i := 1 to 12 do
					ComboBoxEvery.Items.Add(NToS(i));
				ComboBoxEvery.Text := NToS(FormMes.EveryXMonth);
			end;
			scYearly:
			begin
				LabelEveryText.Caption := 'year(s)';
				for i := 1 to 10 do
					ComboBoxEvery.Items.Add(NToS(i));
				ComboBoxEvery.Text := NToS(FormMes.EveryXYear);
			end;
			scWhenIdle:
			begin
				LabelEveryText.Caption := ' is idle';
				ComboBoxEvery.Items.Add(MsToStr(Second, diMSD, 0, False));
				ComboBoxEvery.Items.Add(MsToStr(Minute, diMSD, 0, False));
				ComboBoxEvery.Items.Add(MsToStr(Hour, diMSD, 0, False));
				ComboBoxEvery.Text := MsToStr(FormMes.EveryXIdle, diMSD, -3, False);
			end;
			scWhenOverload:
			begin
				LabelEveryText.Caption := ' is overload';
				ComboBoxEvery.Items.Add(MsToStr(Second, diMSD, 0, False));
				ComboBoxEvery.Items.Add(MsToStr(Minute, diMSD, 0, False));
				ComboBoxEvery.Items.Add(MsToStr(Hour,diMSD, 0, False));
				ComboBoxEvery.Text := MsToStr(FormMes.EveryXOverload, diMSD, -3, False);
			end;
			scLag:
			begin
				LabelEveryText.Caption := ' long lag';
				ComboBoxEvery.Items.Add(MsToStr(Second, diMSD, 0, False));
				ComboBoxEvery.Items.Add(MsToStr(Minute, diMSD, 0, False));
				ComboBoxEvery.Items.Add(MsToStr(Hour, diMSD, 0, False));
				ComboBoxEvery.Text := MsToStr(FormMes.EveryXOverload, diMSD, -3, False);
			end;
			end;
		finally
			ComboBoxEvery.Items.EndUpdate;
		end;
	end;

	ButtonLeft.Enabled := ActItem > 0;
	ButtonRight.Enabled := ActItem < Tasks.Count - 1;
	EditIndex.OnChange := nil;
	EditIndex.Text := NToS(ActItem + 1);
	EditIndex.OnChange := EditIndexChange;
end;

procedure TfMessage.ComboBoxScheduleChange(Sender: TObject);
begin
	FormMes.Schedule := TSchedule(ComboBoxSchedule.ItemIndex);
	Init;
	InitNextRun;
end;

procedure TfMessage.TimePickerChange(Sender: TObject);
begin
	FormMes.StartDT := DateOf(FormMes.StartDT) + TimeOf(TimePicker.DateTime);
	InitNextRun;
end;

procedure TfMessage.InitDate;
var Y, M, D, DOW: U2;
begin
	DecodeDateFully(DatePicker.Date, Y, M, D, DOW);
	EditWofY.Text := NToS(WeekOfTheYear(DatePicker.Date));
	EditDofY.Text := NToS(DayOfTheYear(DatePicker.Date));
	EditPrename.Text := GetForename(D, M);
end;

procedure TfMessage.CalendarChange(Sender: TObject);
begin
	DatePicker.Date := EncodeDate(Calendar.Year, Calendar.Month, Calendar.Day);
	FormMes.StartDT := DateOf(DatePicker.Date) + TimeOf(FormMes.StartDT);
	InitNextRun;
	InitDate;
end;

procedure TfMessage.ComboBoxYChange(Sender: TObject);
begin
	Calendar.Year := StrToValI(ComboBoxY.Text, True, 0, 2003, SG(9999), 1);
	DatePicker.Date := EncodeDate(Calendar.Year, Calendar.Month, Calendar.Day);
	FormMes.StartDT := DateOf(DatePicker.Date) + TimeOf(FormMes.StartDT);
	InitNextRun;
	InitDate;
end;

procedure TfMessage.ComboBoxMChange(Sender: TObject);
begin
	Calendar.Month := ComboBoxM.ItemIndex + 1;
	DatePicker.Date := EncodeDate(Calendar.Year, Calendar.Month, Calendar.Day);
	FormMes.StartDT := DateOf(DatePicker.Date) + TimeOf(FormMes.StartDT);
	InitNextRun;
	InitDate;
end;

procedure TfMessage.ComboBoxEveryChange(Sender: TObject);
begin
	try
		case FormMes.Schedule of
		scDaily: FormMes.EveryXDay := StrToValI(ComboBoxEvery.Text, True, 1, 1, High(FormMes.EveryXDay), 1);
		scWeekly: FormMes.EveryXWeek := StrToValI(ComboBoxEvery.Text, True, 1, 1, High(FormMes.EveryXWeek), 1);
		scMonthly: FormMes.EveryXMonth := StrToValI(ComboBoxEvery.Text, True, 1, 1, UG(31), 1);
		scYearly: FormMes.EveryXYear := StrToValI(ComboBoxEvery.Text, True, 1, 1, High(FormMes.EveryXYear), 1);
		scWhenIdle: FormMes.EveryXIdle := StrToMs(ComboBoxEvery.Text, 0, Minute, MaxInt, True);
		scWhenOverload: FormMes.EveryXOverload := StrToMs(ComboBoxEvery.Text, 0, Minute, MaxInt, True);
		end;
	finally
		InitNextRun;
	end;
end;

procedure TfMessage.SetCalendarDate(const NewDate: TDate);
var Y, M, D, DOW: U2;
begin
	DecodeDateFully(NewDate, Y, M, D, DOW);

	Calendar.OnChange := nil;
	Calendar.CalendarDate := NewDate;
	Calendar.OnChange := CalendarChange;

	ComboBoxY.OnChange := nil;
	ComboBoxY.Text := NToS(Y);
	ComboBoxY.OnChange := ComboBoxYChange;

	ComboBoxM.OnChange := nil;
	ComboBoxM.ItemIndex := M - 1;
	ComboBoxM.OnChange := ComboBoxMChange;

	InitNextRun;
	InitDate;
end;

procedure TfMessage.DatePickerChange(Sender: TObject);
begin
	FormMes.StartDT := DateOf(DatePicker.Date) + TimeOf(FormMes.StartDT);
	SetCalendarDate(DatePicker.Date);
end;

procedure TfMessage.TimePickerDblClick(Sender: TObject);
begin
{	if GetTime('Time', MSec, 0, 0, MSecsPerDay - 1) then
	begin
		DButtonTime.Caption := TimeToS(MSec / MSecsPerDay, 0, ofDisplay);
	end;}
end;

procedure TfMessage.TimePickerDurationChange(Sender: TObject);
begin
	FormMes.Duration :=
		Round(MSecsPerDay * StrToValE(ComboBoxDuration.Text, True, 0, 0, High(FormMes.Duration) div MSecsPerDay)) +
		Round(MSecsPerDay * TimeOf(TimePickerDuration.DateTime));
	InitNextRun;
end;

procedure TfMessage.ComboBoxActionChange(Sender: TObject);
begin
	FormMes.Action := TTaskAction(ComboBoxAction.ItemIndex);
//	EditWaveFileName.Enabled := FormMes.Alert <> maNone;
	InitNextRun;
end;

procedure TfMessage.ButtonNowClick(Sender: TObject);
begin
	FormMes.StartDT := Now;
	TimePicker.DateTime := 1 + TimeOf(FormMes.StartDT);
	DatePicker.DateTime := FormMes.StartDT;
	SetCalendarDate(DatePicker.Date);
end;

procedure TfMessage.ButtonLeftClick(Sender: TObject);
begin
	if TDButton(Sender).Tag = 0 then
	begin
		if ActItem > 0 then
			Dec(ActItem);
	end
	else
	begin
		if ActItem < Tasks.Count - 1 then
			Inc(ActItem);
	end;
	FormShow(Sender);
end;

procedure TfMessage.EditIndexChange(Sender: TObject);
begin
	ActItem := StrToValI(EditIndex.Text, True, 1, ActItem + 1, Tasks.Count, 1) - 1;
	FormShow(Sender);
end;

procedure TfMessage.ButtonLeftKeyPress(Sender: TObject; var Key: Char);
begin
	if Key = Char(VK_RETURN) then
	begin
		// Never executed
	end
	else if Key = Char(VK_HOME) then
	begin
		ActItem := 0;
		FormShow(Sender);
	end
	else if Key = Char(VK_END) then
	begin
		ActItem := Tasks.Count - 1;
		FormShow(Sender);
	end;
end;

procedure TfMessage.ButtonSelectProgramFileNameClick(Sender: TObject);
var
	FileName: TFileName;
	Edit: TDEdit;
begin
	case TDEdit(Sender).Tag of
	0:
	begin
		Edit := EditProgramFileName;
		OpenDialog.Title := 'Select event file';
		OpenDialog.Filter := AllFiles;
	end
	else
	begin
		Edit := EditWaveFileName;
		OpenDialog.Title := 'Select event sound';
		OpenDialog.Filter := AllSounds;
	end;
	end;
	FileName := Edit.Text;
	if ExecuteDialog(OpenDialog, FileName) then
		Edit.Text := FileName;
end;

procedure TfMessage.EditFileNameChange(Sender: TObject);
begin
	if FileOrDirExistsEx(TDEdit(Sender).Text) then
		TDEdit(Sender).Font.Style := []
	else
		TDEdit(Sender).Font.Style := [fsStrikeOut];
end;

end.
