// * File:     EventScheduler\ufContacts.pas
// * Created:  1999-08-01
// * Modified: 2008-10-25
// * Version:  2.4.47.112
// * Author:   David Safranek (Safrad)
// * E-Mail:   safrad at email.cz
// * Web:      http://safrad.own.cz

unit ufContacts;

interface

uses
	uDForm, uTypes, uData,
	Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
	uDImage, uDView, Menus, Dialogs, uDWinControl;

type
	TfContacts = class(TDForm)
		DViewC: TDView;
		PopupMenu1: TPopupMenu;
		Close1: TMenuItem;
		N1: TMenuItem;
		Add1: TMenuItem;
		Edit1: TMenuItem;
		Delete1: TMenuItem;
		N2: TMenuItem;
		ImportContacts1: TMenuItem;
		ExportContacts1: TMenuItem;
		OpenDialog1: TOpenDialog;
		SaveDialog1: TSaveDialog;
		procedure FormCreate(Sender: TObject);
		procedure FormShow(Sender: TObject);
		procedure FormHide(Sender: TObject);
		procedure DViewCGetData(Sender: TObject; var Data: String; ColIndex,
			RowIndex: Integer; Rect: TRect);
		procedure DViewCDblClick(Sender: TObject);
		procedure Close1Click(Sender: TObject);
		procedure Delete1Click(Sender: TObject);
		procedure AddEdit1Click(Sender: TObject);
		procedure PopupMenu1Popup(Sender: TObject);
		procedure ImportContacts1Click(Sender: TObject);
		procedure ExportContacts1Click(Sender: TObject);
		procedure DViewCColumnClick(Sender: TObject; Column: TColumn);
	private
		{ Private declarations }
		procedure RWOptions(const Save: Boolean);
	public
		{ Public declarations }
	end;

procedure RWContacts(const Save: Boolean);

var
	fContacts: TfContacts;
type
	PCon = ^TCon;
	TCon = packed record // 128
		Nick: string; // 4
		FirstName: string; // 4
		SecondName: string; // 4
		Title: string; // 4
		Notes: string; // 4
		BirthDay: TDate; // 8
		NameDay: U4; // 4
		EMails: string; // 4
		WebPages: string; // 4
		Phone: U8; // 8

		Created: TDateTime; // 4
		Modified: TDateTime; // 4
		Enabled: B1; // 1
		Reserve: array[0..60 + 2] of U1; // 63
	end;
const
	ColumnNames: array[0..9] of string = (
	'Second Name', 'First Name', 'Nick', 'E-Mails', 'Title', 'Notes', 'Birth Day', 'Name Day', 'Web Pages', 'Phone');

var
	Con: TData;
type
	PPre = ^TPre;
	TPre = string[63];
var
	Pre: TData;

function ConToStr(C: PCon): string;

implementation

{$R *.dfm}
uses
	uMain, uContact,
	uDIni, uMenus, uFiles, uMsg, uStrings, uSorts, uCSV, uInput, uSystem, uFormat;
var

	ConFileName: TFileName;

function ConToStr(C: PCon): string;
var s: string;
begin
	s := '';
	if C.Nick <> '' then
	begin
		s := s + C.Nick;
		if (C.FirstName <> '') or (C.SecondName <> '') then
			s := s + ' - ';
	end;
	if C.FirstName <> '' then s := s + C.FirstName + ' ';
	if C.SecondName <> '' then s := s + C.SecondName;
	Result := s;
end;

procedure RWContacts(const Save: Boolean);
var
	i: SG;
	Id: string;

	M: PCon;
	P: PPre;
	ConIni: TDIniFile;
	ConCount: SG;

	Lines: TStrings;
	FileName: TFileName;
	s: string;
begin
	ConIni := TDIniFile.Create(AppDataDir + 'Contacts.ini');
	ConCount := Con.Count;
	ConIni.RWNum('Data', 'ConCount', ConCount, Save);
	if Save = False then Con.Clear;
	for i := 0 to ConCount - 1 do
	begin
		if Save = False then
		begin
			M := Con.Add;
			FillChar(M^, SizeOf(TCon), 0);

		end
		else
		begin
			M := Con.Get(i);

		end;

		Id := 'Contact' + NToS(i, ofIO);

		ConIni.RWString(Id, 'Nick', M.Nick, Save);
		ConIni.RWString(Id, 'FirstName', M.FirstName, Save);
		ConIni.RWString(Id, 'SecondName', M.SecondName, Save);
		ConIni.RWString(Id, 'Title', M.Title, Save);
		ConIni.RWString(Id, 'Notes', M.Notes, Save);
		ConIni.RWDate(Id, 'BirthDay', TDateTime(M.BirthDay), Save);
		ConIni.RWNum(Id, 'NameDay', M.NameDay, Save);
		ConIni.RWString(Id, 'E-Mail', M.EMails, Save);
		ConIni.RWString(Id, 'WebPages', M.WebPages, Save);
		ConIni.RWNum(Id, 'Phone', M.Phone, Save);
		ConIni.RWBool(Id, 'Enabled', M.Enabled, Save);

		ConIni.RWDateTime(Id, 'Created', M.Created, Save);
		ConIni.RWDateTime(Id, 'Modified', M.Modified, Save);

		if Save = False then
		begin
		end;

	end;
	ConIni.Free;
end;

procedure TfContacts.RWOptions(const Save: Boolean);
begin
	MainIni.RWFormPos(Self, Save);
	MainIni.RWDView(DViewC, Save);
	if Save = False then ConFileName := AppDataDir + 'Contacts.csv';
	MainIni.RWString('Options', 'ConFileName', string(ConFileName), Save);
end;

procedure TfContacts.FormCreate(Sender: TObject);
var i: SG;
begin
	Background := baNone;
	OpenDialog1.Filter := 'Comma Separated Values', ['csv']) + '|' + AllText;
	SaveDialog1.Filter := OpenDialog1.Filter;

	MenuSet(PopupMenu1);

	DViewC.ColumnCount := 12;
	for i := 0 to 9 do
		DViewC.Columns[i].Caption := ColumnNames[i];

	DViewC.Columns[0].Width := 48;
	DViewC.Columns[1].Width := 96;
	DViewC.Columns[2].Width := 96;
	DViewC.Columns[3].Width := 64;
	DViewC.Columns[4].Width := 32;
//	DViewC.Columns[5].Alignment := taRightJustify;
	DViewC.Columns[5].Width := 32;
	DViewC.Columns[6].Width := 32;
	DViewC.Columns[7].Width := 32;
	DViewC.Columns[8].Width := 32;
	DViewC.Columns[9].Width := 32;
	DViewC.Columns[9].Alignment := taRightJustify;
	DViewC.Columns[10].Caption := 'Created';
	DViewC.Columns[10].Width := 32;
	DViewC.Columns[11].Caption := 'Modified';
	DViewC.Columns[11].Width := 32;
	for i := 0 to DViewC.ColumnCount - 1 do
		DViewC.Columns[i].Click := True;

	RWOptions(False);
end;

procedure TfContacts.FormShow(Sender: TObject);
begin
	fMain.Contacts1.Checked := True;
	DViewC.RowCount := Con.Count;
end;

procedure TfContacts.FormHide(Sender: TObject);
begin
	fMain.Contacts1.Checked := False;
	RWOptions(True);
	RWContacts(True);
end;

procedure TfContacts.DViewCGetData(Sender: TObject; var Data: String;
	ColIndex, RowIndex: Integer; Rect: TRect);
var
	M: PCon;
begin
	M := Con.Get(RowIndex);
	if M.Enabled = False then
		DViewC.Bitmap.Canvas.Font.Color := clGrayText;
	case ColIndex of
	0: Data := M.SecondName;
	1: Data := M.FirstName;
	2: Data := M.Nick;
	3: Data := M.EMails;
	4: Data := M.Title;
	5: Data := M.Notes;
	6: Data := DateTimeToS(M.BirthDay, 0, ofDisplay);
	7:
	begin
		if M.NameDay = 0 then
			Data := ''
		else
		begin
			Data := DateTimeToS(EncodeDate(2000, M.NameDay div 100, M.NameDay mod 100), 0, ofDisplay);
		end;
	end;
	8: Data := M.WebPages;
	9:
	begin
		if M.Phone = 0 then
			Data := ''
		else
		begin
//			Data := NToS(M.Phone, True);
			Data := PhoneToStr(M.Phone);
			case M.Phone mod 1000000000 of
			601000000..602999999, 606000000..607999999, 720000000..729999999: DViewC.Bitmap.Canvas.Brush.Color := $0099ff; // Eurotel
			603000000..605999999, 730000000..739999999: DViewC.Bitmap.Canvas.Brush.Color := $00cc99; // T-Mobile
			608000000..608999999, 776000000..777999999: DViewC.Bitmap.Canvas.Brush.Color := clRed; // Vodafone
			else DViewC.Bitmap.Canvas.Brush.Color := clWindowText;
			end;
		end;
	end;
	10: Data := DateTimeToS(M.Created, 0, ofDisplay);
	11: Data := DateTimeToS(M.Modified, 0, ofDisplay);
	end;
end;

procedure TfContacts.DViewCDblClick(Sender: TObject);
begin
	if DViewC.Where = vaRow then
	if DViewC.ActualRow >= 0 then
	begin
		AddEdit1Click(Sender)
	end;
end;

procedure TfContacts.AddEdit1Click(Sender: TObject);
var i: SG;
begin
	if not Assigned(fContact) then fContact := TfContact.Create(Self);
	case TMenuItem(Sender).Tag of
	1:
	begin
		fContact.ActItem := Con.Count;
		fContact.ActiveControl := fContact.EditNickName;
		fContact.ShowModal;
	end;
	0:
	begin
		for i := 0 to DViewC.RowCount - 1 do
			if DViewC.SelRows[i] then
			begin
				fContact.ActItem := DViewC.RowOrder[i];
				fContact.ActiveControl := fContact.EditNickName;
				fContact.ShowModal;
			end;
	end;
	end;
end;

procedure TfContacts.Delete1Click(Sender: TObject);
var
	i: SG;
	k: UG;
	s: string;
	C: PCon;
begin
	if DViewC.SelCount > 0 then
	begin
		for i := 0 to DViewC.RowCount - 1 do
		begin
			if DViewC.SelRows[i] then
			begin
				C := PCon(Con.Get(DViewC.RowOrder[i]));
				s := 'Delete' + LineSep + ConToStr(C) + '?';
				if Confirmation(s, [mbYes, mbNo]) = mbYes then
				begin
					C.Reserve[0] := $fe;
				end;
			end;
		end;
	end;

	k := 0;
	while k < Con.Count do
	begin
		C := PCon(Con.Get(k));
		if C.Reserve[0] = $fe then
		begin
			Con.Delete(k);
		end
		else
			Inc(k);
	end;
	DViewC.RowCount := Con.Count;

{	if DViewC.SelCount > 0 then
	begin
		if Confirmation('Delete ' + NToS(DViewC.SelCount) + ' Item' + Plural(DViewC.SelCount) + '?', [mbYes, mbNo]) = mbYes then
		begin
			k := 0;
			for i := 0 to DViewC.RowCount - 1 do
			begin
				if DViewC.SelRows[i] then
				begin
					Con.Delete(k);
				end
				else
					Inc(k);
			end;
			DViewC.RowCount := Con.Count;
		end;
	end;}
end;

procedure TfContacts.PopupMenu1Popup(Sender: TObject);
begin
//	Add1.Enabled := DViewC.SelCount > 0;
	Edit1.Enabled := DViewC.SelCount > 0;
	Delete1.Enabled := DViewC.SelCount > 0;
end;

procedure TfContacts.Close1Click(Sender: TObject);
begin
	Close;
end;

procedure TfContacts.ImportContacts1Click(Sender: TObject);
var
	i: SG;
	C: PCon;
	Sep: Char;
	Format: PCSVFormat;
begin
	if ConFileName = '' then ConFileName := AppDataDir + 'Contacts.csv';
	if ExecuteDialog(OpenDialog1, ConFileName) then
	begin
		case OpenDialog1.FilterIndex of
		1: Sep := ',';
		2: Sep := CharTab;
		else Sep := ';';
		end;

		CSVReqFormats.Clear;
		for i := 0 to Length(ColumnNames) - 1 do
		begin
			Format := CSVReqFormats.Add;
			Format.Name := ColumnNames[i];
			Format.ValueType := vtText;
		end;

		if CSVRead(ConFileName, Sep) then
		begin
			while CSVReadLine do
			begin
				C := Con.Add;
				C.Nick := Columns[0];
				C.FirstName := Columns[1];
				C.SecondName := Columns[2];
				C.Title := Columns[3];
				C.Notes := Columns[4];
				C.BirthDay := SToDate(Columns[5]);
				C.NameDay := StrToValI(Columns[6], False, 0, UG(0), 1231, 1);
				C.EMails := Columns[7];
				C.WebPages := Columns[8];
				C.Phone := StrToValS8(DelCharsF(DelCharsF(Columns[9], '+'), '-'), False, 0, 0, High(S8), 1);
				C.Created := Now;
				C.Modified := C.Created;
				C.Enabled := True;
			end;
			DViewC.RowCount := Con.Count;
			CSVClose;
		end;
	end;
end;

procedure TfContacts.ExportContacts1Click(Sender: TObject);
const
	SV = ';';
var
	i: SG;
	s, s2: string;
	C: PCon;
begin
	if ConFileName = '' then ConFileName := AppDataDir + 'Contacts.csv';
	if ExecuteDialog(SaveDialog1, ConFileName) then
	begin
{		Lines.Add('Nick/pezdvka' + SV + 'Jmno' + SV + 'Pjmen' + SV + 'Titul' + SV +
			'Poznmka' + SV + 'Narozeniny' + SV + 'Svtek' + SV +
			'Emaily' + SV + 'WWW strnky' + SV + 'Telefony' + SV + 'Pagery' + SV +
			'Ulice' + SV + 'Msto' + SV + 'PS' + SV + 'Stt' + SV + 'Firma' + SV +
			'Ulice (firma)' + SV + 'Msto (firma)' + SV + 'PS (firma)' + SV + 'Stt (firma)');}

		s := '';
		for i := 0 to Length(ColumnNames) - 1 do
			s := s + ColumnNames[i] + SV;
		s := DelLastChar(s);
		for i := 0 to Con.Count - 1 do
		begin
			C := Con.Get(i);
			if C.BirthDay = 0 then
				s2 := ''
			else
				s2 := DateToS(C.BirthDay);
			s := s +
				C.SecondName + SV + C.FirstName + SV + C.Nick + SV + C.EMails + SV + C.Title + SV + C.Notes +
				SV + s2 + SV + NToS(C.NameDay, '0000') + SV + C.WebPages + SV +
				PhoneToStr(C.Phone) + FileSep;
				//SV + SV + SV + SV + SV + SV + SV + SV + SV;
		end;
		WriteStringToFile(ConFileName, s, False);
	end;
end;

procedure TfContacts.DViewCColumnClick(Sender: TObject; Column: TColumn);
var
	i: SG;
	C: PCon;
	ASG: array of SG;
	AFA: array of FA;
	AStr: array of string;
begin
	SetLength(ASG, Con.Count);
	SetLength(AFA, Con.Count);
	SetLength(AStr, Con.Count);
	for i := 0 to Con.Count - 1 do
	begin
		C := Con.Get(i);

		case DViewC.SortBy of
		0: AStr[i] := C.Nick;
		1: AStr[i] := C.FirstName;
		2: AStr[i] := C.SecondName;
		3: AStr[i] := C.Title;
		4: AStr[i] := C.Notes;
		5: AFA[i] := C.BirthDay;
		6: ASG[i] := C.NameDay;
		7: AStr[i] := C.EMails;
		8: AStr[i] := C.WebPages;
		9: AFA[i] := C.Phone;
		10: AFA[i] := C.Created;
		11: AFA[i] := C.Modified;
		end;
		DViewC.RowOrder[i] := i;
	end;
	case DViewC.SortBy of
	5, 9, 10, 11: SortFA(False, False, PArraySG(@DViewC.RowOrder[0]), PArrayFA(@AFA[0]), Con.Count);
	6: SortS4(False, False, PArraySG(DViewC.RowOrder), PArrayS4(ASG), Con.Count);
	0, 1, 2, 3, 4, 7, 8: SortStr(False, PArraySG(DViewC.RowOrder), AStr);
	end;

	SetLength(AStr, 0);
	SetLength(AFA, 0);
	SetLength(ASG, 0);
end;

initialization
	Con := TData.Create;
	Con.ItemSize := SizeOf(TCon);
finalization
	FreeAndNil(Pre);
	FreeAndNil(Con);
end.
