// * File:     EventScheduler\ufContact.pas
// * Created:  1999-08-01
// * Modified: 2009-08-09
// * Version:  2.4.47.112
// * Author:   David Safranek (Safrad)
// * E-Mail:   safrad at email.cz
// * Web:      http://safrad.own.cz

unit ufContact;

interface

uses
	uTypes, uDForm,
	uContacts,
	Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
	StdCtrls, uDButton, ExtCtrls, uDLabel, ComCtrls, uDEdit;

type
	TfContact = class(TDForm)
		ButtonOk: TDButton;
		ButtonCancel: TDButton;
		LabelPhones: TLabel;
		LabelFirstName: TLabel;
		EditFirstName: TDEdit;
		Bevel1: TBevel;
		DButtonEnabled: TDButton;
		EditCreated: TDEdit;
		EditModified: TDEdit;
		LabelCreated: TLabel;
		LabelModified: TLabel;
		EditPhones: TDEdit;
		LabelEMail: TLabel;
		EditEMails: TDEdit;
		LabelNotes: TLabel;
		EditNotes: TDEdit;
		Bevel2: TBevel;
		LabelNameDay: TLabel;
		EditNameDay: TDEdit;
		LabelBirthDay: TLabel;
		DatePickerBirthday: TDateTimePicker;
		EditSecondName: TDEdit;
		EditTitle: TDEdit;
		LabelSecName: TLabel;
		LabelTitle: TLabel;
		Bevel3: TBevel;
		Bevel4: TBevel;
		LabelContact: TLabel;
		EditIndex: TComboBox;
		ButtonDown: TDButton;
		ButtonUp: TDButton;
		EditWebPages: TDEdit;
		LabelWebPages: TLabel;
		LabelNickName: TLabel;
		EditNickName: TDEdit;
		ButtonUse: TDButton;
		procedure FormShow(Sender: TObject);
		procedure ButtonCancelClick(Sender: TObject);
		procedure ButtonOkClick(Sender: TObject);
		procedure FormCreate(Sender: TObject);
		procedure EditFirstNameChange(Sender: TObject);
		procedure ButtonDownClick(Sender: TObject);
		procedure EditIndexChange(Sender: TObject);
		procedure ButtonDownKeyPress(Sender: TObject; var Key: Char);
	private
		{ Private declarations }
		FormCon: TCon;
	public
		{ Public declarations }
		ActItem: UG;
	end;

var
	fContact: TfContact;

implementation

{$R *.dfm}
uses uStrings, uInput, uFormat;

procedure FillNewContact(Con: PCon);
begin
	FillChar(Con^, SizeOf(TCon), 0);
	Con.Nick := '';
	Con.FirstName := '';
	Con.SecondName := '';
	Con.Title := '';
	Con.Notes := '';
	Con.BirthDay := 0;
	Con.NameDay := 0;
	Con.EMails := '';
	Con.WebPages := '';
	Con.Phone := 0;
	Con.Created := Now;
	Con.Modified := Con.Created;
	Con.Enabled := True;
end;

procedure TfContact.FormShow(Sender: TObject);
begin
	if ActItem >= Con.Count then
	begin
		FillNewContact(@FormCon);
		Caption := 'Add New Contact';
	end
	else
	begin
		FormCon := PCon(Con.Get(ActItem))^;
		Caption := 'Edit Contact ' + NToS(ActItem + 1) + ' / ' + NToS(Con.Count);
	end;
	EditNickName.Text := FormCon.Nick;
	EditFirstName.Text := FormCon.FirstName;
	EditSecondName.Text := FormCon.SecondName;
	EditTitle.Text := FormCon.Title;
	EditNotes.Text := FormCon.Notes;
	ButtonUse.Down := FormCon.BirthDay <> 0;
	if FormCon.BirthDay = 0 then
	begin
		DatePickerBirthday.Date := 1;
	end
	else
		DatePickerBirthday.Date := FormCon.BirthDay;
//	EditFirstNameChange(Sender);
	EditEMails.Text := FormCon.EMails;
	EditPhones.Text := NToS(FormCon.Phone);
	EditWebPages.Text := FormCon.WebPages;

	DButtonEnabled.Down := FormCon.Enabled;

	// Read Only
	EditCreated.Text := DateTimeToS(FormCon.Created, 0, ofDisplay);
	EditModified.Text := DateTimeToS(FormCon.Modified, 0, ofDisplay);

	EditIndex.Text := NToS(ActItem + 1);
end;

procedure TfContact.ButtonCancelClick(Sender: TObject);
begin
	Close;
end;

procedure TfContact.ButtonOkClick(Sender: TObject);
var
	C: PCon;
begin
	if ActItem >= Con.Count then
	begin
		C := Con.Add;
	end
	else
	begin
		C := Con.Get(ActItem);
	end;
	C^ := FormCon;

	C.Nick := EditNickName.Text;
	C.FirstName := EditFirstName.Text;
	C.SecondName := EditSecondName.Text;
	C.Title := EditTitle.Text;
	C.Notes := EditNotes.Text;
	if ButtonUse.Down then
		C.BirthDay := DatePickerBirthday.Date
	else
		C.BirthDay := 0;

	C.EMails := EditEMails.Text;
	C.WebPages := EditWebPages.Text;
	C.Phone := StrToValS8(EditPhones.Text, True, 0, 420555123456, High(S8), 1) mod 999999999999;
	C.Notes := EditNotes.Text;

	C.Enabled := DButtonEnabled.Down;

	C.Modified := Now;

	fContacts.DViewC.RowCount := Con.Count;
	Close;
end;

procedure TfContact.FormCreate(Sender: TObject);
begin
	Background := baGradient;
end;

procedure TfContact.EditFirstNameChange(Sender: TObject);
var
	i: SG;
	s: string;
	Nam: string;
	InLineIndex: SG;
	Year, Month, Day: U2;
begin
	InLineIndex := 1;
	Nam := ReadToChar(EditFirstName.Text, InLineIndex, ' ');
	FormCon.NameDay := 0;
	for i := 0 to Pre.Count - 1 do
	begin
		s := TPre(Pre.Get(i)^);
		InLineIndex := 1;
		while True do
		begin
			if ReadToChar(s, InLineIndex, '/') = Nam then
			begin
				DecodeDate(1 + i, Year, Month, Day);
				FormCon.NameDay := 100 * Month + Day;
				EditNameDay.Text := DateToS(EncodeDate(2000, Month, Day), ofDisplay) + ' (' + NToS(i) + ' day of year)';
			end;
			if InLineIndex >= Length(s) then Break
		end;
	end;
	if FormCon.NameDay = 0 then
		EditNameDay.Text := NAStr;
end;

procedure TfContact.ButtonDownClick(Sender: TObject);
begin
	if TDButton(Sender).Tag = 0 then
	begin
		if ActItem > 0 then
			Dec(ActItem);
	end
	else
	begin
		if ActItem < Con.Count - 1 then
			Inc(ActItem);
	end;
	FormShow(Sender);
end;

procedure TfContact.EditIndexChange(Sender: TObject);
begin
	ActItem := StrToValI(EditIndex.Text, True, 1, ActItem + 1, Con.Count, 1) - 1;
	FormShow(Sender);
end;

procedure TfContact.ButtonDownKeyPress(Sender: TObject; var Key: Char);
begin
	if Key = Char(VK_RETURN) then
	begin
		// Never executed
	end
	else if Key = Char(VK_HOME) then
	begin
		ActItem := 0;
		FormShow(Sender);
	end
	else if Key = Char(VK_END) then
	begin
		ActItem := Con.Count - 1;
		FormShow(Sender);
	end;
end;

end.
