// * File:     EventScheduler\ufAscii.pas
// * Created:  1999-08-01
// * Modified: 2010-07-24
// * Version:  2.4.47.112
// * Author:   David Safranek (Safrad)
// * E-Mail:   safrad at email.cz
// * Web:      http://safrad.own.cz

unit ufAscii;

interface

uses
	uTypes,
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
	uDImage, StdCtrls, uDButton, ExtCtrls, uDForm, Dialogs, uDWinControl, uData;

type
	TFontData = class
		Name: string;
		Typ: SG;
	end;

	TfAscii = class(TDForm)
		FontDialog1: TFontDialog;
		PanelH: TPanel;
		FontName: TComboBox;
		ButtonFont: TDButton;
		ButtonColor: TDButton;
		ImageM: TDImage;
		ComboBoxSize: TComboBox;
		ComboBoxFontType: TComboBox;
		DButtonReload: TDButton;
		procedure FormCreate(Sender: TObject);
		procedure FontNameChange(Sender: TObject);
		procedure ButtonFontClick(Sender: TObject);
		procedure ButtonColorClick(Sender: TObject);
		procedure ImageMFill(Sender: TObject);
		procedure FormResize(Sender: TObject);
		procedure ComboBoxSizeChange(Sender: TObject);
		procedure FormShow(Sender: TObject);
		procedure FormHide(Sender: TObject);
		procedure ComboBoxFontTypeChange(Sender: TObject);
		procedure FormDestroy(Sender: TObject);
		procedure DButtonReloadClick(Sender: TObject);
	private
		{ Private declarations }
		Fonts: TData;
		CurFont: TFont;
		procedure GetFontNames;
		procedure InitFont;
		procedure RWOptions(const Save: Boolean);
	public
		{ Public declarations }
	end;

var
	fAscii: TfAscii;

implementation

{$R *.DFM}
uses
	uFiles, uGColor, uGraph, uDBitmap, uDIniFile, uInputFormat, uOutputFormat, uColor, uStrings, uDrawStyle, uDictionary,
	uMain;

function EnumFontsProc(var LogFont: TLogFont; var TextMetric: TTextMetric;
	FontType: Integer; Data: Pointer): Integer; stdcall;
var
	FontData: TFontData;
begin
	FontData := TFontData.Create; 
	FontData.Typ := FontType;
	FontData.Name := LogFont.lfFaceName;
	TData(Data^).Add(FontData);
	Result := 1;
end;

procedure TfAscii.GetFontNames;
var
	DC: HDC;
begin
	Fonts.Clear;
	DC := GetDC(0);
	try
		EnumFontFamilies(DC, nil, @EnumFontsProc, Integer(@Fonts));
	finally
		ReleaseDC(0, DC);
	end;
end;

procedure TfAscii.InitFont;
var
	Index: SG;
	i: SG;
	FontData: TFontData;
	Count: UG;
begin
	case ComboBoxFontType.ItemIndex of
	0: Index := 0;
	1: Index := DEVICE_FONTTYPE; // 2
	2: Index := RASTER_FONTTYPE; // 1
	3: Index := TRUETYPE_FONTTYPE; // 4
	else Index := -1;
	end;

	FontName.Items.BeginUpdate;
	try
		FontName.Items.Clear;
		
		FontData := TFontData(Fonts.First);
		Count := 0;
		while FontData <> nil do
		begin
			if (Index = -1) or (FontData.Typ = Index) then
			begin
				FontName.Items.Add(FontData.Name);
				Inc(Count);
			end;
			FontData := TFontData(Fonts.Next);
		end;
		FontName.ShowHint := True;
		FontName.Hint := NToS(Count) + ' Font' + Plural(Count);

	finally
		FontName.Items.EndUpdate;
	end;

	ComboBoxSize.Text := NToS(CurFont.Size);
	for i := 0 to FontName.Items.Count - 1 do
		if FontName.Items[i] = CurFont.Name then
		begin
			FontName.ItemIndex := i;
			Break;
		end;
end;

procedure TfAscii.RWOptions(const Save: Boolean);
const
	Section = 'Ascii';
begin
	MainIni.RWFormPos(Self, Save);
	MainIni.RWComboBox(Section, ComboBoxFontType, Save);
	CurFont.Name := MainIni.RWStringF(Section, 'FontName', CurFont.Name, CurFont.Name, Save);
	CurFont.Size := MainIni.RWSGF(Section, 'FontSize', CurFont.Size, CurFont.Size, Save);
	CurFont.Color := MainIni.RWSGF(Section, 'FontColor', CurFont.Color, CurFont.Color, Save);
end;

procedure TfAscii.FormCreate(Sender: TObject);
var i: SG;
begin
	Background := baStandard;
	Fonts := TData.Create;

	GetFontNames;
	CurFont := TFont.Create;
	CurFont.Color := clSilver;

	RWOptions(False);

	ComboBoxSize.Items.BeginUpdate;
	try
		for i := 1 to 32 do
			ComboBoxSize.Items.Add(NToS(i));
	finally
		ComboBoxSize.Items.EndUpdate;
	end;

	Dictionary.TranslateForm(Self);
	InitFont;
end;

procedure TfAscii.FontNameChange(Sender: TObject);
begin
	CurFont.Name := FontName.Text;
	ImageM.Invalidate;
end;

procedure TfAscii.ButtonFontClick(Sender: TObject);
begin
	FontDialog1.Font := CurFont;
	if FontDialog1.Execute then
	begin
		CurFont := FontDialog1.Font;
		InitFont;
		ImageM.Invalidate;
	end;
end;

procedure TfAscii.ButtonColorClick(Sender: TObject);
var CurrentColor: TColor;
begin
	CurrentColor := CurFont.Color;
	if GetColor('Font Color', CurrentColor, clBlack, nil) then
	begin
		CurFont.Color := CurrentColor;
		ImageM.Invalidate;
	end;
end;

procedure TfAscii.ImageMFill(Sender: TObject);
var
	D: SG;
	FX, FY, SX, x, y: SG;
	OutputCanvas: TCanvas;
	NegC: TColor;
	s: string;
begin
	NegC := NegMonoColor(CurFont.Color);
	ImageM.Bitmap.Bar(NegC, ef16);
	OutputCanvas := ImageM.Bitmap.Canvas;
	OutputCanvas.Font := CurFont;
	OutputCanvas.Brush.Color := NegC;
	FX := OutputCanvas.TextWidth(NToS(255) + '  W');
	FY := OutputCanvas.TextHeight(NToS(255) + '  W');
	SX := OutputCanvas.TextWidth(NToS(255));
	D := 0;
	x := 0;
	while x <= 15 do
	begin
		y := 0;
		while y <= 15 do
		begin
			s := NToS(D);
			OutPutCanvas.TextOut(SX - OutputCanvas.TextWidth(s) +
				FX * x - ImageM.OfsX,
				FY * y - ImageM.OfsY,
				s + '  ' + Char(D));
			Inc(d);
			Inc(y, 1);
		end;
		Inc(x, 1);
	end;
	ImageM.UserArea := Rect(0, 0, FX * 16, FY * 16);
end;

procedure TfAscii.FormResize(Sender: TObject);
begin
	ImageM.Invalidate;
end;

procedure TfAscii.ComboBoxSizeChange(Sender: TObject);
begin
	CurFont.Size := StrToValI(ComboBoxSize.Text, True, -1000, 8, 1000, 1);
	ImageM.Invalidate;
end;

procedure TfAscii.FormShow(Sender: TObject);
begin
	fMain.AsciiTable1.Checked := True;
end;

procedure TfAscii.FormHide(Sender: TObject);
begin
	fMain.AsciiTable1.Checked := False;
	RWOptions(True);
end;

procedure TfAscii.ComboBoxFontTypeChange(Sender: TObject);
begin
	InitFont;
end;

procedure TfAscii.FormDestroy(Sender: TObject);
begin
	FreeAndNil(Fonts);
end;

procedure TfAscii.DButtonReloadClick(Sender: TObject);
begin
	GetFontNames;
	InitFont;
end;

end.
