// * File:     EventScheduler\uReportFile.pas
// * Created:  2010-10-09
// * Modified: 2010-11-11
// * Version:  2.4.47.112
// * Author:   David Safranek (Safrad)
// * E-Mail:   safrad at email.cz
// * Web:      http://safrad.own.cz

unit uReportFile;

interface

uses SysUtils, uFile;

type
	TReportFile = class(TFile)
	public
		procedure Close;
		procedure Open(const FileName: TFileName); overload;
		procedure ReportOn;
		procedure ReportOff;
	end;

implementation

uses uTypes, uCSVFile, uOutputFormat, uStrings;

{ TReportFile }

procedure TReportFile.Close;
begin
	if Opened then
	begin
		ReportOff;
		inherited Close;
	end;
end;

procedure TReportFile.Open(const FileName: TFileName);
var
	New: BG;
begin
	New := not FileExists(FileName);
	if inherited Open(FileName, fmAppend) then
	begin
		if New then
		begin
			Write(CSVRemark + 'On' + CSVSep + 'Off');
		end;
		ReportOn;
	end;
end;

procedure TReportFile.ReportOff;
begin
	if Opened then
	begin
		Write(CSVSep + DateTimeToS(Now, 3, ofIO));
		FlushFileBuffers;
	end;
end;

procedure TReportFile.ReportOn;
begin
	if Opened then
	begin
		Write(FileSep + DateTimeToS(Now, 3, ofIO));
		FlushFileBuffers;
	end;
end;

end.
