// * File:     EventScheduler\uMain.pas
// * Created:  1999-08-01
// * Modified: 2010-11-12
// * Version:  2.4.47.112
// * Author:   David Safranek (Safrad)
// * E-Mail:   safrad at email.cz
// * Web:      http://safrad.own.cz

unit uMain;

interface

uses
	uTypes, uFiles, uData,
	uTask,
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
	StdCtrls, ComCtrls, uDButton, ExtCtrls, uDLabel, Menus,
	CoolTrayIcon, uDTimer, uDForm, AppEvnts, uDEdit, Dialogs, WTSAPI;

type
	TfMain = class(TDForm)
		MainMenu: TMainMenu;
		File1: TMenuItem;
		Bevel2: TBevel;
		System1: TMenuItem;
		Capture1: TMenuItem;
		Help1: TMenuItem;
		PopupMenuIcon: TPopupMenu;
		SetSafeMode1: TMenuItem;
		Grate1: TMenuItem;
		N8: TMenuItem;
		RepaintWinodws1: TMenuItem;
		TimerEvent: TTimer;
		DisplayProperties1: TMenuItem;
		SystemProperties1: TMenuItem;
		Zoomer1: TMenuItem;
		Logoff1: TMenuItem;
		OpenGL1: TMenuItem;
		N11: TMenuItem;
		Change3DObjectsColor1: TMenuItem;
		Colors1: TMenuItem;
		DayPeriod1: TMenuItem;
		YearPeriod1: TMenuItem;
		BlackWindows1: TMenuItem;
		InvertWindows1: TMenuItem;
		AsciiTable1: TMenuItem;
		Messages1: TMenuItem;
		StopTimer1: TMenuItem;
		Window1: TMenuItem;
		N13: TMenuItem;
		Wallpapers1: TMenuItem;
		Saver1: TMenuItem;
		SaverEnabled1: TMenuItem;
		N14: TMenuItem;
		LabelCPUUsage: TLabel;
		Bevel6: TBevel;
		PanelCPUUsage: TDEdit;
		Start1: TMenuItem;
		FileNameName1: TMenuItem;
		RunAfter1: TMenuItem;
		CPUUsageNotAbove1: TMenuItem;
		LabelTimeToSaver: TLabel;
		PanelTimeToSaver: TDEdit;
		Stop1: TMenuItem;
		N19: TMenuItem;
		PowerOff1: TMenuItem;
		Reboot1: TMenuItem;
		Shutdown1: TMenuItem;
		Hibernate1: TMenuItem;
		Suspend1: TMenuItem;
		MainForm1: TMenuItem;
		SetStartMode1: TMenuItem;
		ColorDialog1: TMenuItem;
		Options1: TMenuItem;
		Display1: TMenuItem;
		PanelTool: TPanel;
		OpenDialog1: TOpenDialog;
		PowerReport1: TMenuItem;
		KeyboardLogger1: TMenuItem;
		WallpaperOptions1: TMenuItem;
		Options2: TMenuItem;
		KeyboardLoggerOutput1: TMenuItem;
		procedure FormCreate(Sender: TObject);
		procedure Capture1Click(Sender: TObject);
		procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
		procedure Exit1Click(Sender: TObject);
		procedure SetSafeMode1Click(Sender: TObject);
		procedure FormShow(Sender: TObject);
		procedure FormHide(Sender: TObject);
		procedure Grate1Click(Sender: TObject);
		procedure RepaintWinodws1Click(Sender: TObject);
		procedure TimerEventTimer(Sender: TObject);
		procedure DisplayProperties1Click(Sender: TObject);
		procedure SystemProperties1Click(Sender: TObject);
		procedure Zoomer1Click(Sender: TObject);
		procedure Exit1ClickWindows(Sender: TObject);
		procedure OpenGL1Click(Sender: TObject);
		procedure Change3DObjectsColor1Click(Sender: TObject);
		procedure DayPeriod1Click(Sender: TObject);
		procedure YearPeriod1Click(Sender: TObject);
		procedure BlackWindows1Click(Sender: TObject);
		procedure Messages1Click(Sender: TObject);
		procedure AsciiTable1Click(Sender: TObject);
		procedure StopTimer1Click(Sender: TObject);
		procedure Wallpapers1Click(Sender: TObject);
		procedure SaverEnabled1Click(Sender: TObject);
		procedure Start1Click(Sender: TObject);
		procedure FileNameName1Click(Sender: TObject);
		procedure RunAfter1Click(Sender: TObject);
		procedure CPUUsageNotAbove1Click(Sender: TObject);
		procedure Stop1Click(Sender: TObject);
		procedure FormDestroy(Sender: TObject);
		procedure Hibernate1Click(Sender: TObject);
		procedure MainForm1Click(Sender: TObject);
		procedure PopupMenuIconPopup(Sender: TObject);
		procedure SetStartMode1Click(Sender: TObject);
		procedure ColorDialog1Click(Sender: TObject);
		procedure PanelToolResize(Sender: TObject);
		procedure PowerReport1Click(Sender: TObject);
		procedure KeyboardLogger1Click(Sender: TObject);
		procedure WallpaperOptions1Click(Sender: TObject);
		procedure Options2Click(Sender: TObject);
		procedure KeyboardLoggerOutput1Click(Sender: TObject);
		procedure FormResize(Sender: TObject);
	private
		{ Private declarations }
		FWinLocked: BG;
//		procedure CreateMenuIcons;
		procedure TrayIconClick(Sender: TObject);
//		procedure StatusStepXClick(Sender: TObject);

		procedure WMPowerBroadcast(var Msg: TWMPower); message WM_POWERBROADCAST;
		procedure WMDisplayChange(var Msg: TWMDisplayChange); message WM_DISPLAYCHANGE;
		procedure WMWTSessionChange(var Msg: TMessage); message WM_WTSSESSION_CHANGE;

		// Main
		procedure RWOptions(const Save: Boolean);
		procedure RegExt(const T: Integer);

		procedure MainOptionChange(const OptionIndex: SG);

		procedure SaverEvent;

		procedure SetLocked(Value: BG);
		property WinLocked: BG read FWinLocked;
	public
		{ Public declarations }
		StartPopupCount: Integer;
		TrayIcons: array[-1..3] of TTrayIcon;
		procedure InitIcon;
		procedure InitCaption;
		procedure InitMenu;
	end;

var
	fMain: TfMain;
	BalloonHint: string;

procedure InitWinColor;
procedure RunAllMessages(const Schedule: TSchedule);

implementation

{$R *.DFM}
uses
	Registry, ShellAPI, DateUtils,
	MMSystem,
	uCommon,
	uScreen, uAbout, uDIniFile, uMsg, uMenus, uGraph, uGetTime, uColor, uMultiIns, uCSVFile, uStart, uIcons,
		uDBitmap, uWave, uGetStr, uInputFormat, uOutputFormat, uMath, uSystem, uLog, uReg, uAPI, uFile,
		uSystemColors, uSysInfo, uProjectInfo, uWatch, uDictionary,
		uGetInt, uStrings, uGColor, uSimulation, uLink, uParams, uWallpaper,
	ufGrate, ufZoomer, ufOpen, ufCapture, ufMessages, ufAscii, ufWall, ufMessage, uReportFile,
	uOptions, ufOptions, Math;


type
	TMainOption = (
		moShowCPUUsageIcon,
		moShowPhysicalMemoryUsageIcon,
		moShowVirtualMemoryUsageIcon,
		moUnload,
		moCPUStatusStep,
		moPhysicalMemoryStatusStep,
		moVirtualMemoryStatusStep,
		moTimerInterval,
		moCreateShortcuts,
		moDeleteShortcuts
	);
var
	MainOptions: array[TMainOption] of TOption = (
		(Typ: vsCheck; Default: 1),
		(Typ: vsCheck; Default: 1),
		(Typ: vsCheck; Default: 1),
		(Typ: vsButton),
		(Typ: vsSpin; Default: 5; Minimum: 1; Maximum: 100),
		(Typ: vsSpin; Default: 2; Minimum: 1; Maximum: 100),
		(Typ: vsSpin; Default: 1; Minimum: 1; Maximum: 100),
		(Typ: vsTime; Default: Second; Minimum: 0; Maximum: Hour),
		(Typ: vsButton),
		(Typ: vsButton)
	);
var
	MainParams: array[TMainOption] of TParam;

const
	CPUIdleValue = 25;
	CPUOverValue = 75;

//var
//	TimerEventInterval: U4;

// Messages
var
	StartIdleTime,
	StartOverloadTime: U4;

// Saver
	SaverStartTime: U4;
const
	DefSaverUserTime = 5 * Minute;
var
	SaverUserTime: U4;
const
	DefSaverCPUUsage = 30;
var
	SaverCPUUsage: SG;
	SaverFileName: TFileName;

var
	MonthColors: array[-1..11] of TColor;
	MonthColorsInitialized: BG;

procedure ReadMonthColors;
var
	CSV: TCSVFile;
	Row: TArrayOfString;
begin
	Row := nil;
	if MonthColorsInitialized then Exit;
	CSV := TCSVFile.Create(1);
	try
		if CSV.Open(DataDir + 'MonthColors.csv') then
		begin
			while not CSV.EOF do
			begin
				Row := CSV.ReadLine;
				if (CSV.LineIndex < Length(MonthColors)) then
					MonthColors[CSV.LineIndex - 1] := StringToColor(Row[0]);
			end;
			CSV.Close;
		end;
	finally
		CSV.Free;
	end;
	MonthColorsInitialized := True;
end;

function GetWindowColor(const SystemTime: TSystemTime): TRGBA;
var
	i1, i2: SG;
	Len: SG;
//	ZoneInfo: TIME_ZONE_INFORMATION;

begin
	i1 := 65536 * (MonthDays[False, SystemTime.wMonth] - (SystemTime.wDay - 1)) div MonthDays[False, SystemTime.wMonth];
	i2 := 65536 * (SystemTime.wDay - 1) div MonthDays[False, SystemTime.wMonth];
	if fMain.YearPeriod1.Checked then
	begin
		Result.L := MixColors(
			MonthColors[SystemTime.wMonth - 1], MonthColors[SystemTime.wMonth mod 12],
				i1,
				i2);

		Result.L := MixColors(Result.L, clSilver);
	end
	else
		Result.L := StartColors[COLOR_BTNFACE];
{	fMain.YearPeriod1.Caption := 'Year Period ' + NToS(i1) + ' ' + CharTimes + ' ' + ColorToString(MonthColors[SystemTime.wMonth - 1]) + ' + ' +
		NToS(i2) + ' ' + CharTimes + ' ' + ColorToString(MonthColors[SystemTime.wMonth mod 12]) +  '=' + ColorToString(Result.L);}

	Len := LinearMax(Abs(SystemTime.wHour - 2), 12);
	i1 := 3 * 65536 div 4 + Len * 65536 div 24;
	if fMain.DayPeriod1.Checked then
	begin
		Result.L := ColorDiv(Result.L, i1);
	end;
{	fMain.DayPeriod1.Caption := 'Day Period ' + NToS(i1);
	fMain.Change3DObjectsColor1.Caption := 'Change 3D Objects Color ' +
		ColorToString(ColorToRGB(clBtnFace)) + ' -> ' + ColorToString(Result.L);}
end;

procedure InitWinColor;
var
	SystemTime: TSystemTime;
	C: TRGBA;
{	i, j, n: SG;
	s: string;
	B: TDBitmap;}
begin
	ReadMonthColors;
	GetLocalTime(SystemTime);

{	B := TDBitmap.Create;
	B.SetSize(128, 2 * 12 * 28);
	n := 0;
	for j := 1 to 12 do
	for i := 1 to 28 do
	begin
		SystemTime.wDay := i;
		SystemTime.wMonth := j;
		C := GetWindowColor(SystemTime);
		B.Bar(0, 2 * n, B.Width - 1, 2 * n + 1, C.L, ef16);
		Inc(n);
//		s := s + ColorToString(C.L) + LineSep;
	end;
	B.SaveToFile(WorkDir + 'Colors.png');
	B.Free;
//	WriteStringToFile(WorkDir + 'Colors.txt', s, False);
	GetLocalTime(SystemTime);}

	C := GetWindowColor(SystemTime);


{	if (C.L <> ColorToRGB(clBtnFace))
	or (C.L <> ColorToRGB(clMenu)) then}
	SetSystemColors([COLOR_BTNFACE, COLOR_MENU, COLOR_MENUBAR], [C.L, C.L, C.L]);
	MainLogAdd('SetSystemColors to ' + ColorToString(C.L), mlInformation);
end;

procedure TfMain.WMDisplayChange(var Msg: TWMDisplayChange);
begin
	if SelfChange then
	begin
		MainLogAdd('WM_DisplayChange - BitsPerPixel: ' + IntToStr(Msg.BitsPerPixel) + ', Width: ' + IntToStr(Msg.Width) + ', Height: ' + IntToStr(Msg.Height), mlInformation);
		ReadNowMode;
	end;
	if Assigned(Wallpapers) then
		Wallpapers.Invalidate;
end;

procedure TfMain.RegExt(const T: Integer);
var
	StartMenu, QuickLaunch: string;
//	b1, b2: Boolean;
begin
	StartMenu := ShellFolder('Start Menu') + 'Safe Mode.lnk';
	QuickLaunch := CommonAppDataDir + PathDelim + 'Microsoft' + PathDelim + 'Internet Explorer' + PathDelim + 'Quick Launch' + PathDelim + GetProjectInfo(piInternalName) + '.lnk';

	case T of
	0:
	begin
//		b1 := FileExists(StartMenu);
//		b2 := FileExists(QuickLaunch);
{		Shortcut1.Checked := b1 and b2;
		NoShortcut1.Checked := (not b1) and (not b2);
		NoShortcut1.Enabled := not NoShortcut1.Checked;}
	end;
	1:
	begin
		CreateLink(StartMenu, ExeFileName, '-Safe', WorkDir, 0, 'Safe Mode', GraphDir + 'SafeMode.ico', 0);
		CreateLink(QuickLaunch, ExeFileName, '-Minimized', WorkDir, 0, GetProjectInfo(piFileDescription), GraphDir + GetProjectInfo(piInternalName) + '.ico', 0);
	end;
	2:
	begin
		if FileExists(StartMenu) then
			DeleteFile(StartMenu);
		if FileExists(QuickLaunch) then
			DeleteFile(QuickLaunch);
	end;
	end;
end;

procedure TfMain.RWOptions(const Save: Boolean);
var
	Section: string;
//	IconType: TIconType;
begin
	MainIni.RWFormPos(Self, Save);

	// Options
	uOptions.RWOptions(POptions(@MainOptions), Length(MainOptions), PParams(@MainParams), MainIni, 'Main Options', Save);

	Section := 'Options';
	MainIni.RWMenuItem(Section, KeyboardLogger1, Save);

{	MainIni.RWMenuItem(Section, ShowCPUsage1, Save);
	MainIni.RWMenuItem(Section, ShowPMUsage1, Save);
	MainIni.RWMenuItem(Section, ShowVMUsage1, Save);}

{	for IconType := Low(TIconType) to High(TIconType) do
	begin
		if Save = False then StatusStep[IconType] := DefaultStatusStep[IconType];
		MainIni.RWNum(Section, 'StatusStep' + IconTypeStr[IconType], StatusStep[IconType], Save);
	end;

	if Save = False then TimerEventInterval := TimerEvent.Interval;
	MainIni.RWNum(Section, 'TimerEventInterval', TimerEventInterval, Save);}

	// Colors
	Change3DObjectsColor1.Checked := MainIni.RWBGF(Section, 'Change3DObjectsColor', Change3DObjectsColor1.Checked, Change3DObjectsColor1.Checked, Save);
	DayPeriod1.Checked := MainIni.RWBGF(Section, 'DayPeriod', DayPeriod1.Checked, DayPeriod1.Checked, Save);
	YearPeriod1.Checked := MainIni.RWBGF(Section, 'YearPeriod', YearPeriod1.Checked, YearPeriod1.Checked, Save);

	// Saver
	SaverEnabled1.Checked := MainIni.RWBGF('Saver', 'Enabled', SaverEnabled1.Checked, SaverEnabled1.Checked, Save);
	MainIni.RWNum('Saver', 'Time', SaverUserTime, Save);
	MainIni.RWNum('Saver', 'CPU Usage', SaverCPUUsage, Save);
	MainIni.RWFileName('Saver', 'Name', SaverFileName, Save);

{	Section := 'Wallpapers';
	WUserTime := MainIni.RWSGF(Section, 'UserTime', WUserTime, Hour, Save);
	MainIni.RWNum(Section, 'TimeElapsed', WElapsedTime, Save);}
end;

procedure TfMain.InitMenu;
begin
	UpdateIcons(fMain.MainMenu, fMain.PanelTool);
end;

procedure TfMain.InitIcon;
var
	IconType: TIconType;
	PU, PU10: SG;
	ToolTip: string;
var
	DisplayedSomeIcon: BG;
begin
	DisplayedSomeIcon := False;
	FillMemoryStatus(GSysInfo);
	ToolTip := '';
	for IconType := Low(IconType) to High(IconType) do
	begin
		case IconType of
		itCP:
		begin
			PU := RoundDiv(10 * GSysInfo.CPUUsage, CPUUsageMul);
		end;
		itPM:
		begin
			if GSysInfo.MS.dwTotalPhys = 0 then
				PU := 0
			else
				PU := SG(RoundDivU8(U8(1000) * (GSysInfo.MS.dwTotalPhys - GSysInfo.MS.dwAvailPhys), GSysInfo.MS.dwTotalPhys));
		end;
		itVM:
		begin
			if GSysInfo.MS.dwTotalPageFile = 0 then
				PU := 0
			else
				PU := SG(RoundDivU8(U8(1000) * (GSysInfo.MS.dwTotalPageFile - GSysInfo.MS.dwAvailPageFile), GSysInfo.MS.dwTotalPageFile));
		end;
		else // itMessage
		begin
			PU := 0;
		end;
		end;

		if IconType <> itMessage then
			ToolTip := ToolTip + IconTypeStr[IconType] + ' Usage: ' + NToS(PU, 1, ofIO) + '%, ';

		if ((MainParams[moShowCPUUsageIcon].Bool = False) and (IconType = itCP))
			or ((MainParams[moShowPhysicalMemoryUsageIcon].Bool = False) and (IconType = itPM))
			or ((MainParams[moShowVirtualMemoryUsageIcon].Bool = False) and (IconType = itVM))
			or ((GetRunningTaskCount = 0) and (IconType = itMessage))
//		or ((i = 2) and (DisplayedSomeIcon = True))
		then
		begin
			TrayIcons[SG(IconType)].IconVisible := False;
			TrayIcons[SG(IconType)].Icon := nil;
		end
		else
		begin
			DisplayedSomeIcon := True;

			if IconType <> itMessage then
			begin
				PU10 := RoundDiv(PU, 10);
				if Abs(PU10 - ActualValue[IconType]) >= MainParams[TMainOption(SG(moCPUStatusStep) + SG(IconType))].Num then
				begin
					MainLogAdd(IconTypeStr[IconType] + ' Usage: ' + NToS(PU, 1, ofIO) + '%', mlDebug);
					ActualValue[IconType] := PU10;
				end;
				TrayIcons[SG(IconType)].Hint := IconTypeStr[IconType] + ' Usage: ' + NToS(PU, 1, ofIO) + '%';
			end
			else
			begin
				ActualValue[IconType] := 5 + LinearMax(GTime div UG(MainParams[moTimerInterval].Num), 2);
			end;
			TrayIcons[SG(IconType)].Icon := GetIcon(IconType, ActualValue[IconType]);
			TrayIcons[SG(IconType)].IconVisible := True;
		end;
	end;

	if BalloonHint <> '' then
	begin
		TrayIcons[3].ShowBalloonHint(Application.Title, BalloonHint, bitInfo, 60);
		BalloonHint := '';
	end;

	// Program Icon
	TrayIcons[-1].IconVisible := not DisplayedSomeIcon;
	TrayIcons[-1].ShowHint := True;
	TrayIcons[-1].Icon := GetIcon(itMessage, 8);
	TrayIcons[-1].Hint := DelLastChar(ToolTip, 2);
end;

procedure TfMain.InitCaption;
var
	s: string;
begin
	s := GetProjectInfo(piProductName);
	if GetRunningTaskCount > 0 then
	begin
		s := s + ' [' + NToS(GetRunningTaskCount) + ' message' + Plural(GetRunningTaskCount) + ']';
	end;
	if TimerEvent.Enabled = False then s := s + ' [' + Translate('Timer Stopped') + ']';
	Caption := s;
{	for i := Low(TrayIcons) to High(TrayIcons) do}
//	TrayIcons[-1].ToolTip := s;
end;

function MyWndProc(Wnd: HWND; Msg: UG; wParam, lParam: Integer): Integer; stdcall;
begin
	Result := DefWindowProc(Wnd, Msg, wParam, lParam);
end;

procedure ParamMessage(const Value: string);
var
	Task: TTask;
begin
	if Assigned(fMain) then
		RWMessages(True);
	RWMessages(False);
	Task := TTask.Create;
	Task.Name := Value;
	Task.Schedule := scOnce;
	Task.Active := True;
	Tasks.Add(Task);
	StartTask(Task);

	if Assigned(fMain) then
		fMain.TimerEventTimer(nil);
end;

procedure ParamSafeMode(const Value: string);
begin
	ReadScreenModes;
	SetSafeMode;
	ShowTaskBar(True);
	PostMessage(Application.Handle, WM_SYSCOMMAND, SC_MONITORPOWER, -1);
end;

procedure ParamNoStartup(const Value: string);
begin
	NoStartup := True;
end;

procedure RunAllMessages(const Schedule: TSchedule);
var
	i: SG;
	M: ^TTask;
begin
	for i := 0 to Tasks.Count - 1 do
	begin
		M := Tasks.Get(i);
		if (M.Schedule = Schedule) and (M.Enabled) and (M.Running = False) then
		begin
			StartTask(M^);
		end;
	end;
end;

var
	LogReportFile: TReportFile;
	LogReportFileName: TFileName;

	PowerReportFile: TReportFile;
	PowerReportFileName: TFileName;

procedure TfMain.FormCreate(Sender: TObject);
var
	i: SG;
	Task: TTask;
begin
	Background := baGradient;
	StartPopupCount := PopupMenuIcon.Items.Count;
	PowerReportFileName := AppDataDir + 'Power Report.csv';
	LogReportFileName := AppDataDir + 'Log Report.csv';

	ReadScreenModes;
	SelfChange := True;

	SaverFileName := ShortDir(SysDir) + 'ssText3d.scr';//'sspipes.scr';
	SaverUserTime := DefSaverUserTime;
	SaverCPUUsage := DefSaverCPUUsage;

	RWOptions(False);
	if KeyboardLogger1.Checked then KeyboardLogger1Click(nil);

	StartIdleTime := GetStartProgramTime;
	StartOverloadTime := GetStartProgramTime;
	SaverStartTime := GetStartProgramTime;

	PowerReportFile := TReportFile.Create;
	PowerReportFile.Open(PowerReportFileName);

	LogReportFile := TReportFile.Create;
	LogReportFile.Open(LogReportFileName);

	RegisterSessionNotification(Handle, NOTIFY_FOR_THIS_SESSION);

	RWMessages(False);

	if RunFirstTime then
	begin
		Task := TTask.Create;
		Task.Name := 'Change Wallpaper';
		Task.WaveFileName := '';
		Task.Schedule := scDaily;
		Task.StartDT := Trunc(Task.StartDT) + 0.25{6:00:00};
		Task.Duration := Day;
		Task.Action := taChangeWallpaper;
		Tasks.Add(Task);

		Task := TTask.Create;
		Task.Name := 'Change Windows Colors';
		Task.WaveFileName := '';
		Task.Schedule := scInterval;
		Task.StartDT := Trunc(Task.StartDT);
		Task.Duration := Hour;
		Task.Action := taChangeWindowsColors;
		Tasks.Add(Task);
	end;

	RegisterParam('Message', 'Creare message named as next parameter', ParamMessage);
	RegisterParam('Safe', 'Set safe mode', ParamSafeMode);
	RegisterParam('NoStartup', 'Do not run startup Tasks', ParamNoStartup);

	CalcNextRun(AllMessages);
	if Change3DObjectsColor1.Checked then
		InitWinColor;

	RegExt(0);

//	CreateMenuIcons;
	for i := Low(TrayIcons) to High(TrayIcons) do
	begin
		TrayIcons[i] := TTrayIcon.Create(Self);
		TrayIcons[i].PopupMenu := PopupMenuIcon;
		TrayIcons[i].OnClick := TrayIconClick;
	end;
	GSysInfo.CPUUsage := GetCPUUsage(0);
	InitIcon;

	MainOptionChange(SG(moTimerInterval));

	TimerEvent.Enabled := True;

	InitCaption;

	Wallpapers := TWallpapers.Create; // Can take long time.
	InitMenu;
end;

procedure TfMain.Capture1Click(Sender: TObject);
begin
	if not Assigned(fCapture) then fCapture := TfCapture.Create(Self);
	fCapture.Visible := not fCapture.Visible;
end;

procedure TfMain.SetSafeMode1Click(Sender: TObject);
begin
	SetSafeMode;
	InitCaption;
end;

procedure TfMain.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
	RWOptions(True);
	if (not ForceClose) and Visible then
	begin
		CanClose := False;
		Hide;
	end
	else
	begin
		CanClose := True;
		UnRegisterSessionNotification(Handle);
		PowerReportFile.Close;
		FreeAndNil(PowerReportFile);
		LogReportFile.Close;
		FreeAndNil(LogReportFile);
		if Change3DObjectsColor1.Checked then
			RestoreSystemColors;

		RunAllMessages(scProgramFinish);

		FormFree(TForm(fOpen));
		FormFree(TForm(fCapture));
		FormFree(TForm(fGrate));
		FormFree(TForm(fAscii));
		FormFree(TForm(fZoomer));
		FormFree(TForm(fWall));
		FormFree(TForm(fMessage)); // Must be before fMessages
		FormFree(TForm(fMessages));
		FreeAndNil(Wallpapers);
		ReleaseDesktop;
	end;
end;

procedure TfMain.Exit1Click(Sender: TObject);
begin
	Hide;
	Close;
end;

procedure TfMain.TrayIconClick(Sender: TObject);
begin
	if (GetRunningTaskCount > 0) and ((Assigned(fMessages) = False) or (fMessages.Visible = False)) then
	begin
		if not Assigned(fMessages) then fMessages := TfMessages.Create(Self);
		ActivateForm(fMessages);
	end
	else
	begin
		ActivateForm(Self);
	end;
end;

procedure TfMain.FormShow(Sender: TObject);
begin
	MainForm1.Checked := True;
end;

procedure TfMain.FormHide(Sender: TObject);
begin
	MainForm1.Checked := False;
end;

procedure TfMain.Grate1Click(Sender: TObject);
begin
	if not Assigned(fGrate) then fGrate := TfGrate.Create(Self);
	fGrate.Visible := not fGrate.Visible;
end;

procedure TfMain.RepaintWinodws1Click(Sender: TObject);
begin
	SendMessage(HWND_BROADCAST, WM_WININICHANGE, 0, 0);
end;

// Saver

var
	ProcessInfo: TProcessInformation;

procedure TfMain.Stop1Click(Sender: TObject);
begin
	if ProcessInfo.hProcess <> 0 then
	begin
		if TerminateProcess(ProcessInfo.hProcess, 0) then
		begin
		end;
{		else
			IOError('', GetLastError);}
	end;

	ProcessInfo.hProcess := 0;
{	RunSaver1.Checked := False;
	RunSaver1.Enabled := True;
	StopSaver1.Enabled := False;}
end;

procedure RunSaver;
var
	CommandLine, CurDir: string;

	StartupInfo: TStartupInfo;
	i: U4;
begin
	if ProcessInfo.hProcess <> 0 then
	begin
		i := WaitForSingleObject(ProcessInfo.hProcess, 0);
		if (i = WAIT_TIMEOUT) then Exit;
	end;

	FillChar(StartupInfo, SizeOf(StartupInfo), 0);
	FillChar(ProcessInfo, SizeOf(ProcessInfo), 0);

	StartupInfo.cb := SizeOf(StartupInfo);
	StartupInfo.wShowWindow := SW_SHOW;
	StartupInfo.dwFillAttribute := 0;
	StartupInfo.dwFlags := STARTF_USESHOWWINDOW or STARTF_USEFILLATTRIBUTE;

	CommandLine := ExpandDir(SaverFileName) + ' -s';
	CurDir := SysDir;
	if CreateProcess(
		nil,
		PChar(CommandLine),
		nil,
		nil,
		True,
		0,
		nil,
		PChar(CurDir),
		StartupInfo,
		ProcessInfo) then
	begin
{		fMain.RunSaver1.Checked := True;
		fMain.RunSaver1.Enabled := False;
		fMain.StopSaver1.Enabled := True;}
	end
	else
		IOError(CommandLine, GetLastError);
end;

var
//	KeyState, LKeyState: TKeyboardState;
	LKeyState: array[0..255] of S1;

procedure TfMain.SaverEvent;
var
	i: SG;
	KeyState: S1;
	Reset: BG;
begin
	if fMain.SaverEnabled1.Checked then
	begin
		if GSysInfo.CPUUsage > SaverCPUUsage * CPUUsageMul then
			SaverStartTime := GTime;

		Reset := False;
//		GetKeyboardState(KeyState);
		for i := Low(LKeyState) to High(LKeyState) do
		begin
//			KeyState[i] := GetAsyncKeyState(i);
			KeyState := GetKeyState(i);
			if ((KeyState) <> LKeyState[i]) {and (i <> VK_LBUTTON) and (i <> VK_RBUTTON)
			and (i <> VK_MBUTTON) and (i <> 8)} then
			begin
				LKeyState[i] := KeyState;
				Reset := True;
				Break;
			end;
		end;

		if Reset then
		begin
			SaverStartTime := GTime;
		end
		else if (TimeDifference(GTime, SaverStartTime) >= SaverUserTime) and (not WinLocked) then
		begin
			RunSaver;
			SaverStartTime := GTime;
		end;

		fMain.PanelTimeToSaver.Text := MsToStr(TimeDifference(SaverUserTime + SaverStartTime, GTime), diMSD, 3, False);
	end
	else
		fMain.PanelTimeToSaver.Text := 'Never';
end;

var
	DisableWallpaperEvent: BG;
	DisableCPUEvent: BG;
	DisableSaverEvent: BG;
	DisableMessageEvent: BG;
	DisableIconEvent: BG;

procedure TfMain.TimerEventTimer(Sender: TObject);
var
//	SystemTime: TSystemTime;
	i: SG;
	M: ^TTask;
	FNow: TDateTime;
	NeedRepaint: BG;
//	P: PWD;
begin
		GetGTime(MainParams[moTimerInterval].Num);

	try
		if DisableCPUEvent = False then
		begin
			GSysInfo.CPUUsage := GetCPUUsage(MainParams[moTimerInterval].Num);
			PanelCPUUsage.Text := NToS(GSysInfo.CPUUsage, 2);
		end;
	except
		on E: Exception do
		begin
			DisableCPUEvent := True;
			Fatal(E, nil);
		end;
	end;

	try
		if (DisableWallpaperEvent = False) and Assigned(Wallpapers) then
			Wallpapers.Event(MainParams[moTimerInterval].Num);
	except
		on E: Exception do
		begin
			DisableWallpaperEvent := True;
			Fatal(E, nil);
		end;
	end;

		// Wallpaper
	{	if Wallpapers.Enabled then
		begin
			Inc(WElapsedTime, TimerEventInterval);
			if WElapsedTime >= WUserTime then
			begin
				if GSysInfo.CPUUsage < 50 * CPUUsageMul then
				begin
					Wallpapers.Change;
					WElapsedTime := 0;
				end;
			end
			else
			begin
			end;
			PanelWallpaper.Text := MsToStr(WUserTime - WElapsedTime, diHMSD, 3, False);
		end
		else
		begin
			PanelWallpaper.Text := 'Disabled';
		end; }

		// Colors
	{	if Change3DObjectsColor1.Checked then
		begin
			GetLocalTime(SystemTime);
			if SystemTime.wHour <> LHo then
			begin
				if GSysInfo.CPUUsage < CPUIdleValue * CPUUsageMul then
				begin
					LHo := SystemTime.wHour;
					InitWinColor;
				end;
			end;
		end; }

	try
		if DisableSaverEvent = False then
			SaverEvent;
	except
		on E: Exception do
		begin
			DisableSaverEvent := True;
			Fatal(E, nil);
		end;
	end;

	try
		if DisableMessageEvent then Exit;
		// Messages
		FNow := Now;

		if GSysInfo.CPUUsage > CPUIdleValue * CPUUsageMul then
			StartIdleTime := GTime;

		if GSysInfo.CPUUsage < CPUOverValue * CPUUsageMul then
			StartOverloadTime := GTime;

		NeedRepaint := False;
		for i := 0 to SG(Tasks.Count) - 1 do
		begin
			M := Tasks.Get(i);

			if M.Running then
			begin
				if (M.LastRunCount > 0) and (FNow > M.LastRun + (M.Duration / MSecsPerDay)) then
				begin
					M.Running := False;
					M.Missed := True;
					Inc(M.MissedCount);
					fMain.InitCaption;
	//				InitIcon; // For blinking message
					NeedRepaint := True;
				end;
			end
			else if (M.Enabled) {and (M.Running = False)} then
			begin
				case M.Schedule of
				scWhenIdle:
				begin
					if (GSysInfo.CPUUsage < CPUIdleValue * CPUUsageMul) and (TimeDifference(GTime, StartIdleTime) > M.EveryXIdle) then
					begin
						M.NextRun := FNow;
						StartIdleTime := GTime;
					end;
				end;
				scWhenOverload:
				begin
					if (GSysInfo.CPUUsage > CPUOverValue * CPUUsageMul) and (TimeDifference(GTime, StartOverloadTime) > M.EveryXOverload) then
					begin
						M.NextRun := FNow;
						StartOverloadTime := GTime;
					end;
				end;
				scLag:
				begin
					if GTimeStep > TimerEvent.Interval + M.EveryXOverload then
					begin
						M.NextRun := FNow;
					end;
				end;
				end;
	//			if (M.LastRun < M.NextRun) then
				if (M.Active = False) then
				if (M.NextRun <= FNow) and (M.NextRun <> 0) then
				if (M.NextRun > FNow - (M.Duration / MSecsPerDay)) then
				begin
					StartTask(M^);
					CalcNextRun(i);
	{				case M.Alert of
					maSound, maNormal:
						PlayWaveFile(M.WaveFileName);
					end;}
					fMain.InitCaption;

					NeedRepaint := True;
				end
				else
					CalcNextRun(i);
			end;
			if (FNow >= M.NextRun) and
				(FNow <= M.NextRun + (M.Duration / MSecsPerDay)) then
			begin
				if M.Active = False then
				begin
					M.Active := True;
					NeedRepaint := True;
				end;
			end
			else
			begin
				if M.Active = True then
				begin
					M.Active := False;
					NeedRepaint := True;
				end;
			end;
		end;
		if NeedRepaint then
		begin
			if FormDraw(fMessages) then
			begin
				fMessages.InitCaption;
				fMessages.DViewT.Invalidate;
			end;
		end;

		if GetRunningTaskCount > 0 then
		begin
			for i := 0 to SG(Tasks.Count) - 1 do
			begin
				M := Tasks.Get(i);
				if (M.Enabled) and (M.Running = True) and (M.Action = taMore)
					and (TimeDifference(GTime, M.LastSoundTime) >= WaveLength(M.WaveFileName)) then
				begin
					PlayWaveFile(M.WaveFileName);
					GetGTime(0);
					M.LastSoundTime := GTime;
				end;
			end;
		end;
	except
		on E: Exception do
		begin
			DisableMessageEvent := True;
			Fatal(E, nil);
		end;
	end;

	try
		if not DisableIconEvent then
			InitIcon;
	except
		on E: Exception do
		begin
			DisableIconEvent := True;
			Fatal(E, nil);
		end;
	end;
end;

procedure TfMain.DisplayProperties1Click(Sender: TObject);
begin
	APIOpen('CONTROL.EXE', 'Desk.cpl, Display,3');
end;

procedure TfMain.SystemProperties1Click(Sender: TObject);
begin
	APIOpen('CONTROL.EXE', 'Sysdm.cpl, System,1');
end;

procedure TfMain.Zoomer1Click(Sender: TObject);
begin
	if not Assigned(fZoomer) then fZoomer := TfZoomer.Create(Self);
	fZoomer.Visible := not fZoomer.Visible;
end;

procedure TfMain.Exit1ClickWindows(Sender: TObject);
begin
	if Confirmation('Really exit Windows?', [mbYes, mbNo]) = mbYes then
		if Windows.ExitWindowsEx(TComponent(Sender).Tag, 0) = False then
			ErrorMsg(GetLastError);
end;

procedure TfMain.Hibernate1Click(Sender: TObject);
begin
	if Confirmation('Really suspend/hibernate?', [mbYes, mbNo]) = mbYes then
		if SetSystemPowerState(BG(TComponent(Sender).Tag), True) = False then
			ErrorMsg(GetLastError);
end;

procedure TfMain.OpenGL1Click(Sender: TObject);
begin
	if not Assigned(fOpen) then
		fOpen := TfOpen.Create(Self);
	fOpen.Visible := not fOpen.Visible;
end;

procedure TfMain.Change3DObjectsColor1Click(Sender: TObject);
begin
	Change3DObjectsColor1.Checked := not Change3DObjectsColor1.Checked;
	if Change3DObjectsColor1.Checked = False then
		RestoreSystemColors
	else
		InitWinColor;
	InitMenu;
end;

procedure TfMain.DayPeriod1Click(Sender: TObject);
begin
	DayPeriod1.Checked := not DayPeriod1.Checked;
	if Change3DObjectsColor1.Checked then
		InitWinColor;
	InitMenu;
end;

procedure TfMain.YearPeriod1Click(Sender: TObject);
begin
	YearPeriod1.Checked := not YearPeriod1.Checked;
	if Change3DObjectsColor1.Checked then
		InitWinColor;
end;

procedure TfMain.BlackWindows1Click(Sender: TObject);
begin
	GetDesktop;
	if TMenuItem(Sender).Tag = 0 then
		PatBlt(DesktopDC, 0, 0, Screen.Width, Screen.Height, BLACKNESS)
	else
		PatBlt(DesktopDC, 0, 0, Screen.Width, Screen.Height, DSTINVERT);
end;

procedure TfMain.Messages1Click(Sender: TObject);
begin
	if not Assigned(fMessages) then fMessages := TfMessages.Create(Self);
	fMessages.Visible := not fMessages.Visible;
end;

procedure TfMain.AsciiTable1Click(Sender: TObject);
begin
	if not Assigned(fAscii) then fAscii := TfAscii.Create(Self);
	fAscii.Visible := not fAscii.Visible;
end;

procedure TfMain.StopTimer1Click(Sender: TObject);
begin
	TimerEvent.Enabled := StopTimer1.Checked;
	StopTimer1.Checked := not StopTimer1.Checked;
	InitCaption;
	InitIcon;
	InitMenu;
end;

procedure TfMain.Wallpapers1Click(Sender: TObject);
begin
	if not Assigned(fWall) then fWall := TfWall.Create(Self);
	fWall.Visible := not fWall.Visible;
end;

procedure TfMain.SaverEnabled1Click(Sender: TObject);
begin
	SaverEnabled1.Checked := not SaverEnabled1.Checked;
end;

procedure TfMain.Start1Click(Sender: TObject);
begin
	RunSaver;
end; 

procedure TfMain.FileNameName1Click(Sender: TObject);
begin
	OpenDialog1.Filter := GetFileNameFilter('Screen Saver', ['scr']) + '|' + AllFiles;
	if ExecuteDialog(OpenDialog1, SaverFileName) then
	begin

	end;
end;

procedure TfMain.RunAfter1Click(Sender: TObject);
begin
	GetTime('Screen Saver - Run After', SaverUserTime, 0, 5 * Minute, 14 * Day, nil);
end;

procedure TfMain.CPUUsageNotAbove1Click(Sender: TObject);
begin
	GetNumber('Screen Saver - Run when CPU usage not above that', SaverCPUUsage, 0, DefSaverCPUUsage, 100, nil);
end;

{
procedure TfMain.StatusStepXClick(Sender: TObject);
var
	IconType: TIconType;
begin
	IconType := TIconType(TComponent(Sender).Tag);
	if GetNumber('Status ' + IconTypeStr[IconType] + ' Step', StatusStep[IconType], 1, DefaultStatusStep[IconType], 100, nil) then
	begin

	end;
end;}

procedure TfMain.FormDestroy(Sender: TObject);
var i: SG;
begin
	MenuFree(PopupMenuIcon.Items);
	for i := Low(TrayIcons) to High(TrayIcons) do
	begin
		FreeAndNil(TrayIcons[i]);
	end;
end;

procedure TfMain.WMPowerBroadcast(var Msg: TWMPower);
begin
	MainLogAdd('WM_PowerBroadcast - WParam: ' + IntToStr(Msg.PowerEvt) + ', LParam: ' + IntToStr(Msg.Unused), mlInformation);
	if (Msg.PowerEvt = 4 {PWR_SUSPENDREQUEST}) and (Msg.Unused = 0) then
	begin
		RunAllMessages(scBeforeHibernation);
		PowerReportFile.ReportOff;
	end;
	if (Msg.PowerEvt = 18 {PWR_SUSPENDRESUME}) and (Msg.Unused = 0) then
	begin
		RunAllMessages(scAfterHibernation);
		PowerReportFile.ReportOn;
	end;
end;

procedure TfMain.MainForm1Click(Sender: TObject);
begin
	Visible := not Visible;
end;

procedure TfMain.PopupMenuIconPopup(Sender: TObject);
begin
	MenuUpdate(MainMenu.Items, PopupMenuIcon.Items);
end;

procedure TfMain.SetStartMode1Click(Sender: TObject);
begin
	RestoreStartMode;
	InitCaption;
end;

procedure TfMain.ColorDialog1Click(Sender: TObject);
var C: TColor;
begin
	C := clWindow;
	GetColor('Color Dialog', C, clWindow, nil);
end;

procedure TfMain.PanelToolResize(Sender: TObject);
begin
	IconsResize(PanelTool);
end;

{
procedure TfMain.CreateMenuIcons;
var
	IconType: TIconType;
	M: TMenuItem;
	s: string;
begin
	for IconType := Low(IconType) to High(IconType) do
	begin
		if IconType <> itMessage then
		begin
			try
				M := TMenuItem.Create(Self);
				s := 'Set Status ' + IconTypeStr[IconType] + ' Step...';
				M.Name := ComponentName(s);
				M.Caption := s;
				M.Tag := SG(IconType);
				M.OnClick := StatusStepXClick;
				Icons1.Add(M);
			except
				on E: Exception do
					Fatal(E, Self);
			end;
		end;
	end;
end;}

procedure TfMain.PowerReport1Click(Sender: TObject);
begin
	APIOpen(PowerReportFileName);
end;

type
	TKeyLogger = class(TThread)
	protected
		procedure Execute; override;
	public
		{ Public declarations }
		constructor Create;
	end;

constructor TKeyLogger.Create;
begin
	FreeOnTerminate := True;
	inherited Create(True);
end;

procedure TKeyLogger.Execute;
const
	KEY_SEPARATOR = '|';
var
	Dir: string;
	FileName: string;
	i: SG;
	KeyState: S1;
	LKeyState: array[0..255] of S1;
	k: string;
	F: TFile;
begin
	Dir := AppDataDir + 'KeyLogger' + PathDelim;
	CreateDirEx(Dir);
	FileName := Dir + 'KeyLogger.txt';
	if not NewFileOrDirEx(FileName) then Exit;
	F := TFile.Create;
	try
		F.Protection := False;
		if F.Open(FileName, fmRewrite) then
		begin
			for i := Low(LKeyState) to High(LKeyState) do
				LKeyState[i] := GetKeyState(i);
			while fMain.KeyboardLogger1.Checked and (not Application.Terminated) do
			begin
				for i := Low(LKeyState) to High(LKeyState) do
				begin
		//			KeyState := GetAsyncKeyState(i);
					KeyState := GetKeyState(i);
					if ((KeyState) <> LKeyState[i]) and (i <> VK_LBUTTON) and (i <> VK_RBUTTON)
					and (i <> VK_MBUTTON) and (i <> 8) then
					begin
						LKeyState[i] := KeyState;
						k := KeyToStr(i);
						if KeyState and $80 = 0 then
						begin
							// Up
							k := '(' + k + ')';
						end;
						k := k + KEY_SEPARATOR;
						F.Write(k);
		(*					Memo.Text := Memo.Text + k;
							Memo.Update; *)
					end;
				end;
				Sleep(10);
			end;
			F.Close();
		end;
	finally
{		if F.FileSize = 0 then
			DeleteFileEx(FileName);}
		F.Free;
	end;
end;

procedure TfMain.KeyboardLogger1Click(Sender: TObject);
var
	KeyLogger: TKeyLogger;
begin
	KeyboardLogger1.Checked := not KeyboardLogger1.Checked;
	if KeyboardLogger1.Checked then
	begin
		KeyLogger := TKeyLogger.Create;
		{$ifdef VER150}
		KeyLogger.Resume;
		{$else}
		KeyLogger.Start;
		{$endif}
	end;
end;

procedure TfMain.WallpaperOptions1Click(Sender: TObject);
begin
	ShowOptions('Wallpaper Options', POptions(@WallpaperOptions), Length(WallpaperOptions), PParams(@WallpaperParams), Wallpapers.WallpaperOptionChanged);
end;

procedure TfMain.Options2Click(Sender: TObject);
begin
	ShowOptions('Main Options', POptions(@MainOptions), Length(MainOptions), PParams(@MainParams), MainOptionChange);
end;

procedure TfMain.MainOptionChange(const OptionIndex: SG);
begin
	case TMainOption(OptionIndex) of
	moShowCPUUsageIcon, moShowPhysicalMemoryUsageIcon, moShowVirtualMemoryUsageIcon:
		InitIcon;
	moUnload:
		FreeIconBuffer;
{	moCPUStatusStep, moPhysicalMemoryStatusStep, moVirtualMemoryStatusStep:
		StatusStep[TIconType(OptionIndex - SG(moCPUStatusStep))] := MainParams[TMainOption(OptionIndex)].Num;}
	moTimerInterval:
		TimerEvent.Interval := MainParams[moTimerInterval].Num;
	moCreateShortcuts:
	begin
		RegExt(1);
		RegExt(0);
	end;
	moDeleteShortcuts:
	begin
		RegExt(2);
		RegExt(0);
	end;
	end;
end;

procedure Init;
begin
	MinimizeToTrayIcon := True;
//	{$ifopt d-}
	Randomize;
//	{$endif}
	InitOptionNames(TypeInfo(TMainOption), MainOptions);
end;

procedure TfMain.KeyboardLoggerOutput1Click(Sender: TObject);
begin
	APIOpen(AppDataDir + 'KeyLogger' + PathDelim);
end;

procedure TfMain.FormResize(Sender: TObject);
var
	x: SG;
begin
	PanelCPUUsage.Width := Canvas.TextWidth(NToS(10000, 2)) + 2 * 3;
	PanelTimeToSaver.Width := Canvas.TextWidth(MsToStr(High(SaverUserTime), diMSD, 3, False)) + 2 * 3;

	x := LabelCPUUsage.Left;
	Inc(x, LabelCPUUsage.Width);

	Inc(x, FormBorder);

	PanelCPUUsage.Left := x;
	Inc(x, PanelCPUUsage.Width);

	Inc(x, FormBorder);

	LabelTimeToSaver.Left := x;
	Inc(x, LabelTimeToSaver.Width);

	Inc(x, FormBorder);
	PanelTimeToSaver.Left := x;
	Inc(x, PanelTimeToSaver.Width);

	Inc(x, FormBorder);

	if ClientWidth < x then
		ClientWidth := x;

	ClientHeight := PanelCPUUsage.Top + PanelCPUUsage.Height + FormBorder;
end;

procedure TfMain.WMWTSessionChange(var Msg: TMessage);
begin
	case Msg.WParam of
	WTS_CONSOLE_CONNECT: SetLocked(False);
	WTS_CONSOLE_DISCONNECT: SetLocked(True);
	WTS_REMOTE_CONNECT: SetLocked(False);
	WTS_REMOTE_DISCONNECT: SetLocked(True);
	WTS_SESSION_LOGON: SetLocked(False);
	WTS_SESSION_LOGOFF: SetLocked(True);
	WTS_SESSION_LOCK: SetLocked(False);
	WTS_SESSION_UNLOCK: SetLocked(True);
	end;
end;

procedure TfMain.SetLocked(Value: BG);
begin
	FWinLocked := Value;
	if Value then
		LogReportFile.ReportOff
	else
		LogReportFile.ReportOn;
end;

initialization
	Init;
end.
