// * File:     ElectrostaticField\uMain.pas
// * Created:  2001-03-01
// * Modified: 2010-01-10
// * Version:  1.0.47.23
// * Author:   David Safranek (Safrad)
// * E-Mail:   safrad at email.cz
// * Web:      http://safrad.own.cz

unit uMain;

interface

uses
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
	StdCtrls, uDButton, ExtCtrls, uDImage, uDLabel, Menus, uDForm,
	uDWinControl;

type
	TfMain = class(TDForm)
		PanelM: TPanel;
		ScrollImageM: TDImage;
		PanelInput: TPanel;
		LabelAlpha: TDLabel;
		LabelA: TDLabel;
		LabelB: TDLabel;
		LabelZoom: TDLabel;
		LabelEpsilon: TDLabel;
		LabelTau: TDLabel;
		LabelWire: TDLabel;
		ComboBoxAlpha: TComboBox;
		ComboBoxZoom: TComboBox;
		ComboBoxXA: TComboBox;
		ComboBoxYA: TComboBox;
		ComboBoxXB: TComboBox;
		ComboBoxYB: TComboBox;
		ComboBoxEpsilonR: TComboBox;
		ComboBoxTau: TComboBox;
		ComboBoxWireR: TComboBox;
		MainMenu1: TMainMenu;
		File1: TMenuItem;
		LabelTim: TDLabel;
		ViewLabel: TDLabel;
		ComboBoxView: TComboBox;
		ComboBoxShow: TComboBox;
		Results1: TMenuItem;
		Help1: TMenuItem;
		Options1: TMenuItem;
		procedure ScrollImageMFill(Sender: TObject);
		procedure FormCreate(Sender: TObject);
		procedure FormDestroy(Sender: TObject);
		procedure ComboBoxChange(Sender: TObject);
		procedure ButtonShowFiClick(Sender: TObject);
		procedure Results1Click(Sender: TObject);
		procedure ComboBoxZoomChange(Sender: TObject);
		procedure ScrollImageMZoomChange(Sender: TObject);
	private
		{ Private declarations }
		procedure RWOptions(const Save: Boolean);
		procedure UpdateAll;
		procedure Calc;
	public
		{ Public declarations }
	end;

var
	fMain: TfMain;

type
	TFlo = Extended;
	TPoint = record
		X, Y: TFlo;
	end;
	TLine = record
		A, B, C: TFlo;
	end;

	TQ = record
		P: TPoint;
		Q: TFlo;
	end;
var
	A: array[0..1] of TQ;
	Alpha: TFlo;
	Epsilon: TFlo;
	WireR: TFlo;

	Po: array of TQ;
	PoCount, PoOffset, PoOffset1: Integer;

const
	Epsilon0 = 8.854187818e-12;

function PointDist(A, B: TPoint): TFlo;
function VectSize(Poi: TPoint): TFlo;

function GetFi(Poi: TPoint): TFlo;
function GetE(Poi: TPoint): TPoint;


implementation

{$R *.DFM}
uses
	Math,
	uTypes, uGraph, uDBitmap, uDIniFile, uAbout, uResults, uInputFormat, uFiles, uMath, uMenus, uColor, uDrawStyle;

var
	MinX, MinY, MaxX, MaxY: TFlo;

	
function VectSize(Poi: TPoint): TFlo;
begin
	Result := Hypot(Poi.X, Poi.Y);//Sqrt(Sqr(Poi.X) + Sqr(Poi.Y))

end;

function Mirror(P: TQ; ALine: TFlo): TQ;
var r, a, a2: TFlo;
begin
	r := VectSize(P.P);
	a := ArcTan2(P.P.Y, P.P.X);

	a2 := ALine + (ALine - a);

	Result.P.X := r * cos(a2);
	Result.P.Y := r * sin(a2);
	Result.Q := -P.Q;
end;

function PointDist(A, B: TPoint): TFlo;
begin
	Result := Hypot(A.X - B.X, A.Y - B.Y);//Sqrt(Sqr(A.X - B.X) + Sqr(A.Y - B.Y));
end;

function PointDist2(A, B: TPoint): TFlo;
begin
	Result := Sqr(A.X - B.X) + Sqr(A.Y - B.Y);
end;

procedure Rek(Q: TQ);
var
	i: Integer;
	P1, P2: TQ;
begin
	for i := PoOffset to PoCount - 1 do
		if PointDist(Po[i].P, Q.P) < 0.01 then Exit;

	SetLength(Po, PoCount + 1);
	Po[PoCount] := Q;
//  Po[PoCount].Q := -Po[PoCount].Q;

	Inc(PoCount);

	P1 := Mirror(Q, 0);
	P2 := Mirror(Q, Alpha);
	Rek(P1);
	Rek(P2);
end;

function GetFi(Poi: TPoint): TFlo;
var
	i: Integer;
	aa: TFlo;
begin
	Result := 0;
	for i := 0 to PoCount - 1 do
	begin
		aa := PointDist(Poi, Po[i].P);
		if aa < WireR then aa := WireR;
		Result := Result + 1 / (2 * pi * Epsilon) * (-Po[i].Q * ln(aa))
	end;
end;

function GetEGrad(Poi: TPoint): TFlo;
const
	Len = 0.0001; // 0.001 def is r /100
	Steps = 1024; // 32..1024 (8192 = 1s on Duron 700
var
	BestFi, Fi: TFlo;
	i: Integer;
	Poi2: TPoint;
begin
	BestFi := -MaxExtended;
	for i := 0 to Steps - 1 do
	begin
		Poi2.X := Poi.X + Len * cos(i / Steps * 2 * pi);
		Poi2.Y := Poi.Y + Len * sin(i / Steps * 2 * pi);
		fi := GetFi(Poi2);
		if fi > BestFi then
			BestFi := fi;
	end;
	Fi := (BestFi - GetFi(Poi));
	Result := -Fi / Len;
end;

function GetE(Poi: TPoint): TPoint;
var
	FX, FY, Len: TFlo;
	i: Integer;
begin
	FX := 0;
	FY := 0;
	for i := 0 to PoCount - 1 do
	begin
		Len := PointDist(Po[i].P, Poi);
		if Len >= WireR then
		begin
			FX := FX +
				(Po[i].Q) / (2 * pi * Epsilon * Len * Len) *
				(Po[i].P.X - Poi.X);
			FY := FY +
				(Po[i].Q) / (2 * pi * Epsilon * Len * Len) *
				(Po[i].P.Y - Poi.Y);
		end;
	end;
	Result.X := -FX;
	Result.Y := -FY;
end;

procedure TfMain.Calc;
var
	i: Integer;
begin
	PoCount := 0;
	SetLength(Po, 0);

	PoOffset := 0;
	PoOffset1 := 0;
	for i := 0 to 1 do
	begin
		Rek(A[i]);
		PoOffset := PoCount;
		if i = 0 then PoOffset1 := PoOffset;
	end;

	MinX := MaxInt;
	MinY := MaxInt;
	MaxX := MinInt;
	MaxY := MinInt;
	for i := 0 to PoCount - 1 do
	begin
		if Po[i].P.X < MinX then
			MinX := Po[i].P.X;
		if Po[i].P.Y < MinY then
			MinY := Po[i].P.Y;
		if Po[i].P.X > MaxX then
			MaxX := Po[i].P.X;
		if Po[i].P.Y > MaxY then
			MaxY := Po[i].P.Y;

	end;

	MinX := MinX - (MaxX - MinX) / 8;
	MinY := MinY - (MaxY - MinY) / 8;
	MaxX := MaxX + (MaxX - MinX) / 8;
	MaxY := MaxY + (MaxY - MinY) / 8;

	if Assigned(fResults) then
	if fResults.Visible then
	begin
		fResults.FillEdits;
	end;
end;

var
	Zoom: TFlo;

function PosToPixX(Pos: TFlo): TFlo;
begin
	Result := Round((Pos - MinX) * Zoom) - fMain.ScrollImageM.OfsX;
end;

function PosToPixY(Pos: TFlo): TFlo;
begin
	Result := Round((-Pos - MinY) * Zoom) - fMain.ScrollImageM.OfsY;
end;

procedure TfMain.ScrollImageMFill(Sender: TObject);
var
	Bmp: TDBitmap;
	x, y, SX, SY: Integer;
	X1, Y1, X2, Y2: TFlo;
	i: Integer;
	e: Int64;
	C: TColor;
	C2: TRGBA;
	Poi: TPoint;
	Tim: U8;
	ZoomS: Integer;
	f: TFlo;
begin
	Tim := PerformanceCounter;
	Bmp := ScrollImageM.Bitmap;
//	ScrollImageM.UserArea := Rect(0, 0, Round(Zoom * (MaxX - MinX)), Round(Zoom * (MaxY - MinY)));
	ScrollImageM.UserArea := Rect(Round(MinX), Round(MinY), Round(MaxX), Round(MaxY));
	Zoom := ScrollImageM.Zoom;

	if ComboBoxView.ItemIndex = 0 then
		Bmp.Bar(clBlack, ef16)
	else
	begin
		C2.L := 0;
		ZoomS := 4;
		for y := 0 to MaxDiv(Bmp.Height, 1 shl ZoomS) - 1 do
			for x := 0 to MaxDiv(Bmp.Width, 1 shl ZoomS) - 1 do
			begin
				Poi.X := (x shl ZoomS + (1 shl ZoomS) div 2 + ScrollImageM.OfsX) / Zoom + MinX;
				Poi.Y := -((y shl ZoomS + (1 shl ZoomS) div 2 + ScrollImageM.OfsY) / Zoom + MinY);

				if ComboBoxView.ItemIndex = 1 then
				begin
					f := GetFi(Poi) / 2000;
//          if f > MaxInt then f := MaxInt;
					e := Round(f)
				end
				else // 2
					e := Round((VectSize(GetE(Poi))) / 2000);

				case ComboBoxShow.ItemIndex of
				0:
				begin
					Inc(e, MaxSpectrum);
					e := e div 2;
					if e <= 0 then
						e := 0
					else if e > MaxSpectrum then e := MaxSpectrum;
					C2.L := SpectrumColor(e);
				end;
				1:
				begin
					e := Abs(e);
					if e > MaxSpectrum then e := MaxSpectrum;
					C2.L := SpectrumColor(e);
				end;
				2:
				begin
					Inc(e, 128);
					if e <= 0 then
						e := 0
					else if e > 255 then e := 255;
					C2.R := e;
					C2.G := e;
					C2.B := e;
				end;
				3:
				begin
					if e <= 0 then e := -e;
					if e > 255 then e := 255;
					C2.R := e;
					C2.G := e;
					C2.B := e;
				end;
				4:
				begin
					Inc(e, (MaxFireColor + 1) div 2);
					if e <= 0 then
						e := 0
					else if e > MaxFireColor then e := MaxFireColor;
					C2.L := FireColor(e);
				end;
				5:
				begin
					if e <= 0 then e := -e;
					if e > MaxSpectrum then e := MaxFireColor;
					C2.L := FireColor(e);
				end;
				6:
				begin
					if e <= -255 then
						e := -255
					else if e > 255 then e := 255;
					C2.L := 0;
					if e < 0 then
						C2.B := -e
					else
						C2.R := e;
				end;
				end;

				if ZoomS = 1 then
					Pix(Bmp.Data, Bmp.ByteX, X, Y, @C2, ef16)
				else
				begin
					SX := X shl ZoomS;
					SY := Y shl ZoomS;
					Bmp.Bar(SX, SY, SX + 1 shl ZoomS - 1, SY + 1 shl ZoomS - 1, C2.L, ef16)
				end;
			end;
	end;

	X1 := -32767;
	Y1 := PosToPixY(0);
	X2 := 32767;
	Y2 := PosToPixY(0);
	Bmp.Line(X1, Y1, X2, Y2, clGray, ef16);

	X1 := PosToPixX(0);
	Y1 := -32767;
	X2 := PosToPixX(0);
	Y2 := 32767;
	Bmp.Line(X1, Y1, X2, Y2, clGray, ef16);

	X1 := PosToPixX(0);
	Y1 := PosToPixY(0);
	X2 := 32767;
	Y2 := PosToPixY(0);
	Bmp.Line(X1, Y1, X2, Y2, clWhite, ef16);

	X1 := PosToPixX(0);
	Y1 := PosToPixY(0);
	X2 := PosToPixX(1000 * Cos(Alpha));
	Y2 := PosToPixY(1000 * Sin(Alpha));
	Bmp.Line(X1, Y1, X2, Y2, clGray, ef16);

	for i := 0 to PoCount - 1 do
	begin
		X1 := PosToPixX(Po[i].P.X - WireR);
		Y1 := PosToPixY(Po[i].P.Y + WireR);
		X2 := PosToPixX(Po[i].P.X + WireR);
		Y2 := PosToPixY(Po[i].P.Y - WireR);

{   if (X >= 0) and (Y >= 0)
		and (X < Integer(Bmp.Width)) and (Y < Integer(Bmp.Height)) then
			Pix(Bmp.PData, Bmp.ByteX, X, Y, C, ef16);}
		begin
			if Po[i].Q > 0 then
				C := $007f7fff
			else
				C := $00ff7f7f;
			Bmp.Bar(X1 - 1, Y1 - 1, X2 + 1, Y2 + 1, C, ef16);
{			Bmp.Canvas.Pen.Color := C;
			Bmp.Canvas.Brush.Style := bsClear;
			Bmp.Canvas.Ellipse(X1 - 1, Y1 - 1, X2 + 1, Y2 + 1);}
		end;

	end;
	Tim := PerformanceCounter - Tim;

	LabelTim.Caption := IntToStr(RoundDivS8(1000 * Tim, PerformanceFrequency)) + 'ms';
end;

procedure TfMain.ScrollImageMZoomChange(Sender: TObject);
begin
	ComboBoxZoom.Text := FloatToStr(ScrollImageM.Zoom);
end;

procedure TfMain.RWOptions(const Save: Boolean);
const
	Section = 'Options';
begin
	MainIni.RWFormPos(Self, Save);

	ScrollImageM.Serialize(MainIni, Save);

	ComboBoxEpsilonR.Text := MainIni.RWStringF(Section, 'EpsilonR', ComboBoxEpsilonR.Text, ComboBoxEpsilonR.Text, Save);
	ComboBoxAlpha.Text := MainIni.RWStringF(Section, 'Alpha', ComboBoxAlpha.Text, ComboBoxAlpha.Text, Save);
	ComboBoxWireR.Text := MainIni.RWStringF(Section, 'WireR', ComboBoxWireR.Text, ComboBoxWireR.Text, Save);
	ComboBoxXA.Text := MainIni.RWStringF(Section, 'XA', ComboBoxXA.Text, ComboBoxXA.Text, Save);
	ComboBoxYA.Text := MainIni.RWStringF(Section, 'YA', ComboBoxYA.Text, ComboBoxYA.Text, Save);
	ComboBoxXB.Text := MainIni.RWStringF(Section, 'XB', ComboBoxXB.Text, ComboBoxXB.Text, Save);
	ComboBoxYB.Text := MainIni.RWStringF(Section, 'YB', ComboBoxYB.Text, ComboBoxYB.Text, Save);
	ComboBoxTau.Text := MainIni.RWStringF(Section, 'Tau', ComboBoxTau.Text, ComboBoxTau.Text, Save);

//	MainIni.RWComboBox(Section, ComboBoxZoom, Save);
	MainIni.RWComboBox(Section, ComboBoxView, Save);
	MainIni.RWComboBox(Section, ComboBoxShow, Save);
	MainIni.RWMenuItem(Section, Results1, Save);
end;

procedure TfMain.FormCreate(Sender: TObject);
begin
	Background := baNone;
	RWOptions(False);
	ScrollImageM.OnZoomChange(Sender);
	ComboBoxChange(Self);
	if Results1.Checked then Results1Click(Sender);
end;

procedure TfMain.FormDestroy(Sender: TObject);
begin
	RWOptions(True);
end;

procedure TfMain.UpdateAll;
begin
	Epsilon := StrToValE(ComboBoxEpsilonR.Text, True, 1, 52.5, 1000) * Epsilon0;
	Alpha := StrToValE(ComboBoxAlpha.Text, True, 1, 30, 180) / 180 * pi;
	WireR := StrToValE(ComboBoxWireR.Text, True, 0.000001, 0.00977, 1000);
	A[0].P.X := StrToValE(ComboBoxXA.Text, True, 0, 12.7577, 1000);
	A[0].P.Y := StrToValE(ComboBoxYA.Text, True, 0, 3.71, 1000);
	A[1].P.X := StrToValE(ComboBoxXB.Text, True, 0, 23.3282, 1000);
	A[1].P.Y := StrToValE(ComboBoxYB.Text, True, 0, 5.2657, 1000);
	A[0].Q := StrToValE(ComboBoxTau.Text, True, 0.000001, 0.0006337798, 1000);
	A[1].Q := -A[0].Q;
end;

procedure TfMain.ComboBoxChange(Sender: TObject);
begin
	UpdateAll;
	Calc;
	ScrollImageM.Invalidate;
end;

procedure TfMain.ComboBoxZoomChange(Sender: TObject);
begin
	ScrollImageM.Zoom := StrToValI(ComboBoxZoom.Text, True, 1, UG(512), 2048, 1);
end;

procedure TfMain.ButtonShowFiClick(Sender: TObject);
begin
	ScrollImageM.Invalidate;
end;

procedure TfMain.Results1Click(Sender: TObject);
begin
	if not Assigned(fResults) then fResults := TfResults.Create(Self);
	fResults.FillEdits;
	if fResults.Visible = False then
		fResults.Show
	else
		fResults.Hide;
end;

end.
