// * File:     ElectrostaticField\uResults.pas
// * Created:  2001-03-01
// * Modified: 2009-12-08
// * Version:  1.0.47.23
// * Author:   David Safranek (Safrad)
// * E-Mail:   safrad at email.cz
// * Web:      http://safrad.own.cz

unit uResults;

interface

uses
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
	StdCtrls, uDLabel, uDForm, uDEdit, uDWinControl;

type
	TfResults = class(TDForm)
		DLabel8: TDLabel;
		DLabel9: TDLabel;
		DLabel10: TDLabel;
		LabelA: TDLabel;
		LabeB: TDLabel;
		LabelAB: TDLabel;
		LabelF: TDLabel;
		LabelSig: TDLabel;
		LabelX0: TDLabel;
		LabelY0: TDLabel;
		LabelAbs0: TDLabel;
		LabelX: TDLabel;
		LabelY: TDLabel;
		LabelAbs: TDLabel;
		EditFiA: TDEdit;
		EditFiB: TDEdit;
		EditCB0: TDEdit;
		EditCA0: TDEdit;
		EditCAB: TDEdit;
		EditEAB: TDEdit;
		EditSigX12: TDEdit;
		EditFA: TDEdit;
		EditFB: TDEdit;
		EditSigX2: TDEdit;
		EditSigX1: TDEdit;
		EditEABX: TDEdit;
		EditEABY: TDEdit;
		EditFiAB: TDEdit;
		EditFAY: TDEdit;
		EditFAX: TDEdit;
		EditFBY: TDEdit;
		EditFBX: TDEdit;
		EditEAX: TDEdit;
		EditEAY: TDEdit;
		EditEA: TDEdit;
		EditEBX: TDEdit;
		EditEBY: TDEdit;
		EditEB: TDEdit;
		LabelX1: TDLabel;
		LabelX12: TDLabel;
		LabelX2: TDLabel;
		procedure FormShow(Sender: TObject);
		procedure FormHide(Sender: TObject);
		procedure FormCreate(Sender: TObject);
	private
		{ Private declarations }
		procedure RWOptions(const Save: Boolean);
	public
		{ Public declarations }
		procedure FillEdits;
	end;

var
	fResults: TfResults;

implementation

{$R *.DFM}
uses
	uDIniFile, uDictionary,
	uMain;

procedure TfResults.FillEdits;
var
	Poi: TPoint;
	i: Integer;
	fia, fib, FA, FB, SigX2, FX, FY, Len: TFlo;
begin
	{ PoCount := 2;
	Po[0] := A[0];
	Po[1] := A[1];
	PoOffset1 := 1;}

{ fia := 0;
	for i := 0 to PoCount - 1 do
	begin
		if i <> 0 then
		begin
			aa := PointDist(Po[0].P, Po[i].P);
		end
		else
			aa := WireR;

		fia := fia + 1 / (2 * pi * Epsilon) * (-Po[i].Q * ln(aa));
	end;}
	fia := GetFi(Po[0].P);
	EditFiA.Text := FloatToStr(fia);

{ fib := 0;
	for i := 0 to PoCount - 1 do
	begin
		if i <> PoOffset1 then
		begin
			aa := PointDist(Po[PoOffset1].P, Po[i].P)
		end
		else
			aa := WireR;
		fib := fib + 1 / (2 * pi * EpsilonR) * (-Po[i].Q * ln(aa))
	end;}
	Poi.X := (A[0].P.X + A[1].P.X) / 2;
	Poi.Y := (A[0].P.Y + A[1].P.Y) / 2;
	EditFiAB.Text := FloatToStr(GetFi(Poi));

	fib := GetFi(Po[PoOffset1].P);
	EditFiB.Text := FloatToStr(fib);

	EditCA0.Text := FloatToStr(A[0].Q / fia);
{ Poi.X := A[0].P.X;
	Poi.Y := A[0].P.Y;
	EditCA0.Text := FloatToStr(A[0].Q / (GetFi(Poi)));}

	EditCAB.Text := FloatToStr(Po[0].Q / (fia - fib));

	EditCB0.Text := FloatToStr(Po[PoOffset1].Q / fib);

	Poi.X := A[0].P.X;
	Poi.Y := A[0].P.Y;
	Poi := GetE(Poi);
	EditEA.Text := FloatToStr(VectSize(Poi));
	EditEAX.Text := FloatToStr(Poi.X);
	EditEAY.Text := FloatToStr(Poi.Y);

	Poi.X := (A[0].P.X + A[1].P.X) / 2;
	Poi.Y := (A[0].P.Y + A[1].P.Y) / 2;
	Poi := GetE(Poi);
	EditEAB.Text := FloatToStr(VectSize(Poi));
	EditEABX.Text := FloatToStr(Poi.X);
	EditEABY.Text := FloatToStr(Poi.Y);

	Poi.X := A[1].P.X;
	Poi.Y := A[1].P.Y;
	Poi := GetE(Poi);
	EditEB.Text := FloatToStr(VectSize(Poi));
	EditEBX.Text := FloatToStr(Poi.X);
	EditEBY.Text := FloatToStr(Poi.Y);

{ Poi.X := A[0].P.X / 2;
	Poi.Y := 0;
	Poi := GetE(Poi);
	EditEB.Text := FloatToStr(VectSize(Poi));
	EditEBX.Text := FloatToStr(Poi.X);
	EditEBY.Text := FloatToStr(Poi.Y);}

	Poi.X := A[0].P.X;
	Poi.Y := 0;
	SigX2 := -(Epsilon * VectSize(GetE(Poi)));
	EditSigX1.Text := FloatToStr(SigX2);

	Poi.X := (A[0].P.X + A[1].P.X) / 2;
	Poi.Y := 0;
	SigX2 := -(Epsilon * VectSize(GetE(Poi)));
	EditSigX12.Text := FloatToStr(SigX2);

	Poi.X := A[1].P.X;
	Poi.Y := 0;
	SigX2 := -(Epsilon * VectSize(GetE(Poi)));
	EditSigX2.Text := FloatToStr(SigX2);

{ Poi.X := Sqrt(A[0].P.X * A[1].P.X);
	Poi.Y := 0;
	SigX2 := -(Epsilon * VectSize(GetE(Poi)));
	EditSigX2.Text := FloatToStr(SigX2);}

//  FA := Abs(A[0].Q * A[0].Q / (2 * pi * Epsilon * PointDist(Po[PoOffset1].P, Po[0].P)));
{ FA := Abs(A[0].Q * GetE(A[0].P));
	EditFA.Text := FloatToStr(FA);

	FB := Abs(A[1].Q * GetE(A[1].P));
	EditFB.Text := FloatToStr(FB);}

	FX := 0;
	FY := 0;
	for i := 0 to PoCount - 1 do
	begin
		if i <> 0 then
		begin
			Len := PointDist(Po[i].P, Po[0].P);
			FX := FX +
				(-Po[0].Q * Po[i].Q) * (Po[i].P.X - Po[0].P.X) / (2 * pi * Epsilon * Len * Len);

			FY := FY +
				(-Po[0].Q * Po[i].Q) * (Po[i].P.Y - Po[0].P.Y) / (2 * pi * Epsilon * Len * Len);
		end;
	end;

	EditFAX.Text := FloatToStr(FX);
	EditFAY.Text := FloatToStr(FY);
	FA := Sqrt(Sqr(FX) + Sqr(FY));
	EditFA.Text := FloatToStr(FA);


	FX := 0;
	FY := 0;
	for i := 0 to PoCount - 1 do
	begin
		if i <> PoOffset1 then
		begin
			Len := PointDist(Po[i].P, Po[PoOffset1].P);
			FX := FX +
				(-Po[PoOffset1].Q * Po[i].Q) / (2 * pi * Epsilon * Len * Len) *
				(Po[i].P.X - Po[PoOffset1].P.X);
			FY := FY +
				(-Po[PoOffset1].Q * Po[i].Q) / (2 * pi * Epsilon * Len * Len) *
				(Po[i].P.Y - Po[PoOffset1].P.Y);
		end;
	end;

	EditFBX.Text := FloatToStr(FX);
	EditFBY.Text := FloatToStr(FY);
	FB := Sqrt(Sqr(FX) + Sqr(FY));
	EditFB.Text := FloatToStr(FB);
end;

procedure TfResults.FormShow(Sender: TObject);
begin
	fMain.Results1.Checked := True;
end;

procedure TfResults.FormHide(Sender: TObject);
begin
	fMain.Results1.Checked := False;
	RWOptions(True);
end;

procedure TfResults.FormCreate(Sender: TObject);
begin
	Background := baGradient;
	Dictionary.TranslateForm(Self);
	RWOptions(False);
end;

procedure TfResults.RWOptions(const Save: Boolean);
begin
	MainIni.RWFormPos(Self, Save);
end;

end.
