// * File:     Echo\uVisual.pas
// * Created:  2001-09-01
// * Modified: 2009-12-07
// * Version:  1.0.47.36
// * Author:   David Safranek (Safrad)
// * E-Mail:   safrad at email.cz
// * Web:      http://safrad.own.cz

unit uVisual;

interface

uses
	uTypes, uDForm,
	Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
	Menus, uDLabel, uDTimer;

type
	TfVisual = class(TDForm)
		PopupMenu1: TPopupMenu;
		Visualization1: TMenuItem;
		Oscilloscope1: TMenuItem;
		SpectrumAnalyser1: TMenuItem;
		Scope1: TMenuItem;
		Dot1: TMenuItem;
		Line1: TMenuItem;
		Solid1: TMenuItem;
		Source1: TMenuItem;
		Input1: TMenuItem;
		Output1: TMenuItem;
		Both1: TMenuItem;
		Off1: TMenuItem;
		DTimer1: TDTimer;
		RefreshRate1: TMenuItem;
		procedure FormCreate(Sender: TObject);
		procedure FormKeyPress(Sender: TObject; var Key: Char);
		procedure Oscilloscope1Click(Sender: TObject);
		procedure FormShow(Sender: TObject);
		procedure FormHide(Sender: TObject);
		procedure DTimer1Timer(Sender: TObject);
		procedure RefreshRate1Click(Sender: TObject);
		procedure Dot1Click(Sender: TObject);
		procedure Input1Click(Sender: TObject);
		procedure FormPaint(Sender: TObject);
	private
		{ Private declarations }
		Zoom: SG;
	public
		{ Public declarations }
		Buffer: PArrayU1;
		BufferSize: SG;
		BufferNew: BG;
		BitsPerSample: SG;
	end;

var
	fVisual: TfVisual;

type
	TVisualization = (viOscilloscope, viSpectrumAnalyser, viOff);
	TScope = (scDot, scLine, scSolid);
	TSource = (soInput, soOutput, soBoth);
var
	Visualization: TVisualization;
	Scope: TScope;
	Source: TSource;
	RefreshRate: SG;

implementation

{$R *.dfm}
uses
	FFTs, Complexs,
	uMain, uMath, uOutputFormat, uColor, uDrawStyle, uDictionary,
	uMenus, uDBitmap, uGraph, uWave, uDIniFile, uGetInt;

procedure TfVisual.FormCreate(Sender: TObject);
begin
	Background := baUser;
	Dictionary.TranslateForm(Self);
	Zoom := 1;
	Visualization1.Items[SG(Visualization)].Checked := True;
	Scope1.Items[SG(Scope)].Checked := True;
	Source1.Items[SG(Source)].Checked := True;

	MainIni.RWFormPos(Self, False);

	MenuSet(PopupMenu1);
	DTimer1.Interval := RefreshRate;
end;

//	Window: array of U2;
//	Data, Dest: array of TComplex;
{type
	TArrayComplex = array[0..32767] of TComplex;}
var
	Data, Dest: array[0..32767] of TComplex;
//	PArrayComplex = ^TArrayComplex;

procedure TfVisual.FormKeyPress(Sender: TObject; var Key: Char);
begin
	case Key of
	'+': Inc(Zoom);
	'-': Dec(Zoom);
	end;
end;

procedure TfVisual.Oscilloscope1Click(Sender: TObject);
begin
	TMenuItem(Sender).Checked := True;
	Visualization := TVisualization(TMenuItem(Sender).Tag);
	Invalidate;
end;

procedure TfVisual.FormShow(Sender: TObject);
begin
	fMain.Visualization1.Checked := True;
	DTimer1.Enabled := not fMain.ButtonStart.Enabled;
end;

procedure TfVisual.FormHide(Sender: TObject);
begin
	fMain.Visualization1.Checked := False;
	MainIni.RWFormPos(Self, True);
	DTimer1.Enabled := False;
end;

procedure TfVisual.DTimer1Timer(Sender: TObject);
begin
	if BufferNew then
	begin
		BufferNew:= False;
		Invalidate;
	end;
end;

procedure TfVisual.RefreshRate1Click(Sender: TObject);
begin
	if GetNumber('Refresh Rate', RefreshRate, 1, 25, 1000, nil) then
		DTimer1.Interval := RefreshRate;
end;

procedure TfVisual.Dot1Click(Sender: TObject);
begin
	TMenuItem(Sender).Checked := True;
	Scope := TScope(TMenuItem(Sender).Tag);
	Invalidate;
end;

procedure TfVisual.Input1Click(Sender: TObject);
begin
	TMenuItem(Sender).Checked := True;
	Source := TSource(TMenuItem(Sender).Tag);
	Invalidate;
end;

procedure TfVisual.FormPaint(Sender: TObject);
var
	x, y, d: SG;
	m: SG;
	BufferSizeM: SG;
	lx, ly: SG;
	i: SG;
//	da: Double; //Int64;

	Value, ValueMid, ValueMin, ValueMax: SG;
	C: TRGBA;
	Bmp: TDBitmap;
begin
	Bmp := Self.BackBitmap;
	Bmp.Bar(clWindow, ef16);
	Bmp.Border(clDepth[1], clDepth[3], 1, ef16);

//	PanelBufS.Caption := NToS(BufferSize);
	if (Buffer = nil) or (BufferSize = 0) {or (fMain.CloseInvoked)} then
	begin
		// No buffer found
		Exit;
	end;

	m := MaxDiv(BitsPerSample, 8);
	BufferSizeM := BufferSize div m;

	ValueMin := MaxInt;
	ValueMax := MinInt;
	ValueMid := 0;
	for i := 0 to BufferSizeM - 1 do
	begin
		d := m * i;
		case BitsPerSample of
		16:
		begin
			Value := S2(Buffer[d] + Buffer[d + 1] shl 8);
		end
		else
		begin
			Value := SG(Buffer[d])
		end;
		end;
		if Value < ValueMin then ValueMin := Value;
		if Value > ValueMax then ValueMax := Value;
		Inc(ValueMid,  Value);
	end;
	ValueMid := RoundDiv(ValueMid, BufferSizeM);
// m := GetBufferSample(BitsPerSample, BufferSize);

	case Visualization of
	viOscilloscope:
	begin
		if Scope <> scSolid then
			Bmp.Line(0, Bmp.Height div 2, Bmp.Width - 1, Bmp.Height div 2, clGrayText, ef08);

		lx := 0;
		ly := 0;
		for x := 0 to Bmp.Width - 1 do
		begin
			d := m * RoundDiv(x * BufferSizeM, Bmp.Width);
			case BitsPerSample of
			16:
			begin
				Value := S2(Buffer[d] + Buffer[d + 1] shl 8);
				y := SG(Bmp.Height div 2) + (SG(Bmp.Height) * Zoom * Value) div 65536;
			end
			else
			begin
				Value := SG(Buffer[d]);
				y := (SG(Bmp.Height) * SG(Zoom) * SG(Value - 128) + 128 * SG(Bmp.Height)) shr 8;
			end;
			end;
			if (y >= 0) and (y < Bmp.Height) then
			case Scope of
			scDot:
			begin
				C.L := clWindowText;
				Pix(Bmp.Data, Bmp.ByteX, x, y, @C, ef16)
			end;
			scLine:
			begin
				if x > 0 then
					Bmp.Line(lx, ly, x, y, clWindowText, ef16);
				lx := x;
				ly := y;
			end;
			scSolid:
			begin
				Bmp.Line(x, Bmp.Height div 2, x, y, clWindowText, ef16);
			end;
			end;
		end;
	end;
	viSpectrumAnalyser:
	begin
{		SetLength(Data, m);
		SetLength(Dest, m);}
		for i := 0 to BufferSizeM - 1 do
		begin
			d := m * i;
			case BitsPerSample of
			16:
			begin
				x := S2(Buffer[d] + Buffer[d + 1] shl 8);
			end
			else
			begin
				x := SG(SG(Buffer[d]) - 128);
			end;
			end;
			// Blackmann
			Data[i].Re := Round(65535 * (0.42 - 0.5 * cos(2 * pi * i / BufferSizeM) + 0.08 * cos(4 * pi * i / BufferSizeM))) * x / 65536;
//			Data[i].Re := x;
			Data[i].Im := Data[i].Re;
		end;

//		FFTs.ForwardFFT(PArrayComplex(@Data[0]), PArrayComplex(@Dest[0]), Length(Data));
		ForwardFFT(PComplexArray(@Data), PComplexArray(@Dest), BufferSizeM);

		i := 0;
		for x := 0 to Bmp.Width div 4 - 1 do
		begin
//			y := Zoom * da div (5000 * SinDiv);
			i := i + 1 + i div 16;
			if i < BufferSizeM then
			begin
				y := Bmp.Height - 1 - Round(Zoom * Abs(Sqrt(Sqr(Dest[i].Re) + Sqr(Dest[i].Im))) * 0.0001{ / BufS(BufferSize, BitsPerSample)});
				if y >= SG(Bmp.Height) then y := Bmp.Height - 1;
				if (y < 0) then y := 0;

				Bmp.Bar(4 * x, y, 4 * x + 3, Bmp.Height - 1, clWindowText, ef16);
			end
			else
				Break;
		end;
	end;
	end;
	Bmp.Canvas.Brush.Style := bsClear;
	Bmp.Canvas.TextOut(2, 2, 'Middle: ' + NToS(ValueMid));
	Bmp.Canvas.TextOut(2, 2 + 18, 'Min: ' + NToS(ValueMin));
	Bmp.Canvas.TextOut(2, 2 + 2 * 18, 'Max: ' + NToS(ValueMax));
end;

end.
