// * File:     DiskSpeedTest\uMain.pas
// * Created:  1998-06-01
// * Modified: 2009-11-16
// * Version:  1.2.47.23
// * Author:   David Safranek (Safrad)
// * E-Mail:   safrad at email.cz
// * Web:      http://safrad.own.cz

unit uMain;

interface

uses
	uTypes, uProcess,
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
	StdCtrls, uDButton, uDLabel, uDGauge, ExtCtrls, uDImage, uDForm, Menus,
	uDEdit, uDWinControl, uDMemo;

type
	TfMain = class(TDForm)
		ButtonRead: TDButton;
		ButtonWrite: TDButton;
		ComboBoxFileName: TComboBox;
		LabelTotalSize: TLabel;
		LabelBufferSize: TLabel;
		ButtonMemWrite: TDButton;
		Gauge: TDGauge;
		ComboBoxFileSize: TComboBox;
		ComboBoxBufferSize: TComboBox;
		ButtonBuffer: TDButton;
		ButtonWriteThrough: TDButton;
		MemoInfo: TDMemo;
		ComboBoxXB: TComboBox;
		LabelLocation: TLabel;
		MainMenu1: TMainMenu;
		File1: TMenuItem;
		Help1: TMenuItem;
		Bevel1: TBevel;
		ButtonDelete: TDButton;
		ButtonAbort: TDButton;
		Options1: TMenuItem;
		ButtonPause: TDButton;
		ButtonRandom: TDButton;
		procedure ButtonReadClick(Sender: TObject);
		procedure FormCreate(Sender: TObject);
		procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
		procedure FormResize(Sender: TObject);
		procedure ButtonDeleteClick(Sender: TObject);
		procedure ButtonAbortClick(Sender: TObject);
		procedure ButtonPauseClick(Sender: TObject);
		procedure FormDestroy(Sender: TObject);
		procedure ButtonBufferClick(Sender: TObject);
	private
		{ Private declarations }
		Process: TProcess;
		procedure InitButtons;
		procedure Init;
		procedure RWOptions(const Save: BG);
		procedure DeleteAllFiles;
	public
		{ Public declarations }
	end;

var
	fMain: TfMain;

implementation

{$R *.DFM}
uses
	Math,
	uDBitmap, uFile, uFiles, uDIniFile, uAbout, uInputFormat, uMath, uStrings, uOutputFormat, uMenus, uSystem, uDictionary,
	uDrawStyle;

var
	ToBeDeleted: TStringList;

procedure TfMain.InitButtons;
var
	Exists: BG;
	Enabled: BG;
begin
	Enabled := not Process.Run;
	Exists := FileExists(ComboBoxFileName.Text);

	ButtonRead.Enabled := Enabled and Exists;
	ButtonWrite.Enabled := Enabled;
	ButtonDelete.Enabled := Enabled and Exists;
	ButtonMemWrite.Enabled := Enabled;
	ButtonAbort.Enabled := not Enabled;
	ButtonPause.Enabled := not Enabled;
end;

procedure TfMain.ButtonReadClick(Sender: TObject);
const
	Sec = 's';
var
	RW: SG;

	F: TFile;
	FName: TFileName;

	FileSiz, i, mi, BS: U8;

	NTime, Tim: U8;

	Buffer: PArrayU1;

	Clu: S4;

	FM: TFileMode;
	Flag: U4;
	RandomMode: BG;
	s: string;
begin
	if Process.NotRun then
	begin
		Init;
		try
			MemoInfo.Clear;
			RW := TDButton(Sender).Tag;
			RandomMode := ButtonRandom.Down;
			Clu := StrToValI(ComboBoxBufferSize.Text, True, 1, UG(32 * KB), GB, 1);
			FileSiz := StrToValS8(ComboBoxFileSize.Text, True, 0, U8(0), High(U8), 1);
			FileSiz := FileSiz * Round(IntPower(1024, ComboBoxXB.ItemIndex));

			i := 0;
			mi := RoundDivS8(FileSiz, Clu);
			FileSiz := Clu * mi;

			s := NToS(FileSiz) + ' B (' + BToStr(FileSiz) + ') ' + ' - ' + NToS(mi) + CharSpace + Translate('block' + Plural(mi));
			if RW = 4 then
			begin
				MemoInfo.Lines.Add(Translate('Memory:') + CharSpace + s);
			end
			else
			begin
				if RW and 1 = 0 then
					MemoInfo.Lines.Add(Translate('Reading:') + CharSpace + s)
				else
					MemoInfo.Lines.Add(Translate('Writing:') + CharSpace + s);
			end;

			GetMem(Buffer, Clu);
			try
				Sleep(LoopSleepTime);

				if RW = 4 then
				begin
					Process.ResetTime;
					i := 0;
					while i < mi do
					begin
						FillChar(Buffer^, Clu, i and $ff);
						Inc(i);
					end;
				end
				else
				begin
					if RW and 1 <> 0 then
					begin
						i := 0;
						while i < Clu do
						begin
							Buffer[i] := i and $ff;
							Inc(i);
						end;
					end;
					F := TFile.Create;
					F.Protection := False;
					F.Charset := fcAnsi;
					FName := ComboBoxFileName.Text;
					if RW and 1 <> 0 then
						ToBeDeleted.Add(FName);
					try
						Gauge.Position := 0;
						Gauge.Max := mi;

						case RW of
						1: FM := fmRewrite;
						else FM := fmReadOnly;
						end;
						Flag := FILE_FLAG_NO_PREFIX or FILE_ATTRIBUTE_TEMPORARY;
						if RandomMode = False then
							Flag := Flag or FILE_FLAG_SEQUENTIAL_SCAN
						else
							Flag := Flag or FILE_FLAG_RANDOM_ACCESS;

						if (RandomMode = False) and (ButtonBuffer.Down = False) then Flag := Flag or FILE_FLAG_NO_BUFFERING;
						if ButtonWriteThrough.Down and (RW <> 0) then Flag := Flag or FILE_FLAG_WRITE_THROUGH;
						Process.ResetTime;
						if F.Open(FName, FM, Flag) then
						begin
							if RandomMode and (RW <> 0) then
							begin
								F.Seek(FileSiz - Clu);
								F.BlockWrite(Buffer^, Clu);
							end;
							i := 0;
							while i < mi do
							begin
								if RandomMode then
								begin
									F.Seek(Random(FileSiz - Clu));
								end;
								if RW and 1 = 0 then
								begin
									if not F.BlockRead(Buffer^, Clu) then Break;
								end
								else
								begin
									if not F.BlockWrite(Buffer^, Clu) then Break;
								end;
								if Process.Interrupt then
								begin
									Gauge.Position := i;
									if Process.Aborted then Break;
								end;
								Inc(i);
							end;
							Gauge.Position := i;
							F.Close;
						end;
					finally
						F.Free;
					end;
				end;

				NTime := Process.GetTime;
			finally
				FreeMem(Buffer);
			end;

			if NTime = 0 then
				BS := Clu * i
			else
			begin
				BS := RoundDivS8(PerformanceFrequency * Int64(Clu) * Int64(i), NTime);
			end;

			i := U8(Clu) * i;
			MemoInfo.Lines.Add(Translate('Success:') + CharSpace + NToS(i) + ' B (' + BToStr(i) + ')');

			Tim := RoundDivS8(1000 * NTime, PerformanceFrequency);
			MemoInfo.Lines.Add(Translate('Time:') + CharSpace + MsToStr(Tim, diSD, 3, False) + CharSpace + Sec);

			if NTime = 0 then
				s := '>' + NToS(BS) + ' B/' + Sec + ' ( >' + BToStr(BS) + '/' + Sec + ')'
			else
				s := NToS(BS) + ' B/' + Sec + ' (' + BToStr(BS) + '/' + Sec + ')';
			MemoInfo.Lines.Add(Translate('Speed:') + CharSpace + s);

		finally
			Process.Done;
			Init;
		end;
	end;
end;

procedure TfMain.ButtonBufferClick(Sender: TObject);
begin
	ButtonWriteThrough.Enabled := ButtonBuffer.Down;
end;

{
const
	MaxSizes = 17;
var
	TransSpeed: array[0..MaxSizes] of Int64;
	MaxSpeed: Int64;

procedure TfMain.ButtonChartClick(Sender: TObject);
var
	BlockSize: UG;
	i, j: Integer;
	StartTickCount: U8;
	StatTime, Rep: array[0..MaxSizes] of LongWord;

	Buffer: PArrayU1;
begin
	BlockSize := 256;
	MaxSpeed := 0;
	for j := 0 to MaxSizes do
	begin
		GetMem(Buffer, BlockSize);
		Rep[j] := 0;
		StartTickCount := PerformanceCounter;
		repeat
			for i := 0 to 9 do
			begin
				FillChar(Buffer^, BlockSize, i and $ff);
				Inc(Rep[j]);
			end;
		until PerformanceCounter > StartTickCount + PerformanceFrequency div 10;
		StatTime[j] := PerformanceCounter - StartTickCount;
		FreeMem(Buffer);
		TransSpeed[j] := RoundDivS8(BlockSize * Int64(Rep[j]), StatTime[j]);
		if TransSpeed[j] > MaxSpeed then MaxSpeed := TransSpeed[j];
		BlockSize := BlockSize * 2;
	end;

	ImageStat.Invalidate;
end;

procedure TfMain.ImageStatFill(Sender: TObject);
var
	Bmp: TDBitmap;
	X1, Y1, X2, Y2: Integer;
	j: SG;
begin
	Bmp := ImageStat.Bitmap;
	Bmp.Bar(clAppWorkSpace, ef16);
	X2 := 0;
	Y2 := 0;
	if MaxSpeed <> 0 then
	for j := 1 to MaxSizes do
	begin
		X1 := X2;
		Y1 := Y2;
		X2 := 20 * j;
		Y2 := Bmp.Height - 1 - (Bmp.Height - 1) * TransSpeed[j] div MaxSpeed;
		Bmp.Line(X1, 0, X1, Bmp.Height - 1, $00808080, ef16);
		Bmp.Line(X1, Y1, X2, Y2, clWhite, ef16);
	end;
end;
}

procedure TfMain.RWOptions(const Save: BG);
const Section = 'Options';
begin
	MainIni.RWFormPos(Self, Save);

	MainIni.RWComboBox(Section, ComboBoxFileName, Save);

	MainIni.RWComboBox(Section, ComboBoxFileSize, Save);
	MainIni.RWComboBox(Section, ComboBoxXB, Save);
	MainIni.RWComboBox(Section, ComboBoxBufferSize, Save);

	MainIni.RWButton(Section, ButtonBuffer, Save);
	MainIni.RWButton(Section, ButtonWriteThrough, Save);
	MainIni.RWButton(Section, ButtonRandom, Save);
end;

procedure TfMain.FormCreate(Sender: TObject);
const
	MinimalBufferIndex = 9;	
var
	i: SG;
	d: TDriveLetter;
	Drive: TDriveInfo;
begin
	Background := baGradient;

	Process := TProcess.Create(Self);
	ToBeDeleted := TStringList.Create;

	ComboBoxFileName.Items.BeginUpdate;
	try
		for d := Low(d) to High(d) do
		begin
			Drive := GetDriveInfo(d);
			if Drive.DriveType <> DRIVE_NO_ROOT_DIR then
			begin
				ComboBoxFileName.Items.Add(d + DriveDelim + PathDelim + 'Test.tmp');
				if d = 'C' then
					ComboBoxFileName.ItemIndex := ComboBoxFileName.Items.Count - 1;
			end;
		end;
	finally
		ComboBoxFileName.Items.EndUpdate;
	end;

	ComboBoxFileSize.Items.BeginUpdate;
	try
		// 1..512
		for i := 0 to 9 do
			ComboBoxFileSize.Items.Add(NToS(1 shl i));
		ComboBoxFileSize.ItemIndex := 5;
	finally
		ComboBoxFileSize.Items.EndUpdate;
	end;

	ComboBoxBufferSize.Items.BeginUpdate;
	try
		// Files: 512B..32MB
		for i := MinimalBufferIndex to 25 do
			ComboBoxBufferSize.Items.Add(NToS(1 shl i));
		ComboBoxBufferSize.ItemIndex := 15 - MinimalBufferIndex;
	finally
		ComboBoxBufferSize.Items.EndUpdate;
	end;

	RWOptions(False);
	Init;
end;

procedure TfMain.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
	Process.Abort;
	RWOptions(True);
	DeleteAllFiles;
end;

procedure TfMain.FormResize(Sender: TObject);
begin
	MemoInfo.Width := ClientWidth - MemoInfo.Left - FormBorder;
	Gauge.Width := MemoInfo.Width;
{	ImageStat.SetBounds(
		ImageStat.Left, ImageStat.Top,
		ClientWidth - 2 * ImageStat.Left, ClientHeight - ImageStat.Top - FormBorder);}
end;

procedure TfMain.ButtonDeleteClick(Sender: TObject);
begin
	DeleteAllFiles;
	Init;
end;

procedure TfMain.ButtonAbortClick(Sender: TObject);
begin
	Process.Abort;
	InitButtons;
end;

procedure TfMain.ButtonPauseClick(Sender: TObject);
begin
	Process.Pause;
end;

procedure TfMain.Init;
begin
	InitButtons;
end;

procedure TfMain.DeleteAllFiles;
var i: SG;
begin
	for i := 0 to ToBeDeleted.Count - 1 do
		if FileExists(ToBeDeleted[i]) then
			DeleteFileEx(ToBeDeleted[i]);
end;

procedure TfMain.FormDestroy(Sender: TObject);
begin
	ToBeDeleted.Free;
	Process.Free;
end;

end.
