// * File:     DirInfo\uMain.pas
// * Created:  1998-01-01
// * Modified: 2010-11-12
// * Version:  2.2.47.90
// * Author:   David Safranek (Safrad)
// * E-Mail:   safrad at email.cz
// * Web:      http://safrad.own.cz

unit uMain;

interface

uses
	uDForm, uFiles, uTypes, uSystem, uDMemo,
	Menus, ImgList, Controls, StdCtrls, Graphics, ExtCtrls,
	uDImage, uDView, uDButton, ComCtrls, Classes, uDLabel, Types, Dialogs,
	uDEdit, uDWinControl;

type
	TfMain = class(TDForm)
		PageControl1: TPageControl;
		TabSheetED: TTabSheet;
		PanelNED: TDLabel;
		TabSheetEF: TTabSheet;
		PanelNEF: TDLabel;
		ListBoxEF: TDMemo;
		TabSheetSF: TTabSheet;
		PanelNSam: TDLabel;
		TabSheetST: TTabSheet;
		GroupBoxF: TGroupBox;
		PanelMin: TDLabel;
		PanelSmallestFileSize: TDLabel;
		PanelAvg: TDLabel;
		PanelLargestFileSize: TDLabel;
		PanelMax: TDLabel;
		PanelAverageFileSize: TDLabel;
		PanelFD: TDLabel;
		PanelPD: TDLabel;
		PanelF: TDLabel;
		PanelD: TDLabel;
		PanelA: TDLabel;
		PanelF1: TDLabel;
		PanelF2: TDLabel;
		PanelF3: TDLabel;
		PanelD1: TDLabel;
		PanelD2: TDLabel;
		PanelD3: TDLabel;
		PanelA1: TDLabel;
		PanelA2: TDLabel;
		PanelA3: TDLabel;
		PanelNFD: TDLabel;
		PanelS0: TDLabel;
		PanelPF: TDLabel;
		PanelCount: TDLabel;
		PanelClusters: TDLabel;
		PanelUsed: TDLabel;
		TabSheetER: TTabSheet;
		PopupMenuCluster: TPopupMenu;
		None: TMenuItem;
		Cluster1: TMenuItem;
		N512B1: TMenuItem;
		N1kB1: TMenuItem;
		N2kB1: TMenuItem;
		N4kB1: TMenuItem;
		N8kB1: TMenuItem;
		N16kB1: TMenuItem;
		N32kB1: TMenuItem;
		TabSheetOP: TTabSheet;
		PanelSSam: TDLabel;
		ListBoxED: TDMemo;
		ImageList1: TImageList;
		TabSheet1: TTabSheet;
		PanelSort: TDLabel;
		GroupBoxCluster: TGroupBox;
		ComboBoxC: TComboBox;
		ImageCL: TImage;
		GroupBoxMask: TGroupBox;
		MemoFileTypes: TDMemo;
		PanelFolder: TDLabel;
		EditFolderLevelName: TDEdit;
		PanelFolderLevel: TDLabel;
		EditLargestFileName: TDEdit;
		EditSmallestFileName: TDEdit;
		GroupBox1: TGroupBox;
		PanelSFD: TDLabel;
		PanelEFD: TDLabel;
		PanelEFD2: TDLabel;
		PanelNSFD: TDLabel;
		PanelNEFD: TDLabel;
		PanelNEDD: TDLabel;
		PanelRun: TDLabel;
		PanelPC: TDLabel;
		PanelRunCount: TDLabel;
		PanelProcessCount: TDLabel;
		PanelTime: TDLabel;
		PanelRunTime: TDLabel;
		PanelPT: TDLabel;
		PanelProcessTime: TDLabel;
		ButtonSC: TDButton;
		ButtonSort: TDButton;
		ButtonEED: TDButton;
		ButtonEEF: TDButton;
		ButtonESF: TDButton;
		ButtonDT: TDButton;
		TabSheetAccess: TTabSheet;
		ButtonAccess: TDButton;
		ButtonDOSNames: TDButton;
		ButtonIllegal: TDButton;
		ButtonRename: TDButton;
		ButtonSkip: TDButton;
		EditNewName: TDEdit;
		EditOldName: TDEdit;
		ButtonSkipAll: TDButton;
		ButtonRenameAll: TDButton;
		ButtonStartRename: TDButton;
		PopupMenuSave: TPopupMenu;
		SaveToFile1: TMenuItem;
		SaveDialog1: TSaveDialog;
		DViewCluster: TDView;
		DViewS: TDView;
		Drive1: TMenuItem;
		DViewSortFolders: TDView;
		DViewBadNames: TDView;
		ButtonRead: TDButton;
		N64kB1: TMenuItem;
		DViewLogs: TDView;
		ButtonFileExt: TDButton;
		ButtonSounds: TDButton;
		ButtonAbout: TDButton;
		BottomPanel: TPanel;
		LabelET: TLabel;
		LabelPath: TLabel;
		PanelNET: TDLabel;
		PanelNSD: TDLabel;
		PanelSP: TDLabel;
		EditSD: TDEdit;
		MemoAD: TDMemo;
		ButtonClose: TDButton;
		ButtonStop: TDButton;
		ButtonStart: TDButton;
		ButtonPause: TDButton;
		ButtonClear: TDButton;
		ButtonSubfolders: TDButton;
		procedure ButtonStartClick(Sender: TObject);
		procedure ButtonCloseClick(Sender: TObject);
		procedure CheckBoxESFClick(Sender: TObject);
		procedure ButtonClearClick(Sender: TObject);
		procedure ListBoxEFKeyDown(Sender: TObject; var Key: Word;
			Shift: TShiftState);
		procedure ButtonSaveClick(Sender: TObject);
		procedure FormCreate(Sender: TObject);
		procedure ButtonFileExtClick(Sender: TObject);
		procedure ButtonPauseClick(Sender: TObject);
		procedure ButtonStopClick(Sender: TObject);
		procedure NXClick(Sender: TObject);
		procedure DLClick(Sender: TObject);
		procedure ListBoxEDKeyDown(Sender: TObject; var Key: Word;
			Shift: TShiftState);
		procedure MemoADChange(Sender: TObject);
		procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
		procedure DViewSKeyDown(Sender: TObject; var Key: Word;
			Shift: TShiftState);
		procedure ButtonAboutClick(Sender: TObject);
		procedure ButtonStartRenameClick(Sender: TObject);
		procedure ButtonSkipClick(Sender: TObject);
		procedure ButtonRenameClick(Sender: TObject);
		procedure ButtonRenameAllClick(Sender: TObject);
		procedure ButtonSkipAllClick(Sender: TObject);
		procedure SaveToFile1Click(Sender: TObject);
		procedure DViewClusterGetData(Sender: TObject; var Data: string;
			ColIndex, RowIndex: Integer; Rect: TRect);
		procedure DViewClusterColumnClick(Sender: TObject; Column: TColumn);
		procedure DViewSGetData(Sender: TObject; var Data: string;
			ColIndex, RowIndex: Integer; Rect: TRect);
		procedure DViewSortFoldersGetData(Sender: TObject; var Data: string;
			ColIndex, RowIndex: Integer; Rect: TRect);
		procedure DViewSortFoldersColumnClick(Sender: TObject;
			Column: TColumn);
		procedure DViewBadNamesGetData(Sender: TObject; var Data: string;
			ColIndex, RowIndex: Integer; Rect: TRect);
		procedure DViewLogsGetData(Sender: TObject; var Data: String; ColIndex,
			RowIndex: Integer; Rect: TRect);
		procedure FormResize(Sender: TObject);
		procedure ButtonSoundsClick(Sender: TObject);
		procedure Refresh1Click(Sender: TObject);
	private
		{ Private declarations }
		procedure RWOptions(const Save: Boolean);
		{$ifdef Thread}
		procedure ThreadDone(Sender: TObject);
		{$endif}
		procedure InitAbout;
	public
		{ Public declarations }
		procedure Initi;
		procedure InitButtons;
	end;

const
	MaxDrive = Ord('Z') - Ord('A');
var
	fMain: TfMain;

	ProcessCount: U4;
	ProcessTime: U8;
	NSFD, NEFD, NEDD: LongWord;

	SwitchSubDirs, SwitchSF, SwitchDT, SwitchEF, SwitchED,
	SwitchSort,  // SF-Same file, DT-Same file DateTime, EF-Empty file, ED-Empty dir
	SwitchAccess, SwitchRead, SwitchDOSNames, SwitchIllegal: Boolean;

	SFCount, EFCount, EDCount: Integer;

	// Logs
	LogCount: UG;
	Logs: array of string;

	Sub, MaxSub: Byte;
	DirCount: LongWord;
	FilCount: LongWord;
	FilSize: U8;
	FilSect: U8;

	GCluster: LongWord;
	GShrCluster: Byte;
	MinFile, MaxFile: U8;
	Found: Boolean;
	NumSSame: LongWord;

	STime: LongWord;
	ProgramSTime: LongWord;

var
	Drives: array of TDriveInfo;
	DriveCount: SG;

implementation

{$R *.DFM}
uses
	SysUtils, Windows, Forms,
	uGraph, uDBitmap, uReg, uWave, uAbout, uFile, uDIniFile, uSorts, uStrings, uMath, uOutputFormat, uFileExt, uSounds, uMsg,
	uSimulation, uColor, uParams, uStart, uProjectInfo,
	uEngine;

procedure TfMain.InitButtons;
begin
	ButtonStart.Enabled := (Where = whNone);
	ButtonPause.Enabled := (Where <> whNone) and (Where <> whWait);
	ButtonStop.Enabled := (Where = whStart) or (Where = whPause);
	ButtonClear.Enabled := (Where = whNone);
	if Where = whPause then
	begin
		ButtonPause.Caption := '&Continue';
		ButtonPause.Hint := 'Continue operation';
	end
	else
	begin
		ButtonPause.Caption := '&Pause';
		ButtonPause.Hint := 'Pause operation';
	end;

	ButtonStartRename.Enabled := (Where = whNone) and (BadNameCount > 0);
	ButtonRename.Enabled := Where = whWait;
	ButtonRenameAll.Enabled := Where = whWait;
	ButtonSkip.Enabled := Where = whWait;
	ButtonSkipAll.Enabled := Where = whWait;
end;

procedure TfMain.Initi;
var
	AllCount: LongWord;
	AllSect: LongWord;
	SizSDir, SizSFil, SizSAll: Int64;
	PerDir, PerFil, PerAll: SG;
	AvgFile: LongWord;
	C: TColor;
	S: string;
begin
	SizSDir := Int64(GCluster) * Int64(DirCount);
	SizSFil := Int64(GCluster) * Int64(FilSect);
	AllCount := DirCount + FilCount;
	AllSect := DirCount + FilSect;
	SizSAll := Int64(GCluster) * Int64(AllSect);

	if DirCount = 0 then
	begin
		PerDir := High(PerDir);
	end
	else
	begin
		PerDir := RoundDivS8(10000 * FilCount, DirCount);
	end;
	if SizSFil = 0 then
	begin
		PerFil := High(PerFil);
	end
	else
	begin
		PerFil := RoundDivS8(10000 * FilSize, SizSFil);
	end;
	if SizSAll = 0 then
	begin
		PerAll := High(PerAll);
	end
	else
	begin
		PerAll := RoundDivS8(10000 * FilSize, SizSAll);
	end;

	if FilCount = 0 then
	begin
		AvgFile := 0;
	end
	else
	begin
		AvgFile := FilSize div FilCount;
	end;
	PanelAverageFileSize.Caption := BToStr(AvgFile);

	if EDCount > 0 then
	begin
		PanelNED.Color := clRed;
//    TabSheetED.Caption := 'Empty dirs (' + NToS(EDCount) + ')';
	end
	else
	begin
		PanelNED.Color := clBtnFace;
//    TabSheetED.Caption := 'Empty dirs';
	end;
	PanelNED.Caption := NToS(EDCount);

	if EFCount > 0 then
	begin
		PanelNEF.Color := clRed;
//    TabSheetEF.Caption := 'Empty files (' + NToS(EFCount) + ')';
	end
	else
	begin
		PanelNEF.Color := clBtnFace;
//    TabSheetEF.Caption := 'Empty files';
	end;
	PanelNEF.Caption := NToS(EFCount);
	if SwitchSF = True then
	begin
		if SFCount > 0 then
		begin
			PanelNSam.Color := clRed;
//      TabSheetSF.Caption := 'Same files (' + NToS(SFCount) + ')';
		end
		else
		begin
			PanelNSam.Color := clBtnFace;
//      TabSheetSF.Caption := 'Same files';
		end;
		PanelNSam.Caption := NToS(SFCount);
		PanelSSam.Caption := BToStr(Int64(GCluster) * Int64(NumSSame));
	end;

	PanelNET.Caption := MsToStr(TimeDifference(GetTickCount, STime), diMSD, 3, False);

	PanelF1.Caption := NToS(FilCount);
	PanelD1.Caption := NToS(DirCount);
	PanelA1.Caption := NToS(AllCount);

	PanelF2.Caption := NToS(FilSect);
	PanelD2.Caption := NToS(DirCount);
	PanelA2.Caption := NToS(AllSect);

	S := NToS(FilSize);
	PanelS0.Caption := S + ' (' + BToStr(FilSize) + ')';
	S := NToS(SizSFil);
	PanelF3.Caption := S + ' (' + BToStr(SizSFil) + ')';
	S := NToS(SizSDir);
	PanelD3.Caption := S + ' (' + BToStr(SizSDir) + ')';
	S := NToS(SizSAll);
	PanelA3.Caption := S + ' (' + BToStr(SizSAll) + ')';


	if PerFil = High(PerFil) then
	begin
		C := clBtnFace;
		S := ''
	end
	else
	begin
		case PerFil of
		0000..4999: C := clRed;
		else C := SpectrumColor((PerFil - 5000) * 510 div 5000);
		end;
		S := NToS(PerFil, 2) + '%';
	end;
	PanelPF.Color := C;
	PanelPF.Caption := S;

	if PerDir = High(PerDir) then
	begin
		C := clBtnFace;
		S := ''
	end
	else
	begin
		case PerDir of
		00000..01999: C := SpectrumColor(PerDir * 510 div 2000);
		else C := clLime;
		end;
		S := NToS(PerDir, 2);
	end;
	PanelPD.Color := C;
	PanelPD.Caption := S;

{ case PerAll of
	0000..5000:   C := clRed;
	5001..7500:   C := clYellow;
	else C := clBtnFace;
	end;}
	if PerAll = High(PerAll) then
	begin
		C := clBtnFace;
		S := ''
	end
	else
	begin
		case PerAll of
		0000..4999: C := clRed;
		else C := SpectrumColor((PerAll - 5000) * 510 div 5000);
		end;
		S := NToS(PerAll, 2) + '%';
	end;
	PanelNFD.Color := C;
	PanelNFD.Caption := S;
end;

procedure TfMain.ButtonStartClick(Sender: TObject);
begin
	BeginLongOperation(True);
	Where := whStart; InitButtons;
	STime := GetTickCount;
	ButtonClearClick(Sender);
	{$ifdef Thread}
	Search := TSearch.Create;
	Search.OnTerminate := ThreadDone;
	{$else}
	RunSearch;
	{$endif}
end;

{$ifdef Thread}
procedure TfMain.ThreadDone(Sender: TObject);
begin
	if Where = whClose then
	begin
		Where := whNone;
		Close;
	end
	else
	begin
		Where := whNone;
	end;
	InitButtons;
	EndLongOperation;
end;
{$endif}

procedure TfMain.ButtonCloseClick(Sender: TObject);
begin
	Close;
end;

procedure TfMain.CheckBoxESFClick(Sender: TObject);
begin
	if ButtonESF.Down = False then
		PanelNSam.Font.Color := clGrayText
	else
		PanelNSam.Font.Color := clWindowText;
end;

procedure TfMain.ButtonClearClick(Sender: TObject);
begin
	DirCount := 0; FilCount := 0; FilSect := 0; FilSize := 0;

	Sub := 0; MaxSub := 0;
	SFCount := 0; EFCount := 0; EDCount := 0;

	LogCount := 0; DViewLogs.RowCount := 0;

	NumSSame := 0;

	MaxFile := 0; MinFile := MaxLongint;

	ListBoxED.Lines.BeginUpdate;
	ListBoxED.Lines.Clear;
	ListBoxED.Lines.EndUpdate;
	ListBoxEF.Lines.BeginUpdate;
	ListBoxEF.Lines.Clear;
	ListBoxEF.Lines.EndUpdate;
	DViewS.RowCount := 0;
	SetLength(ASame, 0); SameCount := 0;
	SetLength(SameGroup, 0); SameGroupCount := 0;
	DViewSortFolders.RowCount := 0;
	SetLength(Folders, 0); FolderCount := 0;

	DViewBadNames.RowCount := 0;
	SetLength(BadNames, 0); BadNameCount := 0;

	PanelSmallestFileSize.Caption := '';
	EditSmallestFileName.Text := '';
	PanelLargestFileSize.Caption := '';
	EditLargestFileName.Text := '';

	PanelFolderLevel.Caption := '';
	EditFolderLevelName.Text := '';

	PanelNSD.Caption := '';
	EditSD.Text := '';
	Initi;
end;

procedure TfMain.InitAbout;
begin
	PanelRunCount.Caption := NToS(GetRunCount);
	PanelProcessCount.Caption := NToS(ProcessCount);
	PanelRunTime.Caption := MsToStr(GetRunTime, diHMSD, 3, False);
	PanelProcessTime.Caption := MsToStr(ProcessTime, diHMSD, 3, False);
	PanelNSFD.Caption := NToS(NSFD);
	PanelNEFD.Caption := NToS(NEFD);
	PanelNEDD.Caption := NToS(NEDD);
end;

procedure TfMain.ListBoxEDKeyDown(Sender: TObject; var Key: Word;
	Shift: TShiftState);
{var
	W, M: Integer;
	DirName: ShortString;
	YesToAll: Boolean;
	Changed: Boolean;}
begin
	if Key = VK_DELETE then
	begin
(*		if ListBoxED.SelCount = 0 then Exit;
		YesToAll := False;
		Changed := False;
		M := ListBoxED.Items.Count;
		W := 0;
		while W < M do
		begin
			if ListBoxED.Selected[W] = True then
			begin
				DirName := ListBoxED.Items[W];
				if YesToAll = False then
				case Confirmation('Delete' + LineSep + DirName, [mbYesToAll, mbYes, mbNo, mbCancel]) of
				mbYesToAll: YesToAll := True;
				mbNo:
				begin
					Inc(W);
					Continue;
				end;
				mbCancel: Exit;
				end;

				if RemoveDirectoryEx(DirName) then
				begin
					ListBoxED.Items.Delete(W);
					Dec(M);
					Dec(EDCount);
					Inc(NEDD); InitAbout;
					Changed := True;
				end
				else
				begin
					Inc(W);
//					AddError(DirName, ErrorCode);
				end;
			end
			else
				Inc(W);
		end;
		if Changed = True then Initi;} *)
	end;
end;

procedure TfMain.ListBoxEFKeyDown(Sender: TObject; var Key: Word;
	Shift: TShiftState);
{var
	W, M: Integer;
	Changed: Boolean;
	YesToAll: Boolean;
	FileName: TFileName;}
begin
	if Key = VK_DELETE then
	begin
(*		if ListBoxEF.Items.Selected = 0 then Exit;
		YesToAll := False;
		Changed := False;
		M := ListBoxEF.Items.Count;
		W := 0;
		while W < M do
		begin
			if ListBoxEF.Selected[W] = True then
			begin
				FileName := ListBoxEF.Items[W];
				if YesToAll = False then
				case Confirmation('Delete' + LineSep + FileName, [mbYesToAll, mbYes, mbNo, mbCancel]) of
				mbYesToAll: YesToAll := True;
				mbNo:
				begin
					Inc(W);
					Continue;
				end;
				mbCancel: Exit;
				end;
				if DeleteFileEx(FileName) then
				begin
					ListBoxEF.Items.Delete(W);
					Dec(M);
					Dec(EFCount);
					Inc(NEFD); InitAbout;
					Changed := True;
				end
				else
				begin
					Inc(W);
//					AddError(FileName, ErrorCode);
				end;
			end
			else
				Inc(W);
		end;
		if Changed = True then Initi; *)
	end;
end;

procedure TfMain.DViewSKeyDown(Sender: TObject; var Key: Word;
	Shift: TShiftState);
var
	Changed: Boolean;
	YesToAll: Boolean;
	FileName: TFileName;
	SameIndex: SG;
begin
	if Key = VK_DELETE then
	begin
		if DViewS.SelCount = 0 then Exit;
		if Where <> whNone then Exit;
		YesToAll := False;
		Changed := False;
		SameIndex := 0;
		while SameIndex < SameCount do
		begin
			if (DViewS.SelectedRows[SameIndex] = True) and (ASame[SameIndex].Deleted = False) and (SameGroup[ASame[SameIndex].Group] > 1) then
			begin
				FileName := ASame[SameIndex].FileName;
				if YesToAll = False then
				begin
					case Confirmation('Delete %1.', [mbYesToAll, mbYes, mbNo, mbCancel], [FileName]) of
					mbYesToAll: YesToAll := True;
					mbNo:
					begin
						Inc(SameIndex);
						Continue;
					end;
					mbCancel: Break;
					end;
				end;
				if DeleteFileEx(FileName) then
				begin
					ASame[SameIndex].Deleted := True;
					Dec(SameGroup[ASame[SameIndex].Group]);
					Inc(NSFD);
					Changed := True;
					Dec(SFCount);
					Inc(SameIndex);
				end
				else
				begin
					Inc(SameIndex);
				end;
			end
			else
				Inc(SameIndex);
		end;
		if Changed = True then
		begin
			InitAbout;
			DViewS.RowCount := SameCount;
			DViewS.DataChanged;
			Initi;
		end;
	end;
end;

procedure InitDrives;
var
	i: TDriveLetter;
	Drive: TDriveInfo;
begin
	DriveCount := 0;
	SetLength(Drives, MaxDrive + 1);
	for i := Low(i) to High(i) do
	begin
//		FillChar(Drive, 0, SizeOf(Drive));
		Drive := GetDriveInfo(i);
		if Drive.DriveType <> DRIVE_NO_ROOT_DIR then
		begin
			Drives[DriveCount] := Drive;
			Inc(DriveCount);
		end;
	end;
	SetLength(Drives, DriveCount);
	fMain.DViewCluster.RowCount := DriveCount;
end;

procedure TfMain.ButtonSaveClick(Sender: TObject);
begin
	RWOptions(True);
end;

var SaveFileName: TFileName;

procedure TfMain.RWOptions(const Save: Boolean);
var
	Section: string;
begin
	MainIni.RWFormPos(Self, Save);

	Section := 'Statistics';
	MainIni.RWNum(Section, 'ProcessCount', ProcessCount, Save);
	MainIni.RWNum(Section, 'ProcessTime', ProcessTime, Save);
	MainIni.RWNum(Section, 'SameFilesDeleted', NSFD, Save);
	MainIni.RWNum(Section, 'EmptyFilesDeleted', NEFD, Save);
	MainIni.RWNum(Section, 'EmptyDirsDeleted', NEDD, Save);

	Section := 'Options';
	if Save = False then SaveFileName := 'Dirs.txt';
	MainIni.RWFileName(Section, 'SaveFileName', SaveFileName, Save);

	PageControl1.ActivePageIndex := MainIni.RWSGF(Section, 'PageIndex', PageControl1.ActivePageIndex, 6, Save);
	ButtonSubfolders.Down := MainIni.RWBGF(Section, 'SubDirs', ButtonSubfolders.Down, True, Save);
	ButtonSC.Down := MainIni.RWBGF(Section, 'StaticCluster', ButtonSC.Down, False, Save);
	ComboBoxC.Text := MainIni.RWStringF(Section, 'ClusterSize', ComboBoxC.Text, ComboBoxC.Text, Save);
	ButtonESF.Down := MainIni.RWBGF(Section, 'SameFiles', ButtonESF.Down, True, Save);
	ButtonDT.Down := MainIni.RWBGF(Section, 'DateTime', ButtonDT.Down, True, Save);
	ButtonEEF.Down := MainIni.RWBGF(Section, 'EmptyFiles', ButtonEEF.Down, True, Save);
	ButtonEED.Down := MainIni.RWBGF(Section, 'EmptyDirs', ButtonEED.Down, True, Save);
	ButtonSort.Down := MainIni.RWBGF(Section, 'SortDirs', ButtonSort.Down, True, Save);
	ButtonAccess.Down := MainIni.RWBGF(Section, 'Access', ButtonAccess.Down, True, Save);
	ButtonRead.Down := MainIni.RWBGF(Section, 'Read', ButtonRead.Down, True, Save);
	ButtonDOSNames.Down := MainIni.RWBGF(Section, 'DOSNames', ButtonDOSNames.Down, False, Save);
	ButtonIllegal.Down := MainIni.RWBGF(Section, 'IlleagalNames', ButtonIllegal.Down, False, Save);

	DViewS.Serialize(MainIni, Save);
	DViewSortFolders.Serialize(MainIni, Save);
	DViewCluster.Serialize(MainIni, Save);
	DViewBadNames.Serialize(MainIni, Save);
	DViewLogs.Serialize(MainIni, Save);
end;

procedure ParamFile(const Value: string);
begin
	fMain.MemoAD.Lines.Add(Value);
end;

procedure TfMain.FormCreate(Sender: TObject);
var
	i: SG;
	MenuItem: TMenuItem;
begin
	SaveDialog1.Filter := AllText;
	for i := 0 to MaxDrive do
	begin
		MenuItem := TMenuItem.Create(PopupMenuCluster);
		MenuItem.OnClick := DLClick;
		MenuItem.Caption := Char(i + Ord('A'));
		MenuItem.Tag := i;
		Drive1.Add(MenuItem);
	end;
	ComboBoxC.Items.BeginUpdate;
	try
		for i := 9 to 16 do
		begin
			ComboBoxC.Items.Add(NToS(1 shl i));
		end;
		ComboBoxC.ItemIndex := 3;
	finally
		ComboBoxC.Items.EndUpdate;
	end;

	try
		Icon.LoadFromFile(GraphDir + 'DirInfoA.ico');
	except
	end;

	AddFileType(
			'Folder',
			'',
			'',
			[GetProjectInfo(piProductName)],
			['"' + ExeFileName + '" "%1"']);

	DViewLogs.AddColumn('#', 40, taRightJustify);
	DViewLogs.AddColumn('Message', DViewLogs.Width - 40);

	DViewCluster.AddColumn('Drive', 40);
	DViewCluster.AddColumn('Cluster Size', 68, taRightJustify);
	DViewCluster.AddColumn('Sectors', 64, taRightJustify);
	DViewCluster.AddColumn('Bits', 44, taRightJustify);
	DViewCluster.AddColumn('Type', 64);
	DViewCluster.AddColumn('Free Space');
	DViewCluster.AddColumn('Total Size');

	InitDrives;

	DViewSortFolders.AddColumn('Folder', 408);
	DViewSortFolders.AddColumn('Sectors', 56, taRightJustify);
	DViewSortFolders.AddColumn('Size', 56, taRightJustify);

	DViewS.AddColumn('Group', 48);
	DViewS.AddColumn('Size', 56, taRightJustify);
	DViewS.AddColumn('File Name', 416);

	DViewBadNames.AddColumn('Old Name', 256);
	DViewBadNames.AddColumn('New Names', 256);

	RWOptions(False);

	RegisterParam(paFile, 'Search path', ParamFile);
(*	STime := GetTickCount;
	ProgramSTime := STime;
	ButtonClearClick(Sender);

	AcceptParams(True,
		['Cluster', 'Subfolders', 'SameFiles', 'DateTime'],
		['Next parameter is cluster size', 'Search also in subfolders', 'Search Same Files', 'Ignore date of same files']);
	while True do
	begin
		case CompareParams of
		paFile:
		begin
			MemoAD.Lines.Add(ParamFile);
		end;
		0:
		begin
			ComboBoxC.Text := ParamStr(ParamIndex);
			Inc(ParamIndex);
		end;
		1: ButtonSubfolders.Down := False;
		2: ButtonESF.Down := True;
		3: ButtonDT.Down := True;
		else Break;
		end;
	end;
	CloseParams; *)

{	for i := 1 to ParamCount do
	begin
		S := ParamStr(i);
		if (Length(S) > 1) and (S[2] = DriveDelim) then
		begin
			MemoAD.Lines.Add(S);
			goto EndParam;
		end;
		case S[1] of
		'C', 'c':
		begin
			S[1] := ' ';
			ComboBoxC.Text := S;
		end;
		'N', 'n':
		begin
			ButtonSubfolders.Down := False;
		end;
		'D', 'd':
		begin
			ButtonESF.Down := True;
			if (Length(S) > 1) then ButtonDT.Down := True;
		end;
		end;
		EndParam:
	end;}
	InitAbout;
	InitButtons;
end;

procedure TfMain.ButtonFileExtClick(Sender: TObject);
begin
	FormFileExt;
end;

procedure TfMain.ButtonPauseClick(Sender: TObject);
begin
	if Where = whPause then
	begin
		Where := whStart;
		{$ifdef Thread}
		Search.Resume;
		{$endif}
	end
	else
	begin
		Where := whPause;
		{$ifdef Thread}
		Search.Suspend;
		{$endif}
	end;
	InitButtons;
end;

procedure TfMain.ButtonStopClick(Sender: TObject);
begin
	{$ifdef Thread}
	if Where = whPause then Search.Resume;
	{$endif}
	Where := whStop; InitButtons;
end;

procedure TfMain.NXClick(Sender: TObject);
var
	i: SG;
begin
	if DViewCluster.SelCount > 0 then
	begin
		for i := 0 to DViewCluster.RowCount - 1 do
		begin
			if DViewCluster.SelectedRows[i] = True then
			begin
				Drives[i].ClusterSize := 512 * TMenuItem(Sender).Tag;
			end;
		end;
		DViewCluster.Invalidate;
	end;
end;

procedure TfMain.DLClick(Sender: TObject);
var
	i: SG;
begin
	if DViewCluster.SelCount > 0 then
	begin
		for i := 0 to DViewCluster.RowCount - 1 do
		begin
			if DViewCluster.SelectedRows[i] = True then
			begin
				Drives[i].DriveLetter := Char(Ord('A') + TMenuItem(Sender).Tag);
				Break;
			end;
		end;
		DViewCluster.Invalidate;
	end;
end;

procedure TfMain.MemoADChange(Sender: TObject);
var
	i: Integer;
	PathsCount: Integer;
begin
	PathsCount := 0;
	for i := 0 to MemoAD.Lines.Count - 1 do
	begin
		if MemoAD.Lines.Strings[i] <> '' then Inc(PathsCount);
	end;
	PanelSP.Caption := NToS(PathsCount);
end;

procedure TfMain.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
	case Where of
	whNone:
		CanClose := True;
	whStart:
	begin
		Where := whClose;
		CanClose := False;
	end;
	whPause:
	begin
		{$ifdef Thread}
		Search.Resume;
		{$endif}
		Where := whClose;
		CanClose := False;
	end;
	whStop:
	begin
		Where := whClose;
		CanClose := False;
	end;
	whClose:
	begin
		CanClose := False;
	end;
	whWait:
		Where := whSkipAll;
	end;
	if CanClose = False then
		InitButtons
	else
	begin
		RWOptions(True);
	end;
end;

procedure TfMain.ButtonAboutClick(Sender: TObject);
begin
	ExecuteAbout(Self, False);
end;

procedure TfMain.ButtonStartRenameClick(Sender: TObject);
var
	i: Integer;
	NewName, OldName: TFileName;
begin
	Where := whWait;
	fMain.InitButtons;
	i := 0;
	while i < BadNameCount do
	begin
		if DViewBadNames.SelectedRows[i] then
		begin
			OldName := BadNames[i];
			NewName := GoodName(OldName);
			if LastChar(OldName) = PathDelim then
			begin
				fMain.EditOldName.Text := ParentDirF(OldName);
				fMain.EditNewName.Text := ParentDirF(NewName);
			end
			else
			begin
				fMain.EditOldName.Text := ExtractFileName(OldName);
				fMain.EditNewName.Text := ExtractFileName(NewName);
			end;
			if Where <> whRenameAll then
			begin
				Where := whWait;
				while Where = whWait do
				begin
					Sleep(LoopSleepTime);
					Application.ProcessMessages;
				end;
			end;
			if Where = whSkip then
			begin
				Inc(i);
				Continue;
			end;
			if Where = whSkipAll then Break;
			if (Where = whRename) or (Where = whRenameAll) then
			begin
				if LastChar(OldName) = PathDelim then
					NewName := ParentDirF(OldName) + fMain.EditNewName.Text
				else
					NewName := ExtractFilePath(OldName) + fMain.EditNewName.Text;
//				if Length(OldName) = Length(NewName) then
				begin
					RenameFileEx(PChar(OldName), PChar(NewName));
{					if ErrorCode = 0 then
					begin
						for j := i to BadNameCount - 2 do
							BadNames[j] := BadNames[j + 1];
						Dec(BadNameCount);
						DViewBadNames.RowCount := BadNameCount;
						DViewBadNames.Fill;
						SetLength(BadNames, BadNameCount);
						Continue;
					end;}
{				end
				else
				begin
					Warning('Illegal new name length', NewName);}
				end;
			end;
		end;
		Inc(i);
	end;
	Where := whNone;
	fMain.InitButtons;
	EditOldName.Text := '';
	EditNewName.Text := '';
end;

procedure TfMain.ButtonSkipClick(Sender: TObject);
begin
	Where := whSkip;
end;

procedure TfMain.ButtonRenameClick(Sender: TObject);
begin
	Where := whRename;
end;

procedure TfMain.ButtonRenameAllClick(Sender: TObject);
begin
	Where := whRenameAll;
end;

procedure TfMain.ButtonSkipAllClick(Sender: TObject);
begin
	Where := whSkipAll;
end;

procedure TfMain.SaveToFile1Click(Sender: TObject);
var
	i, j: SG;
	F: TFile;
begin
	if ExecuteDialog(SaveDialog1, SaveFileName) then
	begin
		F := TFile.Create;
		try
			if F.Open(SaveFileName, fmRewrite) then
			begin
				for i := 0 to FolderCount - 1 do
				begin
					j := DViewSortFolders.RowOrder[i];
					F.Writeln(Folders[j].Folder + ' (' + BToStr(Folders[j].Sectors) + ')');
				end;
				F.Truncate;
				F.Close;
			end;
		finally
			F.Free;
		end;
	end;
end;

procedure TfMain.DViewClusterGetData(Sender: TObject; var Data: string;
	ColIndex, RowIndex: Integer; Rect: TRect);
var
	i, ShrCluster: SG;
	s: string;
begin
	i := RowIndex;

	case ColIndex of
	0: Data := Drives[i].DriveLetter;
	1: Data := NToS(Drives[i].ClusterSize) + ' B';
	2:
	begin
		s := NToS(Drives[i].ClusterSize shr 9);
		Data := s;
	end;
	3:
	begin
		ShrCluster := CalcShr(Drives[i].ClusterSize);
		s := NToS(ShrCluster);
		Data := s;
	end;
	4: Data := DriveTypeToStr(Drives[i].DriveType);
	5:
	begin
		if Drives[i].FreeSpace = -1 then
			Data := 'Unknown'
		else
			Data := BToStr(Drives[i].FreeSpace);
	end;
	6:
	begin
		if Drives[i].DriveSize = -1 then
			Data := 'Unknown'
		else
			Data := BToStr(Drives[i].DriveSize);
	end;
	end;

end;

procedure TfMain.DViewClusterColumnClick(Sender: TObject; Column: TColumn);
var
	i: SG;
	SortD: array of SG;
	SortD8: array of S8;
begin
	SetLength(SortD, DriveCount);
	SetLength(SortD8, DriveCount);
	for i := 0 to DriveCount - 1 do
	begin
		case DViewCluster.SortBy of
		0: SortD[i] := SG(Drives[i].DriveLetter);
		1, 2, 3: SortD[i] := Drives[i].ClusterSize;
		4: SortD[i] := Drives[i].DriveType;
		5: SortD8[i] := Drives[i].FreeSpace;
		6: SortD8[i] := Drives[i].DriveSize;
		end;
		DViewCluster.RowOrder[i] := i;
	end;
	if DViewCluster.SortBy >= 5 then
		SortS8(False, False, PArraySG(DViewCluster.RowOrder), PArrayS8(SortD8), DriveCount)
	else
		SortS4(False, False, PArraySG(DViewCluster.RowOrder), PArrayS4(SortD), DriveCount);
	SetLength(SortD8, 0);
	SetLength(SortD, 0);
end;

procedure TfMain.DViewSGetData(Sender: TObject; var Data: string;
	ColIndex, RowIndex: Integer; Rect: TRect);
var i: SG;
begin
	DViewS.Bitmap.Canvas.Font.Style := [];
	i := RowIndex;
	case ColIndex of
	0:
	begin
		if ASame[i].FileSize >= 0 then
		begin
			Data := NToS(ASame[i].Group + 1);
		end
		else
			Data := '';
{		if SameGroupCount > 0 then
		begin
			DViewS.Bitmap.Canvas.Brush.Color := SpectrumColor(RoundDiv(MaxSpectrum2 * ASame[i].Group, SameGroupCount));
			DViewS.Bitmap.Canvas.Font.Color := NegMonoColor(DViewS.Bitmap.Canvas.Brush.Color);
		end;}
	end;
	1: if ASame[i].FileSize >= 0 then Data := BToStr(ASame[i].FileSize) else Data := '';
	2:
	begin
		if ASame[i].Deleted then
			DViewS.Bitmap.Canvas.Font.Style := [fsStrikeOut];
		Data := ASame[i].FileName;
	end;
	end;
end;

procedure TfMain.DViewSortFoldersGetData(Sender: TObject; var Data: string;
	ColIndex, RowIndex: Integer; Rect: TRect);
var i: SG;
begin
	i := RowIndex;
	case ColIndex of
	0: Data := Folders[i].Folder;
	1:
	begin
		Data := BToStr(Folders[i].Sectors);
	end;
	2:
	begin
		Data := BToStr(Folders[i].Size);
	end;
	end;
end;

procedure TfMain.DViewSortFoldersColumnClick(Sender: TObject;
	Column: TColumn);
var
	i: SG;
	SortS: array of string;
	SortD: array of S8;
begin
	if FolderCount = 0 then Exit;
	case DViewSortFolders.SortBy of
	0: SetLength(SortS, FolderCount);
	else SetLength(SortD, FolderCount);
	end;
	for i := 0 to FolderCount - 1 do
	begin
		case DViewSortFolders.SortBy of
		0: SortS[i] := Folders[i].Folder;
		1: SortD[i] := Folders[i].Sectors;
		2: SortD[i] := Folders[i].Size;
		end;
		DViewSortFolders.RowOrder[i] := i;
	end;
	case DViewSortFolders.SortBy of
	0:
	begin
		SortStr(PArraySG(DViewSortFolders.RowOrder), PArrayString(SortS), FolderCount);
		SetLength(SortS, 0);
	end
	else
	begin
		SortS8(False, False, PArraySG(DViewSortFolders.RowOrder), PArrayS8(SortD), FolderCount);
		SetLength(SortD, 0);
	end;
	end;
end;

procedure TfMain.DViewBadNamesGetData(Sender: TObject; var Data: string;
	ColIndex, RowIndex: Integer; Rect: TRect);
var i: SG;
begin
	i := RowIndex;
	case ColIndex of
	0: Data := BadNames[i];
	1: Data := GoodName(BadNames[i]);
	end;
end;

procedure TfMain.DViewLogsGetData(Sender: TObject; var Data: String;
	ColIndex, RowIndex: Integer; Rect: TRect);
begin
	case ColIndex of
	0: Data := NToS(RowIndex + 1);
	1: Data := Logs[RowIndex];
	end;
end;

procedure TfMain.FormResize(Sender: TObject);
begin
	DViewS.SetBounds(DViewS.Left, DViewS.Top, TabSheetSF.ClientWidth - DViewS.Left, TabSheetSF.ClientHeight - DViewS.Top);
	DViewSortFolders.SetBounds(DViewSortFolders.Left, DViewSortFolders.Top, TabSheetSF.ClientWidth - DViewSortFolders.Left, TabSheetSF.ClientHeight - DViewSortFolders.Top);
	DViewBadNames.SetBounds(DViewBadNames.Left, DViewBadNames.Top, TabSheetSF.ClientWidth - DViewBadNames.Left, DViewBadNames.Height);

	ListBoxEF.SetBounds(ListBoxEF.Left, ListBoxEF.Top, TabSheetSF.ClientWidth - ListBoxEF.Left, TabSheetSF.ClientHeight - ListBoxEF.Top);
	ListBoxED.SetBounds(ListBoxED.Left, ListBoxED.Top, TabSheetSF.ClientWidth - ListBoxED.Left, TabSheetSF.ClientHeight - ListBoxED.Top);
end;

procedure TfMain.ButtonSoundsClick(Sender: TObject);
begin
	FormSounds;
end;

procedure TfMain.Refresh1Click(Sender: TObject);
begin
	InitDrives;
end;

end.
