// * File:     DirInfo\uEngine.pas
// * Created:  1998-01-01
// * Modified: 2009-09-18
// * Version:  2.2.47.90
// * Author:   David Safranek (Safrad)
// * E-Mail:   safrad at email.cz
// * Web:      http://safrad.own.cz

unit uEngine;

interface

uses
	uTypes,
	Classes, MMSystem, uWave;
{$ifdef Thread}
type
	TSearch = class(TThread)
	private
		{ Private declarations }
		procedure UpdateListViewSameFiles;
		procedure UpDateListViewSortFolders;
	protected
		procedure Execute; override;
	public
		constructor Create;
	end;
{$else}
procedure RunSearch;
{$endif}
procedure AddError(const FileName: string; const ErrorCode: Integer);
function GoodName(const OldName: string): string;

var
{$ifdef Thread}
	Search: TSearch;
{$endif}
	Where: (whNone, whStart, whPause, whStop, whClose, whWait, whSkip, whSkipAll, whRename, whRenameAll);

// Same
	SameGroup: array of U4;
	SameGroupCount: Integer;
type
	TSame = packed record // 256
		FileSize: U8; // 8
		Group: S4; // 4
		Deleted: B1; // 1
		Reserved: array[0..2] of U1; // 3
		FileName: string[239]; // 240
	end;
var
	ASame: array of TSame;
	SameCount: SG;

// Sort Folders
type
	TFolder = packed record // 32
		Sectors, Size: U8; // 16
		Folder: string; // 4
		Reserved: array[0..11] of U1; // 12
	end;
var
	Folders: array of TFolder;
	FolderCount: SG;

// Bad Names
	BadNames: array of string;
	BadNameCount: SG;

implementation

uses
	Windows, Forms, Graphics, ExtCtrls, SysUtils, Controls,
	uMain, uFile, uFiles, uInputFormat, uOutputFormat, uSystem, uMath, uStrings, uMsg, uSimulation, uCharset;

const
	ChecksumNone = High(U4);
// Same files
type
	TSameFile = packed record // 256
		Name: string[235]; // 236
		Time: S4; // 4
		List: S4; // 4
		Checksum: U4; // 4
		Size: U8; // 8
	end;
var
	ASameFile: array of TSameFile;
	SameFileCount: Integer;

	// Same files
	InsertPos: Integer;
	NewName, OldName: string;

	NewFile, OldFile: TFile;
	TmpFile: file;
	BufNew, BufOld: Pointer;
var
	DirSize: U8;
	DirSect: U4;

procedure AddLog(const Text: string);
var NewSize: SG;
begin
	NewSize := LogCount + 1;
	if AllocByExp(Length(Logs), NewSize) then
		SetLength(Logs, NewSize);
	Logs[LogCount] := Text;
	Inc(LogCount);
	fMain.DViewLogs.RowCount := LogCount;
end;

procedure AddError(const FileName: string; const ErrorCode: Integer);
begin
	AddLog(ErrorCodeToStr(ErrorCode) + ' - ' + FileName);
end;

function GoodName(const OldName: string): string;
	function WinName(const s: string): string;
	var
		i: Integer;
		First: Boolean;
	begin
		Result := s;

		for i := 1 to Length(s) do
		begin
			case s[i] of
			'a'..'z': Exit;
			end;
		end;

		First := True;
		for i := 1 to Length(s) do
		begin
			case s[i] of
			'A'..'Z':
			begin
				if First = False then
				begin
					Result[i] := Char(Ord('a') + Ord(s[i]) - Ord('A'));
				end
				else
				begin
					Result[i] := s[i];
					First := False;
				end;
			end;
			'.':
			begin
				Result[i] := s[i];
				First := False;
			end;
			else
			begin
				Result[i] := s[i];
				First := True;
			end;
			end;
		end;
	end;

var i: Integer;
begin
	if SwitchDOSNames then
	begin
		if LastChar(OldName) = PathDelim then
		begin
			Result := OldName;
			ParentDir(Result);
			Result := Result + WinName(Result);
		end
		else
			Result := ExtractFilePath(OldName) + WinName(ExtractFileName(OldName));
	end
	else
		Result := OldName;
	if SwitchIllegal then
	begin
		Result := ConvertToAscii(Result);
		i := Length(Result);
		while i >= 1 do
		begin
			case Result[i] of
			PathDelim: if i < Length(Result) then Break;

{			'': Result[i] := 'a';
			'': Result[i] := 'c';
			'': Result[i] := 'd';
			'': Result[i] := 'e';
			'': Result[i] := 'e';
			'': Result[i] := 'i';
			'': Result[i] := 'n';
			'': Result[i] := 'o';
			'': Result[i] := 'r';
			'': Result[i] := 's';
			'': Result[i] := 't';
			'': Result[i] := 'u';
			'': Result[i] := 'u';
			'': Result[i] := 'y';
			'': Result[i] := 'z';

			'': Result[i] := 'A';
			'': Result[i] := 'C';
			'': Result[i] := 'D';
			'': Result[i] := 'E';
			'': Result[i] := 'E';
			'': Result[i] := 'I';
			'': Result[i] := 'N';
			'': Result[i] := 'O';
			'': Result[i] := 'R';
			'': Result[i] := 'S';
			'': Result[i] := 'T';
			'': Result[i] := 'U';
			'': Result[i] := 'U';
			'': Result[i] := 'Y';
			'': Result[i] := 'Z';}

			'a'..'z', 'A'..'Z', '0'..'9', '_', '.', '-', ' ', #160, {special space}
			'+', '=', '`',
			'~', '!', '@', '#', '$', '%', '^', '&', '(', ')',
			'{', '}', '''', #180, ';', '[', ']', ',':
			begin

			end
			else
			begin
				Result[i] := '_';
			end;
			end;
			Dec(i);
		end;
	end;
end;

function CompareFiles( { TODO : Hash key or checksum of shorter part of file }
	NewFileName, OldFileName: TFileName;
	var NewChecksum, OldChecksum: LongWord;
	const NewFileSize, OldFileSize: U8): Boolean;
label LClose;
var
	CompareBytes: Integer;
	ReadBytes: Integer;
	NewFileOpen, OldFileOpen: Boolean;
	T: U4;
begin
	Result := False;
	if NewFileSize <> OldFileSize then Exit;

	T := GetTickCount;

	if (NewChecksum = ChecksumNone) then
	begin
		AddLog('Creating checksum ' + NewFileName);
		// Checksum NewFile
		NewFile := TFile.Create;
		if not NewFile.Open(NewFileName, fmReadOnly, FILE_FLAG_SEQUENTIAL_SCAN or FILE_FLAG_NO_PREFIX) then
		begin
//			AddError(NewFileName, NewFile.ErrorCode);
			goto LClose;
		end;
		NewChecksum := 0;
		CompareBytes := NewFileSize;
		repeat
			ReadBytes := DefFileBuffer;
			if ReadBytes > CompareBytes then
			begin
				ReadBytes := CompareBytes;
//				BufNew[(ReadBytes - 1) div 4] := 0;
			end;
			if not NewFile.BlockRead(BufNew^, ReadBytes) then
			begin
//				AddError(NewFileName, NewFile.ErrorCode);
				goto LClose;
			end;
			Dec(CompareBytes, ReadBytes);

			NewChecksum := NewChecksum xor Checksum(BufNew^, ReadBytes);
		until CompareBytes = 0;
		NewFileOpen := True;
	end
	else
		NewFileOpen := False;

	// Checksum OldFile
	if (OldChecksum = ChecksumNone) then
	begin
		AddLog('Creating checksum ' + OldFileName);
		OldFile := TFile.Create;
		if not OldFile.Open(OldFileName, fmReadOnly, FILE_FLAG_SEQUENTIAL_SCAN or FILE_FLAG_NO_PREFIX) then
		begin
//			AddError(OldFileName, OldFile.ErrorCode);
			goto LClose;
		end;
		OldChecksum := 0;
		CompareBytes := OldFileSize;
		repeat
			ReadBytes := DefFileBuffer;
			if ReadBytes > CompareBytes then
			begin
				ReadBytes := CompareBytes;
//				BufOld[(ReadBytes - 1) div 4] := 0;
			end;
			if not OldFile.BlockRead(BufOld^, ReadBytes) then
			begin
//				AddError(OldFileName, OldFile.ErrorCode);
				goto LClose;
			end;
			Dec(CompareBytes, ReadBytes);

			OldChecksum := OldChecksum xor Checksum(BufOld^, ReadBytes);
		until CompareBytes = 0;
		if NewChecksum <> OldChecksum then
		begin
			goto LClose;
		end;
		OldFileOpen := True;
	end
	else
	begin
		if NewChecksum <> OldChecksum then
		begin
			goto LClose;
		end;
		OldFileOpen := False;
	end;

	// Real comparation
		AddLog('Real comparation');

	if NewFileOpen = False then
	begin
		NewFile := TFile.Create;
		if not NewFile.Open(NewFileName, fmReadOnly, FILE_FLAG_SEQUENTIAL_SCAN or FILE_FLAG_NO_PREFIX) then
		begin
//			AddError(NewFileName, NewFile.ErrorCode);
			goto LClose;
		end;
	end
	else
		NewFile.SeekBegin;

	if OldFileOpen = False then
	begin
		OldFile := TFile.Create;
		if not OldFile.Open(OldFileName, fmReadOnly, FILE_FLAG_SEQUENTIAL_SCAN or FILE_FLAG_NO_PREFIX) then
		begin
//			AddError(OldFileName, OldFile.ErrorCode);
			goto LClose;
		end;
	end
	else
		OldFile.SeekBegin;

	CompareBytes := OldFileSize;
	repeat
		ReadBytes := DefFileBuffer;
		if ReadBytes > CompareBytes then
		begin
			ReadBytes := CompareBytes;
{			BufNew[(ReadBytes - 1) div 4] := 0;
			BufOld[(ReadBytes - 1) div 4] := 0;}
		end;
		if not NewFile.BlockRead(BufNew^, ReadBytes) then
		begin
//			AddError(NewFileName, NewFile.ErrorCode);
			goto LClose;
		end;
		if not OldFile.BlockRead(BufOld^, ReadBytes) then
		begin
//			AddError(OldFileName, OldFile.ErrorCode);
			goto LClose;
		end;
		Dec(CompareBytes, ReadBytes);

		if SameData(BufNew, BufOld, ReadBytes) = False then goto LClose;
	until CompareBytes = 0;
	Result := True;

	LClose:
	if Assigned(OldFile) then
	begin
		OldFile.Close;
		FreeAndNil(OldFile);
	end;
	if Assigned(NewFile) then
	begin
		NewFile.Close;
		FreeAndNil(NewFile);
	end;

	T := TimeDifference(GetTickCount, T);
	AddLog('Same ' + FalseTrue[SG(Result)] + ' ' + MsToStr(T, diSD, 3, False) + ' ' + NewFileName + '; ' + OldFileName);
end;

{$ifdef Thread}
constructor TSearch.Create;
begin
	FreeOnTerminate := True;
	inherited Create(False);
end;
{$endif}

procedure {$ifdef Thread}TSearch.{$endif}UpdateListViewSameFiles;
begin
	fMain.DViewS.RowCount := SameCount;
end;

procedure {$ifdef Thread}TSearch.{$endif}UpdateListViewSortFolders;
begin
	fMain.PanelSort.Caption := NToS(FolderCount);
	fMain.DViewSortFolders.RowCount := FolderCount;
end;

{$ifdef Thread}
procedure TSearch.Execute;
{$else}
procedure RunSearch;
{$endif}

	procedure SubDir(Dir: ShortString);
	label EndSubProc, EndSelect;
	var
		SearchRec: TSearchRec; // 344
		DirFil: Word;
		SameFile: Integer;
		i: SG;
		ErrorCode: Integer;

		NewSize: Integer;
		ActFileSize: U8;
		NewChecksum: LongWord;
		B: Boolean;

		FileSiz: SG;
		BufSiz: SG;
	begin
		Inc(Sub);
		DirFil := 0;

		if Sub = 2 then
		begin
			DirSect := DirCount + FilSect;
			DirSize := FilSize;
		end;
		if Sub > MaxSub then
		begin
			MaxSub := Sub;
			fMain.PanelNSD.Caption := NToS(MaxSub - 1);
			fMain.PanelFolderLevel.Caption := NToS(Sub);
			fMain.EditFolderLevelName.Text := Dir;
		end;

		fMain.EditSD.Text := Dir;

		ErrorCode := FindFirst(Dir + '*.*',
			faReadOnly or faHidden or faSysFile or faDirectory or faArchive, SearchRec);
		while ErrorCode = 0 do
		begin
			if (SearchRec.Attr and faDirectory) <> 0 then
			begin
				if (SearchRec.Name <> '.') and (SearchRec.Name <> '..') then
				begin
					Inc(DirFil);
					Inc(DirCount);
					if SwitchSubDirs = True then
					begin
						SubDir(Dir + SearchRec.Name + PathDelim);
					end;
				end;
				goto EndSelect;
			end;
			if SwitchIllegal or SwitchDOSNames then
			begin
				OldName := Dir + SearchRec.Name;
				if (SearchRec.Attr and faDirectory) <> 0 then
					OldName := OldName + PathDelim;
				NewName := GoodName(OldName);
				if OldName <> NewName then
				begin
					NewSize := BadNameCount + 1;
					if AllocByExp(Length(BadNames), NewSize) then
						SetLength(BadNames, NewSize);

					BadNames[BadNameCount] := OldName;
					Inc(BadNameCount);
					fMain.DViewBadNames.RowCount := BadNameCount;
				end;
			end;
			if fMain.MemoFileTypes.Lines.Count <> 0 then
			begin
				B := False;
				for i := 0 to fMain.MemoFileTypes.Lines.Count - 1 do
				begin
					if (LowerCase(ExtractFileExt(SearchRec.Name)) =
						'.' + LowerCase(fMain.MemoFileTypes.Lines.Strings[i])) then
					begin
						B := True;
						Break;
					end;
				end;
				if B = False then goto EndSelect;
			end;
			TU8(ActFileSize).D0 := SearchRec.FindData.nFileSizeLow;
			TU8(ActFileSize).D1 := SearchRec.FindData.nFileSizeHigh;
			Inc(DirFil);
			Inc(FilCount);
			Inc(FilSize, ActFileSize);
			if SwitchAccess then
			begin
				AssignFile(TmpFile, Dir + SearchRec.Name);
				FileMode := 0; Reset(TmpFile, 1);
				ErrorCode := IOResult;
				if SwitchRead then
				if ErrorCode = 0 then
				begin
					FileSiz := FileSize(TmpFile);
					while FileSiz > 0 do
					begin
						BufSiz := FileSiz;
						if BufSiz > DefFileBuffer then BufSiz := DefFileBuffer;
						Dec(FileSiz, BufSiz);
						BlockRead(TmpFile, BufNew^, BufSiz);
						ErrorCode := IOResult;
						if ErrorCode <> 0 then
						begin
							Break;
						end;
					end;
				end;
				CloseFile(TmpFile);
				IOResult;
				if ErrorCode <> 0 then
					AddError(Dir + SearchRec.Name, ErrorCode);
			end;
			if (SearchRec.FindData.nFileSizeLow = 0) and (SearchRec.FindData.nFileSizeHigh = 0) then
			begin
				if SwitchEF = True then
				begin
					Inc(EFCount);
					fMain.ListBoxEF.Lines.Add(Dir + SearchRec.Name);
				end;
			end
			else
			begin
				Inc(FilSect, ((ActFileSize - 1) shr GShrCluster) + 1);
				if ActFileSize < MinFile then
				begin
					MinFile := ActFileSize;
					fMain.EditSmallestFileName.Text := Dir + SearchRec.Name;
					fMain.PanelSmallestFileSize.Caption := BToStr(MinFile);
				end;
				if ActFileSize > MaxFile then
				begin
					MaxFile := ActFileSize;
					fMain.EditLargestFileName.Text := Dir + SearchRec.Name;
					fMain.PanelLargestFileSize.Caption := BToStr(MaxFile);
				end;
				if SwitchSF = True then
				begin
					NewChecksum := ChecksumNone;
					for SameFile := 0 to SameFileCount - 1 do
					begin
						if (ASameFile[SameFile].Size = ActFileSize)
						and ((SwitchDT = True) or (ASameFile[SameFile].Time = SearchRec.Time) ) then
						begin
							if CompareFiles(
								Dir + SearchRec.Name,
								ASameFile[SameFile].Name,
								NewChecksum,
								ASameFile[SameFile].Checksum,
								ActFileSize,
								ASameFile[SameFile].Size) then
							begin
								if ASameFile[SameFile].List = -1 then
								begin // New 2 files
									ASameFile[SameFile].List := SameCount + 1;
									NewSize := SameCount + 2;
									if AllocByExp(Length(ASame), NewSize) then
										SetLength(ASame, NewSize);

									InsertPos := SameCount;
									ASame[InsertPos].Group := SameGroupCount;

									ASame[InsertPos].FileSize := ActFileSize;
									ASame[InsertPos].Filename := ASameFile[SameFile].Name;
									ASame[InsertPos].Deleted := False;
									Inc(SameCount);

									InsertPos := SameCount;
									ASame[InsertPos].Group := SameGroupCount;

									ASame[InsertPos].FileSize := -1;
									ASame[InsertPos].FileName := Dir + SearchRec.Name;
									ASame[InsertPos].Deleted := False;

									Inc(SameCount);

									NewSize := SameGroupCount + 1;
									if AllocByExp(Length(SameGroup), NewSize) then
										SetLength(SameGroup, NewSize);
									SameGroup[SameGroupCount] := 2;
									Inc(SameGroupCount);

								end
								else
								begin // Add 1 file for 2 or more files
									NewSize := SameCount + 1;
									if AllocByExp(Length(ASame), NewSize) then
										SetLength(ASame, NewSize);

									InsertPos := ASameFile[SameFile].List + 1;
									for i := SameCount downto InsertPos + 1 do
										ASame[i] := ASame[i - 1];
									ASame[InsertPos].Group := ASame[InsertPos - 1].Group;
									Inc(SameGroup[ASame[InsertPos].Group]);
									ASame[InsertPos].FileSize := -1;
									ASame[InsertPos].Filename := Dir + SearchRec.Name;
									ASame[InsertPos].Deleted := False;

									for i := 0 to SameFileCount - 1 do
									begin
										if ASameFile[i].List > ASameFile[SameFile].List then
										begin
											Inc(ASameFile[i].List);
										end;
									end;
									ASameFile[SameFile].List := InsertPos;
									Inc(SameCount);
								end;
								Inc(SFCount);
								Inc(NumSSame, ((ActFileSize - 1) div GCluster) + 1);
								{$ifdef Thread}
								Synchronize(UpdateListViewSameFiles);
								{$else}
								UpdateListViewSameFiles;
								{$endif}
								goto EndSelect; // Same file found
							end;
						end;
					end;
					// Same file not found - add new
					NewSize := SameFileCount + 1;
					if AllocByExp(Length(ASameFile), NewSize) then
						SetLength(ASameFile, NewSize);
					ASameFile[SameFileCount].Name := Dir + SearchRec.Name;
					ASameFile[SameFileCount].Size := ActFileSize;
					ASameFile[SameFileCount].Checksum := NewChecksum;
					ASameFile[SameFileCount].Time := SearchRec.Time;
					ASameFile[SameFileCount].List := -1;
					Inc(SameFileCount);
				end;
			end;
			EndSelect:
			if (Where = whStop) or (Where = whClose) then goto EndSubProc;
			ErrorCode := FindNext(SearchRec);
		end;
		if ErrorCode <> ERROR_NO_MORE_FILES then
		begin
			AddError(Dir, ErrorCode);
		end
		else
		begin
			if (SwitchED = True) and (DirFil = 0) then
			begin
				Inc(EDCount);
				fMain.ListBoxED.Lines.Add(Dir);
			end;
		end;
		{$ifndef Thread}
		Application.ProcessMessages;
		{$endif}
		EndSubProc:
		FindClose(SearchRec);

		if (Sub = 2) and (SwitchSort) then
		begin
			NewSize := FolderCount + 1;
			if AllocByExp(Length(Folders), NewSize) then
					SetLength(Folders, NewSize);
			Folders[FolderCount].Folder := Dir;
			Folders[FolderCount].Sectors := GCluster * U8(DirCount + FilSect - DirSect);
			Folders[FolderCount].Size := FilSize - DirSize;

			Inc(FolderCount);

			{$ifdef Thread}
			Synchronize(UpDateListViewSortFolders);
			{$else}
			UpDateListViewSortFolders;
			{$endif}
		end;

		fMain.Initi;

		Dec(Sub);
	end;

var
	Par: Byte;
	S: string;
	i: SG;
begin
	try
		SwitchSubDirs := fMain.ButtonSubfolders.Down;
		SwitchSF := fMain.ButtonESF.Down;
		SwitchDT := fMain.ButtonDT.Down;
		SwitchEF := fMain.ButtonEEF.Down;
		SwitchED := fMain.ButtonEED.Down;
		SwitchSort := fMain.ButtonSort.Down;
		SwitchAccess := fMain.ButtonAccess.Down;
		SwitchRead := fMain.ButtonRead.Down;
		SwitchDOSNames := fMain.ButtonDOSNames.Down;
		SwitchIllegal := fMain.ButtonIllegal.Down;

		STime := GetTickCount;

		for Par := 0 to fMain.MemoAd.Lines.Count - 1 do
		begin
			S := fMain.MemoAD.Lines.Strings[Par];
			RemoveComment(S);
			if (S = '') then Continue;
			Inc(DirCount);
			GCluster := 0;
			for i := 0 to Length(Drives) - 1 do
			begin
				if Drives[i].DriveLetter = S[1] then
					GCluster := Drives[i].ClusterSize;
			end;
			if GCluster = 0 then GCluster := 4096;
			if fMain.ButtonSC.Down = True then
			begin
				GCluster := StrToValI(fMain.ComboBoxC.Text, True, 0, GCluster, 64 * KB, 1);
			end;
			GShrCluster := CalcShr(GCluster);
			if LastChar(S) = PathDelim then
			begin
				SubDir(S);
			end
			else
			begin
				SubDir(S + PathDelim);
			end;
		end;

	finally
		SetLength(ASameFile, 0); SameFileCount := 0;
		Inc(ProcessCount);
		fMain.PanelProcessCount.Caption := NToS(ProcessCount);
		Inc(ProcessTime, TimeDifference(GetTickCount, STime));
		fMain.PanelProcessTime.Caption := MsToStr(ProcessTime, diHMSD, 3, False);

		{$ifndef Thread}
		if Where = whClose then
		begin
			Where := whNone;
			fMain.Close;
		end
		else
		begin
			Where := whNone;
		end;
		fMain.InitButtons;
		EndLongOperation(Where = whStart);
		{$else}
		if (Where = whStart) and fMain.ButtonBeep.Down then
		begin
			PlayWinSound(wsAsterisk);
		end;
		{$endif}
	end;
end;

initialization
{$ifopt d+}
	CheckExpSize(SizeOf(TSame));
	CheckExpSize(SizeOf(TFolder));
	CheckExpSize(SizeOf(TSameFile));
{$endif}
	GetMem(BufNew, DefFileBuffer);
	GetMem(BufOld, DefFileBuffer);
finalization
	FreeMem(BufOld);
	FreeMem(BufNew);
end.
