// * File:     CXY\ufOverview.pas
// * Created:  2009-12-29
// * Modified: 2010-01-09
// * Version:  2.2.47.104
// * Author:   David Safranek (Safrad)
// * E-Mail:   safrad at email.cz
// * Web:      http://safrad.own.cz

unit ufOverview;

interface

uses
	uTypes, uDForm,
	Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
	Dialogs, uDWinControl, uDImage;

type
	TfOverview = class(TDForm)
		Image: TDImage;
		procedure FormCreate(Sender: TObject);
		procedure ImageMouseMove(Sender: TObject; Shift: TShiftState; X,
			Y: Integer);
		procedure ImageMouseWheel(Sender: TObject; Shift: TShiftState;
			WheelDelta: Integer; MousePos: TPoint; var Handled: Boolean);
		procedure ImageFill(Sender: TObject);
		procedure FormDestroy(Sender: TObject);
		procedure FormResize(Sender: TObject);
		procedure FormHide(Sender: TObject);
		procedure ImageMouseDown(Sender: TObject; Button: TMouseButton;
			Shift: TShiftState; X, Y: Integer);
		procedure FormShow(Sender: TObject);
		procedure ImageDblClick(Sender: TObject);
		procedure ImageMouseUp(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X,
			Y: Integer);
	private
		{ Private declarations }
		Hand: BG;
		StartUserMouse: TPoint;
		StartOffset: TPoint;
		procedure RWOptions(const Save: BG);
		procedure Scroll;
		procedure InitHand;
	public
		{ Public declarations }
	end;

var
	fOverview: TfOverview;

implementation

{$R *.dfm}
uses
	uDIniFile,
	uDBitmap,
	uGraph,
	uDrawStyle,
	uDelayedCall,
	uProject,
	uMain;

procedure TfOverview.FormCreate(Sender: TObject);
begin
	Background := baNone;
	RWOptions(False);
	Image.LockZoom := True;
	Image.DisplayMode := dmFitImage;
end;

procedure TfOverview.ImageMouseMove(Sender: TObject; Shift: TShiftState;
	X, Y: Integer);
begin
	if not (ssShift in Shift) then
		if Image.MouseL then
		begin
			if Hand then
				fMain.ImageP.ScrollTo(
					Round(StartOffset.X +fMain.ImageP.Zoom * (Image.UserMouse.X - StartUserMouse.X)),
					Round(StartOffset.Y + fMain.ImageP.Zoom * (Image.UserMouse.Y - StartUserMouse.Y)))
			else
				Scroll;
		end
		else
		begin
			InitHand;
		end;
end;

procedure TfOverview.ImageMouseUp(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X,
	Y: Integer);
begin
//  InitHand;
end;

procedure TfOverview.ImageMouseWheel(Sender: TObject; Shift: TShiftState;
	WheelDelta: Integer; MousePos: TPoint; var Handled: Boolean);
begin
	fMain.ImageP.DoMouseWheel(Shift, WheelDelta, MousePos);
	Handled := False;
end;

procedure TfOverview.RWOptions(const Save: BG);
begin
	MainIni.RWFormPos(Self, Save);
end;

procedure TfOverview.ImageDblClick(Sender: TObject);
begin
		Image.Cursor := crHandPoint;
end;

procedure TfOverview.ImageFill(Sender: TObject);
var
	DisplayedArea: TRect;
begin
//	if (fMain.OpenedFiles.Index < 0) or (Project.Bitmap = nil) then Exit;
	if fMain.ImageP.UserBitmap = nil then
	begin
		Image.Bitmap.Bar(clAppWorkSpace, ef16);
		Exit;
	end;
	DisplayedArea := fMain.ImageP.GetDisplayedArea;
	Image.Bitmap.Border(Image.GetPosX(DisplayedArea.Left), Image.GetPosY(DisplayedArea.Top),
		Image.GetPosX(DisplayedArea.Right) - 1, Image.GetPosY(DisplayedArea.Bottom) - 1,
		clWhite, clWhite, 1, efNeg);
	InitHand;
end;

procedure TfOverview.FormDestroy(Sender: TObject);
begin
	RWOptions(True);
end;

procedure TfOverview.FormResize(Sender: TObject);
begin
	Image.FitImage;
end;

procedure TfOverview.FormShow(Sender: TObject);
begin
	if not Assigned(Project) then
	begin
		Image.UserBitmap := nil;
		Image.UserArea := Rect(0, 0, 0, 0);
	end
	else
	begin
		Image.UserBitmap := Project.Bitmap;
		Image.UserArea := Project.Margin;
	end;
end;

procedure TfOverview.FormHide(Sender: TObject);
begin
	fMain.Overview1.Checked := False;
end;

procedure TfOverview.ImageMouseDown(Sender: TObject; Button: TMouseButton;
	Shift: TShiftState; X, Y: Integer);
begin
	if Button = mbLeft then
	begin
		if not (ssShift in Shift) then
			if not Hand then
			begin
				Scroll;
				DelayedCall(0);
//				InitHand;
			end
			else
			begin
				StartUserMouse := Image.UserMouse;
				StartOffset := fMain.ImageP.GetOffset;
			end;
	end;
end;

procedure TfOverview.Scroll;
begin
	if Image.MouseWhere = mwScroll then
		fMain.ImageP.ScrollTo(
			Round(fMain.ImageP.Zoom * (Image.UserMouse.X - fMain.ImageP.SW / 2)),
			Round(fMain.ImageP.Zoom * (Image.UserMouse.Y - fMain.ImageP.SH / 2)));
end;

procedure TfOverview.InitHand;
var
	DR: TRect;
begin
	DR := fMain.ImageP.GetDisplayedArea;
	if Over(Image.UserMouse, DR) then
	begin
		Hand := True;
		Image.AreaCursor := crHandPoint;
	end
	else
	begin
		Hand := False;
		Image.AreaCursor := crDefault;
	end;
end;

end.
