// * File:     CXY\ufLayers.pas
// * Created:  2009-12-29
// * Modified: 2010-02-10
// * Version:  2.2.47.104
// * Author:   David Safranek (Safrad)
// * E-Mail:   safrad at email.cz
// * Web:      http://safrad.own.cz

unit ufLayers;

interface

uses
	uTypes,
	Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
	Dialogs, StdCtrls;

type
	TfLayers = class(TForm)
		CheckBoxPreview: TCheckBox;
		CheckBoxObjects: TCheckBox;
		procedure FormShow(Sender: TObject);
		procedure CheckBoxImageClick(Sender: TObject);
		procedure FormDestroy(Sender: TObject);
		procedure FormCreate(Sender: TObject);
		procedure FormHide(Sender: TObject);
	private
		{ Private declarations }
		procedure RWOptions(const Save: BG);
	public
		{ Public declarations }
		procedure Init;
	end;

var
	fLayers: TfLayers;

implementation

uses
	uProject,
	uDictionary,
	uMain, uDIniFile;

{$R *.dfm}

procedure TfLayers.FormShow(Sender: TObject);
begin
//  CheckBoxImage.Checked :=
end;

procedure TfLayers.CheckBoxImageClick(Sender: TObject);
begin
	if Assigned(Project) then
		Project.Layers[TImageLayer(TCheckBox(Sender).Tag)] := TCheckBox(Sender).Checked;
	fMain.UpdateImage;
end;

procedure TfLayers.RWOptions(const Save: BG);
begin
	MainIni.RWFormPos(Self, Save);
end;

procedure TfLayers.FormDestroy(Sender: TObject);
begin
	RWOptions(True);
end;

procedure TfLayers.FormCreate(Sender: TObject);
begin
	Dictionary.TranslateForm(Self);
	RWOptions(False);
end;

procedure TfLayers.FormHide(Sender: TObject);
begin
	fMain.Layers1.Checked := False;
end;

procedure TfLayers.Init;
begin
	if Assigned(Project) then
	begin
		CheckBoxPreview.Enabled := True;
		CheckBoxObjects.Enabled := True;
		CheckBoxPreview.Checked := Project.Layers[ilPreview];
		CheckBoxObjects.Checked := Project.Layers[ilObjects];
//		Enabled := True;
	end
	else
	begin
		CheckBoxPreview.Checked := False;
		CheckBoxObjects.Checked := True;
		CheckBoxPreview.Enabled := False;
		CheckBoxObjects.Enabled := False;
//		Enabled := False;
	end;
end;

end.
