// * File:     CXY\uFunctions.pas
// * Created:  1998-02-01
// * Modified: 2010-01-10
// * Version:  2.2.47.104
// * Author:   David Safranek (Safrad)
// * E-Mail:   safrad at email.cz
// * Web:      http://safrad.own.cz

unit uFunctions;

interface

uses
	uTypes,
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
	StdCtrls, ComCtrls, ExtCtrls, uDGauge, uDButton, uDLabel, uDForm,
	uDImage, uDEdit, uDWinControl, uNumericComboBox;

type
	TfFunctions = class(TDForm)
		PageControl1: TPageControl;
		TabSheetResize: TTabSheet;
		GroupBoxX: TGroupBox;
		ComboBoxX1: TNumericComboBox;
		RadioButtonX1: TRadioButton;
		RadioButtonX2: TRadioButton;
		RadioButtonX3: TRadioButton;
		ComboBoxX2: TNumericComboBox;
		RadioButtonX4: TRadioButton;
		PanelX4: TDLabel;
		PanelX1: TDLabel;
		PanelX2: TDLabel;
		GroupBoxY: TGroupBox;
		RadioButtonY1: TRadioButton;
		RadioButtonY2: TRadioButton;
		RadioButtonY3: TRadioButton;
		ComboBoxY1: TNumericComboBox;
		ComboBoxY2: TNumericComboBox;
		RadioButtonY4: TRadioButton;
		PanelY4: TDLabel;
		PanelY1: TDLabel;
		PanelY2: TDLabel;
		TabSheetColors: TTabSheet;
		GroupBoxContr: TGroupBox;
		ComboBoxContrast: TNumericComboBox;
		TabSheetMemory: TTabSheet;
		GroupBoxMemory: TGroupBox;
		PanelU: TDLabel;
		PanelR: TDLabel;
		PanelBU: TDLabel;
		PanelBN: TDLabel;
		PanelBR: TDLabel;
		TabSheetGenRGB: TTabSheet;
		GroupBoxF: TGroupBox;
		GroupBoxC: TGroupBox;
		PanelC0: TDButton;
		PanelC1: TDButton;
		PanelC2: TDButton;
		PanelC3: TDButton;
		GroupBoxA: TGroupBox;
		ComboBoxGamma: TNumericComboBox;
		TabSheetRotate: TTabSheet;
		TrackBarRotate: TTrackBar;
		ClearUndo: TDButton;
		ClearRedo: TDButton;
		ComboBoxApply: TComboBox;
		ComboBoxFunction: TComboBox;
		TabSheetRandom: TTabSheet;
		GroupBox3: TGroupBox;
		Label1: TDLabel;
		Label2: TDLabel;
		Label3: TDLabel;
		TrackBarR: TTrackBar;
		TrackBarG: TTrackBar;
		TrackBarB: TTrackBar;
		TrackBarBW: TTrackBar;
		Label6: TDLabel;
		EditRandSeed: TDEdit;
		PanelRC: TDButton;
		PanelXB: TDLabel;
		PanelYB: TDLabel;
		PanelBU1: TDLabel;
		PanelBN1: TDLabel;
		PanelBR1: TDLabel;
		TabSheetGBlur: TTabSheet;
		LabelRadius: TLabel;
		TabSheetBorder: TTabSheet;
		GroupBoxEffect: TGroupBox;
		ComboBoxEffect: TComboBox;
		GroupBoxLines: TGroupBox;
		TrackBarBorder: TTrackBar;
		LabelGamma: TLabel;
		TabSheetBW: TTabSheet;
		GroupBoxBW: TGroupBox;
		LabelBW: TLabel;
		ComboBoxBW: TNumericComboBox;
		LabelCont: TLabel;
		DLabel1: TDLabel;
		DLabel2: TDLabel;
		TabSheetBar: TTabSheet;
		GroupBoxBarEffect: TGroupBox;
		ComboBoxBarEffect: TComboBox;
		PanelBarColor: TDButton;
		LabelRot: TLabel;
		ComboBoxBrightness: TNumericComboBox;
		LabelBrig: TLabel;
		PanelPreview: TPanel;
		ImagePreview: TDImage;
		ComboBoxRotateStyle: TComboBox;
		UseRandomColor: TDButton;
		ButtonRandomize: TDButton;
		ButtonR: TDButton;
		ButtonG: TDButton;
		ButtonB: TDButton;
		TabSheetBmp: TTabSheet;
		GroupBox1: TGroupBox;
		ComboBoxBmpEffect: TComboBox;
		GroupBox4: TGroupBox;
		ComboBoxFromBitmap: TComboBox;
		TabSheetChangeColor: TTabSheet;
		PanelTo: TDButton;
		PanelFrom: TDButton;
		TabSheetMirror: TTabSheet;
		ButtonMH: TDButton;
		ButtonMV: TDButton;
		ComboBoxBlurRadius: TNumericComboBox;
		TabSheetLens: TTabSheet;
		ComboBoxOthers: TComboBox;
		ComboBoxMinZoom: TNumericComboBox;
		ComboBoxMaxZoom: TNumericComboBox;
		TabSheetSGL: TTabSheet;
		ButtonCreate: TDButton;
		ButtonFree: TDButton;
		ButtonBegin: TDButton;
		ButtonEnd: TDButton;
		ButtonClear: TDButton;
		ComboBoxSGL: TComboBox;
		ButtonTest4: TDButton;
		ButtonCircle: TDButton;
		ButtonEllipse: TDButton;
		ButtonArc: TDButton;
		ButtonTest1A: TDButton;
		ButtonTest1B: TDButton;
		ButtonTest1C: TDButton;
		ComboBoxPrec: TComboBox;
		ButtonTest1D: TDButton;
		ButtonTest2A: TDButton;
		ButtonTest3: TDButton;
		ButtonTest2: TDButton;
		ButtonTest1: TDButton;
		ButtonTest2B: TDButton;
		ButtonTest2C: TDButton;
		ButtonTest2D: TDButton;
		ButtonColor: TDButton;
		ButtonFlat: TDButton;
		DButtonTest3A: TDButton;
		ComboBoxBlurDirection: TComboBox;
		LabelDirection: TLabel;
		LabelAlgorithm: TLabel;
		ComboBoxBlurAlgorithm: TComboBox;
		ButtonTest3B: TDButton;
		ButtonTest3C: TDButton;
		ButtonTest3D: TDButton;
		ButtonTest4A: TDButton;
		ButtonTest4B: TDButton;
		ButtonTest4C: TDButton;
		ButtonTest4D: TDButton;
		ButtonTest4E: TDButton;
		ButtonTest4F: TDButton;
		ButtonTest5: TDButton;
		ButtonTest5A: TDButton;
		ButtonTest5B: TDButton;
		ButtonTest5C: TDButton;
		ButtonTest5D: TDButton;
		ButtonTest5E: TDButton;
		ButtonTest5F: TDButton;
		ButtonTest: TDButton;
		LabelAngle: TLabel;
		LabelIntensity: TLabel;
		ComboBoxAngle: TNumericComboBox;
		ComboBoxIntensity: TNumericComboBox;
		procedure RadioButtonXYClick(Sender: TObject);
		procedure PanelC0Click(Sender: TObject);
		procedure PageControl1Change(Sender: TObject);
		procedure ClearUndoClick(Sender: TObject);
		procedure ClearRedoClick(Sender: TObject);
		procedure TrackBarRotateChange(Sender: TObject);
		procedure FormCreate(Sender: TObject);
		procedure FormClose(Sender: TObject; var Action: TCloseAction);
		procedure TrackBarBWChange(Sender: TObject);
		procedure PanelRCClick(Sender: TObject);
		procedure TrackBarRChange(Sender: TObject);
		procedure ComboBoxBCGChange(Sender: TObject);
		procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
		procedure ImagePreviewFill(Sender: TObject);
		procedure ButtonCreateClick(Sender: TObject);
		procedure ButtonBeginClick(Sender: TObject);
		procedure ButtonEndClick(Sender: TObject);
		procedure ButtonFreeClick(Sender: TObject);
		procedure ButtonClearClick(Sender: TObject);
		procedure ButtonTest4Click(Sender: TObject);
		procedure ButtonTest1AClick(Sender: TObject);
		procedure ButtonTest1BClick(Sender: TObject);
		procedure ButtonTest1CClick(Sender: TObject);
		procedure ComboBoxPrecChange(Sender: TObject);
		procedure ButtonTest1DClick(Sender: TObject);
		procedure ButtonTest2AClick(Sender: TObject);
		procedure ButtonTest3Click(Sender: TObject);
		procedure ButtonTest1Click(Sender: TObject);
		procedure ButtonTest2Click(Sender: TObject);
		procedure ButtonTest2BClick(Sender: TObject);
		procedure ButtonTest2CClick(Sender: TObject);
		procedure ButtonTest2DClick(Sender: TObject);
		procedure ButtonColorClick(Sender: TObject);
		procedure ButtonFlatClick(Sender: TObject);
		procedure DButtonTest3AClick(Sender: TObject);
		procedure ButtonTest3BClick(Sender: TObject);
		procedure ButtonTest3CClick(Sender: TObject);
		procedure ButtonTest3DClick(Sender: TObject);
		procedure ButtonTest4AClick(Sender: TObject);
		procedure ButtonTest4BClick(Sender: TObject);
		procedure ButtonTest4CClick(Sender: TObject);
		procedure ButtonTest4DClick(Sender: TObject);
		procedure ButtonTest4EClick(Sender: TObject);
		procedure ButtonTest4FClick(Sender: TObject);
		procedure ButtonTest5Click(Sender: TObject);
		procedure ButtonTest5AClick(Sender: TObject);
		procedure ButtonTest5BClick(Sender: TObject);
		procedure ButtonTest5CClick(Sender: TObject);
		procedure ButtonTest5DClick(Sender: TObject);
		procedure ButtonTest5EClick(Sender: TObject);
		procedure ButtonTest5FClick(Sender: TObject);
		procedure ButtonTestClick(Sender: TObject);
		procedure ComboBoxBlurAlgorithmChange(Sender: TObject);
		procedure ComboBoxBlurRadiusChange(Sender: TObject);
		procedure ComboBoxBlurDirectionChange(Sender: TObject);
		procedure ComboBoxAngleChange(Sender: TObject);
		procedure ComboBoxIntensityChange(Sender: TObject);
		procedure TabSheetBmpShow(Sender: TObject);
	private
		{ Private declarations }
		procedure GeneratePreview;
	public
		{ Public declarations }
	// Clrs Params
		ColorR, ColorG, ColorB: BG;

		//
		Brig, Cont, Gamma: SG;

//		ThreadsCount: SG;
		procedure ShowResize;
		procedure RWOptions(const Save: Boolean);
	end;

var
	fFunctions: TfFunctions;

implementation

{$R *.DFM}

uses
	Math,
	uGraph, uOpenedFiles, uGColor, uDIniFile, uDBitmap, uInputFormat, uSGL, uMsg, uMenus, uSysInfo,
	uDictionary, uOptions, ufOptions, uUndoRedo,
	uFiles, uOutputFormat, uMath, uSystem, uStrings, uColor, uParserMsg, uDrawStyle,
	uMain, uFunc, uProject;

procedure TfFunctions.ShowResize;
var
	L: U8;
	SX, SY: UG;
	X1, Y1: UG;
	X2, Y2: U8;
	X3, Y3: U8;
begin
	if (fMain.OpenedFiles.Index < 0) or (Project.Bitmap = nil) then
	begin
		SX := Screen.Width;
		SY := Screen.Height;
	end
	else
	begin
		SX := Project.Bitmap.Width;
		SY := Project.Bitmap.Height;
		// FreeAndNil(fMain.BmpSource2);
	end;
	PanelXB.Caption := NToS(SX);
	PanelYB.Caption := NToS(SY);

	ComboBoxX1.Miminum := 1;
	ComboBoxX1.Default := SX;
	ComboBoxX1.Maximum := MaxBitmapWidth;
	X1 := ComboBoxX1.RoundedValue;
	ComboBoxY1.Miminum := 1;
	ComboBoxY1.Default := SY;
	ComboBoxY1.Maximum := MaxBitmapHeight;
	Y1 := ComboBoxY1.RoundedValue;
	ComboBoxX2.Miminum := 1;
	ComboBoxX2.Default := SX;
	ComboBoxX2.Maximum := MaxBitmapWidth;
	X2 := Round(100 * ComboBoxX2.Value);
	ComboBoxY2.Miminum := 1;
	ComboBoxY2.Default := SY;
	ComboBoxY2.Maximum := MaxBitmapHeight;
	Y2 := Round(100 * ComboBoxY2.Value);
	if SY <> 0 then
		X3 := RoundDivS8(U8(SX) * NewSY, SY)
	else
		X3 := 0;
	if SX <> 0 then
		Y3 := RoundDivS8(U8(SY) * NewSX, SX)
	else
		Y3 := 0;

	NewSX := SX;
	NewSY := SY;
	if RadioButtonX1.Checked then
	begin
		NewSX := X1;
	end
	else if RadioButtonX2.Checked then
	begin
		NewSX := RoundDivS8(100 * SX, X2);
	end
	else if RadioButtonX3.Checked then
	begin
		NewSX := SX;
	end
	else if (RadioButtonX4.Checked = True) then
	begin
		NewSX := X3;
	end;

	if RadioButtonY1.Checked then
	begin
		NewSY := Y1;
	end
	else if RadioButtonY2.Checked then
	begin
		NewSY := RoundDivS8(100 * SY, Y2);
	end
	else if RadioButtonY3.Checked then
	begin
		NewSY := SY;
	end
	else if (RadioButtonY4.Checked = True) then
	begin
		NewSY := Y3;
	end;

	PanelX4.Caption := NToS(X3);
	PanelY4.Caption := NToS(Y3);

	L := RoundDivS8(100 * U8(SX), X1);
	PanelX1.Caption := NToS(L, 2);

	L := RoundDivS8(100 * U8(SY), Y1);
	PanelY1.Caption := NToS(L, 2);

	L := RoundDivS8(100 * U8(SX), X2);
	PanelX2.Caption := NToS(L);

	L := RoundDivS8(100 * U8(SY), Y2);
	PanelY2.Caption := NToS(L);

end;

procedure TfFunctions.RadioButtonXYClick(Sender: TObject);
begin
	ShowResize;
end;

var
	PanelC: TDButton;

procedure OnApply(Color: TColor);
begin
	PanelC.Color := Color;
	InitButton(PanelC);
end;

procedure TfFunctions.PanelC0Click(Sender: TObject);
var
	C: TColor;
begin
	PanelC := TDButton(Sender);
	C := PanelC.Color;
	GetColor('Color', C, clSilver, OnApply);
end;

procedure TfFunctions.PageControl1Change(Sender: TObject);
begin
	fMain.InitMenu;
end;

procedure TfFunctions.ClearUndoClick(Sender: TObject);
begin
	fMain.ClearUndo1Click(Sender);
end;


procedure TfFunctions.ClearRedoClick(Sender: TObject);
begin
	fMain.ClearRedo1Click(Sender);
end;

procedure TfFunctions.TrackBarRotateChange(Sender: TObject);
begin
	LabelRot.Caption := NToS(TrackBarRotate.Position);
end;

procedure TfFunctions.RWOptions(const Save: Boolean);
var
	Section: string;
begin
	PageControl1.ActivePageIndex := MainIni.RWSGF('Options', 'ActivePage',
		PageControl1.ActivePageIndex, 0, Save);

	TrackBarRotate.Position := MainIni.RWSGF('Rotate', 'Angle', TrackBarRotate.Position, 0, Save);
	MainIni.RWComboBox('Rotate', ComboBoxRotateStyle, Save);

	Section := 'RGB';
	MainIni.RWComboBox(Section, ComboBoxFunction, Save);
	MainIni.RWComboBox(Section, ComboBoxApply, Save);
	TrackBarR.Position := MainIni.RWSGF(Section, 'RandomRed', TrackBarR.Position, 0, Save);
	TrackBarG.Position := MainIni.RWSGF(Section, 'RandomGreen', TrackBarG.Position, 0, Save);
	TrackBarB.Position := MainIni.RWSGF(Section, 'RandomBlue', TrackBarB.Position, 0, Save);
	PanelC0.Color := MainIni.RWSGF(Section, 'Color0', PanelC0.Color, PanelC0.Color, Save);
	PanelC1.Color := MainIni.RWSGF(Section, 'Color1', PanelC1.Color, PanelC1.Color, Save);
	PanelC2.Color := MainIni.RWSGF(Section, 'Color2', PanelC2.Color, PanelC2.Color, Save);
	PanelC3.Color := MainIni.RWSGF(Section, 'Color3', PanelC3.Color, PanelC3.Color, Save);
	if Save = False then
	begin
		InitButton(PanelC0);
		InitButton(PanelC1);
		InitButton(PanelC2);
		InitButton(PanelC3);
	end;

	MainIni.RWComboBox('Resize', ComboBoxX1, Save);
	MainIni.RWComboBox('Resize', ComboBoxX2, Save);
	MainIni.RWComboBox('Resize', ComboBoxY1, Save);
	MainIni.RWComboBox('Resize', ComboBoxY2, Save);

	Section := 'Colors';
	MainIni.RWComboBox(Section, ComboBoxBrightness, Save);
	MainIni.RWComboBox(Section, ComboBoxContrast, Save);
	MainIni.RWComboBox(Section, ComboBoxGamma, Save);
	MainIni.RWComboBox(Section, ComboBoxBW, Save);
	ButtonR.Down := MainIni.RWBGF(Section, 'R', ButtonR.Down, True, Save);
	ButtonG.Down := MainIni.RWBGF(Section, 'G', ButtonG.Down, True, Save);
	ButtonB.Down := MainIni.RWBGF(Section, 'B', ButtonB.Down, True, Save);

	MainIni.RWComboBox('Border', ComboBoxEffect, Save);
	TrackBarBorder.Position := MainIni.RWSGF('Border', 'Lines', TrackBarBorder.Position, 4, Save);

	MainIni.RWComboBox('Bar', ComboBoxBarEffect, Save);
	PanelBarColor.Color := MainIni.RWSGF('Bar', 'Color', PanelBarColor.Color, clWhite, Save);
	MainIni.RWComboBox('Bmp', ComboBoxBmpEffect, Save);
	InitButton(PanelBarColor);

	PanelFrom.Color := MainIni.RWSGF('ChangeColor', 'From', PanelFrom.Color, PanelFrom.Color, Save);
	PanelTo.Color := MainIni.RWSGF('ChangeColor', 'To', PanelTo.Color, PanelTo.Color, Save);
	InitButton(PanelFrom);
	InitButton(PanelTo);

	// GBlur
	Section := 'Blur';
	MainIni.RWComboBox(Section, ComboBoxBlurAlgorithm, Save);
	MainIni.RWComboBox(Section, ComboBoxBlurRadius, Save);
	MainIni.RWComboBox(Section, ComboBoxBlurDirection, Save);
	MainIni.RWComboBox(Section, ComboBoxIntensity, Save);
	MainIni.RWComboBox(Section, ComboBoxAngle, Save);

	// Lens
	Section := 'Lens';
	MainIni.RWComboBox(Section, ComboBoxOthers, Save);
	MainIni.RWComboBox(Section, ComboBoxMinZoom, Save);
	MainIni.RWComboBox(Section, ComboBoxMaxZoom, Save);

	MainIni.RWComboBox('SGL', ComboBoxSGL, Save);

{	MainIni.RWCheckBox('Options', CheckBoxThreads, Save);
	MainIni.RWComboBox('Options', ComboBoxThreads, Save);
	ComboBoxThreadsChange(Self);}
//	MainIni.RWCheckBox('Options', CheckBoxPreview, Save);

	MainIni.RWFormPos(Self, Save);
end;

procedure TfFunctions.FormCreate(Sender: TObject);
var
	i: SG;
	f: FG;
begin
	Background := baGradient;

	ComboBoxSGL.DropDownCount := Length(sglEElementNames);
	StringArrayToStrings(sglEElementNames, ComboBoxSGL.Items);
	ComboBoxSGL.ItemIndex := 0;

	StringArrayToStrings(GenFuncNames, ComboBoxFunction.Items);
	ComboBoxFunction.ItemIndex := 0;

	StringArrayToStrings(EffectNames, ComboBoxEffect.Items);
	ComboBoxEffect.DropDownCount := Length(EffectNames);
	StringArrayToStrings(EffectNames, ComboBoxApply.Items);
	ComboBoxApply.DropDownCount := Length(EffectNames);
	StringArrayToStrings(EffectNames, ComboBoxBmpEffect.Items);
	ComboBoxBmpEffect.DropDownCount := Length(EffectNames);
	StringArrayToStrings(EffectNames, ComboBoxBarEffect.Items);
	ComboBoxBarEffect.DropDownCount := Length(EffectNames);

	ComboBoxBlurRadius.Items.BeginUpdate;
	try
		ComboBoxBlurRadius.Items.Add(FToS(0.7));
		ComboBoxBlurRadius.Items.Add(FToS(1));
		ComboBoxBlurRadius.Items.Add(FToS(2));
		ComboBoxBlurRadius.Items.Add(FToS(3));
		ComboBoxBlurRadius.Items.Add(FToS(4));
		ComboBoxBlurRadius.Items.Add(FToS(8));
		ComboBoxBlurRadius.Items.Add(FToS(16));
		ComboBoxBlurRadius.Items.Add(FToS(32));
		ComboBoxBlurRadius.Items.Add(FToS(64));
		ComboBoxBlurRadius.DropDownCount := ComboBoxBlurRadius.Items.Count;
	finally
		ComboBoxBlurRadius.Items.EndUpdate;
	end;

	ComboBoxRotateStyle.Items.BeginUpdate;
	try
		for i := 0 to MaxTyp do
		begin
			ComboBoxRotateStyle.Items.Add(NToS(i));
		end;
	finally
		ComboBoxRotateStyle.Items.EndUpdate;
	end;

	ComboBoxBrightness.Items.BeginUpdate;
	try
		f := -256 + 32;
		for i := 1 to 15 do
		begin
			ComboBoxBrightness.Items.Add(FToS(f));
			f := f + 32;
		end;
	finally
		ComboBoxBrightness.Items.EndUpdate;
	end;

	ComboBoxContrast.Items.BeginUpdate;
	try
		f := 0.125;
		for i := 1 to 8 do
		begin
			ComboBoxContrast.Items.Add(FToS(f));
			ComboBoxContrast.Items.Add(FToS(f * 1.5));
			f := f * 2;
		end;
	finally
		ComboBoxContrast.Items.EndUpdate;
	end;

	ComboBoxGamma.Items.BeginUpdate;
	try
		f := 0.125;
		for i := 1 to 8 do
		begin
			ComboBoxGamma.Items.Add(FToS(f));
			ComboBoxGamma.Items.Add(FToS(f * 1.5));
			f := f * 2;
		end;
	finally
		ComboBoxGamma.Items.EndUpdate;
	end;

	try
		ComboBoxX2.Items.BeginUpdate;
		ComboBoxY2.Items.BeginUpdate;
		f := 0.5;
		for i := 1 to 8 do
		begin
			ComboBoxX2.Items.Add(FToS(f));
			ComboBoxY2.Items.Add(FToS(f));
			f := f * 2;
		end;
		ComboBoxX2.ItemIndex := 2;
		ComboBoxY2.ItemIndex := 2;
	finally
		ComboBoxX2.Items.EndUpdate;
		ComboBoxY2.Items.EndUpdate;
	end;

	ComboBoxX1.Items.BeginUpdate;
	try
		ComboBoxX1.Items.Add(NToS(320));
		ComboBoxX1.Items.Add(NToS(640));
		ComboBoxX1.Items.Add(NToS(800));
		ComboBoxX1.Items.Add(NToS(1024));
		ComboBoxX1.Items.Add(NToS(1152));
		ComboBoxX1.Items.Add(NToS(1280));
		ComboBoxX1.Items.Add(NToS(1600));
		ComboBoxX1.Items.Add(NToS(2048));
		ComboBoxX1.ItemIndex := 3;
	finally
		ComboBoxX1.Items.EndUpdate;
	end;

	ComboBoxY1.Items.BeginUpdate;
	try
		ComboBoxY1.Items.Add(NToS(240));
		ComboBoxY1.Items.Add(NToS(480));
		ComboBoxY1.Items.Add(NToS(600));
		ComboBoxY1.Items.Add(NToS(768));
		ComboBoxY1.Items.Add(NToS(864));
		ComboBoxY1.Items.Add(NToS(1024));
		ComboBoxY1.Items.Add(NToS(1200));
		ComboBoxY1.Items.Add(NToS(1536));
		ComboBoxY1.ItemIndex := 3;
	finally
		ComboBoxY1.Items.EndUpdate;
	end;

{	CheckBoxThreads.Caption := Translate('Automatically') + CharSpace + '(' + NToS
		(GSysInfo.LogicalProcessorCount) + ')';

	ComboBoxThreads.Items.BeginUpdate;
	try
		ComboBoxThreads.Items.Add(NToS(1));
		ComboBoxThreads.Items.Add(NToS(2));
		ComboBoxThreads.Items.Add(NToS(3));
		ComboBoxThreads.Items.Add(NToS(4));
		ComboBoxThreads.Items.Add(NToS(8));
		ComboBoxThreads.Items.Add(NToS(16));
		ComboBoxThreads.Items.Add(NToS(32));
		ComboBoxThreads.Items.Add(NToS(64));
		ComboBoxThreads.DropDownCount := ComboBoxThreads.Items.Count;
	finally
		ComboBoxThreads.Items.EndUpdate;
	end;}

	LabelBW.Caption := '[-255..0..256]' + LineSep + '-255: Absolute colors' + LineSep +
		'0: No change' + LineSep + '256: Gray colors';

{$IFDEF RealMotionBlur}
(*//	PageControl1.ActivePage := TabSheetRealMotionBlur;
	for i := 0 to PageControl1.PageCount - 1 do
	begin
//		if PageControl1.Pages[i] <> TabSheetRealMotionBlur then
{$IFOPT d+}
			if PageControl1.Pages[i] <> TabSheetGBlur then
{$ENDIF}
//				if PageControl1.Pages[i] <> TabSheetMemory then
//			PageControl1.Pages[i].TabVisible := False;

//PageControl1.Style := tsFlatButtons;
	end;
	PageControl1.ActivePage := TabSheetGBlur;
	*)
{$ENDIF}
	RWOptions(False);
//	CheckBoxThreads.OnClick(Sender);
	ComboBoxBCGChange(Sender);
	ComboBoxBlurAlgorithmChange(Sender);
	ShowResize;
	Dictionary.TranslateForm(Self);
end;

procedure TfFunctions.FormClose(Sender: TObject; var Action: TCloseAction);
begin
	fMain.Functions1.Checked := False;
	UpdateIcons(fMain.MainMenu1, fMain.PanelTool);
end;

procedure TfFunctions.TabSheetBmpShow(Sender: TObject);
var
	i, j: SG;
begin
	j := fFunctions.ComboBoxFromBitmap.ItemIndex;
	ComboBoxFromBitmap.Items.BeginUpdate;
	try
		ComboBoxFromBitmap.Items.Clear;
		for i := 0 to fMain.OpenedFiles.Count - 1 do
		begin
			ComboBoxFromBitmap.Items.Add(ExtractFileName(fMain.OpenedFiles.GetItem(i).FileName));
		end;
		ComboBoxFromBitmap.ItemIndex := j;
	finally
		ComboBoxFromBitmap.Items.EndUpdate;
	end;
end;

procedure TfFunctions.TrackBarBWChange(Sender: TObject);
var
	C: TRGBA;
begin
	TrackBarR.Position := TrackBarBW.Position;
	TrackBarG.Position := TrackBarBW.Position;
	TrackBarB.Position := TrackBarBW.Position;
	C.R := TrackBarR.Position;
	C.G := TrackBarG.Position;
	C.B := TrackBarB.Position;
	C.A := 0;
	PanelRC.Color := C.L;
	InitButton(PanelRC);
end;

procedure TfFunctions.PanelRCClick(Sender: TObject);
begin
	PanelC0Click(Sender);
	TrackBarR.Position := TRGBA(PanelRC.Color).R;
	TrackBarG.Position := TRGBA(PanelRC.Color).G;
	TrackBarB.Position := TRGBA(PanelRC.Color).B;
end;

procedure TfFunctions.TrackBarRChange(Sender: TObject);
var
	C: TRGBA;
begin
	C.R := TrackBarR.Position;
	C.G := TrackBarG.Position;
	C.B := TrackBarB.Position;
	C.A := 0;
	PanelRC.Color := C.L;
	InitButton(PanelRC);
end;

procedure TfFunctions.ComboBoxBCGChange(Sender: TObject);
{var
	Messages: TParserMessages;}
begin
{	Messages := TParserMessages.Create;
	try
		Messages.Clear;
		Brig := StrToValI(ComboBoxBrightness.Text, True, -255, Brig, 255, 1, Messages);
		SetDesign(ComboBoxBrightness, Messages);
		Messages.Clear;
		Cont := StrToValI(ComboBoxContrast.Text, True, 0, Cont, 255 * 256, 256, Messages);
		SetDesign(ComboBoxContrast, Messages);
		Messages.Clear;
		Gamma := StrToValI(ComboBoxGamma.Text, True, 1, Gamma, 255 * 256, 256, Messages);
		SetDesign(ComboBoxGamma, Messages);
	finally
		Messages.Free;
	end;}
	Brig := ComboBoxBrightness.RoundedValue;
	Cont := RoundSG(256 * ComboBoxContrast.Value);
	Gamma := RoundSG(256 * ComboBoxGamma.Value);
	ImagePreview.Invalidate;
end;

procedure TfFunctions.ComboBoxBlurAlgorithmChange(Sender: TObject);
var
	B: BG;
begin
	{ LabelAngle.Enabled := ComboBoxGBlurH.ItemIndex = 3;
		ComboBoxAngle.Enabled := ComboBoxGBlurH.ItemIndex = 3; }
	if ComboBoxBlurAlgorithm.ItemIndex = 0 then
		LabelRadius.Caption := Translate('&Steps')
	else
		LabelRadius.Caption := Translate('&Radius');
	B := ComboBoxBlurAlgorithm.ItemIndex < 3;
	LabelRadius.Enabled := B;
	ComboBoxBlurRadius.Enabled := B;
	LabelDirection.Enabled := B;
	ComboBoxBlurDirection.Enabled := B;
	B := ComboBoxBlurAlgorithm.ItemIndex = 3;
	LabelAngle.Enabled := B;
	ComboBoxAngle.Enabled := B;
	LabelIntensity.Enabled := B;
	ComboBoxIntensity.Enabled := B;
	GeneratePreview;
end;

procedure TfFunctions.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
	RWOptions(True);
end;

procedure TfFunctions.ImagePreviewFill(Sender: TObject);
var
	x, y: Integer;
	B: TDBitmap;
	C: TRGBA;
begin
	B := ImagePreview.Bitmap;
	B.Bar(clWindow, ef16);
	for x := 0 to B.Width - 1 do
	begin
		y := GetColors(256 * x div Integer(B.Width), Brig, Cont, Gamma);
		C.L := clWindowText;
		Pix(B.Data, B.ByteX, x, Integer(B.Height) - 1 - Integer(B.Height) * y div 256, @C, ef08);
	end;
end;

// SGL
var
	Id: SG;
	Tim: U8;

procedure TfFunctions.ButtonCreateClick(Sender: TObject);
var
	Bmp: TDBitmap;
begin
	if fMain.OpenedFiles.Index >= 0 then
	begin
		Bmp := Project.Bitmap;
		Id := sglCreateDrawable(Bmp.Width, Bmp.Height, Bmp.Data);
		sglSetDrawable(Id);
		{ sglEnableClipping(sglTrue);
			sglClipRectangle(
			Pict.GroupX1,
			Pict.GroupY2,
			Pict.GroupX2 - Pict.GroupX1 + 1,
			Pict.GroupY2 - Pict.GroupY1 + 1); }
		// sglOrtho2D(0, Bmp.Width, 0, Bmp.Height);
		// sglViewport(0, 0, Bmp.Width, Bmp.Height);

		sglLoadIdentity();
	end;
end;

procedure TfFunctions.ButtonBeginClick(Sender: TObject);
begin
	sglBegin(sglEElementType(ComboBoxSGL.ItemIndex));
end;

procedure TfFunctions.ButtonEndClick(Sender: TObject);
begin
	fMain.CreateUndo('sglEnd', TMyBitmapUndo);
	sglEnd;
	ButtonBegin.Down := False;
	fMain.UpdateImage;
end;

procedure TfFunctions.ButtonFreeClick(Sender: TObject);
begin
	sglDestroyDrawable(Id);
	Id := -1;
	if sglErrorCount > 0 then
		ErrorMsg(sglGetErrorStrings);
end;

procedure TfFunctions.ButtonClearClick(Sender: TObject);
begin
	fMain.CreateUndo('sglClear', TMyBitmapUndo);
	sglClear(0, 0, 0, $FF);
	fMain.UpdateImage;
end;

procedure CreateScene(Name: string; x, y: SG);
var
	Bmp: TDBitmap;
begin
	BeginLongOperation;
	NewX := -x;
	NewY := -y;
	// OpenedFiles.New1.Click;
	// OpenedFiles.Items[OpenedFiles.Index].FileName := Name;
	fMain.OpenedFiles.OpenedFileNewFile(nil, Name);

	Bmp := Project.Bitmap;
	Id := sglCreateDrawable(Bmp.Width, Bmp.Height, Bmp.Data);
	sglSetDrawable(Id);
	// sglEnableClipping(sglTrue);
	{ sglClipRectangle(Pict.GroupX1, Pict.GroupY1,
		Pict.GroupX2 - Pict.GroupX1 + 1,
		Pict.GroupY2 - Pict.GroupY1 + 1); }
	// sglClipRectangle(Bmp.Width div 4, Bmp.Height div 4, Bmp.Width div 2, Bmp.Height div 2);
	Tim := PerformanceCounter;
end;

procedure FreeScene;
begin
	Tim := PerformanceCounter - Tim;
	Project.OperationTime := Tim;

	fMain.ImageP.Invalidate;
	fMain.InitMenu;
	sglDestroyDrawable(Id);
	if sglErrorCount > 0 then
		ErrorMsg(sglGetErrorStrings);
	EndLongOperation;
end;

procedure TfFunctions.ButtonTest1Click(Sender: TObject);
var
	i: SG;
	W, H: SG;
begin
	W := fMain.ImageP.Width;
	H := fMain.ImageP.Height;
	CreateScene('Test 1', W, H);
	try
		sglColor($FF, 0, 0);
		sglAreaMode(SGL_AREA_MODE_BORDER);
		sglClear(0, 0, 0, 1);
		sglViewport(0, 0, W, H);
		sglMatrixMode(sglModelMatrix);
		sglLoadIdentity();

		{ sglBegin(sglPoints);
			sglVertex(500, 200, 1);
			sglVertex(510, 200, 1);
			sglVertex(520, 210, 1);
			sglEnd;

			sglBegin(sglLines);
			sglVertex(500, 200, 1);
			sglVertex(510, 200, 1);
			sglVertex(0, 0, 1);
			sglVertex(200, 100, 1);
			sglEnd; }

		// sglBegin(sglLines);
		// sglBegin(sglLineStrip);
		// sglBegin(sglLineLoop);
		// sglBegin(sglTriangles);
		// sglViewPort(50, 50, 80, 80);
		sglOrtho2D(-300, 1500, -100, 1500 * H / W);

		// sglRotate(90, 500, 500);
		sglBegin(sglTriangleStrip);
		{ sglBegin(sglTriangleFan); }

		sglVertex(500, 200, 1);
		sglVertex(510, 200, 1);
		sglVertex(0, 0, 1);
		sglVertex(200, 100, 1);
		sglVertex(300, 300, 1);
		sglVertex(200, 400, 1);
		sglEnd;

		sglBegin(sglTriangleFan);
		sglVertex(300, 300, 1);
		for i := 0 to 15 do
		begin
			sglColor($FF, 00, 00, 16 * i);
			sglVertex(300 + 200 * Sin(2 * pi * i / 16), 300 + 200 * Cos(2 * pi * i / 16), 1);
		end;
		sglEnd;

		sglCircle(300, 300, 250);
		sglCircle(300, 300, 300);

		sglCircle(0, 0, 7.5);

		sglEllipse(0, 0, 5, 3.5);
	finally
		FreeScene;
	end;
end;

procedure TfFunctions.ButtonTest1AClick(Sender: TObject);
/// //////////////////////////////////////////////////
// Test 1A: kresleni car a trojuhelniku.           //
// Verze: 22.3.2005 16:15                          //
// (predpokladana velikost okna 1200 x 400 pixelu) //
// _drawable = sglCreateDrawable(1200, 400);       //
/// //////////////////////////////////////////////////
var
	x, y, angle, radius1, radius2: Double;
	i: SG;
const
	deg2rad = pi / 180.0;
	Count = 15;

	delta = 360.0 / Count;

begin
	CreateScene('Test 1A', 1200, 400);
	try
		sglColor($FF, 0, 0);
		sglAreaMode(SGL_AREA_MODE_BORDER);

		sglClear(0, 0, 0, 0);

		sglOrtho2D(-11.5, 11.5, -11.5, 11.5);

		sglMatrixMode(sglModelMatrix);
		sglLoadIdentity();

		sglViewport(0, 0, 400, 400);

		// Nakresli hvezdu o count vrcholech.

		radius1 := 3.25;
		radius2 := 10.0;
		angle := 0.0;

		sglBegin(sglLineLoop);
		for i := 0 to Count - 1 do
		begin

			x := Cos(angle * deg2rad);
			y := Sin(angle * deg2rad);
			sglColor(DarkerColor(SpectrumColor(i * MaxSpectrum div Count)));
			sglVertex(radius1 * x, radius1 * y, 1.0);

			x := Cos((angle + 0.5 * delta) * deg2rad);
			y := Sin((angle + 0.5 * delta) * deg2rad);
			sglColor(SpectrumColor(i * MaxSpectrum div Count));
			sglVertex(radius2 * x, radius2 * y, 1.0);

			angle := angle + delta;
		end;
		sglEnd();

		sglViewport(400, 0, 400, 400);

		// Nakresli hvezdu vzniklou otocenim car.

		for i := 0 to Count - 1 do
		begin

			sglBegin(sglLines);
			sglColor(255 * (i + 1) div Count, 255 * (i + 1) div Count, 255 * (i + 1) div Count);
			// sglColor(0, $7f, $ff);
			sglVertex(-10.0, 0.0, 1.0);
			// sglColor($3f, $ff, 00);
			sglColor(255, 255, 0);
			sglVertex(10.0, 0.0, 1.0);
			sglEnd();

			sglRotate(delta, 0.0, 0.0);
		end;

		sglViewport(800, 0, 400, 400);

		// Vykresleni ruzne velkych trojuhelniku.

		sglLoadIdentity();
		sglTranslate(0, 1.5);
		sglPushMatrix();

		radius1 := 0.8;

		for i := 0 to Count - 1 do
		begin

			sglPopMatrix();
			sglPushMatrix();

			radius2 := radius1 * (i + 1);
			sglScale(radius2, radius2);

			sglBegin(sglTriangles);
			sglColor($FF, $FF, $00);
			sglVertex(Cos(-90 * deg2rad), Sin(-90 * deg2rad), 1.0);
			sglColor($00, $FF, $FF);
			sglVertex(Cos(30 * deg2rad), Sin(30 * deg2rad), 1.0);
			sglColor($FF, $00, $FF);
			sglVertex(Cos(150 * deg2rad), Sin(150 * deg2rad), 1.0);
			sglEnd();
		end;

		/// //////////////////////////////////////////////////
		// Test 1A: konec testu.                           //
		/// //////////////////////////////////////////////////
	finally
		FreeScene;
	end;
end;

procedure TfFunctions.ButtonTest1BClick(Sender: TObject);
/// //////////////////////////////////////////////////
// Test 1B: kresleni kruznic.                      //
// Verze: 22.3.2005 16:15                          //
// (predpokladana velikost okna 1200 x 400 pixelu) //
// _drawable = sglCreateDrawable(1200, 400);       //
/// //////////////////////////////////////////////////
var
	radius1: Double;
	i, Count: SG;
	delta: Double;

begin
	CreateScene('Test 1B', 1200, 400);
	try
		sglColor($FF, 0, 0);
		sglAreaMode(SGL_AREA_MODE_BORDER);
		sglClear(0, 0, 0, 0);

		sglOrtho2D(-11.5, 11.5, -11.5, 11.5);

		sglMatrixMode(sglModelMatrix);

		sglViewport(0, 0, 400, 400);

		// Kresleni kruznic deformovanych zmenou meritka.
		radius1 := 10.0;
		Count := 10;

		sglCircle(0.0, 0.0, radius1);

		for i := 0 to Count - 1 do
		begin
			sglLoadIdentity();
			sglScale((i + 1) / Count, (Count - i) / Count);

			sglCircle(0.0, 0.0, radius1);
		end;

		Count := 8;

		sglViewport(400, 0, 400, 400);

		// Kresleni otocenych kruznic.

		sglLoadIdentity();

		radius1 := 4.25;

		delta := 360.0 / Count;

		for i := 0 to Count - 1 do
		begin

			sglCircle(radius1, 0, radius1);

			sglRotate(delta, 0.0, 0.0);
		end;

		sglViewport(800, 0, 400, 400);

		// Kresleni soustrednych kruznic.

		sglLoadIdentity();
		sglPushMatrix();

		radius1 := 0.5;
		Count := 20;

		for i := 0 to Count - 1 do
		begin
			sglPopMatrix();
			sglPushMatrix();

			sglScale(i + 1, i + 1);

			sglCircle(0, 0, radius1);
		end;

		/// //////////////////////////////////////////////////
		// Test 1B: konec testu.                           //
		/// //////////////////////////////////////////////////
	finally
		FreeScene;
	end;
end;

procedure TfFunctions.ButtonTest1CClick(Sender: TObject);
/// ///////////////////////////////////////////////////
// Test 1C: kresleni elips.                         //
// Verze: 22.3.2005 16:15                          //
// (predpokladana velikost okna 1000 x 1000 pixelu) //
// _drawable = sglCreateDrawable(1000, 1000);       //
/// ///////////////////////////////////////////////////
var
	radius1, radius2, delta: Double;
	i, Count: SG;
begin
	CreateScene('Test 1C', 1000, 1000);
	try
		sglColor($FF, 0, 0);
		sglAreaMode(SGL_AREA_MODE_BORDER);
		sglClear(0, 0, 0, 0);

		sglOrtho2D(-11.5, 11.5, -11.5, 11.5);

		sglMatrixMode(sglModelMatrix);

		sglViewport(0, 0, 500, 500);

		// Kresleni otocenych elips deformovanych zmenou meritka.

		Count := 10;

		radius1 := 6.25;
		radius2 := 2.5;

		for i := 0 to Count - 1 do
		begin

			sglLoadIdentity();
			sglScale(0.25 * (i + 1), 1);
			sglRotate(55, 0.0, 0.0);

			sglEllipse(0.0, 0.0, radius1, radius2);
		end;

		Count := 4;
		delta := 360.0 / Count;

		sglViewport(500, 0, 500, 500);

		// Kresleni otocenych elips.

		sglLoadIdentity();

		radius1 := 8.25;
		radius2 := 2.5;

		for i := 0 to Count - 1 do
		begin
			sglEllipse(0, 0, radius1, radius2);

			sglRotate(delta / 2, 0.0, 0.0);
		end;

		sglViewport(0, 500, 500, 500);

		// Kresleni soustrednych elips.

		sglLoadIdentity();
		sglPushMatrix();

		radius1 := 0.625;
		radius2 := 1.0;
		Count := 10;

		for i := 0 to Count - 1 do
		begin
			sglEllipse(0, 0, radius1, radius2);

			sglPopMatrix();
			sglPushMatrix();

			sglScale(i + 2, i + 2);
		end;

		sglViewport(500, 500, 500, 500);

		// Kresleni deformovanych elips.

		radius1 := 6.25;
		radius2 := 2.5;
		Count := 5;
		delta := 360.0 / Count;

		sglLoadIdentity();
		sglPushMatrix();

		for i := 0 to Count - 1 do
		begin
			sglRotate(delta * i, 0.0, 0.0);
			sglScale(0.25 * (i + 1), 1);
			sglRotate(35, 0.0, 0.0);

			sglEllipse(0.0, 0.0, radius1, radius2);

			sglPopMatrix();
			sglPushMatrix();
		end;

		/// //////////////////////////////////////////////////
		// Test 1C: konec testu.                           //
		/// //////////////////////////////////////////////////
	finally
		FreeScene;
	end;
end;

procedure TfFunctions.ComboBoxPrecChange(Sender: TObject);
begin
	sglPrecision := StrToValE(ComboBoxPrec.Text, True, -MaxInt, 0.5, MaxInt);
end;

{procedure TfFunctions.ComboBoxThreadsChange(Sender: TObject);
var
	Messages: TParserMessages;
begin
	Messages := TParserMessages.Create;
	try
		ThreadsCount := StrToValI(ComboBoxThreads.Text, True, 1, GSysInfo.LogicalProcessorCount, 64, 1,
			Messages);

		SetDesign(ComboBoxThreads, Messages);
	finally
		Messages.Free;
	end;
end;}

procedure TfFunctions.ButtonTest1DClick(Sender: TObject);
var
	radius1: Double;
	angle, delta: Double;
	i, j, Count: SG;
begin
	CreateScene('Test 1D', 1000, 500);
	try
		sglColor($FF, 0, 0);

		/// //////////////////////////////////////////////////
		// Test 1D: kresleni kruhovych oblouku.            //
		// Verze: 29.3.2005 14:30                          //
		// (predpokladana velikost okna 1000 x 500 pixelu) //
		// _drawable = sglCreateDrawable(1000, 500);       //
		/// //////////////////////////////////////////////////

		sglAreaMode(SGL_AREA_MODE_BORDER);
		sglClear(0, 0, 0, 0);

		sglOrtho2D(-11.5, 11.5, -11.5, 11.5);

		sglMatrixMode(sglModelMatrix);
		sglLoadIdentity();

		sglViewport(0, 0, 500, 500);

		// Kresleni kruhovych oblouku deformovanych zmenou meritka.

		radius1 := 10.0;
		Count := 10;

		delta := 360.0 / Count;

		angle := 0.0;
		for j := 0 to Count - 1 do
		begin
			sglArc(0.0, 0.0, radius1, angle, angle + delta);
			angle := angle + delta;
		end;

		for i := 0 to Count - 1 do
		begin
			sglLoadIdentity();
			sglScale((i + 1) / Count, (Count - i) / Count);

			angle := 0.0;
			for j := 0 to Count - 1 do
			begin
				sglArc(0.0, 0.0, radius1, angle, angle + delta);
				angle := angle + delta;
			end;
		end;

		Count := 8;

		sglViewport(0, 0, 1000, 500);
		sglOrtho2D(-11.5, 23.0 + 11.5, -11.5, 11.5);


		// Kresleni otocenych kruznic slozenych z kruhovych oblouku.

		sglLoadIdentity();

		radius1 := 4.25;

		delta := 360.0 / Count;

		sglTranslate(23.0, 0.0);

		for i := 0 to Count - 1 do
		begin
			angle := 0.0;
			for j := 0 to Count - 1 do
			begin
				sglArc(5.0, 0.0, radius1, angle, angle + delta);
				angle := angle + delta;
			end;

			sglRotate(delta, 0.0, 0.0);
		end;

		/// //////////////////////////////////////////////////
		// Test 1D: konec testu.                           //
		/// //////////////////////////////////////////////////
	finally
		FreeScene;
	end;
end;

procedure TfFunctions.ButtonTest2Click(Sender: TObject);
var
	i: SG;
begin
	CreateScene('Test 2', 1200, 800);
	try
		sglColor($FF, $FF, 0);
		sglClear(0, 0, 0, 0);

		sglOrtho2D(0, 10, 0, 10);

		sglBegin(sglBezierCCurve);
		sglColor($FF, 0, $FF);
		sglVertex(2, 5);
		sglColor(0, $FF, $FF);
		sglVertex(3, 6);
		sglColor($FF, $FF, 0);
		sglVertex(4, 6);
		sglColor($FF, $FF, $FF);
		sglVertex(5, 5);
		sglEnd;

		// sglScale(2, 2);
		for i := 0 to 15 do
		begin
			sglBegin(sglFergusonCurve);
			sglVertex(6, 5, 1);
			sglVertex(10 * Sin(2 * pi * i / 16), 10 * Cos(2 * pi * i / 16), 1);
			sglVertex(8, 5, 1);
			sglVertex(1, -10, 1);
			sglEnd;
		end;
		sglBegin(sglLines);
		sglVertex(0, 5);
		sglVertex(10, 5);
		sglVertex(6, 0);
		sglVertex(6, 10);
		sglEnd;
	finally
		FreeScene;
	end;
end;

procedure TfFunctions.ButtonTest2AClick(Sender: TObject);
const
	Count = 10;
var
	delta: Double;
	i: SG;
begin
	CreateScene('Test 2A', 1000, 1000);
	try
		sglColor($FF, $FF, 0);
		/// ///////////////////////////////////////////////////
		// Test 2A: kresleni krivek.                        //
		// Verze: 12.4.2005 15:00                           //
		// (predpokladana velikost okna 1000 x 1000 pixelu) //
		// _drawable = sglCreateDrawable(1000, 1000);       //
		/// ///////////////////////////////////////////////////

		sglClear(0, 0, 0, 0);

		sglOrtho2D(0.0, 20.0, 0.0, 20.0);

		sglViewport(0, 0, 1000, 1000);

		sglMatrixMode(sglModelMatrix);

		delta := 360.0 / Count;

		// Kresleni otocenych Bezierovych kubik.

		sglLoadIdentity();
		sglTranslate(5.0, 5.0);

		for i := 0 to Count - 1 do
		begin
			sglBegin(sglBezierCCurve);

			// prvni kubika
			sglVertex(-4, 0, 1);
			sglVertex(-3, -1, 1);
			sglVertex(-1, -1, 1);
			sglVertex(0, 0, 1);
			// druha kubika
			sglVertex(0, 0, 1);
			sglVertex(1, 1, 1);
			sglVertex(3, 1, 1);
			sglVertex(4, 0, 1);

			sglEnd();

			sglRotate(delta / 2, 0.0, 0.0);
		end;

		// Kresleni otocenych Bezierovych krivek n-teho radu.

		sglLoadIdentity();
		sglTranslate(15.0, 5.0);

		for i := 0 to Count - 1 do
		begin
			sglBegin(sglBezierGCurve);

			sglVertex(-4, 0, 1);
			sglVertex(-3, -1, 1);
			sglVertex(-1, -1, 1);
			sglVertex(0, 0, 1);
			sglVertex(1, 1, 1);
			sglVertex(3, 1, 1);
			sglVertex(4, 0, 1);

			sglEnd();

			sglRotate(delta / 2, 0.0, 0.0);
		end;

		// Kresleni otocenych Coonsovych splinu.

		sglLoadIdentity();
		sglTranslate(5.0, 15.0);

		for i := 0 to Count - 1 do
		begin
			sglBegin(sglCoonsSpline);

			sglVertex(-4, 0, 1);
			sglVertex(-3, -1, 1);
			sglVertex(-1, -1, 1);
			sglVertex(0, 0, 1);
			sglVertex(0, 0, 1);
			sglVertex(0, 0, 1);
			sglVertex(1, 1, 1);
			sglVertex(3, 1, 1);
			sglVertex(4, 0, 1);

			sglEnd();

			sglRotate(delta / 2, 0.0, 0.0);
		end;

		// Kresleni otocenych Fergusonvych kubik.
		sglLoadIdentity();
		sglTranslate(15.0, 15.0);

		for i := 0 to Count - 1 do
		begin
			sglBegin(sglFergusonCurve);

			sglVertex(-4, 0, 1);
			sglVertex(2, -2, 1);

			sglVertex(0, 0, 1);
			sglVertex(2, 2, 1);

			{ sglVertex(0, 0, 1);
				sglVertex(2, 2, 1); }

			sglVertex(4, 0, 1);
			sglVertex(2, -2, 1);

			sglEnd();
			sglRotate(delta / 2, 0.0, 0.0);
		end;

		/// //////////////////////////////////////////////////
		// Test 2A: konec testu.                           //
		/// //////////////////////////////////////////////////
	finally
		FreeScene;
	end;
end;

procedure TfFunctions.ButtonTest2BClick(Sender: TObject);
var
	W, H: SG;
	dist, x, y, dx, dy, delta, angle, deg2rad: Double;
	i, j, Count: SG;
begin
	CreateScene('Test 2B', 1000, 1000);
	try
		sglColor($FF, $FF, 0);
		/// ///////////////////////////////////////////////////
		// Test 2B: kresleni Fergusonovych krivek.          //
		// Verze: 12.4.2005 15:00                            //
		// (predpokladana velikost okna 1000 x 1000 pixelu) //
		// _drawable = sglCreateDrawable(1000, 1000);       //
		/// ///////////////////////////////////////////////////

		W := 1000;
		H := 1000;

		sglClear(0, 0, 0, 0);

		sglOrtho2D(-10.0, 10.0, -10.0, 10.0);

		sglMatrixMode(sglModelMatrix);

		deg2rad := pi / 180.0;
		Count := 6;

		delta := deg2rad * 360.0 / (Count * Count);
		dist := 35.0;
		angle := 90.0 * deg2rad; // M_PI / 2.0

		dx := W / Count;
		dy := H / Count;

		// Kresleni Fergusonovy kubiky (otaceni tecny v 2.bode).

		sglLoadIdentity();
		sglTranslate(-3.0, 0.0);
		sglRotate(15.0, 0.0, 0.0);

		for j := 0 to Count - 1 do
		begin
			for i := 0 to Count - 1 do
			begin
				sglViewport(Round(i * dx), Round(j * dy), Round(dx), Round(dy));

				sglBegin(sglFergusonCurve);

				sglVertex(-6, 0, 1);
				sglVertex(0, dist, 1);

				x := dist * Cos(angle);
				y := dist * Sin(angle);

				sglVertex(6, 0, 1);
				sglVertex(x, y, 1);

				sglEnd();

				angle := angle - delta;
			end;
		end;

		/// //////////////////////////////////////////////////
		// Test 2B: konec testu.                           //
		/// //////////////////////////////////////////////////
	finally
		FreeScene;
	end;
end;

procedure TfFunctions.ButtonTest2CClick(Sender: TObject);
var
	W, H: SG;
	dist, x, y, dx, dy, delta, angle, deg2rad: Double;
	i, j, Count: SG;
begin
	CreateScene('Test 2C', 1000, 1000);
	try
		sglColor($FF, $FF, 0);
		/// ///////////////////////////////////////////////////
		// Test 2C: kresleni Bezierovych kubik.             //
		// Verze: 12.4.2005 15:00                            //
		// (predpokladana velikost okna 1000 x 1000 pixelu) //
		// _drawable = sglCreateDrawable(1000, 1000);       //
		/// ///////////////////////////////////////////////////

		W := 1000;
		H := 1000;

		sglClear(0, 0, 0, 0);

		sglOrtho2D(-10.0, 10.0, -10.0, 10.0);

		sglMatrixMode(sglModelMatrix);

		deg2rad := pi / 180.0;
		Count := 6;

		delta := deg2rad * 360.0 / (Count * Count);
		dist := 10.0;
		angle := 90.0 * deg2rad; // M_PI / 2.0

		dx := W / Count;
		dy := H / Count;

		// Kresleni Bezierovy kubiky (otaceni predposledniho bodu okolo posledniho).

		sglLoadIdentity();
		sglTranslate(-3.0, 0.0);
		sglRotate(25.0, 0.0, 0.0);

		for j := 0 to Count - 1 do
		begin
			for i := 0 to Count - 1 do
			begin

				sglViewport(Round(i * dx), Round(j * dy), Round(dx), Round(dy));

				sglBegin(sglBezierCCurve);

				sglVertex(-6, 0, 1);
				sglVertex(0, dist, 1);

				x := dist * Cos(angle) + 6;
				y := dist * Sin(angle);

				sglVertex(x, y, 1);
				sglVertex(6, 0, 1);

				sglEnd();

				angle := angle - delta;
			end;
		end;
		/// //////////////////////////////////////////////////
		// Test 2C: konec testu.                           //
		/// //////////////////////////////////////////////////
	finally
		FreeScene;
	end;
end;

procedure TfFunctions.ButtonTest2DClick(Sender: TObject);
var
	W, H: SG;
	i, j, Count: SG;
	deg2rad, start, d, d0: Double;
	scale, px, py, angle, dx, dy: Double;

begin
	CreateScene('Test 2D', 1200, 800);
	try
		sglColor($FF, $FF, 0);
		/// ///////////////////////////////////////////////////
		// Test 2D: kresleni krivek.                        //
		// Verze: 8.4.2005 15:30                            //
		// (predpokladana velikost okna 1200 x 800 pixelu)  //
		// _drawable = sglCreateDrawable(1200, 800);        //
		/// ///////////////////////////////////////////////////

		W := 1200;
		H := 800;

		Count := 10;
		d0 := 9.5;
		deg2rad := pi / 180.0;

		sglClear(0, 0, 0, 0);

		sglOrtho2D(-5, 25, -0.5, { 9.5 } 12);
		sglViewport(0, 0, W, H div 2);

		sglMatrixMode(sglModelMatrix);
		sglLoadIdentity();

		angle := 15;

		// Kresleni Coonsova kubickeho splinu.

		for j := 0 to 2 do
		begin
			start := 0.5;
			d := d0 / Cos(deg2rad * angle);
			scale := Power(d / start, 1.0 / (Count - 1.0));

			dx := Cos(deg2rad * (90 - angle));
			dy := Sin(deg2rad * (90 - angle));

			sglBegin(sglCoonsSpline);

			sglVertex(0.0, 0.0, 1.0);

			for i := 0 to Count - 1 do
			begin
				px := start * dx;
				py := start * dy;
				sglVertex(px, py, 1);

				px := px * 0.5 * (1.0 + scale); // px = start*0.5*(1+scale)*dx;
				py := py * 0.5 * (1.0 + scale); // py = start*0.5*(1+scale)*dy;
				sglVertex(-px, py, 1);

				start := start * scale;
			end;

			sglEnd();

			sglTranslate(10.0, 0.0);

			angle := angle + 15;
		end;

		sglViewport(0, H div 2, W, H div 2);

		sglMatrixMode(sglModelMatrix);
		sglLoadIdentity();

		angle := 15;

		// Kresleni Bezierovy krivky n-teho radu.

		for j := 0 to 2 do
		begin
			start := 0.5;
			d := d0 / Cos(deg2rad * angle);
			scale := Power(d / start, 1.0 / (Count - 1.0));

			dx := Cos(deg2rad * (90 - angle));
			dy := Sin(deg2rad * (90 - angle));

			sglBegin(sglBezierGCurve);

			sglVertex(0.0, 0.0, 1.0);

			for i := 0 to Count - 1 do
			begin
				px := start * dx;
				py := start * dy;
				sglVertex(px, py, 1);

				px := px * 0.5 * (1.0 + scale); //
				// px := start*0.5*(1+scale)*dx;
				py := py * 0.5 * (1.0 + scale); //
				// py := start*0.5*(1+scale)*dy;
				sglVertex(-px, py, 1);

				start := start * scale;
			end;

			sglEnd();

			sglTranslate(10.0, 0.0);

			angle := angle + 15;
		end;

		/// //////////////////////////////////////////////////
		// Test 2D: konec testu.                           //
		/// //////////////////////////////////////////////////
	finally
		FreeScene;
	end;
end;

{
	type
	TPoint2 = record
	x, y: Double;
	end;

	function To2D(x, y, z: Double): TPoint2;
	begin
	z := z + 2;
	if z < 1 then
	z := 1;
	Result.x := x / z;
	Result.y := y / z;

	end;

	procedure glVertex3f(x, y, z: Double);
	var P: TPoint2;
	begin
	P := To2D(x, y, z);
	sglVertex(P.x, P.y);
	end; }

procedure TfFunctions.ButtonTest3Click(Sender: TObject);
var
	i: SG;
	W, H: SG;
	// C: TRColor;
begin
	{ W := fMain.ImageP.Width;
		H := fMain.ImageP.Height;
		CreateScene('Test 3-0', W, H);
		sglEnableClipping(sglTrue);
		sglClipRectangle(0, 0, 100, fMain.ImageP.Height - 60);
		sglBegin(sglLines);
		sglColor(clYellow);
		sglVertex(5, 5);
		sglColor($00ffff00);
		sglVertex(5, 200);
		sglEnd;
		FreeScene; }

	W := fMain.ImageP.Width;
	H := fMain.ImageP.Height;
	CreateScene('Test 3-1', W, H);
	try
		for i := 0 to H - 1 do
		begin
			sglColor(0, 255 * i div (H - 1), $A0, 255 * i div (H - 1));
			sglBegin(sglLines);
			sglVertex(0, i, 1);
			sglVertex(W - 1, i, 1);
			sglEnd;
		end;

		sglOrtho2D(1, 6, 4, 7);

		sglBegin(sglPolygon);
		sglColor($FF, 0, $FF);
		sglVertex(2, 5);
		sglColor(0, $FF, $FF);
		sglVertex(3, 6);
		sglColor($FF, $FF, 0);
		sglVertex(4, 6);
		sglColor($FF, $FF, $FF);
		sglVertex(5, 5);
		sglEnd;

		{
			sglOrtho2D(-7.5, 7.5, -5, 5);

			C.L := clRed;
			sglColor(C);
			sglBegin(sglPolygon);
			glVertex3f(1.0, 1.0, 1.0);
			glVertex3f(-1.0, 1.0, 1.0);
			glVertex3f(-1.0, -1.0, 1.0);
			glVertex3f(1.0, -1.0, 1.0);
			sglEnd;

			C.L := clWhite;
			sglColor(C);
			sglBegin(sglPolygon);
			glVertex3f(1.0, 1.0, -1.0);
			glVertex3f(1.0, -1.0, -1.0);
			glVertex3f(-1.0, -1.0, -1.0);
			glVertex3f(-1.0, 1.0, -1.0);
			sglEnd;

			C.L := clSilver;
			sglColor(C);
			sglBegin(sglPolygon);
			glVertex3f(-1.0, 1.0, 1.0);
			glVertex3f(-1.0, 1.0, -1.0);
			glVertex3f(-1.0, -1.0, -1.0);
			glVertex3f(-1.0, -1.0, 1.0);
			sglEnd;

			C.L := clBlue;
			sglColor(C);
			sglBegin(sglPolygon);
			glVertex3f(1.0, 1.0, 1.0);
			glVertex3f(1.0, -1.0, 1.0);
			glVertex3f(1.0, -1.0, -1.0);
			glVertex3f(1.0, 1.0, -1.0);
			sglEnd;

			C.L := clRed;
			sglColor(C);
			sglBegin(sglPolygon);
			glVertex3f(-1.0, 1.0, -1.0);
			glVertex3f(-1.0, 1.0, 1.0);
			glVertex3f(1.0, 1.0, 1.0);
			glVertex3f(1.0, 1.0, -1.0);
			sglEnd;

			C.L := clGreen;
			sglColor(C);
			sglBegin(sglPolygon);
			glVertex3f(-1.0, -1.0, -1.0);
			glVertex3f(1.0, -1.0, -1.0);
			glVertex3f(1.0, -1.0, 1.0);
			glVertex3f(-1.0, -1.0, 1.0);
			sglEnd;
			}
	finally
		FreeScene;
	end;
end;

var
	C: TColor = clWhite;

procedure TfFunctions.ButtonColorClick(Sender: TObject);
begin
	if GetColor('SGL Color', C, clWhite, nil) then
		sglColor(TRGBA(C).R, TRGBA(C).G, TRGBA(C).B);
end;

procedure TfFunctions.ButtonFlatClick(Sender: TObject);
begin
	sglShadeModel(not ButtonFlat.Down);
end;

procedure TfFunctions.DButtonTest3AClick(Sender: TObject);
var
	winWidth, winHeight: SG;
	delta: Double;
	W, H, k, L, i, x, y, tiles, Count: SG;
	R, G, B, dr, db: Byte;

begin
	/// ///////////////////////////////////////////////////
	// Test 3A: orezavani krivek.                       //
	// Verze: 3.5.2005 15:00                            //
	// (predpokladana velikost okna 1000 x 1000 pixelu) //
	// _drawable = sglCreateDrawable(1000, 1000);       //
	/// ///////////////////////////////////////////////////

	winWidth := 1000;
	winHeight := 1000;

	CreateScene('Test 3A', winWidth, winHeight);
	try
		sglClear(0, 0, 0, 0);

		sglOrtho2D(0.0, 20.0, 0.0, 20.0);
		sglViewport(0, 0, winWidth, winHeight);

		sglAreaMode(SGL_AREA_MODE_BORDER);
		sglShadeModel(True);

		sglEnableClipping(True);

		sglMatrixMode(sglModelMatrix);

		Count := 30;

		delta := 360.0 / Count;

		tiles := 10;
		W := winWidth div tiles;
		H := winHeight div tiles;
		dr := (255 div tiles);
		db := dr;

		G := 255;
		R := 0;

		y := 0;
		for k := 0 to tiles - 1 do
		begin
			x := 0;
			B := 255;
			for L := 0 to tiles - 1 do
			begin

				sglClipRectangle(x, y, W, H);
				sglColor(R, G, B, 0);

				// Kresleni otocenych Bezierovych kubik.

				sglLoadIdentity();
				sglTranslate(5.0, 5.0);

				for i := 0 to Count - 1 do
				begin

					sglBegin(sglBezierCCurve);

					// 1. kubika
					sglVertex(-4.5, -0.5, 1);
					sglVertex(-5, 0, 1);
					sglVertex(-4.5, 0.5, 1);
					sglVertex(-4, 0, 1);
					// 2. kubika
					sglVertex(-4, 0, 1);
					sglVertex(-3, -1, 1);
					sglVertex(-1, -1, 1);
					sglVertex(0, 0, 1);
					// 3. kubika
					sglVertex(0, 0, 1);
					sglVertex(1, 1, 1);
					sglVertex(3, 1, 1);
					sglVertex(4, 0, 1);
					// 4. kubika
					sglVertex(4, 0, 1);
					sglVertex(4.5, -0.5, 1);
					sglVertex(5, 0, 1);
					sglVertex(4.5, 0.5, 1);

					sglEnd();

					sglRotate(delta / 2, 0.0, 0.0);
				end;

				// Kresleni otocenych Bezierovych krivek n-teho radu.

				sglLoadIdentity();
				sglTranslate(15.0, 5.0);

				for i := 0 to Count - 1 do
				begin

					sglBegin(sglBezierGCurve);

					sglVertex(-4.5, -0.5, 1);
					sglVertex(-5, 0, 1);
					sglVertex(-4.5, 0.5, 1);
					sglVertex(-4, 0, 1);
					sglVertex(-3, -1, 1);
					sglVertex(-1, -1, 1);
					sglVertex(0, 0, 1);
					sglVertex(1, 1, 1);
					sglVertex(3, 1, 1);
					sglVertex(4, 0, 1);
					sglVertex(4.5, -0.5, 1);
					sglVertex(5, 0, 1);
					sglVertex(4.5, 0.5, 1);

					sglEnd();

					sglRotate(delta / 2, 0.0, 0.0);
				end;

				// Kresleni otocenych Coonsovych splinu.

				sglLoadIdentity();
				sglTranslate(5.0, 15.0);

				for i := 0 to Count - 1 do
				begin
					sglBegin(sglCoonsSpline);

					sglVertex(-4.5, -0.5, 1);
					sglVertex(-5, 0, 1);
					sglVertex(-4.5, 0.5, 1);
					sglVertex(-4, 0, 1);
					sglVertex(-3, -1, 1);
					sglVertex(-1, -1, 1);
					sglVertex(0, 0, 1);
					sglVertex(0, 0, 1);
					sglVertex(0, 0, 1);
					sglVertex(1, 1, 1);
					sglVertex(3, 1, 1);
					sglVertex(4, 0, 1);
					sglVertex(4.5, -0.5, 1);
					sglVertex(5, 0, 1);
					sglVertex(4.5, 0.5, 1);

					sglEnd();

					sglRotate(delta / 2, 0.0, 0.0);
				end;

				// Kresleni otocenych Fergusonvych kubik.

				sglLoadIdentity();
				sglTranslate(15.0, 15.0);

				for i := 0 to Count - 1 do
				begin

					sglBegin(sglFergusonCurve);

					sglVertex(-4.5, -0.5, 1);
					sglVertex(-1.5, 1.5, 1);

					sglVertex(-4, 0, 1);
					sglVertex(2, -2, 1);

					// sglVertex(-4, 0, 1);
					// sglVertex(2, -2, 1);

					sglVertex(0, 0, 1);
					sglVertex(2, 2, 1);

					// sglVertex(0, 0, 1);
					// sglVertex(2, 2, 1);

					sglVertex(4, 0, 1);
					sglVertex(2, -2, 1);

					// sglVertex(4, 0, 1);
					// sglVertex(2, -2, 1);

					sglVertex(4.5, 0.5, 1);
					sglVertex(-1.5, 1.5, 1);

					sglEnd();

					sglRotate(delta / 2, 0.0, 0.0);
				end;

				x := x + W;
				B := B - db;
				B := 255 - B;
			end;
			y := y + H;
			R := R + dr;
			R := 255 - R;
		end;

		/// //////////////////////////////////////////////////
		// Test 3A: konec testu.                           //
		/// //////////////////////////////////////////////////
	finally
		FreeScene;
	end;
end;

procedure TfFunctions.ButtonTest3BClick(Sender: TObject);
var
	winWidth, winHeight: SG;
	k, L, cw, ch, cx, cy, tiles: SG;
	cr, cg, cb, cdr, cdb: Byte;

	x, y, delta, angle, deg2rad: Double;
	radius2, radius1: Double;
	i, j, Count: SG;

begin
	/// //////////////////////////////////////////////////
	// Test 3B: orezavani car, trojuhelniku,           //
	// kruhovych oblouku a kruznic            //
	// Verze: 3.5.2005 15:30                           //
	// (predpokladana velikost okna 1050 x 1050 pixelu)//
	// _drawable = sglCreateDrawable(1050, 1050);      //
	/// //////////////////////////////////////////////////

	winWidth := 1050;
	winHeight := 1050;

	CreateScene('Test 3B', winWidth, winHeight);
	try
		sglClear(0, 0, 0, 0);

		sglAreaMode(SGL_AREA_MODE_BORDER);
		sglShadeModel(True);

		sglEnableClipping(True);

		tiles := 15;
		cw := winWidth div tiles;
		ch := winHeight div tiles;
		cdr := 255 div tiles;
		cdb := cdr;

		cg := 255;
		cr := 0;

		cy := 0;
		for k := 0 to tiles - 1 do
		begin
			cx := 0;
			cb := 255;
			for L := 0 to tiles - 1 do
			begin

				sglClipRectangle(cx, cy, cw, ch);
				sglColor(cr, cg, cb, 0);

				sglOrtho2D(-11.5, 11.5, -11.5, 11.5);

				sglMatrixMode(sglModelMatrix);
				sglLoadIdentity();

				sglViewport(0, 0, 350, 350);

				// Nakresli hvezdu o count vrcholech.

				deg2rad := pi / 180.0;
				radius2 := 10.0;
				radius1 := 3.25;
				Count := 15;

				delta := 360.0 / Count;
				angle := 0.0;

				sglBegin(sglLineLoop);
				for i := 0 to Count - 1 do
				begin
					x := Cos(angle * deg2rad);
					y := Sin(angle * deg2rad);
					sglVertex(radius1 * x, radius1 * y, 1.0);

					x := Cos((angle + 0.5 * delta) * deg2rad);
					y := Sin((angle + 0.5 * delta) * deg2rad);
					sglVertex(radius2 * x, radius2 * y, 1.0);

					angle := angle + delta;
				end;
				sglEnd();

				sglViewport(350, 0, 350, 350);

				// Nakresli hvezdu vzniklou otocenim car.

				for i := 0 to Count - 1 do
				begin

					sglBegin(sglLines);
					sglVertex(-10.0, 0.0, 1.0);
					sglVertex(10.0, 0.0, 1.0);
					sglEnd();

					sglRotate(delta, 0.0, 0.0);
				end;

				sglViewport(700, 0, 350, 350);

				// Vykresleni ruzne velkych trojuhelniku.

				sglLoadIdentity();
				sglTranslate(0, 1.5);

				radius1 := 0.8;

				for i := 0 to Count - 1 do
				begin

					sglPushMatrix();

					radius2 := radius1 * (i + 1);
					sglScale(radius2, radius2);

					sglBegin(sglTriangles);
					sglVertex(Cos(-90 * deg2rad), Sin(-90 * deg2rad), 1.0);
					sglVertex(Cos(30 * deg2rad), Sin(30 * deg2rad), 1.0);
					sglVertex(Cos(150 * deg2rad), Sin(150 * deg2rad), 1.0);
					sglEnd();

					sglPopMatrix();
				end;

				sglLoadIdentity();

				sglViewport(0, 350, 350, 350);

				// Kresleni kruznic deformovanych zmenou meritka.

				radius1 := 10.0;
				Count := 10;

				sglCircle(0.0, 0.0, radius1);

				for i := 0 to Count - 1 do
				begin

					sglLoadIdentity();
					sglScale((i + 1) / Count, (Count - i) / Count);

					sglCircle(0.0, 0.0, radius1);
				end;

				Count := 8;

				sglViewport(350, 350, 350, 350);

				// Kresleni otocenych kruznic.

				sglLoadIdentity();

				radius1 := 4.25;

				delta := 360.0 / Count;

				for i := 0 to Count - 1 do
				begin

					sglCircle(radius1, 0, radius1);

					sglRotate(delta, 0.0, 0.0);
				end;

				sglViewport(700, 350, 350, 350);

				// Kresleni soustrednych kruznic.

				sglLoadIdentity();

				radius1 := 0.5;
				Count := 20;

				for i := 0 to Count - 1 do
				begin

					sglPushMatrix();

					sglScale(i + 1, i + 1);

					sglCircle(0, 0, radius1);

					sglPopMatrix();
				end;

				sglLoadIdentity();

				sglViewport(0, 700, 350, 350);

				// Kresleni kruhovych oblouku deformovanych zmenou meritka.

				radius1 := 10.0;
				Count := 10;

				delta := 360.0 / Count;

				angle := 0.0;
				for j := 0 to Count - 1 do
				begin
					sglArc(0.0, 0.0, radius1, angle, angle + delta);
					angle := angle + delta;
				end;

				for i := 0 to Count - 1 do
				begin

					sglLoadIdentity();
					sglScale((i + 1) / Count, (Count - i) / Count);

					angle := 0.0;
					for j := 0 to Count - 1 do
					begin
						sglArc(0.0, 0.0, radius1, angle, angle + delta);
						angle := angle + delta;
					end;
				end;

				Count := 8;

				sglViewport(0, 700, 1050, 350);
				sglOrtho2D(-11.5, 23.0 + 11.5, -11.5, 11.5);

				// Kresleni otocenych kruznic slozenych z kruhovych oblouku.

				sglLoadIdentity();

				radius1 := 4.25;

				delta := 360.0 / Count;

				sglTranslate(23.0, 0.0);

				for i := 0 to Count - 1 do
				begin
					angle := 0.0;
					for j := 0 to Count - 1 do
					begin
						sglArc(5.0, 0.0, radius1, angle, angle + delta);
						angle := angle + delta;
					end;

					sglRotate(delta, 0.0, 0.0);
				end;

				cx := cx + cw;
				cb := cb - cdb;
				cb := 255 - cb;
			end;
			cy := cy + ch;
			cr := cr + cdr;
			cr := 255 - cr;
		end;

		/// //////////////////////////////////////////////////
		// Test 3B: konec testu.                           //
		/// //////////////////////////////////////////////////
	finally
		FreeScene;
	end;
end;

procedure TfFunctions.ButtonTest3CClick(Sender: TObject);
var
	W, H: SG;
	x, y, dist, dx, dy, delta, deg2rad: Double;
	i, j, Count: SG;
begin
	/// //////////////////////////////////////////////////
	// Test 3C: vyplnovani polygonu a kruznic/elips    //
	// Verze: 3.5.2005 15:00                           //
	// (predpokladana velikost okna 1000 x 1000 pixelu)//
	// _drawable = sglCreateDrawable(1000, 1000);      //
	/// //////////////////////////////////////////////////

	W := 1000;
	H := 1000;
	CreateScene('Test 3C', W, H);
	try
		sglClear(0, 0, 0, 0);

		sglOrtho2D(-10.0, 10.0, -10.0, 10.0);

		sglAreaMode(SGL_AREA_MODE_FILL);
		sglShadeModel(True);

		sglMatrixMode(sglModelMatrix);
		sglLoadIdentity();

		deg2rad := pi / 180.0;
		Count := 5;

		delta := 180.0 / (Count * Count);

		dx := W / Count;
		dy := H / Count;
		dist := 9.0;

		for j := 0 to Count - 1 do
		begin
			for i := 0 to Count - 1 do
			begin

				sglViewport(Round(i * dx), Round(j * dy), Round(dx), Round(dy));

				sglPushMatrix();
				sglScale(1.0, 0.65);

				sglSetDepth(1);
				sglColor(255, 255, 0, 0);
				sglCircle(0, 0, dist);

				sglSetDepth(0);

				sglBegin(sglPolygon);

				sglColor(255, 0, 0, 0);
				sglVertex(dist, 0, 1);

				x := dist * Cos(72 * deg2rad);
				y := dist * Sin(72 * deg2rad);
				sglColor(0, 255, 0, 0);
				sglVertex(x, y, 1);

				x := dist * Cos(144 * deg2rad);
				y := dist * Sin(144 * deg2rad);
				sglColor(0, 0, 255, 0);
				sglVertex(x, y, 1);

				x := dist * Cos(216 * deg2rad);
				y := dist * Sin(216 * deg2rad);
				sglColor(0, 255, 255, 0);
				sglVertex(x, y, 1);

				x := dist * Cos(288 * deg2rad);
				y := dist * Sin(288 * deg2rad);
				sglColor(255, 0, 255, 0);
				sglVertex(x, y, 1);

				sglEnd();

				sglPopMatrix();
				sglRotate(delta, 0.0, 0.0);
			end;
		end;

		/// //////////////////////////////////////////////////
		// Test 3C: konec testu.                           //
		/// //////////////////////////////////////////////////
	finally
		FreeScene;
	end;
end;

procedure TfFunctions.ButtonTest3DClick(Sender: TObject);
var
	W, H: SG;
	k: SG;
begin
	/// //////////////////////////////////////////////////
	// Test 3D: vypplnovani + orezani polygonu         //
	// Verze: 3.5.2005 15:30                           //
	// (predpokladana velikost okna 1000 x 500 pixelu) //
	// _drawable = sglCreateDrawable(1000, 500);       //
	/// //////////////////////////////////////////////////

	W := 1000;
	H := 500;
	CreateScene('Test 3D', W, H);
	try
		k := Round(H * (1.5 / 9.0));

		sglClear(0, 0, 0, 0);

		sglOrtho2D(-4.5, 4.5, -4.5, 4.5);
		sglViewport(0, 0, H, H);

		sglAreaMode(SGL_AREA_MODE_BORDER);
		sglShadeModel(True);

		sglEnableClipping(True);
		sglClipRectangle(k, k, H - 2 * k, H - 2 * k);

		sglMatrixMode(sglModelMatrix);
		sglLoadIdentity();

		sglBegin(sglPolygon);
		sglColor(255, 0, 0, 0);
		sglVertex(4, 0, 1);
		sglColor(0, 255, 0, 0);
		sglVertex(2, 1, 1);
		sglColor(0, 0, 255, 0);
		sglVertex(4, 4, 1);
		sglColor(255, 255, 0, 0);
		sglVertex(1, 2, 1);
		sglColor(255, 0, 255, 0);
		sglVertex(0, 4, 1);
		sglColor(0, 255, 255, 0);
		sglVertex(-1, 2, 1);
		sglColor(255, 255, 255, 0);
		sglVertex(-4, 4, 1);
		sglColor(128, 0, 0, 0);
		sglVertex(-2, 1, 1);
		sglColor(0, 128, 0, 0);
		sglVertex(-4, 0, 1);
		sglColor(0, 0, 128, 0);
		sglVertex(-2, -1, 1);
		sglColor(128, 128, 0, 0);
		sglVertex(-4, -4, 1);
		sglColor(128, 0, 128, 0);
		sglVertex(-1, -2, 1);
		sglColor(0, 128, 128, 0);
		sglVertex(0, -4, 1);
		sglColor(128, 128, 128, 0);
		sglVertex(1, -2, 1);
		sglColor(64, 190, 70, 0);
		sglVertex(4, -4, 1);
		sglColor(166, 32, 65, 0);
		sglVertex(2, -1, 1);
		sglEnd();

		sglOrtho2D(0.0, 10.0, 0.0, 10.0);
		sglViewport(H, 0, H, H);

		sglAreaMode(SGL_AREA_MODE_FILL);
		sglShadeModel(True);

		k := Round(0.2 * W / 2);

		sglEnableClipping(True);
		sglClipRectangle(H + k, k, H - 2 * k, H - 2 * k);

		sglMatrixMode(sglModelMatrix);
		sglLoadIdentity();

		// polygon pres cele okno
		sglBegin(sglPolygon);
		sglColor(255, 0, 0, 0);
		sglVertex(0, 5, 1);
		sglColor(0, 255, 0, 0);
		sglVertex(5, 10, 1);
		sglColor(0, 0, 255, 0);
		sglVertex(10, 5, 1);
		sglColor(255, 0, 255, 0);
		sglVertex(5, 0, 1);
		sglEnd();

		sglBegin(sglTriangles);
		sglColor(255, 255, 0, 0);
		sglVertex(0, 0, 1);
		sglColor(0, 255, 255, 0);
		sglVertex(9.5, 6.5, 1);
		sglColor(255, 0, 255, 0);
		sglVertex(6.5, 9.5, 1);
		sglEnd();

		sglBegin(sglTriangles);
		sglColor(128, 255, 0, 0);
		sglVertex(10, 6, 1);
		sglColor(0, 128, 255, 0);
		sglVertex(5, 0, 1);
		sglColor(255, 0, 128, 0);
		sglVertex(3, 0, 1);
		sglEnd();

		sglBegin(sglTriangleStrip);
		sglColor(255, 128, 64, 0);
		sglVertex(1, 7, 1);
		sglColor(128, 255, 64, 0);
		sglVertex(3, 9, 1);
		sglColor(128, 64, 255, 0);
		sglVertex(2, 10, 1);
		sglColor(255, 64, 255, 0);
		sglVertex(0, 8, 1);
		sglEnd();

		/// //////////////////////////////////////////////////
		// Test 3D: konec testu.                           //
		/// //////////////////////////////////////////////////
	finally
		FreeScene;
	end;
end;

procedure TfFunctions.ButtonTest4Click(Sender: TObject);
var
	i, j: SG;
	W, H: SG;
begin
	W := fMain.ImageP.Width;
	H := fMain.ImageP.Height;
	CreateScene('Test 4', W, H);
	try
		for i := 0 to H - 1 do
		begin
			sglColor(0, $A0 { 255 * i div (H - 1) } , 0 { $A0 } , 255 * i div (H - 1));
			sglBegin(sglLines);
			sglVertex(0, i, 1);
			sglVertex(W - 1, i, 1);
			sglEnd;
		end;

		sglOrtho2D(0, 10, 0, 2);

		sglEnableBlending(True);

		for j := 0 to 4 do
		begin
			sglBlendFunc(j);
			sglBegin(sglTriangleFan);
			sglVertex(1 + 2 * j, 1, 1);
			for i := 0 to 15 do
			begin
				sglColor($FF, 00, 00, 16 * i);
				sglVertex(1 + 2 * j + Sin(2 * pi * i / 16), 1 + Cos(2 * pi * i / 16), 1);
			end;
			sglEnd;
		end;
	finally
		FreeScene;
	end;
end;

procedure TfFunctions.ButtonTest4AClick(Sender: TObject);
var
	delta: Double;
	styl, tloustka, Count: SG;

begin
	/// ///////////////////////////////////////////////////
	// Test 4A: kresleni krivek ruznymi typy car        //
	// Verze: 2.5.2005 12:00                            //
	// (predpokladana velikost okna 1000 x 1000 pixelu) //
	// _drawable = sglCreateDrawable(1000, 1000);       //
	/// ///////////////////////////////////////////////////

	CreateScene('Test 4A', 1000, 1000);
	try
		sglClear(0, 0, 0, 0);

		sglOrtho2D(0.0, 20.0, 0.0, 20.0);

		sglViewport(0, 0, 1000, 1000);

		sglMatrixMode(sglModelMatrix);

		Count := 12;

		delta := 360.0 / Count;

		// Kresleni otocenych Bezierovych kubik.

		sglLoadIdentity();
		sglTranslate(5.0, 5.0);

		for styl := 1 to 4 do
		begin
			for tloustka := 1 to 3 do
			begin
				sglLineWidth(tloustka);
				sglLineStyle(styl);
				sglBegin(sglBezierCCurve);
				// prvni kubika
				sglVertex(-4, 0, 1);
				sglVertex(-3, -1, 1);
				sglVertex(-1, -1, 1);
				sglVertex(0, 0, 1);
				// druha kubika
				sglVertex(0, 0, 1);
				sglVertex(1, 1, 1);
				sglVertex(3, 1, 1);
				sglVertex(4, 0, 1);

				sglEnd();

				sglRotate(delta / 2, 0.0, 0.0);
			end;
		end;


		// Kresleni otocenych Bezierovych krivek n-teho radu.

		sglLoadIdentity();
		sglTranslate(15.0, 5.0);

		for styl := 1 to 4 do
		begin
			for tloustka := 1 to 3 do
			begin
				sglLineWidth(tloustka);
				sglLineStyle(styl);

				sglBegin(sglBezierGCurve);

				sglVertex(-4, 0, 1);

				sglVertex(-3, -1, 1);
				sglVertex(-1, -1, 1);
				sglVertex(0, 0, 1);
				sglVertex(1, 1, 1);
				sglVertex(3, 1, 1);
				sglVertex(4, 0, 1);

				sglEnd();

				sglRotate(delta / 2, 0.0, 0.0);
			end;
		end;

		// Kresleni otocenych Coonsovych splinu.

		sglLoadIdentity();
		sglTranslate(5.0, 15.0);

		for styl := 1 to 4 do
		begin
			for tloustka := 1 to 3 do
			begin
				sglLineWidth(tloustka);
				sglLineStyle(styl);

				sglBegin(sglCoonsSpline);

				sglVertex(-4, 0, 1);
				sglVertex(-3, -1, 1);
				sglVertex(-1, -1, 1);
				sglVertex(0, 0, 1);
				sglVertex(0, 0, 1);
				sglVertex(0, 0, 1);
				sglVertex(1, 1, 1);
				sglVertex(3, 1, 1);
				sglVertex(4, 0, 1);

				sglEnd();

				sglRotate(delta / 2, 0.0, 0.0);
			end;
		end;

		// Kresleni otocenych Fergusonvych kubik.

		sglLoadIdentity();
		sglTranslate(15.0, 15.0);

		for styl := 1 to 4 do
		begin
			for tloustka := 1 to 3 do
			begin
				sglLineWidth(tloustka);
				sglLineStyle(styl);

				sglBegin(sglFergusonCurve);

				sglVertex(-4, 0, 1);
				sglVertex(2, -2, 1);

				sglVertex(0, 0, 1);
				sglVertex(2, 2, 1);

				// sglVertex(0, 0, 1);
				// sglVertex(2, 2, 1);

				sglVertex(4, 0, 1);
				sglVertex(2, -2, 1);

				sglEnd();

				sglRotate(delta / 2, 0.0, 0.0);
			end;
		end;

		/// //////////////////////////////////////////////////
		// Test 4A: konec testu.                           //
		/// //////////////////////////////////////////////////
	finally
		FreeScene;
	end;
end;

procedure TfFunctions.ButtonTest4BClick(Sender: TObject);
var
	W, H, k: SG;
begin
	/// /////////////////////////////////////////////////////
	// Test 4B: vyplnovani + orezani + srafovani polygonu //
	// Verze: 2.5.2005 12:00                              //
	// (predpokladana velikost okna 1000 x 500 pixelu)    //
	// _drawable = sglCreateDrawable(1000, 500);          //
	/// /////////////////////////////////////////////////////

	CreateScene('Test 4B', 1000, 500);
	try
		W := 1000;
		H := 500;
		k := Round(H * (1.5 / 9.0));

		sglClear(0, 0, 0, 0);

		sglOrtho2D(-4.5, 4.5, -4.5, 4.5);
		sglViewport(0, 0, H, H);

		sglAreaMode(SGL_AREA_MODE_FILL);
		sglShadeModel(True);

		sglEnableClipping(True);
		sglClipRectangle(k, k, H - k, H - k);

		sglMatrixMode(sglModelMatrix);
		sglLoadIdentity();

		sglHatching(SGL_HATCH_BRICKS, 0, 0, 0, 0);

		sglBegin(sglPolygon);
		sglColor(255, 0, 0, 0);
		sglVertex(4, 0, 1);
		sglColor(0, 255, 0, 0);
		sglVertex(2, 1, 1);
		sglColor(0, 0, 255, 0);
		sglVertex(4, 4, 1);
		sglColor(255, 255, 0, 0);
		sglVertex(1, 2, 1);
		sglColor(255, 0, 255, 0);
		sglVertex(0, 4, 1);
		sglColor(0, 255, 255, 0);
		sglVertex(-1, 2, 1);
		sglColor(255, 255, 255, 0);
		sglVertex(-4, 4, 1);
		sglColor(128, 0, 0, 0);
		sglVertex(-2, 1, 1);
		sglColor(0, 128, 0, 0);
		sglVertex(-4, 0, 1);
		sglColor(0, 0, 128, 0);
		sglVertex(-2, -1, 1);
		sglColor(128, 128, 0, 0);
		sglVertex(-4, -4, 1);
		sglColor(128, 0, 128, 0);
		sglVertex(-1, -2, 1);
		sglColor(0, 128, 128, 0);
		sglVertex(0, -4, 1);
		sglColor(128, 128, 128, 0);
		sglVertex(1, -2, 1);
		sglColor(64, 190, 70, 0);
		sglVertex(4, -4, 1);
		sglColor(166, 32, 65, 0);
		sglVertex(2, -1, 1);
		sglEnd();

		sglOrtho2D(0.0, 10.0, 0.0, 10.0);
		sglViewport(H, 0, H, H);

		sglAreaMode(SGL_AREA_MODE_FILL);
		sglShadeModel(True);

		k := Round(0.2 * W / 2);

		sglEnableClipping(True);
		sglClipRectangle(H + k, k, W - k, H - k);

		sglMatrixMode(sglModelMatrix);
		sglLoadIdentity();

		sglHatching(SGL_HATCH_VERTICAL, 0, 0, 0, 0);

		// polygon pres cele okno
		sglBegin(sglPolygon);
		sglColor(255, 0, 0, 0);
		sglVertex(0, 5, 1);
		sglColor(0, 255, 0, 0);
		sglVertex(5, 10, 1);
		sglColor(0, 0, 255, 0);
		sglVertex(10, 5, 1);
		sglColor(255, 0, 255, 0);
		sglVertex(5, 0, 1);
		sglEnd();

		sglHatching(SGL_HATCH_HORIZONTAL, 0, 0, 0, 0);

		sglBegin(sglTriangles);
		sglColor(255, 255, 0, 0);
		sglVertex(0, 0, 1);
		sglColor(0, 255, 255, 0);
		sglVertex(9.5, 6.5, 1);
		sglColor(255, 0, 255, 0);
		sglVertex(6.5, 9.5, 1);
		sglEnd();

		sglHatching(SGL_HATCH_DIAGONAL, 0, 0, 0, 0);

		sglBegin(sglTriangles);
		sglColor(128, 255, 0, 0);
		sglVertex(10, 6, 1);
		sglColor(0, 128, 255, 0);
		sglVertex(5, 0, 1);
		sglColor(255, 0, 128, 0);
		sglVertex(3, 0, 1);
		sglEnd();

		sglHatching(SGL_HATCH_TIRE_TREADS, 0, 0, 0, 0);

		sglBegin(sglTriangleStrip);
		sglColor(255, 128, 64, 0);
		sglVertex(1, 7, 1);
		sglColor(128, 255, 64, 0);
		sglVertex(3, 9, 1);
		sglColor(128, 64, 255, 0);
		sglVertex(2, 10, 1);
		sglColor(255, 64, 255, 0);
		sglVertex(0, 8, 1);
		sglEnd();

		/// //////////////////////////////////////////////////
		// Test 4B: konec testu.                           //
		/// //////////////////////////////////////////////////
	finally
		FreeScene;
	end;
end;

procedure TfFunctions.ButtonTest4CClick(Sender: TObject);
var
	radius1, angle, delta: Double;
	i, j, Count: SG;
	styl, tloustka: SG;
begin
	/// //////////////////////////////////////////////////
	// Test 4C: kresleni kruhovych oblouku.            //
	// Verze: 2.5.2005 12:00                           //
	// (predpokladana velikost okna 1000 x 500 pixelu) //
	// _drawable = sglCreateDrawable(1000, 500);       //
	/// //////////////////////////////////////////////////

	CreateScene('Test 4C', 1000, 500);
	try
		sglClear(0, 0, 0, 0);

		sglOrtho2D(-11.5, 11.5, -11.5, 11.5);

		sglMatrixMode(sglModelMatrix);
		sglLoadIdentity();

		sglColor(0, 255, 0, 0);
		sglAreaMode(SGL_AREA_MODE_BORDER);

		sglViewport(0, 0, 500, 500);

		// Kresleni kruhovych oblouku deformovanych zmenou meritka.

		radius1 := 10.0;
		Count := 12;

		delta := 360.0 / Count;

		angle := 0.0;
		for j := 0 to Count - 1 do
		begin
			sglArc(0.0, 0.0, radius1, angle, angle + delta);
			angle := angle + delta;
		end;

		for styl := 1 to 4 do
		begin
			for tloustka := 1 to 3 do
			begin

				sglLineWidth(tloustka);
				sglLineStyle(styl);

				i := (styl - 1) * 3 + tloustka - 1;

				sglLoadIdentity();
				sglScale((i + 1) / Count, (Count - i) / Count);

				angle := 0.0;
				for j := 0 to Count - 1 do
				begin
					sglArc(0.0, 0.0, radius1, angle, angle + delta);
					angle := angle + delta;
				end;
			end;
		end;

		// count = 8;

		sglViewport(0, 0, 1000, 500);
		sglOrtho2D(-11.5, 23.0 + 11.5, -11.5, 11.5);

		// Kresleni otocenych kruznic slozenych z kruhovych oblouku.

		sglLoadIdentity();

		radius1 := 4.25;

		// delta = 360.0 / count;

		sglTranslate(23.0, 0.0);

		for styl := 1 to 4 do
		begin
			for tloustka := 1 to 3 do
			begin
				sglLineWidth(tloustka);
				sglLineStyle(styl);

				angle := 0.0;
				for j := 0 to Count - 1 do
				begin
					sglArc(5.0, 0.0, radius1, angle, angle + delta);
					angle := angle + delta;
				end;

				sglRotate(delta, 0.0, 0.0);
			end;
		end;

		/// //////////////////////////////////////////////////
		// Test 4C: konec testu.                           //
		/// //////////////////////////////////////////////////
	finally
		FreeScene;
	end;
end;

procedure TfFunctions.ButtonTest4DClick(Sender: TObject);
var
	radius1: Double;
	i, Count: SG;
	styl, tloustka: SG;
	delta: Double;
begin
	/// //////////////////////////////////////////////////
	// Test 4D: kresleni kruznic.                      //
	// Verze: 2.5.2005 12:00                           //
	// (predpokladana velikost okna 1200 x 400 pixelu) //
	// _drawable = sglCreateDrawable(1200, 400);       //
	/// //////////////////////////////////////////////////

	CreateScene('Test 4D', 1200, 400);
	try
		sglClear(0, 0, 0, 0);

		sglOrtho2D(-11.5, 11.5, -11.5, 11.5);

		sglMatrixMode(sglModelMatrix);
		sglLoadIdentity();

		sglAreaMode(SGL_AREA_MODE_BORDER);
		sglColor(255, 0, 0, 0);

		sglViewport(0, 0, 400, 400);

		// Kresleni kruznic deformovanych zmenou meritka.

		radius1 := 10.0;
		Count := 12;

		sglCircle(0.0, 0.0, radius1);

		for styl := 1 to 4 do
		begin
			for tloustka := 1 to 3 do
			begin

				sglLineWidth(tloustka);
				sglLineStyle(styl);

				i := (styl - 1) * 3 + tloustka - 1;

				sglLoadIdentity();
				sglScale((i + 1) / Count, (Count - i) / Count);

				sglCircle(0.0, 0.0, radius1);
			end;
		end;

		// count = 8;

		sglViewport(400, 0, 400, 400);

		// Kresleni otocenych kruznic.

		sglLoadIdentity();

		radius1 := 4.25;

		delta := 360.0 / Count;

		for styl := 1 to 4 do
		begin
			for tloustka := 1 to 3 do
			begin
				sglLineWidth(tloustka);
				sglLineStyle(styl);

				sglCircle(radius1, 0, radius1);

				sglRotate(delta, 0.0, 0.0);
			end;
		end;

		sglViewport(800, 0, 400, 400);

		// Kresleni soustrednych kruznic.

		sglLoadIdentity();
		sglPushMatrix();

		radius1 := 0.5;
		// count = 20;

		for styl := 1 to 4 do
		begin
			for tloustka := 1 to 3 do
			begin

				sglLineWidth(tloustka);
				sglLineStyle(styl);

				i := (styl - 1) * 3 + tloustka - 1;

				sglPushMatrix();

				sglScale(i + 1, i + 1);

				sglCircle(0, 0, radius1);

				sglPopMatrix();
			end;
		end;

		/// //////////////////////////////////////////////////
		// Test 4D: konec testu.                           //
		/// //////////////////////////////////////////////////
	finally
		FreeScene;
	end;
end;

procedure TfFunctions.ButtonTest4EClick(Sender: TObject);
var
	x, y, delta, angle, deg2rad: Double;
	radius2, radius1: Double;
	j, i, Count: SG;
	styl, tloustka: SG;
begin
	/// //////////////////////////////////////////////////
	// Test 4E: kresleni car a trojuhelniku.           //
	// Verze: 2.5.2005 12:00                           //
	// (predpokladana velikost okna 1200 x 400 pixelu) //
	// _drawable = sglCreateDrawable(1200, 400);       //
	/// //////////////////////////////////////////////////

	CreateScene('Test 4E', 1200, 400);
	try
		sglClear(0, 0, 0, 0);

		sglOrtho2D(-11.5, 11.5, -11.5, 11.5);

		sglMatrixMode(sglModelMatrix);
		sglLoadIdentity();

		sglViewport(0, 0, 400, 400);

		// Nakresli hvezdu o count vrcholech.

		deg2rad := pi / 180.0;
		radius2 := 11.0;
		radius1 := 5.25;
		Count := 15;

		delta := 360.0 / Count;
		angle := 0.0;

		sglAreaMode(SGL_AREA_MODE_BORDER);
		sglLineWidth(2);

		for j := 1 to 4 do
		begin
			sglLineStyle(j);

			sglBegin(sglLineLoop);
			for i := 0 to Count - 1 do
			begin

				x := Cos(angle * deg2rad);
				y := Sin(angle * deg2rad);
				sglVertex(radius1 * x, radius1 * y, 1.0);

				x := Cos((angle + 0.5 * delta) * deg2rad);
				y := Sin((angle + 0.5 * delta) * deg2rad);
				sglVertex(radius2 * x, radius2 * y, 1.0);

				angle := angle + delta;
			end;
			sglEnd();

			radius1 := radius1 - 1;
			radius2 := radius2 - 1;
		end;

		sglViewport(400, 0, 400, 400);

		// Nakresli hvezdu vzniklou otocenim car.

		Count := 12;
		delta := 180.0 / Count;

		for styl := 1 to 4 do
		begin
			for tloustka := 1 to 3 do
			begin
				sglLineWidth(tloustka);
				sglLineStyle(styl);

				sglBegin(sglLines);
				sglVertex(-10.0, 0.0, 1.0);
				sglVertex(10.0, 0.0, 1.0);
				sglEnd();

				sglRotate(delta, 0.0, 0.0);
			end;
		end;

		sglViewport(800, 0, 400, 400);

		// Vykresleni ruzne velkych trojuhelniku.

		sglLoadIdentity();
		sglTranslate(0, 1.5);
		sglPushMatrix();

		radius1 := 0.8;
		// radius2 := 10.0;

		for styl := 1 to 4 do
		begin
			for tloustka := 1 to 3 do
			begin
				sglLineWidth(tloustka);
				sglLineStyle(styl);

				i := (styl - 1) * 3 + tloustka - 1;

				sglPopMatrix();
				sglPushMatrix();

				radius2 := radius1 * (i + 1);
				sglScale(radius2, radius2);

				sglBegin(sglTriangles);
				sglVertex(Cos(-90 * deg2rad), Sin(-90 * deg2rad), 1.0);
				sglVertex(Cos(30 * deg2rad), Sin(30 * deg2rad), 1.0);
				sglVertex(Cos(150 * deg2rad), Sin(150 * deg2rad), 1.0);
				sglEnd();
			end;
		end;

		/// //////////////////////////////////////////////////
		// Test 4E: konec testu.                           //
		/// //////////////////////////////////////////////////
	finally
		FreeScene;
	end;
end;

procedure TfFunctions.ButtonTest4FClick(Sender: TObject);
var
	W, H: SG;
	delta, deg2rad: Double;
	i, j, Count: SG;
	dx, dy: Double;
	hatch: SG;
begin
	/// ///////////////////////////////////////////////////
	// Test 4F: srafovani.                              //
	// Verze: 2.5.2005 12:00                            //
	// (predpokladana velikost okna 1000 x 1000 pixelu) //
	// _drawable = sglCreateDrawable(1000, 1000);       //
	/// ///////////////////////////////////////////////////

	W := 1000;
	H := 1000;

	CreateScene('Test 4F', W, H);
	try
		sglClear(0, 0, 0, 0);

		sglOrtho2D(-10.0, 10.0, -10.0, 10.0);

		sglMatrixMode(sglModelMatrix);

		deg2rad := pi / 180.0;
		Count := 4;

		delta := deg2rad * 360.0 / (Count * Count);

		dx := W / Count;
		dy := H / Count;

		sglLoadIdentity();

		sglAreaMode(SGL_AREA_MODE_FILL);
		sglShadeModel(True);

		hatch := 1;

		for j := 0 to Count - 1 do
		begin
			for i := 0 to Count - 1 do
			begin
				sglViewport(Round(i * dx), Round(j * dy), Round(dx), Round(dy));

				sglHatching(hatch, 255, 255, 255, 0);

				sglColor(255, 0, 0, 0);
				sglCircle(5, 5, 4.5);

				sglColor(0, 0, 255, 0);
				sglEllipse(5, -5, 4.5, 2.5);

				sglBegin(sglTriangles);
				sglColor(255, 0, 0, 0);
				sglVertex(-5.0, 9.5, 1);
				sglColor(0, 255, 0, 0);
				sglVertex(-9.5, 0.5, 1);
				sglColor(0, 0, 255, 0);
				sglVertex(-0.5, 0.5, 1);
				sglEnd();

				sglBegin(sglTriangleFan);
				sglColor(255, 0, 0, 0);
				sglVertex(-3.0, -1.0, 1);
				sglColor(0, 255, 0, 0);
				sglVertex(-7.0, -1.0, 1);
				sglColor(0, 0, 255, 0);
				sglVertex(-9.5, -5.0, 1);
				sglColor(255, 255, 0, 0);
				sglVertex(-7.0, -9.0, 1);
				sglColor(255, 0, 255, 0);
				sglVertex(-3.0, -9.0, 1);
				sglColor(0, 255, 255, 0);
				sglVertex(-0.5, -5.0, 1);
				sglEnd();

				hatch := 1 + hatch mod 5;

				sglRotate(delta, 0.0, 0.0);
			end;
		end;

		/// //////////////////////////////////////////////////
		// Test 4F: konec testu.                           //
		/// //////////////////////////////////////////////////
	finally
		FreeScene;
	end;
end;

procedure TfFunctions.ButtonTest5Click(Sender: TObject);
var
	W, H: SG;
	Id: SG;
	i, j: SG;
begin
	W := fMain.ImageP.Width;
	H := fMain.ImageP.Height;
	CreateScene('Test 5', W, H);
	try
		sglClear(0, 0, 0, 0);
		sglEnableTexturing(True);
		Id := sglCreateTexture;
		sglBindTexture(Id);
		sglLoadTexture(GraphDir + 'Logo.png');
		sglOrtho2D(0, 16.0, 0, 10.0);

		sglMatrixMode(sglTextureMatrix);
		sglLoadIdentity;
		// sglTranslate(0.1, 0.1);
		// sglScale(0.5, 0.5);
		// sglRotate(10, 0.5, 0.5);
		sglMatrixMode(sglModelMatrix);
		sglTexMode(SGL_TEXTURE_MODE_MUL); // Shadowing
		// sglTexFilter(SGL_TEXTURE_FILTER_NEAREST);
		// sglTexFilter(SGL_TEXTURE_FILTER_MIPMAP);
		for i := 0 to 3 do
		begin
			sglLoadIdentity;
			sglTranslate(-1, -4);
			sglTranslate(i * 4, 0);
			sglTexFilter(i);

			for j := 0 to 7 do
			begin
				sglBegin(sglPolygon);

				sglColor($FFFFFF);
				sglTexCoord(0, 0, 1);
				sglVertex(1, 5);

				sglColor($5F5F5F);
				sglTexCoord(0, 1, 1);
				sglVertex(2, 6);

				sglColor($000000);
				sglTexCoord(1, 1, 1);
				sglVertex(5 { 4 } , 6);

				sglColor($FFFFFF);
				sglTexCoord(1, -0, 1);
				sglVertex(5, 5);

				sglEnd;

				sglScale(0.8, 0.8);
				sglTranslate(1, 4);
			end;
		end;
		sglDeleteTexture(Id);

		// sglSaveImage(GraphDir + 'Buffer.png');
	finally
		FreeScene;
	end;
end;

procedure TfFunctions.ButtonTest5AClick(Sender: TObject);
var
	texture: SG;
	i, j, x, y, delta: SG;
	angle: Double;
begin
	/// //////////////////////////////////////////////////
	// Test 5A: transformace texturovacich souradnic.  //
	// Verze: 24.5.2005 15:00                          //
	// (predpokladana velikost okna 1200 x 800 pixelu) //
	// _drawable = sglCreateDrawable(1200, 800);       //
	/// //////////////////////////////////////////////////

	CreateScene('Test 5A', 1200, 800);
	try
		sglClear(0, 0, 0, 0);

		sglOrtho2D(-10, 10, -10, 10);

		sglMatrixMode(sglModelMatrix);
		sglLoadIdentity();

		sglEnableTexturing(True);

		texture := sglCreateTexture();
		sglLoadTexture(GraphDir + 'textura5A.png');
		sglTexFilter(SGL_TEXTURE_FILTER_LINEAR);
		sglTexMode(SGL_TEXTURE_MODE_REPLACE);

		sglMatrixMode(sglTextureMatrix);
		sglLoadIdentity();

		delta := 400;
		angle := 30.0;

		y := 0;
		for i := 0 to 1 do
		begin
			x := 0;
			for j := 0 to 2 do
			begin
				sglViewport(x, y, delta, delta);

				sglBegin(sglTriangles);

				sglTexCoord(0.15, 0.15, 1);
				sglVertex(-7.0, -7.0, 1);

				sglTexCoord(0.85, 0.15, 1);
				sglVertex(7.0, -7.0, 1);

				sglTexCoord(0.5, 0.85, 1);
				sglVertex(0.0, 7.0, 1);

				sglEnd();

				sglRotate(angle, 0.5, 0.5);

				x := x + delta;
			end;
			y := y + delta;

		end;

		sglDeleteTexture(texture);

		// sglSaveImage(GraphDir + 'out5A.tga');

		/// //////////////////////////////////////////////////
		// Test 5A: konec testu.                           //
		/// //////////////////////////////////////////////////
	finally
		FreeScene;
	end;
end;

procedure TfFunctions.ButtonTest5BClick(Sender: TObject);
var
	texture: array [0 .. 5] of SG;
	i, j, x, y, index, delta: SG;
	angle: Double;
begin
	/// //////////////////////////////////////////////////
	// Test 5B: prepinani 6-ti textur.                 //
	// Verze: 24.5.2005 15:00                          //
	// (predpokladana velikost okna 1200 x 800 pixelu) //
	// _drawable = sglCreateDrawable(1200, 800);       //
	/// //////////////////////////////////////////////////
	CreateScene('Test 5B', 1200, 800);
	try
		sglClear(0, 0, 0, 0);

		sglOrtho2D(-10, 10, -10, 10);

		sglMatrixMode(sglModelMatrix);
		sglLoadIdentity();

		sglEnableTexturing(True);

		texture[0] := sglCreateTexture();
		sglLoadTexture(GraphDir + 'textura5A.png');
		sglTexFilter(SGL_TEXTURE_FILTER_LINEAR);
		sglTexMode(SGL_TEXTURE_MODE_REPLACE);

		sglMatrixMode(sglTextureMatrix);
		sglLoadIdentity();

		texture[1] := sglCreateTexture();
		sglLoadTexture(GraphDir + 'textura5B.png');
		sglTexFilter(SGL_TEXTURE_FILTER_NEAREST);
		sglTexMode(SGL_TEXTURE_MODE_REPLACE);

		sglMatrixMode(sglTextureMatrix);
		sglLoadIdentity();

		texture[2] := sglCreateTexture();
		sglLoadTexture(GraphDir + 'textura5C.png');
		sglTexFilter(SGL_TEXTURE_FILTER_LINEAR);
		sglTexMode(SGL_TEXTURE_MODE_ADD);

		sglMatrixMode(sglTextureMatrix);
		sglLoadIdentity();

		texture[3] := sglCreateTexture();
		sglLoadTexture(GraphDir + 'textura5D.png');
		sglTexFilter(SGL_TEXTURE_FILTER_LINEAR);
		sglTexMode(SGL_TEXTURE_MODE_MUL);

		sglMatrixMode(sglTextureMatrix);
		sglLoadIdentity();

		texture[4] := sglCreateTexture();
		sglLoadTexture(GraphDir + 'textura5E.png');
		sglTexFilter(SGL_TEXTURE_FILTER_NEAREST);
		sglTexMode(SGL_TEXTURE_MODE_MUL);

		sglMatrixMode(sglTextureMatrix);
		sglLoadIdentity();

		texture[5] := sglCreateTexture();
		sglLoadTexture(GraphDir + 'textura5F.png');
		sglTexFilter(SGL_TEXTURE_FILTER_NEAREST);
		sglTexMode(SGL_TEXTURE_MODE_ADD);

		sglMatrixMode(sglTextureMatrix);
		sglLoadIdentity();

		delta := 400;
		angle := 30.0;

		y := 0;
		index := 0;
		for i := 0 to 1 do
		begin
			x := 0;
			for j := 0 to 2 do
			begin
				sglViewport(x, y, delta, delta);

				sglBindTexture(texture[index]);

				sglBegin(sglPolygon);

				sglTexCoord(0.5, 0.85, 1);
				sglColor(255, 255, 255, 0);
				sglVertex(0.0, 7.0, 1);

				sglTexCoord(0.7, 0.7, 1);
				sglColor(128, 128, 128, 0);
				sglVertex(4.0, 4.0, 1);

				sglTexCoord(0.85, 0.5, 1);
				sglColor(64, 64, 64, 0);
				sglVertex(7.0, 0.0, 1);

				sglTexCoord(0.7, 0.3, 1);
				sglColor(192, 192, 192, 0);
				sglVertex(4.0, -4.0, 1);

				sglTexCoord(0.5, 0.15, 1);
				sglColor(32, 32, 32, 0);
				sglVertex(0.0, -7.0, 1);

				sglTexCoord(0.3, 0.3, 1);
				sglColor(164, 14, 164, 0);
				sglVertex(-4.0, -4.0, 1);

				sglTexCoord(0.15, 0.5, 1);
				sglColor(255, 128, 255, 0);
				sglVertex(-7.0, 0.0, 1);

				sglTexCoord(0.3, 0.7, 1);
				sglColor(32, 64, 128, 0);
				sglVertex(-4.0, 4.0, 1);

				sglEnd();

				sglRotate(-angle, 0.5, 0.5);

				Inc(index);
				x := x + delta;
			end;
			y := y + delta;

		end;

		for i := 0 to 5 do
			sglDeleteTexture(texture[i]);

		// sglSaveImage(GraphDir + 'out5B.tga');

		/// //////////////////////////////////////////////////
		// Test 5B: konec testu.                           //
		/// //////////////////////////////////////////////////
	finally
		FreeScene;
	end;
end;

procedure TfFunctions.ButtonTest5CClick(Sender: TObject);
var
	texture: array [0 .. 2] of SG;
	i, x, delta: SG;

begin
	/// //////////////////////////////////////////////////
	// Test 5C: test filtrovani textur - zmensovani.   //
	// Verze: 24.5.2005 15:00                          //
	// (predpokladana velikost okna 1200 x 400 pixelu) //
	// _drawable = sglCreateDrawable(1200, 400);       //
	/// //////////////////////////////////////////////////
	CreateScene('Test 5C', 1200, 400);
	try
		sglClear(0, 0, 0, 0);

		sglOrtho2D(-10, 10, -10, 10);

		sglMatrixMode(sglModelMatrix);
		sglLoadIdentity();

		sglEnableTexturing(True);

		texture[0] := sglCreateTexture();
		sglLoadTexture(GraphDir + '_textura5G.png');
		sglTexFilter(SGL_TEXTURE_FILTER_NEAREST);
		sglTexMode(SGL_TEXTURE_MODE_REPLACE);

		sglMatrixMode(sglTextureMatrix);
		sglLoadIdentity();

		texture[1] := sglCreateTexture();
		sglLoadTexture(GraphDir + '_textura5G.png');
		sglTexFilter(SGL_TEXTURE_FILTER_LINEAR);
		sglTexMode(SGL_TEXTURE_MODE_REPLACE);

		sglMatrixMode(sglTextureMatrix);
		sglLoadIdentity();

		texture[2] := sglCreateTexture();
		sglLoadTexture(GraphDir + '_textura5G.png');
		sglTexFilter(SGL_TEXTURE_FILTER_MIPMAP);
		sglTexMode(SGL_TEXTURE_MODE_REPLACE);

		sglMatrixMode(sglTextureMatrix);
		sglLoadIdentity();

		delta := 400;

		x := 0;
		for i := 0 to 2 do
		begin
			sglViewport(x, 0, delta, delta);

			sglBindTexture(texture[i]);

			sglBegin(sglTriangleStrip);

			sglTexCoord(0.0, 0.0, 1);
			sglColor(255, 255, 255, 0);
			sglVertex(-7.0, -7.0, 1);

			sglTexCoord(1.0, 0.0, 1);
			sglColor(192, 192, 192, 0);
			sglVertex(7.0, -7.0, 1);

			sglTexCoord(0.0, 1.0, 1);
			sglColor(64, 64, 64, 0);
			sglVertex(-7.0, 7.0, 1);

			sglTexCoord(1.0, 1.0, 1);
			sglColor(128, 128, 128, 0);
			sglVertex(7.0, 7.0, 1);

			sglEnd();

			x := x + delta;
		end;

		for i := 0 to 2 do
			sglDeleteTexture(texture[i]);

		// sglSaveImage(GraphDir + 'out5C.tga');

		/// //////////////////////////////////////////////////
		// Test 5C: konec testu.                           //
		/// //////////////////////////////////////////////////
	finally
		FreeScene;
	end;
end;

procedure TfFunctions.ButtonTest5DClick(Sender: TObject);
var
	texture: array [0 .. 2] of SG;
	i, x, delta: SG;

begin
	/// //////////////////////////////////////////////////
	// Test 5D: test filtrovani textur - zvetsovani.   //
	// Verze: 24.5.2005 15:00                          //
	// (predpokladana velikost okna 1200 x 400 pixelu) //
	// _drawable = sglCreateDrawable(1200, 400);       //
	/// //////////////////////////////////////////////////
	CreateScene('Test 5D', 1200, 400);
	try
		sglClear(0, 0, 0, 0);

		sglOrtho2D(-10, 10, -10, 10);

		sglMatrixMode(sglModelMatrix);
		sglLoadIdentity();

		sglEnableTexturing(True);

		texture[0] := sglCreateTexture();
		sglLoadTexture(GraphDir + 'textura5H.tga');
		sglTexFilter(SGL_TEXTURE_FILTER_NEAREST);
		sglTexMode(SGL_TEXTURE_MODE_REPLACE);

		sglMatrixMode(sglTextureMatrix);
		sglLoadIdentity();

		texture[1] := sglCreateTexture();
		sglLoadTexture(GraphDir + 'textura5H.tga');
		sglTexFilter(SGL_TEXTURE_FILTER_LINEAR);
		sglTexMode(SGL_TEXTURE_MODE_REPLACE);

		sglMatrixMode(sglTextureMatrix);
		sglLoadIdentity();

		texture[2] := sglCreateTexture();
		sglLoadTexture(GraphDir + 'textura5H.tga');
		sglTexFilter(SGL_TEXTURE_FILTER_MIPMAP);
		sglTexMode(SGL_TEXTURE_MODE_REPLACE);

		sglMatrixMode(sglTextureMatrix);
		sglLoadIdentity();

		delta := 400;

		x := 0;
		for i := 0 to 2 do
		begin
			sglViewport(x, 0, delta, delta);

			sglBindTexture(texture[i]);

			sglBegin(sglTriangleStrip);

			sglTexCoord(0.0, 0.0, 1);
			sglColor(255, 255, 255, 0);
			sglVertex(-7.0, -7.0, 1);

			sglTexCoord(1.0, 0.0, 1);
			sglColor(192, 192, 192, 0);
			sglVertex(7.0, -7.0, 1);

			sglTexCoord(0.0, 1.0, 1);
			sglColor(64, 64, 64, 0);
			sglVertex(-7.0, 7.0, 1);

			sglTexCoord(1.0, 1.0, 1);
			sglColor(128, 128, 128, 0);
			sglVertex(7.0, 7.0, 1);

			sglEnd();

			x := x + delta;
		end;

		for i := 0 to 2 do
			sglDeleteTexture(texture[i]);

		// sglSaveImage(GraphDir + 'out5D.tga');

		/// //////////////////////////////////////////////////
		// Test 5D: konec testu.                           //
		/// //////////////////////////////////////////////////
	finally
		FreeScene;
	end;
end;

procedure TfFunctions.ButtonTest5EClick(Sender: TObject);
var
	texture: array [0 .. 3] of SG;
	i, x, delta: SG;
begin
	/// //////////////////////////////////////////////////
	// Test 5E: zpusoby aplikace textur.               //
	// Verze: 24.5.2005 15:00                          //
	// (predpokladana velikost okna 1200 x 300 pixelu) //
	// _drawable = sglCreateDrawable(1200, 300);       //
	/// //////////////////////////////////////////////////
	CreateScene('Test 5E', 1200, 300);
	try
		sglClear(0, 0, 0, 0);

		sglOrtho2D(-10, 10, -10, 10);

		sglMatrixMode(sglModelMatrix);
		sglLoadIdentity();

		sglEnableTexturing(True);

		texture[0] := sglCreateTexture();
		sglLoadTexture(GraphDir + 'textura5A.png');
		sglTexFilter(SGL_TEXTURE_FILTER_LINEAR);
		sglTexMode(SGL_TEXTURE_MODE_COLOR);

		sglMatrixMode(sglTextureMatrix);
		sglLoadIdentity();

		texture[1] := sglCreateTexture();
		sglLoadTexture(GraphDir + 'textura5A.png');
		sglTexFilter(SGL_TEXTURE_FILTER_LINEAR);
		sglTexMode(SGL_TEXTURE_MODE_REPLACE);

		sglMatrixMode(sglTextureMatrix);
		sglLoadIdentity();

		texture[2] := sglCreateTexture();
		sglLoadTexture(GraphDir + 'textura5A.png');
		sglTexFilter(SGL_TEXTURE_FILTER_LINEAR);
		sglTexMode(SGL_TEXTURE_MODE_ADD);

		sglMatrixMode(sglTextureMatrix);
		sglLoadIdentity();

		texture[3] := sglCreateTexture();
		sglLoadTexture(GraphDir + 'textura5A.png');
		sglTexFilter(SGL_TEXTURE_FILTER_LINEAR);
		sglTexMode(SGL_TEXTURE_MODE_MUL);

		sglMatrixMode(sglTextureMatrix);
		sglLoadIdentity();

		delta := 300;

		x := 0;
		for i := 0 to 3 do
		begin
			sglViewport(x, 0, delta, delta);

			sglBindTexture(texture[i]);

			sglBegin(sglTriangleStrip);

			sglTexCoord(0.0, 0.0, 1);
			sglColor(255, 255, 255, 0);
			sglVertex(-7.0, -7.0, 1);

			sglTexCoord(1.0, 0.0, 1);
			sglColor(192, 192, 192, 0);
			sglVertex(7.0, -7.0, 1);

			sglTexCoord(0.0, 1.0, 1);
			sglColor(0, 0, 0, 0);
			sglVertex(-7.0, 7.0, 1);

			sglTexCoord(1.0, 1.0, 1);
			sglColor(128, 0, 128, 0);
			sglVertex(7.0, 7.0, 1);

			sglEnd();

			x := x + delta;
		end;

		for i := 0 to 3 do
			sglDeleteTexture(texture[i]);

		// sglSaveImage(GraphDir + 'out5E.tga');

		/// //////////////////////////////////////////////////
		// Test 5E: konec testu.                           //
		/// //////////////////////////////////////////////////
	finally
		FreeScene;
	end;
end;

procedure TfFunctions.ButtonTest5FClick(Sender: TObject);
var
	texture: SG;
begin
	/// //////////////////////////////////////////////////
	// Test 5F: zmensovani textur - mipmapy.           //
	// Verze: 24.5.2005 15:00                          //
	// (predpokladana velikost okna 512 x 512 pixelu)  //
	// _drawable = sglCreateDrawable(512, 512);        //
	/// //////////////////////////////////////////////////
	CreateScene('Test 5F', 512, 512);
	try
		sglClear(0, 0, 0, 0);

		sglOrtho2D(0, 10, 0, 10);

		sglViewport(0, 0, 512, 512);

		sglMatrixMode(sglModelMatrix);
		sglLoadIdentity();

		sglEnableTexturing(True);

		texture := sglCreateTexture();
		sglLoadTexture(GraphDir + 'textura5I.png');
		// sglTexFilter(SGL_TEXTURE_FILTER_NEAREST);
		sglTexFilter(SGL_TEXTURE_FILTER_MIPMAP);
		sglTexMode(SGL_TEXTURE_MODE_REPLACE);
		// sglTexMode(SGL_TEXTURE_MODE_COLOR);

		sglMatrixMode(sglTextureMatrix);
		sglLoadIdentity();

		sglBegin(sglTriangleStrip);

		sglTexCoord(0.0, 0.0, 1);
		sglVertex(0.0, 0.0, 1);

		sglTexCoord(1.0, 0.0, 1);
		sglVertex(10.0, 0.0, 1);

		sglTexCoord(0.0, 1.0, 1);
		sglVertex(0.0, 5.0, 1);

		sglTexCoord(1.0, 1.0, 1);
		sglVertex(10.0, 5.0, 1);

		sglEnd();

		sglBegin(sglTriangleStrip);

		sglTexCoord(0.0, 0.0, 1);
		sglVertex(2.5, 5.0, 1);

		sglTexCoord(1.0, 0.0, 1);
		sglVertex(7.5, 5.0, 1);

		sglTexCoord(0.0, 1.0, 1);
		sglVertex(2.5, 7.5, 1);

		sglTexCoord(1.0, 1.0, 1);
		sglVertex(7.5, 7.5, 1);

		sglEnd();

		sglBegin(sglTriangleStrip);

		sglTexCoord(0.0, 0.0, 1);
		sglVertex(3.75, 7.5, 1);

		sglTexCoord(1.0, 0.0, 1);
		sglVertex(6.25, 7.5, 1);

		sglTexCoord(0.0, 1.0, 1);
		sglVertex(3.75, 8.75, 1);

		sglTexCoord(1.0, 1.0, 1);
		sglVertex(6.25, 8.75, 1);

		sglEnd();

		sglBegin(sglTriangleStrip);

		sglTexCoord(0.0, 0.0, 1);
		sglVertex(4.375, 8.75, 1);

		sglTexCoord(1.0, 0.0, 1);
		sglVertex(5.625, 8.75, 1);

		sglTexCoord(0.0, 1.0, 1);
		sglVertex(4.375, 9.375, 1);

		sglTexCoord(1.0, 1.0, 1);
		sglVertex(5.625, 9.375, 1);

		sglEnd();

		sglDeleteTexture(texture);

		// sglSaveImage(GraphDir + 'out5F.tga');

		/// //////////////////////////////////////////////////
		// Test 5F: konec testu.                           //
		/// //////////////////////////////////////////////////
	finally
		FreeScene;
	end;
end;

procedure TfFunctions.ButtonTestClick(Sender: TObject);
var
	i, j: SG;
	W, H: SG;
	A: SG;
begin
	W := fMain.ImageP.Width;
	H := fMain.ImageP.Height;
	CreateScene('Test', W, H);
	try
		for i := 0 to H - 1 do
		begin
			sglColor(0, 255 * i div (H - 1), $A0, 255 * i div (H - 1));
			sglBegin(sglLines);
			sglVertex(0, i, 1);
			sglVertex(W - 1, i, 1);
			sglEnd;
		end;

		sglOrtho2D(1, 6, 4, 7);

		{ sglBegin(sglPolygon);
			sglColor($ff, 0, $ff);
			sglVertex(2, 5);
			sglColor(0, $ff, $ff);
			sglVertex(3, 6);
			sglColor($ff, $ff, 0);
			sglVertex(4, 6);
			sglColor($ff, $ff, $ff);
			sglVertex(5, 5);
			sglEnd; }

		sglColor($FF, $FF, 0);

		sglLoadIdentity;
		sglOrtho2D(-4.5 - 2, 4.5 + 2, -4.5, 4.5);
		sglHatching(SGL_HATCH_BRICKS, 0, 0, 0, 0);

		sglBegin(sglPolygon);
		sglColor(255, 0, 0, 0);
		sglVertex(4, 0, 1);
		sglColor(0, 255, 0, 0);
		sglVertex(2, 1, 1);
		sglColor(0, 0, 255, 0);
		sglVertex(4, 4, 1);
		sglColor(255, 255, 0, 0);
		sglVertex(1, 2, 1);
		sglColor(255, 0, 255, 0);
		sglVertex(0, 4, 1);
		sglColor(0, 255, 255, 0);
		sglVertex(-1, 2, 1);
		sglColor(255, 255, 255, 0);
		sglVertex(-4, 4, 1);
		sglColor(128, 0, 0, 0);
		sglVertex(-2, 1, 1);
		sglColor(0, 128, 0, 0);
		sglVertex(-4, 0, 1);
		sglColor(0, 0, 128, 0);
		sglVertex(-2, -1, 1);
		sglColor(128, 128, 0, 0);
		sglVertex(-4, -4, 1);
		sglColor(128, 0, 128, 0);
		sglVertex(-1, -2, 1);
		sglColor(0, 128, 128, 0);
		sglVertex(0, -4, 1);
		sglColor(128, 128, 128, 0);
		sglVertex(1, -2, 1);
		sglColor(64, 190, 70, 0);
		sglVertex(4, -4, 1);
		sglColor(166, 32, 65, 0);
		sglVertex(2, -1, 1);
		sglEnd();

		// sglOrtho2D(1, 6, 4, 7);
		sglOrtho2D(4, 10, 3.5, 8);
		sglHatching(SGL_HATCH_NONE, 0, 0, 0, 0);
		{ sglScale(2, 2);
			sglBegin(sglBezierCCurve);
			sglColor($ff, 0, $ff);
			sglVertex(2, 5);
			sglColor(0, $ff, $ff);
			sglVertex(3, 6);
			sglColor($ff, $ff, 0);
			sglVertex(4, 6);
			sglColor($ff, $ff, $ff);
			sglVertex(5, 5);
			sglEnd; }

		sglViewport(W div 4, H div 4, W div 2, H div 2);
		sglLoadIdentity;
		// sglScale(0.1, 0.1);
		for i := 0 to 15 do
		begin
			sglBegin(sglFergusonCurve);
			sglColor($FFFF00);
			sglVertex(6, 5, 1);
			sglColor($FFFF00);
			sglVertex(10 * Sin(2 * pi * i / 16), 10 * Cos(2 * pi * i / 16), 1);
			sglColor($00FF00);
			sglVertex(8, 5, 1);
			sglColor($00FFFF);
			sglVertex(1, -10, 1);
			sglEnd;
		end;
		{ sglColor($ffffff);
			sglBegin(sglLines);
			sglVertex(5, 5);
			sglVertex(9, 5);
			sglVertex(6, 0);
			sglVertex(6, 10);
			sglEnd; }

		sglViewport(0, 0, W, H);

		sglEnableTexturing(True);
		Id := sglCreateTexture;
		sglBindTexture(Id);
		sglLoadTexture(GraphDir + 'Logo.png');
		sglOrtho2D(0, 16.0, 0, 10.0);

		sglMatrixMode(sglTextureMatrix);
		sglLoadIdentity;

		sglMatrixMode(sglModelMatrix);
		sglTexMode(SGL_TEXTURE_MODE_MUL); // Shadowing
		sglTexFilter(SGL_TEXTURE_FILTER_MIPMAP_LINEAR);

		sglEnableBlending(True);
		sglBlendFunc(SGL_BLEND_FG_ALPHA);
		for i := 0 to 0 do
		begin
			sglLoadIdentity;
			sglTranslate(-1, -4);
			sglTranslate(i * 4, 0);

			for j := 0 to 7 do
			begin
				A := 255 - 32 * j;
				sglBegin(sglPolygon);

				sglColor($FF, $FF, $FF, A);
				sglTexCoord(0, 0);
				sglVertex(1.1, 5);

				sglColor($5F, $5F, $5F, A);
				sglTexCoord(0, 1);
				sglVertex(2, 6);

				sglColor($00, $00, $00, A);
				sglTexCoord(1, 1);
				sglVertex(4, 6);

				sglColor($FF, $FF, $FF, A);
				sglTexCoord(1, -0);
				sglVertex(4.9, 5);

				sglEnd;

				sglScale(0.8, 0.8);
				sglTranslate(1, 4);
			end;
		end;
		sglDeleteTexture(Id);
	finally
		FreeScene;
	end;
end;

procedure TfFunctions.ComboBoxBlurRadiusChange(Sender: TObject);
begin
	GeneratePreview;
end;

procedure TfFunctions.ComboBoxBlurDirectionChange(Sender: TObject);
begin
	GeneratePreview;
end;

procedure TfFunctions.ComboBoxAngleChange(Sender: TObject);
begin
	GeneratePreview;
end;

procedure TfFunctions.ComboBoxIntensityChange(Sender: TObject);
begin
	GeneratePreview;
end;

procedure TfFunctions.GeneratePreview;
begin
{	if CheckBoxPreview.Checked then
		Preview(); }
end;

end.
