// * File:     CXY\uInfo.pas
// * Created:  1998-02-01
// * Modified: 2010-01-09
// * Version:  2.2.47.104
// * Author:   David Safranek (Safrad)
// * E-Mail:   safrad at email.cz
// * Web:      http://safrad.own.cz

unit uInfo;

interface

uses
	uDForm,
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
	StdCtrls, uDButton, uDLabel, ExtCtrls, uDWinControl, uDEdit;

type
	TfInfo = class(TDForm)
		Bevel1: TBevel;
		Bevel2: TBevel;
		Bevel3: TBevel;
		Bevel4: TBevel;
		LabelX1: TLabel;
		LabelX2: TLabel;
		LabelX4: TLabel;
		LabelX5: TLabel;
		PanelOX: TDLabel;
		PanelOY: TDLabel;
		PanelX: TDLabel;
		PanelY: TDLabel;
		PanelSX1: TDLabel;
		PanelSY1: TDLabel;
		PanelSX2: TDLabel;
		PanelSY2: TDLabel;
		ComboBoxZoom: TComboBox;
		ButtonHand: TDButton;
		ButtonSelect: TDButton;
		DButtonTransparentColor: TDButton;
		PanelPictX: TDLabel;
		LabelX3: TLabel;
		PanelPictY: TDLabel;
		PanelColor: TDEdit;
		Bevel7: TBevel;
		LabelX6: TLabel;
		PanelSW: TDLabel;
		PanelSH: TDLabel;
		ButtonPipette: TDButton;
		EditLastOperationTime: TLabeledEdit;
		LabelTransparentColor: TLabel;
		procedure FormCreate(Sender: TObject);
		procedure ComboBoxZoomChange(Sender: TObject);
		procedure ButtonHandClick(Sender: TObject);
		procedure ButtonSelectClick(Sender: TObject);
		procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
		procedure DButtonTransparentColorClick(Sender: TObject);
		procedure PanelColorChange(Sender: TObject);
		procedure ButtonPipetteClick(Sender: TObject);
		procedure FormClose(Sender: TObject; var Action: TCloseAction);
		procedure FormShow(Sender: TObject);
	private
		{ Private declarations }
	public
		{ Public declarations }
		procedure RWOptions(const Save: Boolean);
		procedure InitXY;
		procedure InitZoom;
		procedure ShowOffset;
		procedure InitMouseMode;
	end;

var
	fInfo: TfInfo;

implementation

{$R *.dfm}

uses
	Math,
	uMain, uProject,
	uDBitmap, uGColor, uInputFormat, uDIniFile, uTypes, uOutputFormat, uMath, uGraph, uColor,
	uParserMsg,
	uDrawStyle, uMenus, uDictionary;

procedure TfInfo.FormCreate(Sender: TObject);
begin
	Background := baGradient;
	RWOptions(False);
	Dictionary.TranslateForm(Self);
end;

procedure TfInfo.InitMouseMode;
begin
	ButtonPipette.Down := fMain.MouseMode = mmPipette;
	ButtonSelect.Down := fMain.MouseMode = mmSelect;
	ButtonHand.Down := fMain.MouseMode = mmScroll;
end;

procedure TfInfo.InitXY;
var
	C: TRGBA;
	B: TDBitmap;
	// Ok: BG;
begin
	if (fMain.OpenedFiles.Index >= 0) and (Project.Bitmap <> nil) then
	begin
		B := Project.Bitmap;
		// if (fMain.ImageP.UserMouseX >=0) and (fMain.ImageP.UserMouseY >= 0) and (fMain.ImageP.UserMouseX < B.Width) and (fMain.ImageP.UserMouseY < B.Height) then
		{ if (Pict.Pipette.X < B.Width) and (Pict.Pipette.Y < B.Height) then
			begin
			Ok := True;
			end
			else
			Ok := False; }

		PanelX.Caption := NToS(B.Width);
		PanelY.Caption := NToS(B.Height);
		EditLastOperationTime.Text := NToS
			(RoundDivS8(1000000 * Project.OperationTime, PerformanceFrequency), 6);

		PanelSX1.Caption := NToS(Project.Group.Left);
		PanelSX1.Update;
		PanelSY1.Caption := NToS(Project.Group.Top);
		PanelSY1.Update;
		PanelSX2.Caption := NToS(Project.Group.Right);
		PanelSX2.Update;
		PanelSY2.Caption := NToS(Project.Group.Bottom);
		PanelSY2.Update;
		PanelSW.Caption := NToS(Abs(Project.Group.Right - Project.Group.Left) + 1);
		PanelSW.Update;
		PanelSH.Caption := NToS(Abs(Project.Group.Bottom - Project.Group.Top) + 1);
		PanelSH.Update;

		if B.Transparent then
		begin
			DButtonTransparentColor.Color := B.TransparentColor;
			InitButton(DButtonTransparentColor);
		end
		else
		begin
			DButtonTransparentColor.Color := clBtnFace;
			DButtonTransparentColor.Font.Color := clWindowText;
			DButtonTransparentColor.Caption := '';
		end;
	end
	else
	begin
		B := nil;
		// Ok := False;
		DButtonTransparentColor.Caption := '';
		DButtonTransparentColor.Color := clBtnFace;
		PanelX.Caption := '';
		PanelY.Caption := '';

		EditLastOperationTime.Text := '';

		PanelSX1.Caption := '';
		PanelSX1.Update;
		PanelSY1.Caption := '';
		PanelSY1.Update;
		PanelSX2.Caption := '';
		PanelSX2.Update;
		PanelSY2.Caption := '';
		PanelSY2.Update;
		PanelSW.Caption := '';
		PanelSW.Update;
		PanelSH.Caption := '';
		PanelSH.Update;
	end;
	PanelColor.OnChange := nil;
	try
		if Assigned(B) and B.PixelOnBitmap(Project.Pipette) then
		begin
			PanelPictX.Caption := NToS(Project.Pipette.X);
			PanelPictY.Caption := NToS(Project.Pipette.Y);
			GetPix(B.Data, B.ByteX, Project.Pipette.X, Project.Pipette.Y, C);
			C.L := ColorRB(C.L);
			PanelColor.Color := C.L;
			PanelColor.Font.Color := NegMonoColor(PanelColor.Color);
			PanelColor.Text := ColorToString(C.L { Canvas.Pixels[PictX, PictY] } );
		end
		else
		begin
			PanelPictX.Caption := '';
			PanelPictY.Caption := '';
			PanelColor.Color := clBtnFace;
			PanelColor.Text := '';
		end;
	finally
		PanelColor.OnChange := PanelColorChange;
	end;
	DButtonTransparentColor.Enabled := fMain.OpenedFiles.Index >= 0;
end;

function RoundD(const X: Extended; const d: Integer): Extended;
begin
	{ if x >= 1000 then
		Result := RoundTo(x, d - 2)
		else } if X >= 100 then
		Result := RoundTo(X, d - 3)
	else if X >= 10 then
		Result := RoundTo(X, d - 4)
	else if X >= 1 then
		Result := RoundTo(X, d - 5)
	else if X >= 0.1 then
		Result := RoundTo(X, d - 6)
	else if X >= 0.01 then
		Result := RoundTo(X, d - 7)
	else if X >= 0.001 then
		Result := RoundTo(X, d - 8)
	else if X >= 0.0001 then
		Result := RoundTo(X, d - 9)
		{ else if x >= 0.00001 then
			Result := RoundTo(x, d - 10)
			else if x >= 0.000001 then
			Result := RoundTo(x, d - 11) }
	else
		Result := X;
end;

procedure TfInfo.InitZoom;
begin
	ComboBoxZoom.OnChange := nil;
	try
		ComboBoxZoom.Text := FloatToStr(RoundD(100 * fMain.ImageP.Zoom, 3)) + '%';
	finally
		ComboBoxZoom.OnChange := ComboBoxZoomChange;
	end;
end;

procedure TfInfo.ComboBoxZoomChange(Sender: TObject);
var
	Messages: TParserMessages;
begin
	Messages := TParserMessages.Create;
	try
		Project.Zoom := StrToValE(ComboBoxZoom.Text, True, 1 / 1000, 1, 1000, Messages);
		SetDesign(ComboBoxZoom, Messages);
		fMain.ImageP.Zoom := Project.Zoom;
	finally
		Messages.Free;
	end;
end;

procedure TfInfo.ShowOffset;
begin
	if fMain.OpenedFiles.Index >= 0 then
	begin
		PanelOX.Caption := NToS(Project.Offset.X);
		PanelOX.Update;
		PanelOY.Caption := NToS(Project.Offset.Y);
		PanelOY.Update;
	end
	else
	begin
		PanelOX.Caption := '';
		PanelOY.Caption := '';
	end;
end;

procedure TfInfo.ButtonHandClick(Sender: TObject);
begin
	fMain.SetMouseMode(mmScroll)
end;

procedure TfInfo.ButtonSelectClick(Sender: TObject);
begin
	fMain.SetMouseMode(mmSelect)
end;

procedure TfInfo.RWOptions(const Save: Boolean);
begin
	MainIni.RWFormPos(Self, Save);
end;

procedure TfInfo.FormClose(Sender: TObject; var Action: TCloseAction);
begin
	fMain.Info1.Checked := False;
	UpdateIcons(fMain.MainMenu1, fMain.PanelTool);
end;

procedure TfInfo.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
	RWOptions(True);
end;

procedure TfInfo.DButtonTransparentColorClick(Sender: TObject);
var
	C: TColor;
begin
	if fMain.OpenedFiles.Index >= 0 then
	begin
		C := Project.Bitmap.TransparentColor;
		if GetColor('Color', C, clPurple, nil) then
		begin
			Project.Bitmap.TransparentColor := C;
			Project.Bitmap.Transparent := True;
		end;
		DButtonTransparentColor.Color := C;
		InitButton(DButtonTransparentColor);
	end;
end;

procedure TfInfo.PanelColorChange(Sender: TObject);
var
	C: TRGBA;
begin
	if fMain.OpenedFiles.Index >= 0 then
	begin
		fMain.CreateUndo('Change Pixel', TMyBitmapUndo);
		GetPix(Project.Bitmap.Data, Project.Bitmap.ByteX, Project.Pipette.X, Project.Pipette.Y,
			C);
		C.L := StringToColor(PanelColor.Text); // StrToValI(PanelColor.Text, True, MinInt, C.L, MaxInt, 1, nil);
		C.L := ColorRB(C.L);
		Pix(Project.Bitmap.Data, Project.Bitmap.ByteX, Project.Pipette.X, Project.Pipette.Y, @C,
			ef16);
		fMain.UpdateImage;
	end;
end;

procedure TfInfo.ButtonPipetteClick(Sender: TObject);
begin
	fMain.SetMouseMode(mmPipette)
end;

procedure TfInfo.FormShow(Sender: TObject);
begin
	InitZoom;
	InitXY;
	ShowOffset;
	InitMouseMode;
end;

end.
