// * File:     CXY\uMain.pas
// * Created:  1998-02-01
// * Modified: 2010-11-13
// * Version:  2.2.47.104
// * Author:   David Safranek (Safrad)
// * E-Mail:   safrad at email.cz
// * Web:      http://safrad.own.cz

unit uMain;

interface

uses
	uTypes, uDBitmap, uUndo, {$IFDEF RealMotionBlur} uRealMotionBlur, {$ENDIF} uOptions, uStrings,
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
	StdCtrls, ExtCtrls, ComCtrls, ExtDlgs, Menus, ActnList,
	uDButton, uOpenedFiles, uDImage, uDLabel, uDForm, Dialogs, uDWinControl, uUndoRedo,
	uOpenedFileItem,
	uGraphicObject, uProject;

type
	TMouseMode = (mmNone, mmScroll, mmPipette, mmSelect, mmAddObject);

	TSelectionMode = (smNone, smStart, smStartEx, smMoveAll, smStartMoveVectors, smMoveVectors,
		smLeft, smRight, smTop, smBottom, smLeftTop, smLeftBottom, smRightTop, smRightBottom);

	TfMain = class(TDForm)
		OpenPictureDialog1: TOpenPictureDialog;
		SavePictureDialog1: TSavePictureDialog;
		MainMenu1: TMainMenu;
		Edit1: TMenuItem;
		Undo1: TMenuItem;
		Redo1: TMenuItem;
		N1: TMenuItem;
		File1: TMenuItem;
		Start1: TMenuItem;
		ClearUndo1: TMenuItem;
		ClearRedo1: TMenuItem;
		Functions1: TMenuItem;
		Stop1: TMenuItem;
		Window1: TMenuItem;
		N6: TMenuItem;
		Cut1: TMenuItem;
		CopyX1: TMenuItem;
		Paste1: TMenuItem;
		Delete1: TMenuItem;
		SelectAll1: TMenuItem;
		Help1: TMenuItem;
		ImageP: TDImage;
		Function1: TMenuItem;
		BmpToJpeg1: TMenuItem;
		BmpTo100Jpeg1: TMenuItem;
		ColorCount1: TMenuItem;
		ResizePictures1: TMenuItem;
		Info1: TMenuItem;
		Zoom1: TMenuItem;
		FileExtensions1: TMenuItem;
		OpenedFiles: TOpenedFiles;
		Options1: TMenuItem;
		ActionList1: TActionList;
		ActionUndo: TAction;
		ActionRedo: TAction;
		AdvancedMode1: TMenuItem;
		StatusBar: TStatusBar;
		ActionDelete: TAction;
		AddVector1: TMenuItem;
		N2: TMenuItem;
		VelocityMode1: TMenuItem;
		Select1: TMenuItem;
		Hand1: TMenuItem;
		None1: TMenuItem;
		Pipette1: TMenuItem;
		ActionMoveUp: TAction;
		ActionMoveDown: TAction;
		ActionMoveLeft: TAction;
		ActionMoveRight: TAction;
		ProcessWithVariableSpeed1: TMenuItem;
		ProjectSettings1: TMenuItem;
		ApplicationSettings1: TMenuItem;
		RenderedImage1: TMenuItem;
		Status1: TMenuItem;
		Overview1: TMenuItem;
		View1: TMenuItem;
		ProcessAllOpenedProjects1: TMenuItem;
		RenderFolder1: TMenuItem;
		AddBezierCube1: TMenuItem;
		ImportImage1: TMenuItem;
		Layers1: TMenuItem;
		N3: TMenuItem;
		Timer1: TTimer;
		InvertSelection1: TMenuItem;
		RealTimePreview1: TMenuItem;
		Image1: TMenuItem;
		ImageInfo1: TMenuItem;
		Resize1: TMenuItem;
		Rotate1: TMenuItem;
		Crop1: TMenuItem;
		AddCircleEllipse1: TMenuItem;
		AddSquareRectangle1: TMenuItem;
		AddSwirl1: TMenuItem;
		AddButton1: TMenuItem;
		AddLens1: TMenuItem;
		AddZoom1: TMenuItem;
		procedure Start1Click(Sender: TObject);
		procedure ClearUndo1Click(Sender: TObject);
		procedure ClearRedo1Click(Sender: TObject);
		procedure ButtonCUClick(Sender: TObject);
		procedure ButtonCRClick(Sender: TObject);
		procedure ImagePMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
		procedure ImagePMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState;
			X, Y: Integer);
		procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
		procedure Functions1Click(Sender: TObject);
		procedure FormCreate(Sender: TObject);
		procedure CopyX1Click(Sender: TObject);
		procedure Paste1Click(Sender: TObject);
		procedure Cut1Click(Sender: TObject);
		procedure Stop1Click(Sender: TObject);
		procedure SelectAll1Click(Sender: TObject);
		procedure ImagePFill(Sender: TObject);
		procedure FormDestroy(Sender: TObject);
		procedure BmpToJpeg1Click(Sender: TObject);
		procedure BmpTo100Jpeg1Click(Sender: TObject);
		procedure FormShow(Sender: TObject);
		procedure DButtonTransparentColorClick(Sender: TObject);
		procedure ColorCount1Click(Sender: TObject);
		procedure ResizePictures1Click(Sender: TObject);
		procedure Info1Click(Sender: TObject);
		procedure FileExtensions1Click(Sender: TObject);
		procedure OpenedFilesChangeFile(Sender: TObject);
		function OpenedFilesFreeFile(Sender: TObject; const Item: TOpenedFileItem): Boolean;
		function OpenedFilesLoadFromFile(Sender: TObject; var FileName: TFileName): Boolean;
		function OpenedFilesNewFile(Sender: TObject; const Item: TOpenedFileItem): Boolean;
		function OpenedFilesSaveToFile(Sender: TObject; var FileName: TFileName): Boolean;
		function OpenedFilesGetFilePos(Sender: TObject; const Data: Pointer): String;
		procedure OpenedFilesSetFilePos(Sender: TObject; FilePos: String);
		procedure WMDropFiles(var Msg: TWMDropFiles);
		message WM_DropFiles;
		procedure ImagePKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
		procedure ImagePMouseUp(Sender: TObject; Button: TMouseButton; Shift: TShiftState;
			X, Y: Integer);
		procedure FormResize(Sender: TObject);
		procedure ActionUndoRedoExecute(Sender: TObject);
		procedure AdvancedMode1Click(Sender: TObject);
		procedure ActionDeleteExecute(Sender: TObject);
		procedure AddX1Click(Sender: TObject);
		procedure VelocityMode1Click(Sender: TObject);
		procedure Select1Click(Sender: TObject);
		procedure Hand1Click(Sender: TObject);
		procedure Pipette1Click(Sender: TObject);
		procedure None1Click(Sender: TObject);
		procedure ImagePZoomChange(Sender: TObject);
		procedure ActionMoveUpDownExecute(Sender: TObject);
		procedure ActionMoveLeftRigthExecute(Sender: TObject);
		procedure ProcessWithVariableSpeed1Click(Sender: TObject);
		procedure FormKeyPress(Sender: TObject; var Key: Char);
		procedure ProjectSettings1Click(Sender: TObject);
		procedure ApplicationSettings1Click(Sender: TObject);
		procedure RenderedImage1Click(Sender: TObject);
		procedure Status1Click(Sender: TObject);
		procedure Overview1Click(Sender: TObject);
		procedure ProcessAllOpenedProjects1Click(Sender: TObject);
		procedure RenderFolder1Click(Sender: TObject);
		procedure ImportImage1Click(Sender: TObject);
		procedure Layers1Click(Sender: TObject);
		procedure Timer1Timer(Sender: TObject);
		procedure InvertSelection1Click(Sender: TObject);
		procedure RealTimePreview1Click(Sender: TObject);
		procedure ImageInfo1Click(Sender: TObject);
		procedure Crop1Click(Sender: TObject);
		procedure Resize1Click(Sender: TObject);
		procedure Rotate1Click(Sender: TObject);
	private
		{ Private declarations }
		// MouseX, MouseY: Integer;
		BevelMenu: TBevel;
		AddObjectIndex: SG;

		BmpBack: TDBitmap;
		FMouseMode: TMouseMode;
		StartGroup: TRect;
		U: TPoint;
		SelectionMode: TSelectionMode;
		procedure SetMode;
		procedure InitStatusBar;
		procedure DrawObjects;
		function SelectObject(const X, Y: SG; const Test: BG; const Shift: BG; const MouseUp: BG): BG;
			overload;
		function SelectObject(const FloPoint: TFloPoint; const Test: BG; const Shift: BG;
			const MouseUp: BG): BG; overload;
		procedure DeselectAllObjects;
		procedure ApplicationOptionChanged(const OptionIndex: SG);
		procedure ProjectOptionChanged(const OptionIndex: SG);
		procedure SelectImportImage;
	public
		{ Public declarations }
		StartGraphicObjects: TArrayOfGraphicObject; // TODO Rename
		BmpSource2: TDBitmap;
		PanelTool: TPanel;
		GetBitmap: TDBitmap;
		procedure InitMenu;
		procedure RWOptions(const Save: Boolean);
		procedure CreateUndo(const Name: string; const C: TClass);
		procedure UpdateImage;
		procedure SetMouseMode(const MouseMode: TMouseMode);
		property MouseMode: TMouseMode read FMouseMode;
	end;

var
	fMain: TfMain;

type
	TApplicationSettings = (asAlgorithm, asRenderingQuality, asAutomaticallyNumberOfThreads,
		asNumberOfThreads, asRenderOrder, asOpenRenderOutput, asSaveDirectionalImage, asUndoCountLimit,
		asUndoSizePercentOfRAM);

	TRealMotionBlurAlgorithm = (raBest, raDirection, raAll, raNearest3, raNearest2, raNearest);
	TRenderOrder = (roWindows, roLinesDown, roRandomWindows, roWindowsFromCenter,
		roWindowsFromSelection, roFullProcessing);

var
	ApplicationOptions: array [TApplicationSettings] of TOption = (
		(
			Typ: vsCombo; Default: 0; Minimum: 0; Maximum: 4;
			DefaultStr: 'Best' + CharTab + 'Direction' + CharTab + 'All' + CharTab + 'Nearest 3' +
				CharTab + 'Nearest 2' + CharTab + 'Nearest'), //
		(Typ: vsCombo; Default: 0; Minimum: 0; Maximum: 1; DefaultStr: 'Low' + CharTab + 'High'), //
		(Typ: vsCheck; Default: 1; Minimum: 0; Maximum: 1), //
		(Typ: vsSpin; Default: 1; Minimum: 1; Maximum: 64), //
		(Typ: vsCombo; Default: 0; Minimum: 0; Maximum: 5;
			DefaultStr: 'Windows' + CharTab + 'Lines Down' + CharTab + 'Random Windows' + CharTab +
				'Windows from Center' + CharTab + 'Windows from Selection' + CharTab + 'Full processing'),
		//
		(Typ: vsCheck; Default: 1; Minimum: 0; Maximum: 1), //
		(Typ: vsCheck; Default: 0; Minimum: 0; Maximum: 1), //
		(Typ: vsSpin; Default: 1000; Minimum: 0; Maximum: MaxInt), //
		(Typ: vsSpin; Default: 20; Minimum: 0; Maximum: 100) //
		);

	ApplicationParams: array [TApplicationSettings] of TParam;

var
	NewX, NewY: SG;

function ObjectRect(const Source: TArrayOfGraphicObject): TFloRect;

implementation

{$R *.DFM}

uses
	ClipBrd, Jpeg, ShellAPI, Math, XMLDoc, XMLIntf, TypInfo, uFiles, uGraph, uGetInt, uFileExt,
	uSounds, uParams, uColor, uMsgDlg, uStart, uProjectInfo, uReg, uDIniFile, uAbout, uMenus,
	uScreen, uMsg, uSplash, uInputFormat, uGColor, uSystem, uMath, uOutputFormat, uAPI, uDrawStyle,
	uThreadPool, uSysInfo, ufStatus, uWave, uDelayedCall, uBlur, uParserMsg,
	uDictionary, uFunctions, uFunc, uSGL, uInfo, uWatch, uCommon, ufOptions,
	ufOverview, ufLayers;

const
	DefaultExt = 'rmb';

var
	Quality: SG = -90;

	{ TfMain }

procedure TfMain.InitMenu;
var
	i, j: Integer;
	L: UG;
	B: Boolean;
begin
	if (OpenedFiles.Index >= 0) and (Project.Bitmap <> nil) then
	begin
		if Assigned(fFunctions) then
		begin
			i := Project.UndoRedo.UndoCount;
			j := Project.UndoRedo.RedoCount;
			L := Project.UndoRedo.GetUndoSize;
			fFunctions.PanelU.Caption := NToS(i);
			fFunctions.PanelBU.Caption := BToStr(L);
			fFunctions.PanelBU1.Caption := NToS(L);

			L := Project.Bitmap.DataSize;
			fFunctions.PanelBN.Caption := BToStr(L);
			fFunctions.PanelBN1.Caption := NToS(L);

			L := Project.UndoRedo.GetRedoSize;
			fFunctions.PanelR.Caption := NToS(j);
			fFunctions.PanelBR.Caption := BToStr(L);
			fFunctions.PanelBR1.Caption := NToS(L);
		end;
		SelectAll1.Enabled := not SameData(@Project.Group, @Project.Margin, SizeOf(TRect));
		{ ((Project.Group.Left <> 0) or (Project.Group.Top <> 0) or
			(Project.Group.Right <> Project.Bitmap.Width - 1) or
			(Project.Group.Bottom <> Project.Bitmap.Height - 1)); }
{$IFDEF RealMotionBlur}
		B := True;
{$ELSE}
		B := (fFunctions.PageControl1.ActivePage <> fFunctions.TabSheetMemory) and
			(fFunctions.PageControl1.ActivePage <> fFunctions.TabSheetSGL);
{$ENDIF}
		FormatCaption(ClearUndo1, Project.UndoRedo.UndoCount);
		FormatCaption(ClearRedo1, Project.UndoRedo.RedoCount);
		Stop1.Enabled := Project.CommandRunCount > 0;
		RenderedImage1.Enabled := FileExists(Project.RenderFileName);
		RenderFolder1.Enabled := DirectoryExists(Project.RenderFolder);
	end
	else
	begin
		if Assigned(fFunctions) then
		begin
			fFunctions.PanelU.Caption := '';
			fFunctions.PanelBU.Caption := '';
			fFunctions.PanelBU1.Caption := '';

			fFunctions.PanelBN.Caption := '';
			fFunctions.PanelBN1.Caption := '';

			fFunctions.PanelR.Caption := '';
			fFunctions.PanelBR.Caption := '';
			fFunctions.PanelBR1.Caption := '';
		end;

		B := False;
		SelectAll1.Enabled := False;
		ClearUndo1.Enabled := False;
		ClearRedo1.Enabled := False;
		Stop1.Enabled := False;
		ImportImage1.Enabled := False;
		RenderedImage1.Enabled := False;
		RenderFolder1.Enabled := False;
	end;

	// ImportImage1.Enabled := Project.CommandRunCount = 0;
	InvertSelection1.Enabled := Project <> nil;

	ImportImage1.Enabled := Project <> nil;
	Crop1.Enabled := Project <> nil;
	Resize1.Enabled := Project <> nil;
	Rotate1.Enabled := Project <> nil;
	ImageInfo1.Enabled := Project <> nil;

	if Assigned(fInfo) then
		fInfo.InitXY;

	ClearUndo1.Enabled := Undo1.Enabled;
	ClearRedo1.Enabled := Redo1.Enabled;

	if Assigned(fFunctions) then
	begin
		// fFunctions.ButtonUndo.Enabled := ClearUndo1.Enabled;
		fFunctions.ClearUndo.Enabled := ClearUndo1.Enabled;
		fFunctions.ClearRedo.Enabled := ClearRedo1.Enabled;
	end;

	Cut1.Enabled := OpenedFiles.Index >= 0;
	CopyX1.Enabled := OpenedFiles.Index >= 0;
	Paste1.Enabled := OpenedFiles.Index >= 0;
	Delete1.Enabled := OpenedFiles.Index >= 0;

	ColorCount1.Enabled := OpenedFiles.Index >= 0;

	Start1.Enabled := B;

	UpdateIcons(MainMenu1, PanelTool);
end;

procedure TfMain.InitStatusBar;
var
	s: string;
	Selected: UG;
begin
	if (OpenedFiles.Index < 0) or (Project.Bitmap = nil) then
	begin
		s := '';
	end
	else
	begin
		Selected := Project.SelectedObjects;
		if Selected > 0 then
			s := ReplaceParam(Translate('%1 objects selected'), [NToS(Selected)])
		else
			s := ReplaceParam(Translate('%1 objects'), [NToS(Length(Project.GraphicObjects))]);
	end;
	StatusBar.Panels[0].Text := s;
end;

procedure TfMain.InvertSelection1Click(Sender: TObject);
var
	i: SG;
begin
	if not Assigned(Project) then
		Exit;

	i := 0;
	while (i < Length(Project.GraphicObjects)) do
	begin
		Project.GraphicObjects[i].S.Selected := not Project.GraphicObjects[i].S.Selected;
		Project.GraphicObjects[i].M.Selected := not Project.GraphicObjects[i].M.Selected;
		Project.GraphicObjects[i].E.Selected := not Project.GraphicObjects[i].E.Selected;
		Inc(i);
	end;
	InitStatusBar;
	UpdateImage;
end;

procedure TfMain.None1Click(Sender: TObject);
begin
	SetMouseMode(mmNone);
end;

procedure TfMain.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
	CanClose := OpenedFiles.CanClose;
	if CanClose then
	begin
		RWOptions(True);
	end;
end;

procedure TfMain.UpdateImage;
begin
	if (OpenedFiles.Index < 0) or (Project.Bitmap = nil) then
	begin
		ImageP.UserArea := Rect(0, 0, 0, 0);
		ImageP.UserBitmap := nil;
	end
	else
	begin
		ImageP.UserArea := Project.Margin;
		if Project.Layers[ilPreview] then
		begin
			{ if Project.RenderedImage = nil then
				begin }
			ImageP.UserBitmap := Project.RenderedImage;
		end
		else
			ImageP.UserBitmap := Project.Bitmap;
		// ImageP.UserArea := ImageP.UserBitmap.GetRect;
	end;

	if Assigned(fFunctions) then
		fFunctions.ShowResize;

	if Assigned(fInfo) then
		fInfo.InitXY;
	ImageP.Invalidate;
	InitMenu;
end;

procedure TfMain.VelocityMode1Click(Sender: TObject);
begin
	VelocityMode1.Checked := not VelocityMode1.Checked;
	UpdateImage;
end;

procedure TfMain.Start1Click(Sender: TObject);
begin
	AOpen := True;
	Project.Process;
end;

procedure TfMain.ClearUndo1Click(Sender: TObject);
begin
	Project.UndoRedo.ClearUndo;
	InitMenu;
end;

procedure TfMain.ClearRedo1Click(Sender: TObject);
begin
	Project.UndoRedo.ClearRedo;
	InitMenu;
end;

procedure TfMain.ButtonCUClick(Sender: TObject);
begin
	ClearUndo1Click(Sender);
end;

procedure TfMain.ButtonCRClick(Sender: TObject);
begin
	ClearRedo1Click(Sender);
end;

function SelectionModeToCursor(const SelectionMode: TSelectionMode): TCursor;
begin
	case SelectionMode of
	smNone:
		Result := crDefault;
	smMoveAll, smStartMoveVectors, smMoveVectors:
		Result := crSize;
	smLeft, smRight:
		Result := crSizeWE;
	smTop, smBottom:
		Result := crSizeNS;
	smLeftTop, smRightBottom:
		Result := crSizeNWSE;
	smLeftBottom, smRightTop:
		Result := crSizeNESW;
	else
		Result := crDefault;
	end;
end;

procedure Keep(var Group: TRect; const Ratio: FA = 1);
var
	SquareSize: SG;
begin
	SquareSize := Min(Project.Group.Right - Project.Group.Left,
		Project.Group.Bottom - Project.Group.Top);
	Group.Right := Project.Group.Left + Round(Ratio * SquareSize);
	Group.Bottom := Project.Group.Top + SquareSize;
end;

function CreateGraphicObject(const AddObjectIndex: SG): TGraphicObject;
begin
	case AddObjectIndex of
	0:
		Result := TBlurVector.Create;
	1:
		Result := TBezier.Create;
	2:
		Result := TCircle.Create;
	3:
		Result := TSquare.Create;
	4:
		Result := TSwirl.Create;
	5:
		Result := TButton.Create;
	6:
		Result := TLens.Create;
	7:
		Result := TZoomer.Create;
	else
		Result := nil;
	end;
end;

procedure TfMain.ImagePMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
var
	CliLeft, CliRight, CliBottom, CliTop: BG;
	Tolerance: SG;
	i: SG;
	V: TGraphicObject;
	NewCursor: TCursor;
begin
	if ImageP.MouseAction <> mwNone then
		Exit;

	NewCursor := crDefault;
	if (OpenedFiles.Index >= 0) and (ImageP.MouseAction = mwNone) and
		(ImageP.MouseWhere in [mwNone, mwScroll]) then
	begin
		case FMouseMode of
		mmNone:
			;
		mmAddObject, mmSelect:
			begin
				if ImageP.MouseL = False then
				begin
					CliLeft := False;
					CliRight := False;
					CliTop := False;
					CliBottom := False;
					Tolerance := Round(MouseTolerance / ImageP.Zoom);
					if (Abs(ImageP.UserMouse.X - Project.Group.Left) <= Tolerance) and
						(ImageP.UserMouse.Y + Tolerance >= Project.Group.Top) and
						(ImageP.UserMouse.Y - Tolerance <= Project.Group.Bottom) then
						CliLeft := True;
					if (Abs(ImageP.UserMouse.X - Project.Group.Right) <= Tolerance) and
						(ImageP.UserMouse.Y + Tolerance >= Project.Group.Top) and
						(ImageP.UserMouse.Y - Tolerance <= Project.Group.Bottom) then
						CliRight := True;
					if (Abs(ImageP.UserMouse.Y - Project.Group.Top) <= Tolerance) and
						(ImageP.UserMouse.X + Tolerance >= Project.Group.Left) and
						(ImageP.UserMouse.X - Tolerance <= Project.Group.Right) then
						CliTop := True;
					if (Abs(ImageP.UserMouse.Y - Project.Group.Bottom) <= Tolerance) and
						(ImageP.UserMouse.X + Tolerance >= Project.Group.Left) and
						(ImageP.UserMouse.X - Tolerance <= Project.Group.Right) then
						CliBottom := True;

					if (CliLeft and CliBottom) then
						SelectionMode := smLeftBottom
					else if (CliRight and CliTop) then
						SelectionMode := smRightTop
					else if (CliLeft and CliTop) then
						SelectionMode := smLeftTop
					else if (CliRight and CliBottom) then
						SelectionMode := smRightBottom
					else if CliLeft then
						SelectionMode := smLeft
					else if CliRight then
						SelectionMode := smRight
					else if CliTop then
						SelectionMode := smTop
					else if CliBottom then
						SelectionMode := smBottom
					else if ((ImageP.UserMouse.X > Project.Group.Left) and
							(ImageP.UserMouse.X < Project.Group.Right) and
							(ImageP.UserMouse.Y > Project.Group.Top) and
							(ImageP.UserMouse.Y < Project.Group.Bottom)) and (SelectAll1.Enabled) then
					begin
						SelectionMode := smMoveAll;
					end
					else
					begin
						if SelectObject(ImageP.UserMouseFlo, True, (ssCtrl in Shift), False) then
							SelectionMode := smStartMoveVectors
						else
							SelectionMode := smNone;
					end;
					NewCursor := SelectionModeToCursor(SelectionMode);
				end
				else // if ImageP.MouseL = True then
				begin
					if SelectionMode = smStart then
					begin
						CloneGraphicObjects(StartGraphicObjects, Project.GraphicObjects);
						{ SetLength(StartVectors, 0);
							if Length(Project.GraphicObjects) > 0 then
							begin
							SetLength(StartVectors, Length(Project.GraphicObjects));
							CopyMemory(@StartVectors[0], @Project.GraphicObjects[0], SizeOf(TGraphicObject) * Length
							(Project.GraphicObjects));
							end; }
						{ if not (ssCtrl in Shift) then
							DeselectAllObjects; }
						// SetLength(StartGroup, 0);
						SelectionMode := smStartEx;
					end;
					if SelectionMode = smStartEx then
					begin
						Project.SetGroup(U, ImageP.UserMouse);
						if ssShift in Shift then
						begin
							Keep(Project.Group, 1);
						end;
					end;
					case SelectionMode of
					smStartMoveVectors, smMoveVectors:
						begin
							if SelectionMode = smStartMoveVectors then
							begin
								case FMouseMode of
								mmSelect:
									begin
										CreateUndo('Move Objects', TMyVectorsUndo);
									end;
								mmAddObject:
									begin
										V := CreateGraphicObject(AddObjectIndex);
										CreateUndo('Add Objects', TMyVectorsUndo);
										if not(ssCtrl in Shift) then
											DeselectAllObjects;
										SetLength(Project.GraphicObjects, Length(Project.GraphicObjects) + 1);
										Project.GraphicObjects[Length(Project.GraphicObjects) - 1] := V;
										V.S.X := ImageP.UserMouse.X;
										V.S.Y := ImageP.UserMouse.Y;
										V.S.Selected := True;
										{ V.M.Selected := True;
											V.E.Selected := True; }
										V.M := V.s;
										V.E := V.s;
										V.S.Selected := False;
										U := ImageP.UserMouse;
										// SelectionMode := smStartMoveVectors;
										CloneGraphicObjects(StartGraphicObjects, Project.GraphicObjects);
										{ SetLength(StartVectors, 0);
											SetLength(StartVectors, Length(Project.GraphicObjects));
											CopyMemory(@StartVectors[0], @Project.GraphicObjects[0], SizeOf(TGraphicObject) * Length
											(Project.GraphicObjects)); }
										InitStatusBar;
										DoPreview(ImageP.UserMouse);
									end;
								end;
								SelectionMode := smMoveVectors;
							end;
							for i := 0 to Length(StartGraphicObjects) - 1 do
							begin
								if (Project.GraphicObjects[i].S.Selected) then
								begin
									Project.GraphicObjects[i].S.X := StartGraphicObjects[i]
										.s.X + ImageP.UserMouse.X - U.X;
									Project.GraphicObjects[i].S.Y := StartGraphicObjects[i]
										.s.Y + ImageP.UserMouse.Y - U.Y;
								end;
								if (Project.GraphicObjects[i].M.Selected) then
								begin
									Project.GraphicObjects[i].M.X := StartGraphicObjects[i]
										.M.X + ImageP.UserMouse.X - U.X;
									Project.GraphicObjects[i].M.Y := StartGraphicObjects[i]
										.M.Y + ImageP.UserMouse.Y - U.Y;
								end;
								if (Project.GraphicObjects[i].E.Selected) then
								begin
									Project.GraphicObjects[i].E.X := StartGraphicObjects[i]
										.E.X + ImageP.UserMouse.X - U.X;
									Project.GraphicObjects[i].E.Y := StartGraphicObjects[i]
										.E.Y + ImageP.UserMouse.Y - U.Y;
								end;
								Project.GraphicObjects[i].InitM;
							end;
							Project.InitMargin;
							ImageP.UserArea := Project.Margin;
							DoPreview(ImageP.UserMouse);
						end;
					smMoveAll:
						begin
							Project.SetGroup(StartGroup.Left + ImageP.UserMouse.X - U.X,
								StartGroup.Top + ImageP.UserMouse.Y - U.Y,
								StartGroup.Right + ImageP.UserMouse.X - U.X,
								StartGroup.Bottom + ImageP.UserMouse.Y - U.Y);
						end;
					else
						begin
							if SelectionMode in [smLeft, smLeftTop, smLeftBottom] then
								Project.Group.Left := StartGroup.Left + ImageP.UserMouse.X - U.X;
							if SelectionMode in [smRight, smRightTop, smRightBottom] then
								Project.Group.Right := StartGroup.Right + ImageP.UserMouse.X - U.X;
							if SelectionMode in [smTop, smLeftTop, smRightTop] then
								Project.Group.Top := StartGroup.Top + ImageP.UserMouse.Y - U.Y;
							if SelectionMode in [smBottom, smLeftBottom, smRightBottom] then
								Project.Group.Bottom := StartGroup.Bottom + ImageP.UserMouse.Y - U.Y;
							if ssShift in Shift then
							begin
								if StartGroup.Bottom - StartGroup.Top <> 0 then
								begin
									Keep(Project.Group, (StartGroup.Right - StartGroup.Left) /
											(StartGroup.Bottom - StartGroup.Top));
								end;
							end;
							Project.SetGroup(Project.Group.TopLeft, Project.Group.BottomRight);
						end;
					end;
					InitMenu;
					ImageP.Refresh;
				end;
			end;
		end;
		if (FMouseMode = mmPipette) then
		begin
			NewCursor := crCross;
			if ImageP.MouseL then
			begin
				Project.Pipette := ImageP.UserMouse;
				if Assigned(fInfo) then
					fInfo.InitXY;
			end;
		end;
	end;
	if ImageP.AreaCursor <> 1 then
		ImageP.AreaCursor := NewCursor;
end;

procedure TfMain.ImagePMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState;
	X, Y: Integer);
begin
	if (OpenedFiles.Index >= 0) and (ImageP.MouseAction = mwNone) then
	begin
		case Button of
		mbLeft:
			begin
				case FMouseMode of
				mmNone:
					;
				mmAddObject:
					begin
						SelectionMode := smStartMoveVectors;
					end;
				mmPipette:
					begin
						ImageP.SmallMovement := True;
						if ImageP.MouseL then
						begin
							Project.Pipette := ImageP.UserMouse;
							if Assigned(fInfo) then
								fInfo.InitXY;
						end;
					end;
				mmSelect:
					begin
						StartGroup := Project.Group;
						U := ImageP.UserMouse;
						// if SelectionMode <> smMoveAll then
						begin
							CloneGraphicObjects(StartGraphicObjects, Project.GraphicObjects);
							{ SetLength(StartVectors, 0);
								if Length(Project.GraphicObjects) > 0 then
								begin
								SetLength(StartVectors, Length(Project.GraphicObjects));
								CopyMemory(@StartVectors[0], @Project.GraphicObjects[0], SizeOf(TGraphicObject) * Length
								(Project.GraphicObjects));
								end; }
						end;
						if SelectionMode in [smNone, smStartMoveVectors, smMoveAll] then
						begin
							if not SelectObject(ImageP.UserMouseFlo, False, (ssCtrl in Shift), False) then
							begin
								// if (ImageP.UserMouseX < ImageP.UserWidth) and  (ImageP.UserMouseY < ImageP.UserHeight) then
								if SelectionMode = smNone then
								begin
									SelectionMode := smStart;
								end;
							end
							else
								SelectionMode := smStartMoveVectors;
							InitStatusBar;
						end;
					end
				end;
				{ else
					begin
					O := ImageP.UserMouse;
					if fFunctions.ButtonCircle.Down then
					sglCircle(O.X, O.Y, 1 + Random(100));
					if fFunctions.ButtonEllipse.Down then
					sglEllipse(O.X, O.Y, 1 + Random(100), 1 + Random(100));
					if fFunctions.ButtonArc.Down then
					sglArc(O.X, O.Y, 1 + Random(100), 0, Random(360));

					if (fFunctions.ButtonBegin.Down) then
					begin
					sglVertex(O.X, O.Y, 1);
					end;
					end; }
				ImageP.Invalidate;
			end;
		end;
	end;
end;

procedure TfMain.Functions1Click(Sender: TObject);
begin
	Functions1.Checked := not Functions1.Checked;
	if not Assigned(fFunctions) then
		fFunctions := TfFunctions.Create(Self);
	if Functions1.Checked then
		fFunctions.Show
	else
		fFunctions.Close;
	UpdateIcons(MainMenu1, PanelTool);
end;

procedure TfMain.Info1Click(Sender: TObject);
begin
	Info1.Checked := not Info1.Checked;
	if not Assigned(fInfo) then
		fInfo := TfInfo.Create(Self);
	if Info1.Checked then
		fInfo.Show
	else
		fInfo.Close;
	UpdateIcons(MainMenu1, PanelTool);
end;

procedure TfMain.ImageInfo1Click(Sender: TObject);
var
	ImageFileName: TFileName;
begin
	ImageFileName := OpenedFiles.ActualItem.FileName + '.' + Project.Params[psImageExtension].Str;
	PropertiesDialog(ImageFileName);
end;

var
	ActualDir: string;
	ActualFileName: TFileName;

procedure TfMain.RWOptions(const Save: Boolean);
var
	Section: string;
	XMouseMode: TMouseMode;
begin
	Section := 'View';
	XMouseMode := FMouseMode;
	MainIni.RWEnum(Section, TypeInfo(TMouseMode), U1(XMouseMode), Save);
	{ MainIni.RWButton(Section, fInfo.ButtonPipette, Save);
		MainIni.RWButton(Section, fInfo.ButtonHand, Save);
		MainIni.RWButton(Section, fInfo.ButtonSelect, Save);
		ImageP.HandScroll := fInfo.ButtonHand.Down; }
	if Save = False then
		SetMouseMode(XMouseMode);

	MainIni.RWMenuItem(Section, RealTimePreview1, Save);

	MainIni.RWMenuItem(Section, Functions1, Save);
	MainIni.RWMenuItem(Section, Info1, Save);
	MainIni.RWMenuItem(Section, Status1, Save);
	MainIni.RWMenuItem(Section, Overview1, Save);
	MainIni.RWMenuItem(Section, AdvancedMode1, Save);

	Section := 'Options';
	MainIni.RWFileName(Section, 'ActualFileName', ActualFileName, Save);
	MainIni.RWString(Section, 'ActualDir', ActualDir, Save);

	uOptions.RWOptions(POptions(@ApplicationOptions), Length(ApplicationOptions), PParams
			(@ApplicationParams), MainIni, 'Options', Save);

	ImageP.Serialize(MainIni, Save);

	MainIni.RWFormPos(Self, Save);
end;

procedure ImageChanged;
begin
	fMain.ImageP.UserBitmapChanged;
end;

procedure TfMain.FormCreate(Sender: TObject);
var
	i: SG;
begin
	Background := baNone;

	RegisterDelayedCall(0, ImageChanged);

	AddSounds(['Done'], [GetWinSoundFileName(wsAsterisk)]);

	uUndoRedo.Undo1 := Undo1;
	uUndoRedo.Redo1 := Redo1;

	BevelMenu := TBevel.Create(Self);
	BevelMenu.Shape := bsTopLine;
	BevelMenu.Height := 2;
	BevelMenu.Align := alTop;

	PanelTool := TPanel.Create(Self);
	PanelTool.Align := alTop;
	PanelTool.BevelOuter := bvNone;
	PanelTool.Height := IconSize;
	PanelTool.Name := 'PanelTool';
	PanelTool.Caption := '';
	InsertControl(PanelTool);
	InsertControl(BevelMenu);

	OpenPictureDialog1.Filter := AllPictures;
{$IFDEF RealMotionBlur}
	BmpToJpeg1.Visible := False;
	BmpTo100Jpeg1.Visible := False;
	ResizePictures1.Visible := False;
{$ENDIF}
	OpenPictureDialog1.Filter := DialogStrWithoutAll([DefaultExt, 'vrs', 'bsp'],
		['Real Motion Blur Project', 'VirtualRig Studio Project File',
		'VirtualRig Studio Project File']) + OpenPictureDialog1.Filter;
	SavePictureDialog1.Filter := OpenPictureDialog1.Filter;

	BmpBack := TDBitmap.Create;
	BmpBack.LoadFromFile(GraphDir + 'Background.png');
	BmpBack.Transparent := False;
	NewX := Screen.Width;
	NewY := Screen.Height;

	for i := 0 to Length(AllPictureExt) - 1 do
		AddFileType(AllPictureExt[i], AllPictureDes[i], '', [GetProjectInfo(piProductName)],
			[AddQuoteF(ExeFileName) + ' ' + AddQuoteF('%1')]);

	AddFileType('rmb', 'Real Motion Blur Project', '', [GetProjectInfo(piProductName)],
		[AddQuoteF(ExeFileName) + ' ' + AddQuoteF('%1')]);
	AddFileType('vrs', 'Real Motion Blur Project', '', [GetProjectInfo(piProductName)],
		[AddQuoteF(ExeFileName) + ' ' + AddQuoteF('%1')]);
	AddFileType('bsp', 'Real Motion Blur Project', '', [GetProjectInfo(piProductName)],
		[AddQuoteF(ExeFileName) + ' ' + AddQuoteF('%1')]);

	// OpenedFiles
	OpenedFiles.ItemAddr := @Project;
	OpenedFiles.ItemSize := SizeOf(Project);

	OpenedFiles.File1 := File1;
	OpenedFiles.Window1 := Window1;

	OpenedFiles.CreateMenuFile(True);

	OpenedFiles.OpenDialog1 := TOpenDialog(OpenPictureDialog1);
	OpenedFiles.SaveDialog1 := TSaveDialog(SavePictureDialog1);

	ApplicationOptions[asNumberOfThreads].Default := GSysInfo.LogicalProcessorCount;

	SetMouseMode(mmSelect);
	RWOptions(False);
	ImageP.CreateZoom(Zoom1);

	ApplicationOptionChanged(SG(asUndoCountLimit));
	ApplicationOptionChanged(SG(asUndoSizePercentOfRAM));

	ThreadPool := TThreadPool.Create;
	ApplicationOptionChanged(SG(asNumberOfThreads));

	if RunFirstTime then
	begin
{$IFNDEF RealMotionBlur}
		OpenedFiles.OpenedFileLoadFromFile(GraphDir + 'Logo.png');
{$ELSE}
		OpenedFiles.OpenedFileLoadFromFile(WorkDir + 'Samples\Clock.' + DefaultExt);
		OpenedFiles.OpenedFileLoadFromFile(WorkDir + 'Samples\Vltava River.' + DefaultExt);
{$ENDIF}
	end;
{$IFNDEF RealMotionBlur}
	if Functions1.Checked then
	begin
		if fFunctions = nil then
			fFunctions := TfFunctions.Create(Self);
		fFunctions.Show;
	end;
	// fFunctions.Visible := Functions1.Checked;
{$ELSE}
	Functions1.Visible := False;
{$ENDIF}
	if Info1.Checked then
	begin
		Info1.Checked := False;
		Info1.Click;
	end;
	if Status1.Checked then
	begin
		Status1.Checked := False;
		Status1.Click;
	end;
	if Overview1.Checked then
	begin
		if fOverview = nil then
			fOverview := TfOverview.Create(Self);
		fOverview.Show;
	end;
	if Layers1.Checked then
	begin
		if fLayers = nil then
			fLayers := TfLayers.Create(Self);
		fLayers.Show;
	end;
end;

function ObjectRect(const Source: TArrayOfGraphicObject): TFloRect;
var
	i: SG;
	Vector: TGraphicObject;
begin
	Result.Left := MaxInt;
	Result.Top := MaxInt;
	Result.Right := MinInt;
	Result.Bottom := MinInt;
	for i := 0 to Length(Source) - 1 do
	begin
		Vector := Source[i];
		if Result.Left > Vector.s.X then
		begin
			Result.Left := Vector.s.X;
		end;
		if Result.Top > Vector.s.Y then
		begin
			Result.Top := Vector.s.Y;
		end;
		if Result.Left > Vector.E.X then
		begin
			Result.Left := Vector.E.X;
		end;
		if Result.Top > Vector.E.Y then
		begin
			Result.Top := Vector.E.Y;
		end;

		if Result.Right < Vector.s.X then
		begin
			Result.Right := Vector.s.X;
		end;
		if Result.Bottom < Vector.s.Y then
		begin
			Result.Bottom := Vector.s.Y;
		end;
		if Result.Right < Vector.E.X then
		begin
			Result.Right := Vector.E.X;
		end;
		if Result.Bottom < Vector.E.Y then
		begin
			Result.Bottom := Vector.E.Y;
		end;
	end;
end;

procedure AddVectors(const Source: TArrayOfGraphicObject; var Dest: TArrayOfGraphicObject;
	const Paste: BG);
var
	Vector: TGraphicObject;
	Index: SG;
	i: SG;
	R: TFloRect;
begin
	if Paste then
		R := ObjectRect(Source);
	Index := Length(Dest);
	for i := 0 to Length(Source) - 1 do
	begin
		Vector := Source[i];
		if Paste or (Vector.S.Selected and Vector.E.Selected) then
		begin
			SetLength(Dest, Index + 1);
			Dest[Index] := Vector;
			if Paste then
			begin
				Dest[Index].Move(fMain.ImageP.UserMouse.X - R.Left, fMain.ImageP.UserMouse.Y - R.Top);
			end;
			Inc(Index);
		end;
	end;
end;

procedure TfMain.CopyX1Click(Sender: TObject);
var
	MyFormat: Word;
	AData: THandle;
	APalette: HPALETTE;
	SmallBmp: TDBitmap;
begin
	if Project.SelectedObjects > 0 then
	begin
		SetLength(ClipboardVectors, 0);
		AddVectors(Project.GraphicObjects, ClipboardVectors, False);
	end
	else
	begin
		SmallBmp := Project.Bitmap.GetBitmap(Project.Group);
		try
			SmallBmp.SaveToClipboardFormat(MyFormat, AData, APalette);
			ClipBoard.SetAsHandle(MyFormat, AData);
		finally
			SmallBmp.Free;
		end;
	end;
end;

procedure TfMain.Paste1Click(Sender: TObject);
{$IFNDEF RealMotionBlur}
var
	B: TBitmap;
{$ENDIF}
begin
{$IFDEF RealMotionBlur}
	if Length(ClipboardVectors) <= 0 then
		Exit;
	CreateUndo('Paste form Clipboard', TMyVectorsUndo);
{$ELSE}
	if not(ClipBoard.HasFormat(CF_BITMAP)) then
		Exit;
	CreateUndo('Paste form Clipboard', TMyBitmapUndo);
{$ENDIF}
{$IFDEF RealMotionBlur}
	AddVectors(ClipboardVectors, Project.GraphicObjects, True);
	UpdateImage;
	InitStatusBar;
{$ELSE}
	B := TDBitmap.Create;
	try
		B.LoadFromClipboardFormat(CF_BITMAP, ClipBoard.GetAsHandle(CF_BITMAP), 0);
		Project.Bitmap.FromBitmap(B);
		SelectAll1Click(Sender);
		// OpenedFiles.OpenedFileChangeFile(nil);
	finally
		B.Free;
	end;
	// UpdateImage;
{$ENDIF}
end;

procedure TfMain.Pipette1Click(Sender: TObject);
begin
	SetMouseMode(mmPipette);
end;

procedure TfMain.Cut1Click(Sender: TObject);
begin
	CopyX1Click(Sender);
	ActionDeleteExecute(Sender);
end;

procedure TfMain.Stop1Click(Sender: TObject);
begin
	Stop;
	HideStatusWindow;
end;

procedure TfMain.Hand1Click(Sender: TObject);
begin
	SetMouseMode(mmScroll);
end;

procedure TfMain.Select1Click(Sender: TObject);
begin
	SetMouseMode(mmSelect);
end;

procedure TfMain.SelectAll1Click(Sender: TObject);
begin
	Project.Group := Project.Margin;
	Project.ChangeGroup;
	UpdateImage;
end;

function TfMain.SelectObject(const X, Y: SG; const Test: BG; const Shift: BG; const MouseUp: BG)
	: BG;
begin
	Result := SelectObject(FloPoint(X, Y), Test, Shift, MouseUp);
end;

function TfMain.SelectObject(const FloPoint: TFloPoint; const Test: BG; const Shift: BG;
	const MouseUp: BG): BG;
const
	Border = Sqr(16);
var
	i: SG;
	Vector: TGraphicObject;
	Len, BestLen: TFlo;
	BestPoint: PPointDS;
	BestVector: TGraphicObject;
begin
	Result := False;
	if Project.Layers[ilObjects] = False then
		Exit;
	BestVector := nil;
	BestPoint := nil;
	BestLen := Infinity;
	for i := 0 to Length(Project.GraphicObjects) - 1 do
	begin
		Vector := Project.GraphicObjects[i];
		Len := GetLength(FloPoint, Vector.S);
		if (Len < Border) and (Len < BestLen) then // Over(Vector.S.X, Vector.S.Y, Vector.E.X, Vector.E.Y, X, Y, X, Y) then
		begin
			BestLen := Len;
			BestPoint := @Vector.s;
		end;
		Len := GetLength(FloPoint, Vector.E);
		if (Len < Border) and (Len < BestLen) then // Over(Vector.S.X, Vector.S.Y, Vector.E.X, Vector.E.Y, X, Y, X, Y) then
		begin
			BestLen := Len;
			BestPoint := @Vector.E;
		end;
		Len := GetLength(FloPoint, Vector.M);
		if (Len <= Border) and (Len < BestLen) then // Over(Vector.S.X, Vector.S.Y, Vector.E.X, Vector.E.Y, X, Y, X, Y) then
		begin
			BestLen := Len;
			BestPoint := @Vector.M;
			BestVector := Vector;
		end;
	end;
	if BestPoint <> nil then
	begin
		if not Test then
		begin
			if Shift or (BestPoint.Selected = False) then
			begin
				if not Shift then
					DeselectAllObjects;
				if BestPoint.Selected then
				begin
					if MouseUp then
						BestPoint.Selected := False;
				end
				else
				begin
					if not MouseUp then
						BestPoint.Selected := True;
				end;
				if BestVector <> nil then
				begin
					BestVector.S.Selected := not BestVector.S.Selected;
					BestVector.E.Selected := not BestVector.E.Selected;
				end;
				if BestPoint = @BestVector.M then
				begin
					BestVector.S.Selected := True;
					BestVector.E.Selected := True;
				end;
			end;
		end;
		Result := True;
	end
	else if not Test then
		if not Shift then
			DeselectAllObjects;

end;

procedure TfMain.SetMode;
var
	B: BG;
begin
	B := AdvancedMode1.Checked;

	// File
	TMenuItem(File1.FindComponent('OpenDirectory1')).Visible := B;
	TMenuItem(File1.FindComponent('Revert1')).Visible := B;
	TMenuItem(File1.FindComponent('DeleteFile1')).Visible := B;
	TMenuItem(File1.FindComponent('Properties1')).Visible := B;

	// Edit
	ClearUndo1.Visible := B;
	ClearRedo1.Visible := B;
	None1.Visible := B;
	TMenuItem(Zoom1.FindComponent('Copy1')).Visible := B;

	// Image
	Resize1.Visible := B;
	Crop1.Visible := B;
	Rotate1.Visible := B;
	ImageInfo1.Visible := B;
	N1.Visible := B;
	ColorCount1.Visible := B;

	// View
	Status1.Visible := B;

	// Options
	TMenuItem(Options1.FindComponent('Sounds1')).Visible := B;
	TMenuItem(Options1.FindComponent('ViewIniFile1')).Visible := B;
	TMenuItem(Options1.FindComponent('Log1')).Visible := B;

	// Help
	TMenuItem(Help1.FindComponent('Messages1')).Visible := B;
	TMenuItem(Help1.FindComponent('Parameters1')).Visible := B;

	RecreateIconsFromMenu(MainMenu1, PanelTool);
end;

procedure TfMain.SetMouseMode(const MouseMode: TMouseMode);
var
	Index: SG;
begin
	// if MouseMode <> FMouseMode then
	begin
		FMouseMode := MouseMode;
		Index := Edit1.IndexOf(None1) + SG(FMouseMode);
		if FMouseMode = mmAddObject then
			Inc(Index, AddObjectIndex);

		Edit1.Items[Index].Checked := True;
		UpdateIcons(MainMenu1, PanelTool);
		ImageP.HandScroll := FMouseMode = mmScroll;

		if Assigned(fInfo) then
		begin
			fInfo.InitMouseMode;
		end;
	end;
end;

procedure TfMain.DrawObjects;
const
	Width = 2;
var
	i: SG;
	// SC, C: TRGBA;
	Id: SG;
	VT: TVectorType;
begin
	C.L := Project.Params[psVectorColor].Num; { StrToValS8('$' + Pict.SettingsValues[psvectorColor], True, MinInt, clRed, High(U4), 1,
		nil); }
	// Exchange(C.R, C.B);
	SC.L := Project.Params[psSelectionColor].Num; { StrToValS8('$' + Pict.SettingsValues[psselectionColor], True, MinInt, clRed, High(U4), 1,
		nil); }
	// Exchange(SC.R, SC.B);
	// ImageP.Bitmap.Canvas.Pen.Color := C;

	VT := TVectorType(Project.Params[psVectorType].Num);
	// StrToValI(Pict.SettingsValues[psvectorType], False, 1, 1, 3, 1, nil));
	if VT = vtCurve then
	begin
		Id := sglCreateDrawable(ImageP.Bitmap.Width, ImageP.Bitmap.Height, ImageP.Bitmap.Data);
		sglSetDrawable(Id);
		sglLoadIdentity;
	end
	else
		Id := -1;
	try
		// sglScale(100, 100);
		for i := 0 to Length(Project.GraphicObjects) - 1 do
		begin
			Project.GraphicObjects[i].Draw(ImageP);
		end;
	finally
		if VT = vtCurve then
			sglDestroyDrawable(Id);
	end;
{$IFDEF RealMotionBlur}
	for i := 0 to Length(Project.RenderVectors) - 1 do
	begin
		DrawVector(Project.RenderVectors[i], ImageP);
	end;
{$ENDIF}
end;

procedure TfMain.ImagePFill(Sender: TObject);
{$IFOPT d-}
var
	Co: array [0 .. 3] of TColor;
{$ENDIF}
begin
	if OpenedFiles.Index < 0 then
	begin
{$IFOPT d-}
		Co[0] := DarkerColor(clAppWorkSpace);
		Co[1] := LighterColor(clAppWorkSpace);
		Co[2] := Co[0];
		Co[3] := Co[1];
		ImageP.Bitmap.Texture(BmpBack, ef16);
		ImageP.Bitmap.Bar(clAppWorkSpace, ef11);
{$ELSE}
		ImageP.Bitmap.Bar(clAppWorkSpace, ef16);
{$ENDIF}
		if Assigned(fInfo) then
			fInfo.ShowOffset;
	end
	else
	begin
		Project.Offset.X := ImageP.OfsX;
		Project.Offset.Y := ImageP.OfsY;
		if Assigned(fInfo) then
			fInfo.ShowOffset;
		if Project.Layers[ilObjects] { and (not Project.Layers[ilPreview]) }
		{ and (not VelocityMode1.Checked) } { and (ImageP.UserBitmap <> Project.Preview) } then
			DrawObjects;
		// Selection
		if SelectAll1.Enabled then
		begin
			ImageP.Bitmap.Border(ImageP.GetPosX(Project.Group.Left), ImageP.GetPosY(Project.Group.Top),
				ImageP.GetPosX(Project.Group.Right + 1) - 1, ImageP.GetPosY(Project.Group.Bottom + 1) - 1,
				clWhite, clWhite, Max(1, Round(ImageP.Zoom)), efNeg);
		end;
	end;
	if Assigned(fOverview) then
		fOverview.Image.Invalidate;
end;

procedure TfMain.FormDestroy(Sender: TObject);
var
	i: SG;
begin
	for i := 0 to Length(StartGraphicObjects) - 1 do
		StartGraphicObjects[i].Free;

	SetLength(StartGraphicObjects, 0);

	OnResize := nil;
	if Assigned(fFunctions) then
		fFunctions.Close;
	if Assigned(fInfo) then
		fInfo.Close;

	ThreadPool.Stop;
	FreeAndNil(ThreadPool);

	FreeAndNil(OpenedFiles);
	FreeAndNil(BmpBack);
	FreeAndNil(ThreadPool);
end;
{$IFDEF RealMotionBlur}

const
	Password = 'SDG';

var
	PasswordIndex: SG;
{$ENDIF}

procedure TfMain.FormKeyPress(Sender: TObject; var Key: Char);
begin
{$IFDEF RealMotionBlur}
	if UpCase(Key) = Password[PasswordIndex + 1] then
		Inc(PasswordIndex)
	else
		PasswordIndex := 0;

	if PasswordIndex = Length(Password) then
	begin
		FullVersion := True;
		PasswordIndex := 0;
		Beep;
	end;
{$ENDIF}
end;

procedure TfMain.FormResize(Sender: TObject);
begin
	IconsResize(PanelTool);
end;

procedure TfMain.BmpToJpeg1Click(Sender: TObject);
var
	SQuality, Quality: SG;
	FileNames: TFileNames;
	FileNamesCount: SG;
	FileName, FileNameO: TFileName;
	i: SG;
	Bmp: TDBitmap;
	Ext: string;
begin
	SQuality := 90;
	if GetNumber('JPEG Quality', SQuality, 1, 90, 100, nil) then
	begin
		if SelectFolder(ActualDir) then
		begin
			FileNamesCount := 0;
			ReadDir(FileNames, FileNamesCount, ActualDir, [], True, False, True, False);
			for i := 0 to FileNamesCount - 1 do
			begin
				Ext := LowerCase(ExtractFileExt(FileNames[i]));
				if (Ext = '.bmp') or (Ext = '.ppm') or (Ext = '.tga') then
				begin
					Bmp := TDBitmap.Create;
					FileNameO := ActualDir + FileNames[i];
					Bmp.LoadFromFile(FileNameO);
					Quality := -SQuality;
					FileName := DelFileExt(FileNameO) + '.png';
					Bmp.SaveToFileEx(FileName, Quality);
					DeleteFileDialog(FileNameO);
					Bmp.Free;
				end;
			end;
			SetLength(FileNames, 0);
		end;
	end;
end;

procedure TfMain.AddX1Click(Sender: TObject);
begin
	AddObjectIndex := TMenuItem(Sender).Tag;
	SetMouseMode(mmAddObject);
end;

procedure TfMain.ActionDeleteExecute(Sender: TObject);
var
{$IFDEF RealMotionBlur}
	i: SG;
	j: SG;
{$ELSE}
	B: TDBitmap;
{$ENDIF}
begin
{$IFDEF RealMotionBlur}
	CreateUndo('Delete', TMyVectorsUndo);
	i := 0;
	while (i < Length(Project.GraphicObjects)) do
	begin
		if (Project.GraphicObjects[i].S.Selected) and (Project.GraphicObjects[i].E.Selected) then
		begin
			for j := i to Length(Project.GraphicObjects) - 2 do
				Project.GraphicObjects[j] := Project.GraphicObjects[j + 1];
			SetLength(Project.GraphicObjects, Length(Project.GraphicObjects) - 1);
		end
		else
			Inc(i);
	end;
	InitStatusBar;
{$ELSE}
	CreateUndo('Delete', TMyBitmapUndo);
	B := Project.Bitmap;
	B.FromBitmap(Project.Bitmap);
	{ B.SetSize(Pict.ABmp[Max(0, Pict.BmpI - 1)].Width, Pict.ABmp[Max(0, Pict.BmpI - 1)].Height,
		clWhite); }
	B.Bar(Project.Group, clWhite, ef16);
{$ENDIF}
	UpdateImage;
end;

procedure TfMain.ActionMoveLeftRigthExecute(Sender: TObject);
var
	i: SG;
	Offset: TFlo;
begin
	CreateUndo('Move Vectors', TMyVectorsUndo);
	Offset := TAction(Sender).Tag;
	for i := 0 to Length(Project.GraphicObjects) - 1 do
	begin
		Project.GraphicObjects[i].Move(Offset, 0);
		Project.GraphicObjects[i].InitM;
	end;
	UpdateImage;
	DoPreview;
end;

procedure TfMain.ActionMoveUpDownExecute(Sender: TObject);
var
	i: SG;
	Offset: TFlo;
begin
	CreateUndo('Move Vectors', TMyVectorsUndo);
	Offset := TAction(Sender).Tag;
	for i := 0 to Length(Project.GraphicObjects) - 1 do
	begin
		Project.GraphicObjects[i].Move(0, Offset);
		Project.GraphicObjects[i].InitM;
	end;
	UpdateImage;
	DoPreview;
end;

procedure TfMain.ActionUndoRedoExecute(Sender: TObject);
var
	Undo: TUndo;
	DoUndo: BG;
begin
	{ i := Pict.BmpI + TComponent(Sender).Tag;
		if i >= Pict.BmpCount then
		Exit
		else if i < 0 then
		Exit; }

	DoUndo := TComponent(Sender).Tag = -1;
	Undo := Project.UndoRedo.GetUndoRedo(DoUndo);
	if Undo <> nil then
	begin
		Project.UndoRedo.ApplyUndo(Project.GetUndo(Undo.ClassType), DoUndo);
		Project.SetUndo(Undo);
		Undo.Free;
	end;
	InitStatusBar;
	DoPreview;
end;

procedure TfMain.AdvancedMode1Click(Sender: TObject);
begin
	AdvancedMode1.Checked := not AdvancedMode1.Checked;
	SetMode;
end;

procedure TfMain.ApplicationSettings1Click(Sender: TObject);
begin
	if ShowOptions('Application Settings', POptions(@ApplicationOptions), Length(ApplicationOptions),
		PParams(@ApplicationParams), ApplicationOptionChanged) then
	begin

	end;
end;

procedure TfMain.BmpTo100Jpeg1Click(Sender: TObject);
var
	SQuality, Quality: SG;
	FileNam: TFileName;
	Bmp, Bmp2: TDBitmap;
begin
	if ExecuteDialog(OpenPictureDialog1, ActualFileName) then
	begin
		Bmp := TDBitmap.Create;
		Bmp.LoadFromFile(ActualFileName);
		Bmp2 := nil;
		for SQuality := 1 to 100 do
		begin
			Quality := -SQuality;
			BitmapCopy(Bmp2, Bmp);
			FileNam := DelFileExt(ActualFileName) + NToS(SQuality, '000') + '.jpg';
			Bmp2.SaveToFileEx(FileNam, Quality);
			FreeAndNil(Bmp2);
		end;
		Bmp.Free;
	end;
end;

procedure TfMain.ProcessWithVariableSpeed1Click(Sender: TObject);
var
	Speed: TFlo;
	LastSpeed: TFlo;
	FileName: string;
	// Bmp: TDBitmap;
begin
	CreateDirEx(Project.RenderFolder);
	LastSpeed := Project.Params[psSpeedCoefficient].Float;
	// BeginLongOperation;
	try
		Speed := 0.1;
		while Speed < 5 do
		begin
			Project.Params[psSpeedCoefficient].Float := Speed;
			FileName := Project.RenderFolder + 'render_speed_' + FloatToStr(Speed) + '.png';
			// Bmp := TDBitmap.Create;
			AOpen := False;
			Process(Project, FileName);
			while (not TerminateThreads) and (Project.CommandRunCount > 0) do
			begin
				Sleep(LoopSleepTime);
				Application.ProcessMessages;
			end;
			if TerminateThreads then
				Break;

			{ if NewFileOrDir(FileName) then
				Bmp.SaveToFile(FileName); }
			Speed := Speed + 0.1;
		end;
	finally
		Project.Params[psSpeedCoefficient].Float := LastSpeed;
		// EndLongOperation;
		// Bmp.Free;
	end;
	APIOpen(Project.RenderFolder);
end;

procedure TfMain.ProjectSettings1Click(Sender: TObject);
begin
	// fMain.CreateUndo('Project Settings Changed', TMySettingsUndo);
	if ShowOptions('Project Settings', POptions(@ProjectOptions), Length(ProjectOptions), PParams
			(@Project.Params), ProjectOptionChanged) then
	begin
		fMain.OpenedFiles.Change;
		fMain.InitMenu;
	end;
end;

function GetNewXY: BG;
begin
	Result := True;
	if NewX < 0 then
	begin
		NewX := -NewX;
	end
	else
	begin
		Result := Result and GetNumber('Image Width [pixels]', NewX, 1, NewX, MaxBitmapWidth, nil);
		if Result = False then
			Exit;
	end;
	if NewY < 0 then
	begin
		NewY := -NewY;
	end
	else
	begin
		Result := Result and GetNumber('Image Height [pixels]', NewY, 1, NewY, MaxBitmapHeight, nil);
		if Result = False then
			Exit;
	end;
end;

procedure ImageResizedBefore;
begin
	StopAndWait;
	// FreeAndNil(Project.RenderedImage);
	// FreeAndNil(Project.BmpS);
	FreeAndNil(Project.BmpD);
	FreeAndNil(Project.Thumbnail);
end;

procedure ImageResizedAfter;
begin
	Project.InitMargin;
	Project.Group := Project.Margin;
	fMain.UpdateImage;
	if Assigned(fOverview) then
		fOverview.OnShow(nil);
	DoPreview;
end;

procedure TfMain.Resize1Click(Sender: TObject);
begin
	if GetNewXY then
	begin
		ImageResizedBefore;

		CreateUndo('Resize', TMyBitmapUndo);
		CreateUndo('Resize', TMyVectorsUndo);
		Project.ScaleVectors(NewX / Project.Bitmap.Width, NewY / Project.Bitmap.Height);
		Project.Bitmap.Resize(NewX, NewY);

		ImageResizedAfter;
	end;
end;

procedure TfMain.ResizePictures1Click(Sender: TObject);
const
	WQuality: array [0 .. 1] of SG = (75, 60);
	// WName: array of
var
	Quality: SG;
	Dir2: string;
	FileNames: TFileNames;
	FileNamesCount: SG;
	FileName: TFileName;
	i, Index: SG;
	X, Y: SG;
	Bmp, Bmp2: TDBitmap;
begin
	if SelectFolder(ActualDir, 'Original Picture Path') then
	begin
		FileNamesCount := 0;
		ReadDir(FileNames, FileNamesCount, ActualDir, [], True, False, False, False);
		CreateDirEx(ActualDir + 'Small' + PathDelim);
		CreateDirEx(ActualDir + 'Preview' + PathDelim);
		for i := 0 to FileNamesCount - 1 do
		begin
			Bmp := TDBitmap.Create;
			FileName := ActualDir + FileNames[i];
			Bmp.LoadFromFile(FileName);
			Bmp2 := TDBitmap.Create;
			for Index := 0 to 1 do
			begin
				case Index of
				0:
					Dir2 := ActualDir + 'Small' + PathDelim;
				else
					Dir2 := ActualDir + 'Preview' + PathDelim;
				end;
				case Index of
				0:
					begin
						if Bmp.Width > Bmp.Height then
						begin
							X := 1024;
							Y := 768;
						end
						else
						begin
							X := 768;
							Y := 1024;
						end;
					end;
				else
					begin
						{ if Bmp.Width > Bmp.Height then
							begin
							x := 128; y := 96;
							end
							else
							begin
							x := 96; y := 128;
							end; }
						if Bmp.Width > Bmp.Height then
						begin
							X := 160;
							Y := 120;
						end
						else
						begin
							X := 120;
							Y := 160;
						end;
						{ if Bmp.Width > Bmp.Height then
							begin
							x := 150; y := 113;
							end
							else
							begin
							x := 113; y := 150;
							end; }

					end;
				end;
				// 1024{Bmp.Width div 2}, 768{Bmp.Height div 2}

				Bmp2.Resize(X, Y, Bmp);
				FileName := Dir2 + FileNames[i];
				Quality := -WQuality[Index];
				Bmp2.SaveToFileEx(FileName, Quality);
			end;
			Bmp2.Free;
			Bmp.Free;
		end;
		SetLength(FileNames, 0);
	end;
end;

procedure TfMain.Rotate1Click(Sender: TObject);
begin
	ImageResizedBefore;

	CreateUndo('Rotate', TMyBitmapUndo);
	CreateUndo('Rotate', TMyVectorsUndo);
	// ScaleVectors(NewX / Project.Bitmap.Width, NewY / Project.Bitmap.Height);
	Project.Bitmap.RotateRight(ef16);

	ImageResizedAfter;
end;

procedure TfMain.FormShow(Sender: TObject);
begin
	OpenedFiles.OpenedFileChangeFile(Sender);
	// Zoom problem
	ImageP.Zoom := ImageP.Zoom + 1;
	ImageP.Zoom := ImageP.Zoom - 1;
	SetMode;
end;

procedure TfMain.DButtonTransparentColorClick(Sender: TObject);
var
	C: TColor;
begin
	C := Project.Bitmap.TransparentColor;
	if GetColor('Image transparent color', C, clNone, nil) then
		Project.Bitmap.TransparentColor := C;
end;

procedure TfMain.DeselectAllObjects;
var
	i: SG;
begin
	// SetLength(fMain.StartVectors, 0);
	for i := 0 to Length(Project.GraphicObjects) - 1 do
	begin
		Project.GraphicObjects[i].S.Selected := False;
		Project.GraphicObjects[i].M.Selected := False;
		Project.GraphicObjects[i].E.Selected := False;
	end;
end;

procedure TfMain.ColorCount1Click(Sender: TObject);
begin
	BeginLongOperation;
	try
		Information('Image contains %1 colors.', [NToS(Project.Bitmap.ColorCount(MaxInt))]);
	finally
		EndLongOperation(False);
	end;
end;

procedure TfMain.FileExtensions1Click(Sender: TObject);
begin
	FormFileExt;
end;

procedure TfMain.OpenedFilesChangeFile(Sender: TObject);
begin
	UpdateImage;
	if Assigned(fOverview) then
		fOverview.OnShow(Sender);
	if (OpenedFiles.Index < 0) or (Project.Bitmap = nil) then
	begin
		{ ImageP.UserArea := Rect(0, 0, 0, 0);
			ImageP.UserBitmap := nil; }
		ImageP.Zoom := 1;
		ImageP.ScrollTo(0, 0);
		Undo1.Enabled := False;
		Redo1.Enabled := False;
	end
	else
	begin
		{ ImageP.UserArea := Project.Margin;
			ImageP.UserBitmap := Project.Bitmap; }
		ImageP.Zoom := Project.Zoom;
		ImageP.ScrollTo(Project.Offset.X, Project.Offset.Y);
		Project.UndoRedo.InitMenu;
	end;
	{ if Assigned(fOverview) then
		fOverview.Image.Invalidate; }
	InitStatusBar;

	{ if Assigned(fInfo) then
		fInfo.InitZoom;
		if Assigned(fFunctions) then
		fFunctions.ShowResize; }
	if Assigned(fLayers) then
		fLayers.Init;

	// ImageP.Invalidate;
	// InitMenu;
	if Assigned(Project) then
		if not Project.PreviewDone then
			DoPreview;
end;

function TfMain.OpenedFilesFreeFile(Sender: TObject; const Item: TOpenedFileItem): Boolean;
var
	Project: PProject;
begin
	Project := Item.PData;
	{ if Project = nil then
		Project := @uProject.Project; TODO }

	WatchRemoveFile(Item.FileName + '.' + Project.Params[psImageExtension].Str);

	FreeAndNil(Project^);
	Result := True;
end;

function StrToFloat(const Name: string): FA;
var
	Code: SG;
begin
	Val(Name, Result, Code);
end;
{$IFDEF RealMotionBlur}

procedure ListComponentProperties(Component: TObject; iNode: IXMLNode);
var
	Count, Size, i: Integer;
	List: PPropList;
	PropInfo: PPropInfo;
	PropOrEvent, PropValue: string;
begin
	Count := GetPropList(Component.ClassInfo, tkAny, nil, False);
	Size := Count * SizeOf(Pointer);
	GetMem(List, Size);
	try
		Count := GetPropList(Component.ClassInfo, tkAny, List, False);
		for i := 0 to Count - 1 do
		begin
			PropInfo := List^[i];
			if PropInfo^.PropType^.Kind in tkMethods then
				PropOrEvent := 'Event'
			else
			begin
				PropOrEvent := 'Property';
				iNode.Attributes[PropInfo^.Name] := GetPropValue(Component, PropInfo^.Name)
			end;
			// PropValue := VarToStr(GetPropValue(Component, PropInfo^.Name));
			{ Strings.Add(Format('[%s] %s: %s = %s', [PropOrEvent, PropInfo^.Name,
				PropInfo^.PropType^.Name, PropValue])); }
		end;
	finally
		FreeMem(List);
	end;
end;

procedure WriteObjects(iNode2: IXMLNode);
var
	F: TFlo;
	k: SG;
	V: TGraphicObject;
	iNode: IXMLNode;
	PropList: PPropList;
	Count: SG;
	j: SG;
	Value: string;
begin
	for k := 0 to Length(Project.GraphicObjects) - 1 do
	begin
		V := Project.GraphicObjects[k];
		if not(V is TBlurVector) then
		begin
			iNode := iNode2.AddChild(V.ClassName);
			ListComponentProperties(V, iNode);
		end;
	end;
end;

procedure ReadObject(Component: TObject; iNode: IXMLNode);
var
	Count, Size, i: Integer;
	List: PPropList;
	PropInfo: PPropInfo;
	PropOrEvent, PropValue: string;
	Value: Variant;
begin
	Count := GetPropList(Component.ClassInfo, tkAny, nil, False);
	Size := Count * SizeOf(Pointer);
	GetMem(List, Size);
	try
		Count := GetPropList(Component.ClassInfo, tkAny, List, False);
		for i := 0 to Count - 1 do
		begin
			PropInfo := List^[i];
			if PropInfo^.PropType^.Kind in tkMethods then
				PropOrEvent := 'Event'
			else
			begin
				PropOrEvent := 'Property';
				if iNode.HasAttribute(PropInfo^.Name) then
				begin
					Value := iNode.GetAttribute(PropInfo^.Name);
					SetPropValue(Component, PropInfo^.Name, Value);
				end;
//				iNode.Attributes[PropInfo^.Name] := GetPropValue(Component, PropInfo^.Name)
			end;
			// PropValue := VarToStr(GetPropValue(Component, PropInfo^.Name));
			{ Strings.Add(Format('[%s] %s: %s = %s', [PropOrEvent, PropInfo^.Name,
				PropInfo^.PropType^.Name, PropValue])); }
		end;
	finally
		FreeMem(List);
	end;
end;

function RWBSP(const FileName: TFileName; const Save: BG): BG;
const
	VectorNames: array [0 .. 5] of string = ('endX', 'endY', 'middleX', 'middleY', 'startX',
		'startY');

	procedure ProcessNode(const Node: IXMLNode);
	var
		cNode: IXMLNode;
		i: TProjectSettings;
		j: SG;
		AttrName, Name, Value: string;
		V: TGraphicObject;
		VPC: TPersistentClass;
		V2: TPersistent;
	begin
		if Node = nil then
			Exit;

		// virtualRigProject
		if Node.NodeName = 'settings' then
		begin
			for i := Low(ProjectSettingsNames) to High(ProjectSettingsNames) do
			begin
				AttrName := ProjectSettingsNames[i];
				if Node.HasAttribute(AttrName) then
				begin
					Value := Node.GetAttribute(AttrName);
					if TProjectSettings(i) in [psSelectionColor, psVectorColor] then
					begin
						Value := '$' + Value;
					end;
					Project.Params[i] := StrToParam(@ProjectOptions[i], Value);
					{ if TProjectSettings(i) in [psselectionColor, psvectorColor] then
						begin
						Pict.Params[i].Num := ColorRB(Pict.Params[i].Num);
						end; }
				end;
			end;
		end
		else if Node.NodeName = 'vectors' then

		else if Node.NodeName = 'vector' then
		begin
			V := TBlurVector.Create;
			SetLength(Project.GraphicObjects, Length(Project.GraphicObjects) + 1);
			Project.GraphicObjects[Length(Project.GraphicObjects) - 1] := V;
			for j := Low(VectorNames) to High(VectorNames) do
			begin
				AttrName := VectorNames[j];
				if Node.HasAttribute(AttrName) then
				begin
					Name := Node.GetAttribute(AttrName);
					case j of
					0:
						V.E.X := StrToFloat(Name);
					1:
						V.E.Y := StrToFloat(Name);
					2:
						V.M.X := StrToFloat(Name);
					3:
						V.M.Y := StrToFloat(Name);
					4:
						V.s.X := StrToFloat(Name);
					5:
						V.s.Y := StrToFloat(Name);
					end;
				end;
			end;
		end
		else if Node.NodeName = 'objects' then
		else
		begin
			if Node.NodeName = 'TBezier' then
				V := CreateGraphicObject(1)
			else if Node.NodeName = 'TCircle' then
				V := CreateGraphicObject(2)
			else if Node.NodeName = 'TSquare' then
				V := CreateGraphicObject(3)
			else if Node.NodeName = 'TSwirl' then
				V := CreateGraphicObject(4)
			else if Node.NodeName = 'TButton' then
				V := CreateGraphicObject(5)
			else if Node.NodeName = 'TLens' then
				V := CreateGraphicObject(6)
			else if Node.NodeName = 'TZoomer' then
				V := CreateGraphicObject(7);

//			VPC := GetClass('Circle'{Node.NodeName});
//			V2 := .Create;
			SetLength(Project.GraphicObjects, Length(Project.GraphicObjects) + 1);
			Project.GraphicObjects[Length(Project.GraphicObjects) - 1] := TGraphicObject(V);
			ReadObject(V, Node);
		end;

		cNode := Node.ChildNodes.First;
		while cNode <> nil do
		begin
			ProcessNode(cNode);
			cNode := cNode.NextSibling;
		end;
	end;

var
	XML: IXMLDocument;
	iNode: IXMLNode;
	iNode2: IXMLNode;
	i: TProjectSettings;
	j: SG;
	k: SG;
	V: TGraphicObject;
	F: TFlo;
	RMBProject: BG;
begin
	Result := True;
	if Save = False then
	begin
		DefaultOptions(POptions(@ProjectOptions), Length(ProjectOptions), PParams(@Project.Params));
	end;

	if Save then
		BackupFile(FileName);
	if Save = False then
		XML := TXMLDocument.Create(FileName)
	else
		XML := TXMLDocument.Create(nil);

	XML.Active := True;
	try
		// XML.Options += [doAttrNull];
		{ doNodeAutoCreate, doNodeAutoIndent, doAttrNull,
			doAutoPrefix, doNamespaceDecl, doAutoSave }
		if Save = False then
		begin
			if XML.IsEmptyDoc then
				Exit;
			iNode := XML.DocumentElement.ChildNodes.First;
			while iNode <> nil do
			begin
				ProcessNode(iNode);
				iNode := iNode.NextSibling;
			end;
			iNode := nil;
		end
		else // if Save then
		begin
			// XML.CreateElement('virtualRigProject', 'version=1');
			// XML.ParseOptions
			RMBProject := UpperCase(ExtractFileExt(FileName)) = '.RMB';
			if RMBProject then
				iNode2 := XML.AddChild('RealMotionBlurProject', '')
			else
				iNode2 := XML.AddChild('virtualRigProject', '');
			iNode2.Attributes['version'] := '1';

			// iNode := XML.AddChild('settings','');
			iNode := XML.DocumentElement.AddChild('settings');
			// iNode := IXMLNode.Create(nil, iNode2, XML);
			for i := Low(ProjectSettingsNames) to High(ProjectSettingsNames) do
			begin
				iNode.Attributes[ProjectSettingsNames[i]] := ParamToStr
					(@ProjectOptions[i], @Project.Params[i], not RMBProject);
			end;
			// iNode2.ChildNodes.Add(iNode);
			iNode2 := XML.DocumentElement.AddChild('vectors');

			F := 0;
			for k := 0 to Length(Project.GraphicObjects) - 1 do
			begin
				V := Project.GraphicObjects[k];
				if V is TBlurVector then
				begin
					iNode := iNode2.AddChild('vector');
					// iNode := XML.DocumentElement.AddChild('vector');
					for j := Low(VectorNames) to High(VectorNames) do
					begin
						case j of
						0:
							F := V.E.X;
						1:
							F := V.E.Y;
						2:
							F := V.M.X;
						3:
							F := V.M.Y;
						4:
							F := V.s.X;
						5:
							F := V.s.Y;
						end;
						iNode.Attributes[VectorNames[j]] := FToS(F, ofIO);
					end;
				end;
			end;

			iNode2 := XML.DocumentElement.AddChild('objects');

			WriteObjects(iNode2);

			XML.SaveToFile(FileName);
		end;
	finally
		XML.Active := False;
		XML := nil;
		// Release XML document
	end;
end;
{$ENDIF}

procedure FileChanged(const FileName: TFileName);
var
	Item: TOpenedFileItem;
begin
	Item := fMain.OpenedFiles.GetItemByName(DelFileExt(FileName));
	if Item <> nil then
	begin
		fMain.OpenedFilesFreeFile(nil, Item);
		if fMain.OpenedFilesLoadFromFile(nil, Item.FileName) then
			fMain.OpenedFiles.OpenedFileChangeFile(nil);
	end;
end;

function TfMain.OpenedFilesLoadFromFile(Sender: TObject; var FileName: TFileName): Boolean;
var
	B: TDBitmap;
	StartTime: U8;
{$IFDEF RealMotionBlur}
	ImageFileName: TFileName;
{$ENDIF}
begin
	BeginLongOperation;
	try
		B := TDBitmap.Create;
		StartTime := PerformanceCounter;
		Project := TProject.Create;
{$IFDEF RealMotionBlur}
		if (LowerCase(ExtractFileExt(FileName)) = '.' + DefaultExt) or
			(LowerCase(ExtractFileExt(FileName)) = '.bsp') or
			(LowerCase(ExtractFileExt(FileName)) = '.vrs') then
		begin
			if not FileExists(FileName) then
			begin
				IOError(FileName, 3);
				Result := False;
				Exit;
			end;
			Result := RWBSP(FileName, False);
			ImageFileName := FileName + '.' + Project.Params[psImageExtension].Str;
			WatchAddFile(ImageFileName, FileChanged);
			if FileExists(ImageFileName) then
				B.LoadFromFile(ImageFileName);
		end
		else
		begin
{$ENDIF}
			Result := B.LoadFromFileEx(FileName);
{$IFDEF RealMotionBlur}
		end;
{$ENDIF}

		Project.OperationTime := PerformanceCounter - StartTime;
		if Result then
		begin
			Project.Bitmap := B;
			B := nil;
			Project.InitMargin;
			Project.Group := Project.Margin;
			Project.Offset := Point(0, 0);
			Project.Zoom := 1;
			Project.RenderFolder := DelFileExt(FileName) + '_renders' + PathDelim;
		end;
	finally
		FreeAndNil(B);
		EndLongOperation(False);
	end;
end;

procedure TfMain.SelectImportImage;
var
	ImportFileName: TFileName;
	OldX, OldY: SG;
begin
	ImportFileName := '';
	try
		OpenPictureDialog1.Title := Translate('Select image for import');
		OpenPictureDialog1.FilterIndex := 5;
		if ExecuteDialog(OpenPictureDialog1, ImportFileName) then
		begin
			ImageResizedBefore;

			// CopyFile();
			OldX := Project.Bitmap.Width;
			OldY := Project.Bitmap.Height;
			Project.Bitmap.LoadFromFile(ImportFileName);
			if (OldX > 0) and (OldY > 0) then
			begin
				Project.ScaleVectors(Project.Bitmap.Width / OldX, Project.Bitmap.Height / OldY);
			end;

			ImageResizedAfter;
		end
		else
			Exit;
	finally
		OpenPictureDialog1.Title := '';
	end;
end;

function TfMain.OpenedFilesNewFile(Sender: TObject; const Item: TOpenedFileItem): Boolean;
begin
{$IFNDEF RealMotionBlur}
	Result := GetNewXY;
	if Result = False then
		Exit;
{$ELSE}
	Result := False;
{$ENDIF}
	Project := TProject.Create;
	Project.Bitmap := nil;

	Project.Offset := Point(0, 0);
	Project.Zoom := 1;

	Item.FileName := Item.FileName + {$IFNDEF RealMotionBlur} '.png' {$ELSE} '.rmb' {$ENDIF};

	Project.Bitmap := TDBitmap.Create;
	try
{$IFNDEF RealMotionBlur}
		Project.Bitmap.SetSize(NewX, NewY);
{$ELSE}
		DefaultOptions(POptions(@ProjectOptions), Length(ProjectOptions), PParams(@Project.Params));
		SelectImportImage;
		Project.RenderFolder := AppDataDir + Item.FileName + '_renders' + PathDelim;
{$ENDIF}
		Project.InitMargin;
		Project.Group := Project.Margin;
		Result := True;
	except
		on E: Exception do
		begin
			Fatal(E, Self);
			// SetLength(Pict.ABmp, 0);
		end;
		// Result := False;
	end;
end;

function TfMain.OpenedFilesSaveToFile(Sender: TObject; var FileName: TFileName): Boolean;
{$IFDEF RealMotionBlur}
var
	ImageFileName: TFileName;
{$ENDIF}
begin
{$IFDEF RealMotionBlur}
	if (LowerCase(ExtractFileExt(FileName)) = '.' + DefaultExt) or
		(LowerCase(ExtractFileExt(FileName)) = '.bsp') or
		(LowerCase(ExtractFileExt(FileName)) = '.vrs') then
	begin
		Result := RWBSP(FileName, True);
		if Result then
		begin
			ImageFileName := FileName + '.' + Project.Params[psImageExtension].Str;
			WatchRemoveFile(ImageFileName);
			if FileExists(ImageFileName) = False then
			begin
				// TODO Copy File
				Result := Project.Bitmap.SaveToFileEx(ImageFileName, Quality);
			end;
			WatchAddFile(ImageFileName, FileChanged);
		end;
	end
	else
	begin
{$ENDIF}
		Result := Project.Bitmap.SaveToFileEx(FileName, Quality);
		Project.RenderFolder := DelFileExt(FileName) + '_renders' + PathDelim;
{$IFDEF RealMotionBlur}
	end;
{$ENDIF}
	if Result then
		Project.UndoRedo.Saved := True;
end;

function TfMain.OpenedFilesGetFilePos(Sender: TObject; const Data: Pointer): String;
var
	Project: PProject;
begin
	Project := PProject(Data);
	if (Project.Offset.X <> 0) or (Project.Offset.Y <> 0) or
		(not SameData(@Project.Group, @Project.Margin, SizeOf(TRect))) or (Project.Zoom <> 1) then
		Result := NToS(Project.Offset.X, ofIO) + CharTab + NToS(Project.Offset.Y, ofIO) + CharTab + NToS
			(Project.Group.Left, ofIO) + CharTab + NToS(Project.Group.Top, ofIO) + CharTab + NToS
			(Project.Group.Right, ofIO) + CharTab + NToS(Project.Group.Bottom, ofIO) + CharTab + FToS
			(Project.Zoom, ofIO)
	else
		Result := ''
end;

procedure TfMain.OpenedFilesSetFilePos(Sender: TObject; FilePos: String);
var
	InLineIndex: SG;
	Messages: TParserMessages;
begin
	if FilePos = '' then
		Exit;
	Messages := TParserMessages.Create;
	try
		InLineIndex := 1;
		Project.Offset.X := StrToValI(ReadToChar(FilePos, InLineIndex, CharTab), False, MinInt, 0,
			MaxInt, 1, Messages);
		Project.Offset.Y := StrToValI(ReadToChar(FilePos, InLineIndex, CharTab), False, MinInt, 0,
			MaxInt, 1, Messages);
		Project.Group.Left := StrToValI(ReadToChar(FilePos, InLineIndex, CharTab), False, MinInt,
			Project.Margin.Left, MaxInt, 1, Messages);
		Project.Group.Top := StrToValI(ReadToChar(FilePos, InLineIndex, CharTab), False, MinInt,
			Project.Margin.Top, MaxInt, 1, Messages);
		Project.Group.Right := StrToValI(ReadToChar(FilePos, InLineIndex, CharTab), False, MinInt,
			Project.Margin.Right, MaxInt, 1, Messages);
		Project.Group.Bottom := StrToValI(ReadToChar(FilePos, InLineIndex, CharTab), False, MinInt,
			Project.Margin.Bottom, MaxInt, 1, Messages);
		Project.Zoom := StrToValE(ReadToChar(FilePos, InLineIndex, CharTab), False, 1 / 1000, 1, 1000,
			Messages);
	finally
		Messages.Free;
		Project.ChangeGroup;
	end;
end;

procedure TfMain.WMDropFiles(var Msg: TWMDropFiles);
begin
	OpenedFiles.DropFiles(Msg);
end;

procedure TfMain.ImagePKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
	if Shift = [] then
	begin
		case Key of
		VK_ESCAPE:
			begin
				if SelectionMode <> smNone then
				begin
					SelectionMode := smNone;
					ImageP.AreaCursor := SelectionModeToCursor(SelectionMode);
					ActionUndo.Execute;
				end;
			end;
		VK_DELETE, VK_BACK:
			begin
				ActionDelete.Execute;
			end;
		end;
	end
	else if Shift = [ssCtrl] then
	begin
		case Key of
		Ord('C'):
			CopyX1Click(Sender);
		Ord('X'):
			Cut1Click(Sender);
		Ord('V'):
			Paste1Click(Sender);
		Ord('A'):
			SelectAll1Click(Sender);
		end;
	end;
end;

procedure TfMain.ImagePMouseUp(Sender: TObject; Button: TMouseButton; Shift: TShiftState;
	X, Y: Integer);
begin
	if FMouseMode = mmSelect then
	begin
		if Button = mbLeft then
		begin
			// SelectionMode := smNone;
			{ if SelectObject(X, Y, False, ssCtrl in Shift, True) then
				begin
				UpdateImage;
				end; }
		end;
		if ImageP.MouseWhere = mwScroll then
			ImageP.AreaCursor := SelectionModeToCursor(SelectionMode);
	end;
end;

procedure TfMain.ImagePZoomChange(Sender: TObject);
begin
	if Project <> nil then
	begin
		Project.Zoom := ImageP.Zoom;
		if Assigned(fInfo) then
			fInfo.InitZoom;
	end;
end;

procedure TfMain.CreateUndo(const Name: string; const C: TClass);
begin
	OpenedFiles.Change;
	Project.UndoRedo.AddUndo(Project.GetUndo(C));
	InitMenu;
end;

procedure TfMain.Crop1Click(Sender: TObject);
begin
	ImageResizedBefore;

	CreateUndo('Crop', TMyBitmapUndo);
	CreateUndo('Crop', TMyVectorsUndo);
	Project.ScaleVectors((Project.Group.Right - Project.Group.Left + 1) / Project.Bitmap.Width,
		(Project.Group.Bottom - Project.Group.Top + 1) / Project.Bitmap.Height);
	Project.Bitmap.Crop(Project.Group);

	ImageResizedAfter;
end;

procedure Init;
var
	i: TProjectSettings;
begin
{$IFDEF RealMotionBlur}
{$IFNDEF Trial}
	FullVersion := True;
{$ENDIF}
{$ENDIF}
	InitOptionNames(TypeInfo(TProjectSettings), ProjectOptions);
	InitOptionNames(TypeInfo(TApplicationSettings), ApplicationOptions);
	EnumToStrEx(TypeInfo(TProjectSettings), ProjectSettingsNames);
	for i := Low(ProjectSettingsNames) to High(ProjectSettingsNames) do
	begin
		ProjectSettingsNames[i][1] := LowCase(ProjectSettingsNames[i][1]);
	end;
end;

procedure TfMain.RealTimePreview1Click(Sender: TObject);
begin
	RealTimePreview1.Checked := not RealTimePreview1.Checked;
	if RealTimePreview1.Checked then
		DoPreview;
end;

procedure TfMain.RenderedImage1Click(Sender: TObject);
begin
	// ImageP.UserBitmap := BmpD;
	if Project <> nil then
		APIOpen(Project.RenderFileName);
end;

procedure TfMain.Status1Click(Sender: TObject);
begin
	Status1.Checked := not Status1.Checked;
	if Status1.Checked then
		ShowStatusWindow(ThreadPool, Status1)
	else
		HideStatusWindow;
	UpdateIcons(MainMenu1, PanelTool);
end;

procedure TfMain.ApplicationOptionChanged(const OptionIndex: SG);
begin
	case TApplicationSettings(OptionIndex) of
	asAutomaticallyNumberOfThreads, asNumberOfThreads:
		begin
			if ApplicationParams[asAutomaticallyNumberOfThreads].Bool then
				ThreadPool.MaxThreads := GSysInfo.LogicalProcessorCount
			else
				ThreadPool.MaxThreads := ApplicationParams[asNumberOfThreads].Num
		end;
	asUndoCountLimit:
		UndoCountLimit := ApplicationParams[asUndoCountLimit].Num;
	asUndoSizePercentOfRAM:
		UndoSizePercentOfRAM := ApplicationParams[asUndoSizePercentOfRAM].Num;
	end;
end;

procedure TfMain.ProjectOptionChanged(const OptionIndex: SG);
begin
	case TProjectSettings(OptionIndex) of
	{ psimageExtension
		psmarginStripSize }
	psVectorType, psVectorCurvePrecision, psVectorColor, psSelectionColor:
		DelayedCall(0);
	// psspeedCoefficient, psvectorType) UpdatePreview;
	end;
end;

procedure TfMain.Overview1Click(Sender: TObject);
begin
	Overview1.Checked := not Overview1.Checked;
	if Overview1.Checked then
	begin
		if fOverview = nil then
			fOverview := TfOverview.Create(Self);
		fOverview.Show;
	end
	else
		fOverview.Hide;
	UpdateIcons(MainMenu1, PanelTool);
end;

procedure TfMain.ProcessAllOpenedProjects1Click(Sender: TObject);
var
	i: SG;
	P: PProject;
begin
	AOpen := False;
	try
		for i := 0 to OpenedFiles.Count - 1 do
		begin
			P := OpenedFiles.GetItemData(i);
			P.Process;
		end;
	finally

	end;
end;

procedure TfMain.RenderFolder1Click(Sender: TObject);
begin
	// ImageP.UserBitmap := BmpD;
	if Project <> nil then
		APIOpen(Project.RenderFolder);
end;

procedure TfMain.ImportImage1Click(Sender: TObject);
begin
	SelectImportImage;
end;

procedure TfMain.Layers1Click(Sender: TObject);
begin
	Layers1.Checked := not Layers1.Checked;
	if fLayers = nil then
		fLayers := TfLayers.Create(Self);
	if Layers1.Checked then
	begin
		fLayers.Show;
	end
	else
		fLayers.Hide;
	UpdateIcons(MainMenu1, PanelTool);
end;

procedure TfMain.Timer1Timer(Sender: TObject);
begin
	DelayedTimer;
end;

initialization

Init;

finalization

end.
