// * File:     CXY\uGraphicObject.pas
// * Created:  2009-12-29
// * Modified: 2010-11-13
// * Version:  2.2.47.104
// * Author:   David Safranek (Safrad)
// * E-Mail:   safrad at email.cz
// * Web:      http://safrad.own.cz

unit uGraphicObject;

interface

uses
	uTypes, uDBitmap, uDImage, uColor,
	uBlur,
	Graphics;

type
	TRenderingMethod = (rmStart = 1, rmMiddle = 2, rmEnd = 3);

	{ TGraphicFunction = (gfTexture, gfCircle, gfChangeColor, gfLens, gdColors, gfText, gfBlurVectors, gfBlurCircle, gfBlurTwister, gfBlurZoomer
		gfBlurBezier); }
	TArrayOfVector = array of TVector;

	TGraphicObject = class
	private
		function GetEndX: TFlo;
		function GetEndY: TFlo;
		function GetStartX: TFlo;
		function GetStartY: TFlo;
		procedure SetEndX(const Value: TFlo);
		procedure SetEndY(const Value: TFlo);
		procedure SetStartX(const Value: TFlo);
		procedure SetStartY(const Value: TFlo);
		// FGraphicFunction: TGraphicFunction;
	public
		S: TPointDS;
		M: TPointDS;
		E: TPointDS;

		procedure InitM;
		procedure Move(const OffsetX, OffsetY: TFlo); overload;
		procedure MoveSelected(const OffsetX, OffsetY: TFlo);
		procedure Scale(const Scale: TFlo); overload;
		procedure Scale(const ScaleX, ScaleY: TFlo); overload;
		// Layer: SG; // TODO : Implement
		function Clone: TGraphicObject; virtual; abstract;
		procedure Draw(ImageP: TDImage); virtual;
		procedure ToVectors(var Vectors: TArrayOfVector); virtual; abstract;
	published
		property StartX: TFlo read GetStartX write SetStartX;
		property StartY: TFlo read GetStartY write SetStartY;
		property EndX: TFlo read GetEndX write SetEndX;
		property EndY: TFlo read GetEndY write SetEndY;
	end;

	TArrayOfGraphicObject = array of TGraphicObject;

	TVectorType = (vtStraight = 1, vtPolyline = 2, vtCurve = 3);

	TBlurVector = class(TGraphicObject)

	public
		function Clone: TGraphicObject; override;
		procedure Draw(ImageP: TDImage); override;
		procedure ToVectors(var Vectors: TArrayOfVector); override;
	end;

	TBezier = class(TGraphicObject)
	public
		Count: SG;
		Points: array of TPointDS;

		constructor Create;
		function Clone: TGraphicObject; override;
		procedure Draw(ImageP: TDImage); override;
		procedure ToVectors(var Vectors: TArrayOfVector); override;
	end;

const
	DefaultIntensity = 50;
type
	TCircle = class(TGraphicObject)
	private
		FIntensity: TFlo;
	public
		constructor Create;
		function Clone: TGraphicObject; override;
		procedure Draw(ImageP: TDImage); override;
		procedure ToVectors(var Vectors: TArrayOfVector); override;
	published
		property Intensity: TFlo read FIntensity write FIntensity;
	end;

	TSquare = class(TGraphicObject)
	private
		FIntensity: TFlo;
	public
		property Intensity: TFlo read FIntensity write FIntensity;
		constructor Create;
		function Clone: TGraphicObject; override;
		procedure Draw(ImageP: TDImage); override;
		procedure ToVectors(var Vectors: TArrayOfVector); override;
	end;

	TSwirl = class(TGraphicObject)
	public
		function Clone: TGraphicObject; override;
		procedure Draw(ImageP: TDImage); override;
		procedure ToVectors(var Vectors: TArrayOfVector); override;
	end;

	TButton = class(TGraphicObject)
	public
		function Clone: TGraphicObject; override;
		procedure Draw(ImageP: TDImage); override;
		procedure ToVectors(var Vectors: TArrayOfVector); override;
	end;

	TLens = class(TGraphicObject)
	private
		FMinZoom: TFlo;
		FMaxZoom: TFlo;
	public
		property MinZoom: TFlo read FMinZoom write FMinZoom;
		property MaxZoom: TFlo read FMaxZoom write FMaxZoom;

		function Clone: TGraphicObject; override;
		procedure Draw(ImageP: TDImage); override;
		procedure ToVectors(var Vectors: TArrayOfVector); override;
	end;

	TZoomer = class(TGraphicObject)
	public
		function Clone: TGraphicObject; override;
		procedure Draw(ImageP: TDImage); override;
		procedure ToVectors(var Vectors: TArrayOfVector); override;
	end;

	// Others

	TTwister = class(TGraphicObject)
	private
	public
		function Clone: TGraphicObject; override;
		procedure Draw(ImageP: TDImage); override;
		procedure ToVectors(var Vectors: TArrayOfVector); override;
	end;

	TChangeColor = class(TGraphicObject)
	private
		FSourceColor: TColor;
		FTargetColor: TColor;
	public
		property SourceColor: TColor read FSourceColor write FSourceColor;
		property TargetColor: TColor read FTargetColor write FTargetColor;

		function Clone: TGraphicObject; override;
		procedure Draw(ImageP: TDImage); override;
		procedure ToVectors(var Vectors: TArrayOfVector); override;
	end;

var
	SC, C: TRGBA;

procedure CloneGraphicObjects(var Dst: TArrayOfGraphicObject; const Src: TArrayOfGraphicObject);
procedure ScaleVector(Vector: PVector; const Scale: TFlo); overload;
procedure ScaleVector(Vector: PVector; const ScaleX, ScaleY: TFlo); overload;
procedure MoveVector(Vector: PVector; const OffsetX, OffsetY: TFlo); overload;
procedure DrawVector(const Vector: TVector; ImageP: TDImage);

implementation

uses
	Types, Classes,
{$ifdef UNICODE}
	GDIPlus,
{$ENDIF}
	uDrawStyle, uSGL, uProject;

const
	DefaultWidth = 2;

procedure CloneGraphicObjects(var Dst: TArrayOfGraphicObject; const Src: TArrayOfGraphicObject);
var
	i: SG;
begin
	for i := 0 to Length(Dst) - 1 do
		Dst[i].Free;
	SetLength(Dst, 0);
	SetLength(Dst, Length(Src));
	for i := 0 to Length(Dst) - 1 do
		Dst[i] := Src[i].Clone;
end;

procedure Arrow(const Bmp: TDBitmap; const P1, P2: TFloPoint; const C1, C2: TColor);
const
	Effect = ef12;
	Wide = 4;
	Le = 8;
var
	Len: TFlo;
	Width: SG;
begin
	Width := DefaultWidth;
	Len := Sqr(P1.X - P2.X) + Sqr(P1.Y - P2.Y);
	if Len = 0 then
		Exit;
	Len := Sqrt(Len);
	if 4 * Width > Len then
		Width := 1;

	Bmp.Line(P1.X, P1.Y, P2.X, P2.Y, MixColors(C1, C2), Effect, Width);
//	Bmp.Bar(P1.X - Width, P1.Y - Width, P1.X + Width, P1.Y + Width, C1, Effect);
	if Len > 0 then
	begin
		Bmp.Line(P2.X, P2.Y, P2.X + (Le * (P1.X - P2.X) + Wide * (P1.Y - P2.Y)) / Len, P2.Y +
				(Le * (P1.Y - P2.Y) - Wide * (P1.X - P2.X)) / Len, C2, Effect, Width);
		Bmp.Line(P2.X, P2.Y, P2.X + (Le * (P1.X - P2.X) - Wide * (P1.Y - P2.Y)) / Len, P2.Y +
				(Le * (P1.Y - P2.Y) + Wide * (P1.X - P2.X)) / Len, C2, Effect, Width);
	end;
	{ Mul = 4;
		var
		Len: SG;
		begin
		Bmp.Line(P1.X, P1.Y, P2.X, P2.Y, MixColors(P1.C, P2.C), Effect);
		Bmp.Bar(P1.X - 1, P1.Y - 1, P1.X + 1, P1.Y + 1, P1.C, Effect);

		Len := Round(Sqrt(Sqr(P1.X - P2.X) + Sqr(P1.Y - P2.Y)));
		if Len > 0 then
		begin
		Len := Len * 8;
		Bmp.Line(P2.X, P2.Y,
		P1.X + Mul * (P1.Y - P2.Y) div Len,
		P1.Y - Mul * (P1.X - P2.X) div Len, P2.C, Effect);
		Bmp.Line(P2.X, P2.Y,
		P1.X - Mul * (P1.Y - P2.Y) div Len,
		P1.Y + Mul * (P1.X - P2.X) div Len, P2.C, Effect);
		end; }
end;

procedure DrawSelectedRectangle(const SP, EP: TFloPoint; ImageP: TDImage);
{$IFDEF UNICODE}
var
	Pen: IGPPen;
begin
//	ImageP.Bitmap. Rec(SP, EP, clRed, ef16);
	Pen := TGPPen.Create(TGPColor.Create(clWhite));
	Pen.DashStyle := DashStyleDashDot;
	Pen.Width := 1;
//	ImageP.Bitmap.GPGraphic.DrawEllipse(Pen, SP.X, SP.Y, EP.X, EP.Y);
	ImageP.Bitmap.GPGraphic.DrawRectangle(Pen, SP.X, SP.Y, EP.X, EP.Y);
	// TODO DNW
{$ELSE}
begin
{$ENDIF}
end;

procedure DrawVector(const Vector: TVector; ImageP: TDImage);
var
	SP, EP: TFloPoint;
	C1, C2: TColor;
begin
	SP := ImageP.GetFloPoint(Vector.S.X, Vector.S.Y);
	EP := ImageP.GetFloPoint(Vector.E.X, Vector.E.Y);
	C1 := clSilver;
	C2 := clSilver;
	Arrow(ImageP.Bitmap, SP, EP, C1, C2);
end;

procedure AddVector(var Vectors: TArrayOfVector; const S, E: TPointDS);
var
	L: SG;
begin
	L := Length(Vectors);
	SetLength(Vectors, L + 1);
	Vectors[L].S := S;
	Vectors[L].E := E;
end;

{ TGraphicObject }

function GraphicObjectColor(const Selected: BG): TColor;
begin
	if Selected then
		Result := SC.L
	else
		Result := C.L;
end;

procedure TGraphicObject.Draw(ImageP: TDImage);
var
	SP, MP, EP: TFloPoint;
begin
	SP := ImageP.GetFloPoint(S.X, S.Y);
	MP := ImageP.GetFloPoint(M.X, M.Y);
	EP := ImageP.GetFloPoint(E.X, E.Y);

	ImageP.Bitmap.Clip(SP, GraphicObjectColor(S.Selected));
	ImageP.Bitmap.Clip(MP, GraphicObjectColor(M.Selected));
	ImageP.Bitmap.Clip(EP, GraphicObjectColor(E.Selected));
end;

function TGraphicObject.GetEndX: TFlo;
begin
	Result := E.X;
end;

function TGraphicObject.GetEndY: TFlo;
begin
	Result := E.Y;
end;

function TGraphicObject.GetStartX: TFlo;
begin
	Result := S.X;
end;

function TGraphicObject.GetStartY: TFlo;
begin
	Result := S.Y;
end;

procedure TGraphicObject.InitM;
begin
	M.X := (S.X + E.X) / 2;
	M.Y := (S.Y + E.Y) / 2;
end;

procedure TGraphicObject.Move(const OffsetX, OffsetY: TFlo);
begin

end;

procedure TGraphicObject.MoveSelected(const OffsetX, OffsetY: TFlo);
begin

end;

procedure TGraphicObject.Scale(const Scale: TFlo);
begin

end;

procedure TGraphicObject.Scale(const ScaleX, ScaleY: TFlo);
begin

end;

procedure TGraphicObject.SetEndX(const Value: TFlo);
begin
	E.X := Value;
end;

procedure TGraphicObject.SetEndY(const Value: TFlo);
begin
	E.Y := Value;
end;

procedure TGraphicObject.SetStartX(const Value: TFlo);
begin
	S.X := Value;
end;

procedure TGraphicObject.SetStartY(const Value: TFlo);
begin
	S.Y := Value;
end;

procedure MovePoint(var P: TPointDS; const OffsetX, OffsetY: TFlo);
begin
	P.X := P.X + OffsetX;
	P.Y := P.Y + OffsetY;
end;

procedure MoveSelectedPoint(var P: TPointDS; const OffsetX, OffsetY: TFlo);
begin
	if P.Selected then
	begin
		P.X := P.X + OffsetX;
		P.Y := P.Y + OffsetY;
	end;
end;

procedure ScalePoint(var P: TPointDS; const Scale: TFlo); overload;
begin
	P.X := Scale * P.X;
	P.Y := Scale * P.Y;
end;

procedure ScalePoint(var P: TPointDS; const ScaleX, ScaleY: TFlo); overload;
begin
	P.X := ScaleX * P.X;
	P.Y := ScaleY * P.Y;
end;

procedure MoveVector(var Vector: TGraphicObject; const OffsetX, OffsetY: TFlo); overload;
begin
	MovePoint(Vector.S, OffsetX, OffsetY);
	MovePoint(Vector.M, OffsetX, OffsetY);
	MovePoint(Vector.E, OffsetX, OffsetY);
end;

procedure MoveSelectedVector(var Vector: TVector; const OffsetX, OffsetY: TFlo); overload;
begin
	MoveSelectedPoint(Vector.S, OffsetX, OffsetY);
	// MoveSelectedPoint(Vector.M, OffsetX, OffsetY);
	MoveSelectedPoint(Vector.E, OffsetX, OffsetY);
end;

procedure MoveVector(Vector: PVector; const OffsetX, OffsetY: TFlo); overload;
begin
	MovePoint(Vector.S, OffsetX, OffsetY);
	// MovePoint(Vector.M, OffsetX, OffsetY);
	MovePoint(Vector.E, OffsetX, OffsetY);
end;

procedure ScaleVector(Vector: PVector; const Scale: TFlo); overload;
begin
	ScalePoint(Vector.S, Scale);
	// ScalePoint(Vector.M, Scale);
	ScalePoint(Vector.E, Scale);
end;

procedure ScaleVector(Vector: PVector; const ScaleX, ScaleY: TFlo); overload;
begin
	ScalePoint(Vector.S, ScaleX, ScaleY);
	// ScalePoint(Vector.M, ScaleX, ScaleY);
	ScalePoint(Vector.E, ScaleX, ScaleY);
end;

{ TBezier }

function TBezier.Clone: TGraphicObject;
var
	i: SG;
begin
	Result := TBezier.Create;
	Result.S := S;
	Result.M := M;
	Result.E := E;
	TBezier(Result).Count := Count;
	SetLength(TBezier(Result).Points, Count);
	for i := 0 to Count - 1 do
	begin
		TBezier(Result).Points[i] := Points[i];
	end;
end;

constructor TBezier.Create;
begin
	Count := 2;
	SetLength(Points, Count);
	Points[0] := S;
	Points[1] := E;
end;

procedure TBezier.Draw(ImageP: TDImage);
var
	i: SG;
begin
	inherited;

	sglLineWidth(DefaultWidth);
	sglLineStyle(SGL_LINE_STYLE_DASH_DOUBLE_DOTTED);
	sglHatching(SGL_HATCH_NONE, 255, 255, 255, 255);
	sglColor(GraphicObjectColor(M.Selected));
	sglBegin(sglBezierGCurve);
	sglVertex(S.X, S.Y);
	for i := 0 to Count - 1 do
		sglVertex(Points[i].X, Points[i].Y);

	sglVertex(E.X, E.Y);
	sglEnd;
end;

procedure TBezier.ToVectors(var Vectors: TArrayOfVector);
begin
	// TODO
end;

{ TBlurVector }

function TBlurVector.Clone: TGraphicObject;
begin
	Result := TBlurVector.Create;
	Result.S := S;
	Result.M := M;
	Result.E := E;
end;

procedure TBlurVector.Draw(ImageP: TDImage);
const
	Width = 2;
var
	V: TGraphicObject;
	SP, MP, EP: TFloPoint;
	VT: TVectorType;
	C1, C2: TColor;
begin
	inherited;
	V := Self;
	VT := vtStraight;

	SP := ImageP.GetFloPoint(V.S.X, V.S.Y);
	if V.S.Selected then
		C1 := SC.L
	else
		C1 := C.L;
	MP := ImageP.GetFloPoint(V.M.X, V.M.Y);
	EP := ImageP.GetFloPoint(V.E.X, V.E.Y);
	if V.E.Selected then
		C2 := SC.L
	else
		C2 := C.L;
	case VT of
	vtStraight:
		begin
			Arrow(ImageP.Bitmap, SP, EP, C1, C2);
{			ImageP.Bitmap.Bar(MP.X - Width, MP.Y - Width, MP.X + Width, MP.Y + Width, MixColors(C1, C2),
				ef16);}
		end;
	vtPolyline:
		begin
			ImageP.Bitmap.Arrow(SP.X, SP.Y, MP.X, MP.Y, 4, C1, ef12);
			ImageP.Bitmap.Arrow(MP.X, MP.Y, EP.X, EP.Y, 10, C2, ef12);
		end;
	vtCurve:
		begin
			ImageP.Bitmap.Arrow(SP.X, SP.Y, MP.X, MP.Y, 4, C1, ef08);
			sglLineWidth(2);
			sglLineStyle(SGL_LINE_STYLE_DASH_DOUBLE_DOTTED);
			sglHatching(SGL_HATCH_NONE, 255, 255, 255, 255);
			sglColor(C2);
			sglBegin(sglBezierGCurve);
			sglVertex(SP.X, SP.Y);
			sglVertex(MP.X, MP.Y);
			sglVertex(EP.X, EP.Y);
			sglEnd;
			// ImageP.Bitmap.Arrow(Round(V.M.X), Round(V.M.Y), Round(V.E.X), Round(V.E.Y), 10, C.L, ef12);
		end;
	end;
end;

procedure TBlurVector.ToVectors(var Vectors: TArrayOfVector);
var
	L: SG;
begin
//	AddVector(Vectors, S, E);
	L := Length(Vectors);
	SetLength(Vectors, L + 1);
	Vectors[L].S := S;
	Vectors[L].E := E;
	case TRenderingMethod(Project.Params[psRenderingMethod].Num) of
	rmStart:
		begin
		end;
	rmMiddle:
		begin
			MoveVector(@Vectors[L], (E.X - S.X) / 2, (E.Y - S.Y) / 2);
		end;
	rmEnd:
		begin
			MoveVector(@Vectors[L], (E.X - S.X), (E.Y - S.Y));
		end;
	end;
end;

{ TChangeColor }

function TChangeColor.Clone: TGraphicObject;
begin
	Result := TChangeColor.Create;
	Result.S := S;
	Result.M := M;
	Result.E := E;
	TChangeColor(Result).FSourceColor := FSourceColor;
	TChangeColor(Result).FTargetColor := FTargetColor;
end;

procedure TChangeColor.Draw(ImageP: TDImage);
var
	SP, EP: TFloPoint;
begin
	inherited;

	SP := ImageP.GetFloPoint(S.X, S.Y);
	EP := ImageP.GetFloPoint(E.X, E.Y);
	ImageP.Bitmap.ChangeColor(Rect(Round(S.X), Round(S.Y), Round(E.X), Round(E.Y)), FSourceColor,
		FTargetColor);
end;

procedure TChangeColor.ToVectors(var Vectors: TArrayOfVector);
begin
	// No vectors
end;

{ TCircle }

function TCircle.Clone: TGraphicObject;
begin
	Result := TCircle.Create;
	Result.S := S;
	Result.M := M;
	Result.E := E;
	TCircle(Result).Intensity := FIntensity;
end;

constructor TCircle.Create;
begin
	inherited Create;
	FIntensity := DefaultIntensity;
end;

procedure TCircle.Draw(ImageP: TDImage);
var
	SP, EP: TFloPoint;
begin
	inherited;

	// sglEllipse();
	SP := ImageP.GetFloPoint(S.X, S.Y);
//	MP := ImageP.GetFloPoint(M.X, M.Y);
	EP := ImageP.GetFloPoint(E.X, E.Y);
	DrawSelectedRectangle(SP, EP, ImageP);
	ImageP.Bitmap.Ellipse(SP, EP, GraphicObjectColor(M.Selected), ef16, DefaultWidth);
end;

procedure TCircle.ToVectors(var Vectors: TArrayOfVector);
const
	Count = 36;
var
	i: SG;
	SP, EP: TPointDS;
	SizeX, SizeY: TFlo;
begin
{	SP.X := E.X;
	SP.Y := (S.Y + E.Y) / 2;}
	SizeX := (E.X - S.X) / 2;
	SizeY := (E.Y - S.Y) / 2;
	for i := 0 to Count - 1 do
	begin
		SP.X := M.X + SizeX * Cos(2 * pi * i / Count);
		SP.Y := M.Y + SizeY * Sin(2 * pi * i / Count);

		EP.X := SP.X + Intensity * Sin(2 * pi * i / Count);
		EP.Y := SP.Y + Intensity * -Cos(2 * pi * i / Count);
		AddVector(Vectors, SP, EP);
		SP := EP;
	end;
end;

{ TLens }

function TLens.Clone: TGraphicObject;
begin
	Result := TLens.Create;
	Result.S := S;
	Result.M := M;
	Result.E := E;
	TLens(Result).FMinZoom := FMinZoom;
	TLens(Result).FMaxZoom := FMaxZoom;
end;

procedure TLens.Draw(ImageP: TDImage);
var
	SP, EP: TFloPoint;
begin
	inherited;

	SP := ImageP.GetFloPoint(S.X, S.Y);
	EP := ImageP.GetFloPoint(E.X, E.Y);
	ImageP.Bitmap.Ellipse(SP, EP, GraphicObjectColor(M.Selected), ef16, DefaultWidth);

//	ImageP.Bitmap.Ellipse(SP, EP, GraphicObjectColor(M.Selected), ef16, DefaultWidth);
end;

procedure TLens.ToVectors(var Vectors: TArrayOfVector);
begin
	// TODO
end;

{ TTwister }

function TTwister.Clone: TGraphicObject;
begin
	Result := TTwister.Create;
	Result.S := S;
	Result.M := M;
	Result.E := E;
end;

procedure TTwister.Draw(ImageP: TDImage);
var
	P: TPointDS;
	C: TRGBA;
begin
	inherited;

	P := M;
	C.L := clGreen;
	{ while True do
		begin
		if Over(x) then

		Pix(FBitmap.Data, FBitmap.ByteX, x, y, @C, ef16);

		end; }
end;

procedure TTwister.ToVectors(var Vectors: TArrayOfVector);
begin
	// TODO
end;

{ TSquare }

function TSquare.Clone: TGraphicObject;
begin
	Result := TSquare.Create;
	Result.S := S;
	Result.M := M;
	Result.E := E;
end;

constructor TSquare.Create;
begin
	inherited Create;
	FIntensity := DefaultIntensity;
end;

procedure TSquare.Draw(ImageP: TDImage);
var
	SP, EP: TFloPoint;
begin
	inherited;

	SP := ImageP.GetFloPoint(S.X, S.Y);
	EP := ImageP.GetFloPoint(E.X, E.Y);
	ImageP.Bitmap.Rec(SP, EP, GraphicObjectColor(M.Selected), ef16, DefaultWidth);
end;

procedure TSquare.ToVectors(var Vectors: TArrayOfVector);
const
	Count = 10;
var
	i: SG;
begin
	for i := 0 to Count - 1 do
	begin

//		EP.X := SP.X +
	end;

//		AddVector(Vectors, SP, EP);
end;

{ TSwirl }

function TSwirl.Clone: TGraphicObject;
begin
	Result := TSwirl.Create;
	Result.S := S;
	Result.M := M;
	Result.E := E;
end;

procedure TSwirl.Draw(ImageP: TDImage);
const
	Draw = True;
	Count = 36;
var
	SP, EP: TPointDS;
	SP2, EP2: TFloPoint;
	SizeX, SizeY: TFlo;
	Angle: TFlo;
begin
	inherited;

	InitM;

	SizeX := (E.X - S.X) / 2;
	SizeY := (E.Y - S.Y) / 2;
	Angle := 0;
	while True do
	begin
		SP.X := M.X + SizeX * Cos(2 * pi * Angle);
		SP.Y := M.Y + SizeY * Sin(2 * pi * Angle);
		Angle := Angle + 0.02;
		SizeX := SizeX - 0.5;
		SizeY := SizeY - 0.5;
		if Draw then
		begin
			EP.X := M.X + SizeX * Cos(2 * pi * Angle);
			EP.Y := M.Y + SizeY * Sin(2 * pi * Angle);
			SP2 := ImageP.GetFloPoint(SP.X, SP.Y);
			EP2 := ImageP.GetFloPoint(EP.X, EP.Y);
			ImageP.Bitmap.Line(SP2.X, SP2.Y, EP2.X, EP2.Y, GraphicObjectColor(M.Selected), ef16, DefaultWidth);
		end
		else
		begin
			EP.X := M.X + SizeX * Cos(2 * pi * Angle);
			EP.Y := M.Y + SizeY * Sin(2 * pi * Angle);
//			AddVector(Vectors, SP, EP);
		end;

		if SizeX < 1 then Break;
		if SizeY < 1 then Break;
	end;
end;

procedure TSwirl.ToVectors(var Vectors: TArrayOfVector);
begin
//	Intensity := TODO
end;

{ TButton }

function TButton.Clone: TGraphicObject;
begin
	Result := TButton.Create;
	Result.S := S;
	Result.M := M;
	Result.E := E;
end;

procedure TButton.Draw(ImageP: TDImage);
begin
	inherited;

end;

procedure TButton.ToVectors(var Vectors: TArrayOfVector);
begin
	// TODO
end;

{ TZoomer }

function TZoomer.Clone: TGraphicObject;
begin
	Result := TZoomer.Create;
	Result.S := S;
	Result.M := M;
	Result.E := E;
end;

procedure TZoomer.Draw(ImageP: TDImage);
begin
	inherited;

end;

procedure TZoomer.ToVectors(var Vectors: TArrayOfVector);
begin
	// TODO
end;

procedure Register;
begin
//	RegisterComponents(ComponentPageName, [TCircle]);
//	RegisterClasses([TCircle, TForm]);    uDButton
end;

end.
