// * File:     CXY\uFunc.pas
// * Created:  1998-02-01
// * Modified: 2010-11-13
// * Version:  2.2.47.104
// * Author:   David Safranek (Safrad)
// * E-Mail:   safrad at email.cz
// * Web:      http://safrad.own.cz

unit uFunc;

interface

uses
	uTypes, uDBitmap, uInputFormat, uThreadPool, uProject,
	SysUtils, Windows, Graphics;

procedure ResizeGroup(BmpS, BmpD: TDBitmap);

procedure Stop;
procedure StopAndWait;
procedure DoPreview(const PreviewPoint: TPoint); overload;
procedure DoPreview; overload;
procedure Process(const Project: TProject; const FileName: TFileName);

var
	ThreadPool: TThreadPool;

	TerminateThreads: BG;

	NewSX, NewSY: UG;

implementation

uses
	Classes, Forms, Math,
	uGraph, uOpenedFiles, uMath, uOutputFormat, uColor, uStrings, uDrawStyle, uSysInfo, uSimulation,
	uSystem, uAPI, uFiles, ufStatus, uSounds, uDelayedCall,
	uMain, uFunctions {$IFDEF RealMotionBlur}, uRealMotionBlur {$ENDIF}, uBlur,
	uGraphicObject,
	uOptions, uNumericComboBox, StdCtrls, Types;

threadvar LastDone: SG;

// Unique for every Thread
var
	LastTime: U4;

	// GenRGB Params
	AC: array [0 .. 3] of TColor;
{$IFNDEF RealMotionBlur}
	C: TRGBA;
{$ENDIF}
	// Bmp
	K2: PProject;

	// Blur
	BlurInteractions: UG;
	BlurRadius: FA;
	BlurIntensity: FA;
	BlurDirection: FA;

type
	TMyCommand = class(TCommand)
	protected
		procedure Execute; override;
	public
		{ Public declarations }
		Project: TProject;
		Range: TRect;
		// GraphicFunction: TGraphicFunction;
		destructor Destroy; override;
	end;

	// var
	// Project: PProject;
	// BmpS, BmpD: TDBitmap;
	{ var
		ProcessThreads: array of TProcessThread; }

procedure ResizeGroup(BmpS, BmpD: TDBitmap);
begin
	if (BmpS.Width > 0) and (BmpS.Height > 0) then
	begin
		Project.Group.Left := RoundDivS8(U8(BmpD.Width) * Project.Group.Left, BmpS.Width);
		Project.Group.Top := RoundDivS8(U8(BmpD.Height) * Project.Group.Top, BmpS.Height);
		Project.Group.Right := RoundDivS8(U8(BmpD.Width) * Project.Group.Right, BmpS.Width);
		Project.Group.Bottom := RoundDivS8(U8(BmpD.Height) * Project.Group.Bottom, BmpS.Height);
	end;
end;

{ function Suma(const A: array of SG): SG;
	var
	i: SG;
	begin
	Result := 0;
	for i := 0 to Length(A) - 1 do
	begin
	Inc(Result, A[i]);
	end;
	end; }

function InterruptProcedure(const Done: SG): BG;
const
	Interval = Second; // 5 * LoopSleepTime;
begin
	Result := TerminateThreads;
	if Result then
		Exit;

	Assert(Done >= LastDone);
	Inc(Project.Done, Done - LastDone); // Synchronized
	LastDone := Done;
	if { (Done <> LastDone) and } (IntervalFrom(LastTime) >= Interval) then
	begin
		LastTime := GTime;
		UpdateStatus(Project.Done);
		// fMain.InitMenu;
		// TODO : Synchronized
		{ Application.ProcessMessages; }
	end;
end;

procedure Stop;
begin
	if Project.CommandRunCount > 0 then
	begin
		{ for I := 0 to Length(ProcessThreads) - 1 do
			ProcessThreads[I].Terminate; }
		TerminateThreads := True;
		ThreadPool.Clear;
		fMain.InitMenu;
	end;
end;

procedure StopAndWait;
var
	StartTickCount: U4;
begin
	Stop;
	StartTickCount := GetTickCount;
	while (Project.CommandRunCount > 0) and (TimeDifference(GetTickCount, StartTickCount) < 2 * Second) do
	begin
		Sleep(100);
	end;
	Project.CommandRunCount := 0;
	TerminateThreads := False;
end;

type
	TRange = record
		F, T: SG;
	end;

	TRangeArray = array of TRange;

	{ procedure RandomizeRangeArray(var A: TRangeArray);
		var
		T: TRange;
		Count: SG;
		i, X: SG;
		begin
		Count := Length(A);
		for i := 0 to Count - 1 do
		begin
		X := Random(Count);
		T := A[i];
		A[i] := A[X];
		A[X] := T;
		end;
		end; }

procedure Separators(const F, T: SG; MaxParts: SG; out Sep: TRangeArray);
var
	V1, V2: SG;
	i: SG;
begin
	if MaxParts > T - F + 1 then
		MaxParts := T - F + 1;
	if MaxParts <= 0 then
		MaxParts := 1;

	SetLength(Sep, MaxParts);
	V2 := F - 1;
	i := 0;
	while i < MaxParts do
	begin
		V1 := V2 + 1;
		V2 := F + ((i + 1) * (T - F)) div MaxParts;
		Sep[i].F := V1;
		Sep[i].T := V2;
		Inc(i);
	end;
end;
{$IFNDEF RealMotionBlur}

procedure Clrs;
begin
	// Project.BmpD.FromBitmap(Project.BmpS);

	fFunctions.ColorB := fFunctions.ButtonB.Down;
	fFunctions.ColorG := fFunctions.ButtonG.Down;
	fFunctions.ColorR := fFunctions.ButtonR.Down;
end;

procedure GnRGB;
begin
	AC[0] := fFunctions.PanelC0.Color;
	AC[1] := fFunctions.PanelC1.Color;
	AC[2] := fFunctions.PanelC2.Color;
	AC[3] := fFunctions.PanelC3.Color;
	if fFunctions.UseRandomColor.Down then
	begin
		C.R := fFunctions.TrackBarR.Position;
		C.G := fFunctions.TrackBarG.Position;
		C.B := fFunctions.TrackBarB.Position;
		C.A := 0;
	end
	else
	begin
		C.L := 0;
	end;
end;
{$ENDIF}

function GetLength(const P: TPoint; const R: TRect): SG;
var
	RP: TPoint;
begin
	RP := CenterOfRect(R);
	Result := Sqr(RP.x - P.x) + Sqr(RP.y - P.y);
end;

procedure DoWork(const Project: TProject; Preview: BG);
const
	AverageWindowSize = 64;
var
	SepX, SepY: TRangeArray;
	x, y: SG;
	MyCommand: TMyCommand;
	Partable: BG;
	Group: TRect;
	{ BmpS, } BmpD: TDBitmap;
	Len: TArrayOfSG;
	i: SG;
	RenderOrder: TRenderOrder;
begin
	if Project.Bitmap.Width = 0 then
		Exit;
{$IFDEF RealMotionBlur}
	Project.GraphicObjectsToVectors(Project.GetMarginSize, Project.BmpS.Width / Project.Bitmap.Width);
{$ENDIF}

	// BmpS := Project.BmpS;
	Group := Project.RenderGroup;
	// fMain.OpenedFiles.Lock(Project); TODO

	BmpD := Project.RenderedImage;
	// ResizeGroup(BmpS, BmpD);
	Group := BmpD.GetFullRect;
{$IFDEF RealMotionBlur}
	Project.BlurArray := TBlurArray.Create;
	Project.BlurArray.SetSize((Group.Right - Group.Left + 1), (Group.Bottom - Group.Top + 1));

	Partable := True;
{$ELSE}
	if (fFunctions.PageControl1.ActivePage = fFunctions.TabSheetColors) or
		(fFunctions.PageControl1.ActivePage = fFunctions.TabSheetBW) then
		Clrs
	else if fFunctions.PageControl1.ActivePage = fFunctions.TabSheetGenRGB then
		GnRGB
	else if (fFunctions.PageControl1.ActivePage = fFunctions.TabSheetGBlur) then
	begin
		BlurInteractions := fFunctions.ComboBoxBlurRadius.RoundedValue;
		BlurRadius := fFunctions.ComboBoxBlurRadius.Value;
		BlurIntensity := fFunctions.ComboBoxIntensity.Value;
		BlurDirection := AngleCount * fFunctions.ComboBoxAngle.Value / 360;
	end;

	Partable := not((fFunctions.PageControl1.ActivePage = fFunctions.TabSheetBorder) or
			(fFunctions.PageControl1.ActivePage = fFunctions.TabSheetGenRGB) or
			(fFunctions.PageControl1.ActivePage = fFunctions.TabSheetLens) or
			(fFunctions.PageControl1.ActivePage = fFunctions.TabSheetResize) or
		// TODO : Implement multi thread and remove
			(fFunctions.PageControl1.ActivePage = fFunctions.TabSheetBmp) or
		// TODO : Implement multi thread and remove
			(fFunctions.PageControl1.ActivePage = fFunctions.TabSheetMirror) or
			(fFunctions.PageControl1.ActivePage = fFunctions.TabSheetRotate));
{$ENDIF}
	if not Preview then
		RenderOrder := TRenderOrder(ApplicationParams[asRenderOrder].Num)
	else
		RenderOrder := roWindowsFromSelection;

	if (RenderOrder = roFullProcessing) or (not Partable) then
	begin
		SetLength(SepX, 1);
		SepX[0].F := Group.Left;
		SepX[0].T := Group.Right;
		SetLength(SepY, 1);
		SepY[0].F := Group.Top;
		SepY[0].T := Group.Bottom;
	end
	else
	begin
		case RenderOrder of
		roWindows, roRandomWindows, roWindowsFromCenter, roWindowsFromSelection:
			begin
				Separators(Group.Left, Group.Right, RoundDiv((Group.Right - Group.Left + 1),
						AverageWindowSize), SepX);
				Separators(Group.Top, Group.Bottom, RoundDiv((Group.Bottom - Group.Top + 1),
						AverageWindowSize), SepY);
			end;
		roLinesDown:
			begin
				SetLength(SepX, 1);
				SepX[0].F := Group.Left;
				SepX[0].T := Group.Right;
				Separators(Group.Top, Group.Bottom, RoundDiv((Group.Right - Group.Left + 1) *
							(Group.Bottom - Group.Top + 1), 2 * Sqr(AverageWindowSize)), SepY);
			end;
		end;
	end;
	Project.StartTime := PerformanceCounter;
	Project.Done := 0;
	Project.MaxDone := MaxDone * Length(SepX) * Length(SepY); { * (Group.Bottom - Group.Top + 1) }
	GetGTime;
	LastTime := GTime;
	UpdateStatus(0);
	UpdateMaximum(Project.MaxDone);

	if not Preview then
		case RenderOrder of
		roWindowsFromCenter:
			Project.PreviewPoint := CenterOfRect(Group);
		roWindowsFromSelection:
			Project.PreviewPoint := CenterOfRect(Project.Group);
		end;

	if RenderOrder in [roWindowsFromCenter, roWindowsFromSelection] then
	begin
		SetLength(Len, Length(SepX) * Length(SepY));
	end;
	i := 0;
	Project.CommandRunCount := 0;
	for y := 0 to Length(SepY) - 1 do
		for x := 0 to Length(SepX) - 1 do
		begin
			Inc(Project.CommandRunCount);

			MyCommand := TMyCommand.Create;
			// MyCommand.GraphicFunction := gfBar;
			MyCommand.Project := Project;
			MyCommand.Range := Rect(SepX[x].F, SepY[y].F, SepX[x].T, SepY[y].T);
			if RenderOrder in [roWindowsFromCenter, roWindowsFromSelection] then
			begin
				Len[i] := GetLength(Project.PreviewPoint, MyCommand.Range);
				Inc(i);
			end;
			{ MyCommand.Project := @Project;
				MyCommand.BmpS := BmpS;
				MyCommand.BmpD := BmpD; }
			// MyCommand.Execute;
			// MyCommands[i] := MyCommand;
			ThreadPool.AddCommand(MyCommand);
			(*
				{$IFOPT d-}
				ProcessThread.Start;
				{$ELSE}
				ProcessThread.Start;
				//ProcessThread.Execute;
				{$ENDIF}
				*)
		end;
	if RenderOrder in [roWindowsFromCenter, roWindowsFromSelection] then
	begin
		ThreadPool.SortCommands(Len);
	end
	else if RenderOrder = roRandomWindows then
	begin
		ThreadPool.RandomizeCommands;
	end;
end;

procedure DoPreview(const PreviewPoint: TPoint);
begin
	if fMain.RealTimePreview1.Checked then
	begin
		StopAndWait;

		Project.PreviewDone := False;

		Project.BmpS := Project.SourceImage;
//		Project.BmpS := fMain.ImageP.SmallerBitmap;
		Project.RenderGroup := Project.BmpS.GetFullRect; // Project.Bitmap.GetFullRect;

		Project.PreviewPoint := PreviewPoint;
		DoWork(Project, True);
	end;
end;

procedure DoPreview;
begin
	if Project <> nil then
		DoPreview(CenterOfRect(Project.Group));
end;

procedure Process(const Project: TProject; const FileName: TFileName);
begin
	TerminateThreads := False;
{$IFNDEF RealMotionBlur}
	if (fFunctions.PageControl1.ActivePage = fFunctions.TabSheetBmp) then
	begin
		if fFunctions.ComboBoxFromBitmap.ItemIndex <> -1 then
		begin
			if fFunctions.ComboBoxFromBitmap.ItemIndex <> fMain.OpenedFiles.Index then
			begin
				K2 := fMain.OpenedFiles.GetItemData(fFunctions.ComboBoxFromBitmap.ItemIndex);
			end
			else
				K2 := @Project;
		end
		else
			Exit;
	end;
{$ENDIF}
	BeginLongOperation(True);
	ShowStatusWindow(ThreadPool, fMain.Status1);
{$IFDEF RealMotionBlur}
	Project.BmpS := Project.SourceImage;
{$ELSE}
	fMain.CreateUndo(fFunctions.PageControl1.ActivePage.Caption, TMyBitmapUndo);
	Project.BmpS := Project.Bitmap;
{$ENDIF}
{$IFDEF RealMotionBlur}
	Project.RenderGroup := Project.BmpS.GetFullRect;
{$ELSE}
	Project.RenderGroup := Project.Group;
{$ENDIF}
	Project.RenderFileName := FileName;
	DoWork(Project, False);

	fMain.InitMenu;
end;

{ TMyCommand }

destructor TMyCommand.Destroy;
{$IFDEF RealMotionBlur}
var
	BmpDB: TDBitmap;
{$ENDIF}
begin
	if Project.CommandRunCount = 1 then
	begin
		if TerminateThreads = False then
		begin
			Project.PreviewDone := True;
			// Last Thread Finished
			Project.OperationTime := IntervalFrom(Project.StartTime);
			Project.Done := Project.MaxDone;
			UpdateStatus(Project.Done);
			// fMain.UpdateImage;
{$IFDEF RealMotionBlur}
			if Project.RenderFileName <> '' then
			begin
				PlaySound(2);
				CreateDirEx(ExtractFilePath(Project.RenderFileName));
				Project.RenderedImage.SaveToFile(Project.RenderFileName);
				if AOpen then
				begin
					if ApplicationParams[asOpenRenderOutput].Bool then
					begin
						APIOpen(Project.RenderFileName);
					end;
				end
				else
				begin
					// FreeAndNil(Project.BmpD);
				end;
			end;

			if ApplicationParams[asSaveDirectionalImage].Bool then
			begin
				BmpDB := TDBitmap.Create;
				try
					BmpDB.SetSize(Project.RenderedImage.Width, Project.RenderedImage.Height);
					SaveDirectionBitmap(Project.BlurArray, Project.RenderedImage.GetFullRect, BmpDB);
					BmpDB.SaveToFile(DelFileExt(Project.RenderFileName) + '_db.png');
				finally
					BmpDB.Free;
				end;
			end;

			Project.RenderedImage.Resize(Project.OriginalX, Project.OriginalY);
{$ENDIF}
		end;
		FreeAndNil(Project.BlurArray);
		Project.BlurArray := nil;
{$IFDEF RealMotionBlur}
		SetLength(Project.RenderVectors, 0);
{$ENDIF}
		if AOpen then
		begin
			EndLongOperation(True);
			HideStatusWindow;
		end;
		// fMain.OpenedFiles.Unlock(@Project); TODO
		Dec(Project.CommandRunCount);
		fMain.InitMenu;
	end
	else
	begin
		Dec(Project.CommandRunCount);
	end;
	if Project.Layers[ilPreview] then
		DelayedCall(0);
end;

procedure TMyCommand.Execute;
var
	i: SG;
	BmpS, BmpD: TDBitmap;
begin
	LastDone := 0;
	BmpS := Project.BmpS;
	BmpD := Project.RenderedImage;
{$IFDEF RealMotionBlur}
	RealMotionBlur(BmpD, BmpS, Project.BlurArray, Range, Project.RenderVectors,
		Project.Params[psSpeedCoefficient].Float, TQuality(ApplicationParams[asRenderingQuality].Num),
		InterruptProcedure);
	Exit;
{$ENDIF}
	if fFunctions.PageControl1.ActivePage = fFunctions.TabSheetResize then
	begin
		BmpD.Resize(NewSX, NewSY, BmpS, InterruptProcedure);
	end
	else if fFunctions.PageControl1.ActivePage = fFunctions.TabSheetRotate then
	begin
		i := fFunctions.ComboBoxRotateStyle.ItemIndex;
		if i < 0 then
			i := 0;
		RotateDef(BmpD, BmpS, i, fFunctions.TrackBarRotate.Position, ef16);
	end
	else if (fFunctions.PageControl1.ActivePage = fFunctions.TabSheetColors) or
		(fFunctions.PageControl1.ActivePage = fFunctions.TabSheetBW) then
	begin
		BmpD.Colors(BmpS, Range, fFunctions.Brig, fFunctions.Cont, fFunctions.Gamma,
			fFunctions.ComboBoxBW.RoundedValue, fFunctions.ColorR, fFunctions.ColorG, fFunctions.ColorB,
			InterruptProcedure);
	end
	else if fFunctions.PageControl1.ActivePage = fFunctions.TabSheetGenRGB then
	begin
		BmpD.GenerateRGBEx(Range, TGenFunc(fFunctions.ComboBoxFunction.ItemIndex), AC, TEffect
				(fFunctions.ComboBoxApply.ItemIndex), 0, InterruptProcedure);
	end
	else if fFunctions.PageControl1.ActivePage = fFunctions.TabSheetRandom then
	begin
		BmpD.Rand(fFunctions.PanelRC.Color, Range);
	end
	else if fFunctions.PageControl1.ActivePage = fFunctions.TabSheetBorder then
	begin
		BmpD.Border(Range, clWhite, clBlack, fFunctions.TrackBarBorder.Position, TEffect
				(fFunctions.ComboBoxEffect.ItemIndex));
	end
	else if fFunctions.PageControl1.ActivePage = fFunctions.TabSheetBar then
	begin
		BmpD.Bar(Range, fFunctions.PanelBarColor.Color, TEffect(fFunctions.ComboBoxBarEffect.ItemIndex)
			);
	end
	else if (fFunctions.PageControl1.ActivePage = fFunctions.TabSheetGBlur) then
	begin
		if fFunctions.ComboBoxBlurAlgorithm.ItemIndex = 0 then
		begin
			BmpD.BoxBlur(BmpS, Range, BlurInteractions, fFunctions.ComboBoxBlurDirection.ItemIndex <> 1,
				fFunctions.ComboBoxBlurDirection.ItemIndex > 0, InterruptProcedure);
		end
		else if fFunctions.ComboBoxBlurAlgorithm.ItemIndex <= 2 then
			BmpS.GBlurTo(BmpD, Range, BlurRadius, fFunctions.ComboBoxBlurDirection.ItemIndex <> 1,
				fFunctions.ComboBoxBlurDirection.ItemIndex > 0, InterruptProcedure,
				fFunctions.ComboBoxBlurAlgorithm.ItemIndex = 2)
		else if fFunctions.ComboBoxBlurAlgorithm.ItemIndex = 3 then
		begin
			BmpD.DirectionalBlur(BmpS, Range, TQuality(ApplicationParams[asRenderingQuality].Num),
				BlurDirection, BlurIntensity, InterruptProcedure);
		end;
	end
	else if fFunctions.PageControl1.ActivePage = fFunctions.TabSheetBmp then
	begin
		BmpD.Bmp(Range.Left, Range.Top, K2.Bitmap, K2.Group.Left, K2.Group.Top, K2.Group.Right,
			K2.Group.Bottom, TEffect(fFunctions.ComboBoxBmpEffect.ItemIndex))
	end
	else if fFunctions.PageControl1.ActivePage = fFunctions.TabSheetChangeColor then
	begin
		BmpD.ChangeColor(Range, fFunctions.PanelFrom.Color, fFunctions.PanelTo.Color);
	end
	else if fFunctions.PageControl1.ActivePage = fFunctions.TabSheetMirror then
	begin
		BmpD.Bmp(0, 0, BmpS, ef16);
		{ BmpD.Bmp(BmpS.Width, 0, BmpS, ef16);
			BmpD.Bmp(0, BmpS.Height, BmpS, ef16);
			BmpD.Bmp(BmpS.Width, BmpS.Height, BmpS, ef16); }
		if fFunctions.ButtonMH.Down then
			RotateDef(BmpD, BmpS.Width + BmpS.Width div 2, BmpS.Height div 2, BmpS, 0, 0, BmpS.Width - 1,
				BmpS.Height - 1, 8, AngleCount div 2, ef16);
		if fFunctions.ButtonMV.Down then
			RotateDef(BmpD, BmpS.Width div 2, BmpS.Height + BmpS.Height div 2, BmpS, 0, 0,
				BmpS.Width - 1, BmpS.Height - 1, 14, AngleCount div 2, ef16);
		if fFunctions.ButtonMH.Down and fFunctions.ButtonMV.Down then
			RotateDef(BmpD, BmpS.Width + BmpS.Width div 2, BmpS.Height + BmpS.Height div 2, BmpS, 0, 0,
				BmpS.Width - 1, BmpS.Height - 1, 11, AngleCount div 2, ef16);
		{ RotateDef(BmpD, BmpS.Width, BmpS.Height, BmpS, 0, 0, BmpS.Width - 1, BmpS.Height - 1,
			8, AngleCount div 2, ef16); }
		{ RotateBmp(BmpD, BmpS.Width, BmpS.Height, BmpS, 0, 0, BmpS.Width - 1, BmpS.Height - 1,
			AngleCount div 4, 0, 0, AngleCount div 4, ef16); }
	end
	else if fFunctions.PageControl1.ActivePage = fFunctions.TabSheetLens then
	begin
		BmpD.Lens(BmpS, Range.Left, Range.Top, Range.Right, Range.Bottom,
			fFunctions.ComboBoxMinZoom.RoundedValue, fFunctions.ComboBoxMaxZoom.RoundedValue);
	end;
end;

end.
