// * File:     CopyMoreFiles\uMain.pas
// * Created:  2010-08-28
// * Modified: 2010-10-17
// * Version:  1.1.47.26
// * Author:   David Safranek (Safrad)
// * E-Mail:   safrad at email.cz
// * Web:      http://safrad.own.cz

unit uMain;

interface

uses
	uTypes, uDForm,
	Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
	Dialogs, StdCtrls, ExtCtrls, uSxPathEdit, Menus, uDButton, uDMemo;

type
	TfMain = class(TDForm)
		MemoFiles: TDMemo;
		btnCopy: TDButton;
		LabelFiles: TLabel;
		pedSourcePath: TSxPathEdit;
		lblSourcePath: TLabel;
		lblTargetPath: TLabel;
		pedTargetPath: TSxPathEdit;
		btnSwap: TDButton;
		MainMenu1: TMainMenu;
		File1: TMenuItem;
		Options1: TMenuItem;
		Help1: TMenuItem;
		OpenSource1: TMenuItem;
		OpenTarget1: TMenuItem;
		procedure btnCopyClick(Sender: TObject);
		procedure FormDestroy(Sender: TObject);
		procedure btnSwapClick(Sender: TObject);
		procedure pedSTChange(Sender: TObject);
		procedure OpenSource1Click(Sender: TObject);
		procedure OpenTarget1Click(Sender: TObject);
		procedure FormCreate(Sender: TObject);
		procedure FormResize(Sender: TObject);
		procedure FormShow(Sender: TObject);
	private
		{ Private declarations }
		SourceDir, TargetDir: string;
		function Check(const SourceDir: string): BG;
		procedure RWOptions(const Save: BG);
		procedure SetEnabledFor(const Value: BG);
	public
		{ Public declarations }
	end;

var
	fMain: TfMain;

implementation

{$R *.dfm}

uses uStrings, uFiles, uMsgDlg, uDIniFile, uMsg, uSystem, uOutputFormat, uAPI;

procedure TfMain.btnCopyClick(Sender: TObject);
var
	i: Integer;
	Path: string;
	Line: string;
	FileCount: SG;
begin
	SourceDir := ExpandDir(pedSourcePath.Path);
	TargetDir := ExpandDir(pedTargetPath.Path);

	BeginLongOperation;
	SetEnabledFor(False);
	try
		// Remove prefix (Absolute to Relative)
		for i := 0 to MemoFiles.Lines.Count - 1 do
		begin
			Line :=  MemoFiles.Lines[i];
			if StartStr(SourceDir, Line) then
			begin
				Delete(Line, 1, Length(SourceDir));
				MemoFiles.Lines[i] := Line;
			end;
		end;
		if not Check(SourceDir) then Exit;
		CreateDir(TargetDir);
		pedTargetPath.Changed;
		FileCount := 0;
		for i := 0 to MemoFiles.Lines.Count - 1 do
		begin
			Path := ReadToChar(ReplaceF(MemoFiles.Lines[i], '/', '\'), CharTab);
			if FileExists(SourceDir + Path) then
			begin
				CreateDirsEx(ExtractFilePath(TargetDir + Path));
				if CopyFile(SourceDir + Path, TargetDir + Path, False) then
					Inc(FileCount);
			end;
		end;
		MessageD('%1 file(s) copied.', [NToS(FileCount)], mlInformation, [mbOk]);
		if FileCount < MemoFiles.Lines.Count then
			MessageD('%1 file(s) NOT copied.', [NToS(MemoFiles.Lines.Count - FileCount)], mlWarning, [mbOk]);
	finally
		SetEnabledFor(True);
		EndLongOperation;
	end;
end;

function TfMain.Check(const SourceDir: string): BG;
var
	i: Integer;
	Line: string;
begin
	Result := True;
	Line := UpperCase(MemoFiles.Lines[0]);
	if (Line = 'PATH'){TortoiseSVN} or (Line = 'FILES') then
	begin
		if MessageD('First line contain suspicious text %1.' + LineSep + 'Do you want to remove it?', [MemoFiles.Lines[0]], mlWarning, [mbYes, mbNo]) = mbYes then
			MemoFiles.Lines.Delete(0);
	end;

	i := 0;
	while i < MemoFiles.Lines.Count do
	begin
		Line := MemoFiles.Lines[i];
		if Line = '' then
		begin
			MemoFiles.Lines.Delete(i);
			Continue;
		end;
		if not FileExistsEx(SourceDir + Line) then
		begin
			if MessageD('File %1 do not exists!' + LineSep + 'Continue?', [MemoFiles.Lines[i]], mlError, [mbYes, mbNo]) <> mbYes then
			begin
				Result := False;
				Exit;
			end;
		end;
		Inc(i);
	end;
end;

procedure TfMain.FormDestroy(Sender: TObject);
begin
	RWOptions(True);
end;

procedure TfMain.RWOptions(const Save: BG);
const
	Section = 'Options';
var
	s: string;
begin
	if Save = False then s := '' else s := pedSourcePath.Path;
	MainIni.RWString(Section, 'SourcePath', s, Save);
	if Save = False then pedSourcePath.Path := s;

	if Save = False then s := '' else s := pedTargetPath.Path;
	MainIni.RWString(Section, 'TargetPath', s, Save);
	if Save = False then pedTargetPath.Path := s;

	if Save = False then s := '' else s := MemoFiles.Lines.Text;
	MainIni.RWMultilineString(Section, 'RelativeFileNames', s, Save);
	if Save = False then MemoFiles.Lines.Text := s;

	MainIni.RWFormPos(Self, Save);
end;

procedure TfMain.btnSwapClick(Sender: TObject);
var
	Path: string;
begin
	Path := pedSourcePath.Path;
	pedSourcePath.Path := pedTargetPath.Path;
	pedTargetPath.Path := Path;
end;

procedure TfMain.pedSTChange(Sender: TObject);
begin
	btnCopy.Enabled := pedSourcePath.IsCorrect {and pedTarget.IsCorrect} and (MemoFiles.Lines.Count > 0);
	OpenSource1.Enabled := pedSourcePath.IsCorrect;
	OpenTarget1.Enabled := pedTargetPath.IsCorrect;
end;

procedure SetComponentEnabled(const AComponent: TComponent; const Value: BG);
var
	i: SG;
	Component: TComponent;
begin
	for i := 0 to AComponent.ComponentCount - 1 do
	begin
		Component := AComponent.Components[i];
		if Component is TControl then
			TControl(Component).Enabled := Value
		else if Component is TComponent then
			SetComponentEnabled(TComponent(Component), Value);
	end;
end;

procedure TfMain.SetEnabledFor(const Value: BG);
begin
	SetComponentEnabled(Self, Value);
end;

procedure TfMain.OpenSource1Click(Sender: TObject);
begin
	APIOpen(pedSourcePath.Path);
end;

procedure TfMain.OpenTarget1Click(Sender: TObject);
begin
	APIOpen(pedTargetPath.Path);
end;

procedure TfMain.FormCreate(Sender: TObject);
begin
	RWOptions(False);
end;

procedure TfMain.FormResize(Sender: TObject);
begin
	AlignControlRight(pedSourcePath);
//	AlignControl(btnSwap, [akTop, akRight]);
	btnSwap.Left := ClientWidth - btnSwap.Width - FormBorder;
	AlignControlRight(pedTargetPath);
	AlignControlRightTop(MemoFiles);
//	AlignControlRightTop(btnCopy);
	btnCopy.Left := ClientWidth - btnCopy.Width - FormBorder;
	btnCopy.Top := ClientHeight - btnCopy.Height - FormBorder;
	MemoFiles.Height := btnCopy.Top - MemoFiles.Top - FormBorder;
end;

procedure TfMain.FormShow(Sender: TObject);
begin
	FocusControl(btnCopy);
end;

end.
