// * File:     CmdCalc\uChart.pas
// * Created:  2001-08-01
// * Modified: 2009-11-05
// * Version:  1.3.47.75
// * Author:   David Safranek (Safrad)
// * E-Mail:   safrad at email.cz
// * Web:      http://safrad.own.cz

unit uChart;

interface

uses
	Series,
	uDForm, uTypes,
	Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
	Menus, ExtCtrls, TeeProcs, TeEngine, Chart, TeeFunci;

type
	TfChart = class(TDForm)
		Chart: TChart;
		Series1: TFastLineSeries;
		procedure FormCreate(Sender: TObject);
		procedure FormShow(Sender: TObject);
		procedure FormHide(Sender: TObject);
		procedure FormResize(Sender: TObject);
	private
		{ Private declarations }
		ASeries: TFastLineSeries;
	public
		{ Public declarations }
		procedure Draw;
	end;

var
	fChart: TfChart;

implementation

{$R *.dfm}
uses
	Math,
	uDChart, uOutputFormat, uMath, uStrings,
	uDIniFile, uDParser, uMathFunctions, uVector, uMain;

procedure TfChart.FormCreate(Sender: TObject);
begin
	Background := baNone;
	MainIni.RWFormPos(Self, False);
	ASeries := Chart.Series[0] as TFastLineSeries;
	HTMLStyle(Chart);
end;

procedure TfChart.FormShow(Sender: TObject);
begin
	fMain.Chart1.Checked := True;
end;

procedure TfChart.FormHide(Sender: TObject);
begin
	fMain.Chart1.Checked := False;
	MainIni.RWFormPos(Self, True);
end;

procedure TfChart.FormResize(Sender: TObject);
begin
	Draw;
end;

procedure TfChart.Draw;
var
	i: SG;
	V: TVector;
	Res, LRes, MinVal, MaxVal: FG;
	Inp: SG;
	LastSkipped: BG;
begin
	Caption := 'Chart ' + NToS(ClientWidth) + CharTimes + NToS(ClientHeight);
	Chart.LeftAxis.Title.Caption := fMain.Input.Text;

	MinVal := Infinity;
	MaxVal := NegInfinity;
	try
		ASeries.Clear;
{		VF := IsVarFunc('x', 0, UnitSystem);
		if VF <> nil then
		begin}
		LRes := Infinity;
		Res := Infinity;
		Inp := 0;
		LastSkipped := False;
		for i := 0 to ClientWidth - 1 do
		begin
			Inp := i - ClientWidth div 2;
			VariableX := NumToVector(Inp);
			try
				Res := Infinity;
				V := CalcTree;
				if Length(V) > 0 then
					Res := V[0]
				else
					Res := 0;
				if Res > MaxVal then MaxVal := Res;
				if Res < MinVal then MinVal := Res;
				if Res <> LRes then
				begin
					if LastSkipped then
						ASeries.AddXY(Inp - 1, LRes);
					ASeries.AddXY(Inp, Res);
					LRes := Res;
					LastSkipped := False;
				end
				else
					LastSkipped := True;
			except

			end;
		end;
		if Res = LRes then
		begin
			ASeries.AddXY(Inp, Res);
		end;
//			ASeries.AddXY(VF.Value, Res + 1);
//		end;
	finally
		if (MinVal = Infinity) or (MaxVal = Infinity) or (MinVal = NegInfinity) or (MaxVal = NegInfinity) then
		begin
			MinVal := -1;
			MaxVal := 1;
		end
		else if MinVal >= MaxVal then
		begin
			if MaxVal > 0 then
				MaxVal := MaxVal * 2
			else
				MaxVal := MaxVal / 2;
			if MinVal > 0 then
				MinVal := MinVal / 2
			else
				MinVal := MinVal * 2;
		end;
		Chart.LeftAxis.Maximum := Infinity; // Chart bug (cannot set minimum > maximum)
		Chart.LeftAxis.Minimum := MinVal; //Range(-999, MinVal, 999);
		Chart.LeftAxis.Maximum := MaxVal; // Max(Chart.LeftAxis.Minimum, Min(999, MaxVal));
	end;
end;

end.
