// * File:     CmdCalc\uCalcTest.pas
// * Created:  2009-08-08
// * Modified: 2009-09-10
// * Version:  1.3.47.75
// * Author:   David Safranek (Safrad)
// * E-Mail:   safrad at email.cz
// * Web:      http://safrad.own.cz

unit uCalcTest;

interface

procedure CalcTest;

implementation

uses
	SysUtils,
	uCalc,
	uTypes, uFiles, uCSVFile, uVector, uInputFormat, uOutputFormat, uMsg;

procedure CalcTest;
var
	CSVFile: TCSVFile;
	Line: TArrayOfString;
	Vector: TVector;
	Res: string;
	FailCount{, PassCount}: UG;
	Output: TOutput;
begin
	FailCount := 0;
//	PassCount := 0;
	Output.OutputType := otNumber;
	Output.Base := 10;
	Output.Precision := -1;
	Output.OutputFormat := ofIO;

	CSVFile := TCSVFile.Create(3);
	try
		if CSVFile.Open(WorkDir + '_Tests.csv') then
		begin
			while not CSVFile.EOF do
			begin
				Line := CSVFile.ReadLine;
				Vector := CalcCore(Line[0], False);
				Res := OutputToStr(Vector, Output);
				if Line[1] <> Res then
				begin
					Warning('Failed expression %1=%2 (should be %3).', [Line[0], Res, Line[1]]);
					Inc(FailCount);
					Continue;
				end;
				if StrToValI(Line[2], False, 0, 0, MaxInt, 1) <> ParserMessages.Count then
				begin
					Inc(FailCount);
					Continue;
				end;
//				Inc(PassCount);
			end;
		end;
		CSVFile.Close;
	finally
		FreeAndNil(CSVFile);
	end;
	if FailCount <> 0 then
		Warning('Fail %1 calc tests.', [NToS(FailCount)]);
end;

end.
