// * File:     CmdCalc\uMain.pas
// * Created:  2001-08-01
// * Modified: 2010-11-13
// * Version:  1.3.47.75
// * Author:   David Safranek (Safrad)
// * E-Mail:   safrad at email.cz
// * Web:      http://safrad.own.cz

unit uMain;

interface

uses
	uTypes, uVector, uParserMsg,
	uCalc, uFunctions, ufTableForm,
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
	StdCtrls, ExtCtrls, uDButton, uDImage, Menus, uDForm, uDEdit, uDWinControl,
	ComCtrls, uDTimer, ActnList, uDMemo;

type
	PBracket = ^TBracket;

	TBracket = record
		PosOpen: SG;
		PosClose: SG;
		Color: TColor;
	end;

	TfMain = class(TDForm)
		EditErrors: TDMemo;
		EditResult: TDMemo;
		MainMenu1: TMainMenu;
		File1: TMenuItem;
		Help1: TMenuItem;
		CopyResult1: TMenuItem;
		Paste1: TMenuItem;
		Bevel1: TBevel;
		PopupMenuInput: TPopupMenu;
		ResultToInput1: TMenuItem;
		Hex2: TMenuItem;
		Dec2: TMenuItem;
		Oct2: TMenuItem;
		Bin2: TMenuItem;
		Rad1: TMenuItem;
		Grad1: TMenuItem;
		Deg1: TMenuItem;
		Input: TRichEdit;
		Chart1: TMenuItem;
		Cycle1: TMenuItem;
		EditStatus: TDEdit;
		Custom1: TMenuItem;
		UseWindowsFormat1: TMenuItem;
		N11: TMenuItem;
		UseThousandSeparator1: TMenuItem;
		N12: TMenuItem;
		AddToFavorites1: TMenuItem;
		OrganizeFavorites1: TMenuItem;
		CzText1: TMenuItem;
		EnText1: TMenuItem;
		FrText1: TMenuItem;
		N1: TMenuItem;
		Precision1: TMenuItem;
		Single32bit1: TMenuItem;
		Double64bit1: TMenuItem;
		Extended80bit1: TMenuItem;
		Options1: TMenuItem;
		RomanNumerals1: TMenuItem;
		ViewFunctions1: TMenuItem;
		N2: TMenuItem;
		Undo1: TMenuItem;
		Redo1: TMenuItem;
		SyntaxHighlight1: TMenuItem;
		ChangePrecision1: TMenuItem;
		Input1: TMenuItem;
		Result1: TMenuItem;
		Common1: TMenuItem;
		N3: TMenuItem;
		N4: TMenuItem;
		Copy2: TMenuItem;
		PopupMenuResult: TPopupMenu;
		CopyChart1: TMenuItem;
		AvailableFunctionList1: TMenuItem;
		PanelTool: TPanel;
		ActionList1: TActionList;
		ActionUndo: TAction;
		ActionRedo: TAction;
		N5: TMenuItem;
		HighlightBrackets1: TMenuItem;
		Time1: TMenuItem;
		Normal1: TMenuItem;
		XTimeFormat1: TMenuItem;
		ext1: TMenuItem;
		TextLanguage1: TMenuItem;
		SS1: TMenuItem;
		MMSS1: TMenuItem;
		HHMMSS1: TMenuItem;
		DaysHHMMSS1: TMenuItem;
		Base1: TMenuItem;
		HMMSS1: TMenuItem;
		ViewErrors1: TMenuItem;
		ViewStatus1: TMenuItem;
		procedure FormCreate(Sender: TObject);
		procedure InputChange(Sender: TObject);
		procedure FormResize(Sender: TObject);
		procedure CopyResult1Click(Sender: TObject);
		procedure Paste1Click(Sender: TObject);
		procedure FormDestroy(Sender: TObject);
		procedure CurBase1Click(Sender: TObject);
		procedure ResultToInput1Click(Sender: TObject);
		procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
		procedure Rad1Click(Sender: TObject);
		procedure Chart1Click(Sender: TObject);
		procedure Custom1Click(Sender: TObject);
		procedure UseWindowsFormat1Click(Sender: TObject);
		procedure UseThousandSeparator1Click(Sender: TObject);
		procedure AddToFavorites1Click(Sender: TObject);
		procedure LanguageText1Click(Sender: TObject);
		procedure PopupMenuInputPopup(Sender: TObject);
		procedure Extended80bit1Click(Sender: TObject);
		procedure ViewFunctions1Click(Sender: TObject);
		procedure SyntaxHighlight1Click(Sender: TObject);
		procedure ChangePrecision1Click(Sender: TObject);
		procedure Copy2Click(Sender: TObject);
		procedure PopupMenuResultPopup(Sender: TObject);
		procedure CopyChart1Click(Sender: TObject);
		procedure OrganizeFavorites1Click(Sender: TObject);
		procedure InputKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
		procedure AvailableFunctionList1Click(Sender: TObject);
		procedure PanelToolResize(Sender: TObject);
		procedure ActionUndoRedoExecute(Sender: TObject);
		procedure HighlightBrackets1Click(Sender: TObject);
		procedure Time1Click(Sender: TObject);
		procedure Normal1Click(Sender: TObject);
		procedure SS1Click(Sender: TObject);
		procedure FormShow(Sender: TObject);
		procedure ViewErrors1Click(Sender: TObject);
		procedure ViewStatus1Click(Sender: TObject);
	private
		{ Private declarations }
		Output: TOutput;
		CurrentValue: TVector;

		UndoIndex: SG;
		UndoCount: SG;
		Undos: array of string;

		fTableForm: TfTableForm;
		fAvailableFunctions: TfFunctions;

		procedure CreateBracketGroups(out Brackets: array of TBracket);
		procedure RWOptions(const Save: Boolean);
		// procedure MenuItemClick(Sender: TObject);
		procedure InitMenu;
		procedure InitUndoRedo;
		procedure ResetStyle;
		procedure UnResetStyle;
		procedure HighlightErrors(const InputStr: string);
		procedure DrawOutput;
		procedure Calc;

		procedure UseFavorite(RowIndex: SG);
		procedure AppendFavorite(RowIndex: SG);
		procedure HighlightBrackets;
		procedure Highlight;

		procedure FavoritesHide(Sender: TObject);
	public
		{ Public declarations }
		DeleteIndex: SG;
		DeleteLength: SG;
		// procedure InitFavorites;
		// procedure SetFavorite(i: SG; Append: BG);
	end;

var
	fMain: TfMain;

implementation

{$R *.DFM}

uses
	ClipBrd, Math, RichEdit,
	uFiles, uAbout, uDIniFile, uDBitmap, uGraph, uMenus, uStrings, uColor, uCharTable,
	uInputFormat, uOutputFormat, uDParser, uGoniometricFunctions, uGetInt, uGetStr, uData, uMath,
	uSystem, uMsg, uNamespace, uEscape, uParamDataModel, uStack, uDictionary,
	uChart, uFavorites, uHashTable {$IFOPT d+}, uCalcTest {$ENDIF};

{ TfMain }

procedure TfMain.RWOptions(const Save: Boolean);
var
	Section: string;
	s: string;
begin
	MainIni.RWFormPos(Self, Save);

	Section := 'Format';

	MainIni.RWEnum(Section, TypeInfo(TOutputType), U1(Output.OutputType), Save);

	if Save = False then
		Output.Base := 10;
	MainIni.RWNum(Section, 'CurrentBase', Output.Base, Save);
	Output.Base := Range(UG(2), Output.Base, MaxNumericBase);

	if Save = False then
		Output.TimeFormat := diHMSD;
	MainIni.RWEnum(Section, TypeInfo(TDisplay), U1(Output.TimeFormat), Save);
	MainIni.RWEnum(Section, TypeInfo(TNumLanguage), U1(Output.Language), Save);

	if Save = False then
		Output.Precision := 2;
	MainIni.RWNumM(Section, Precision1, Output.Precision, Save, True);

	MainIni.RWEnum(Section, TypeInfo(TGoniometricFormat), U1(GoniometricFormat), Save);

	MainIni.RWMenuItem(Section, SyntaxHighlight1, Save);
	MainIni.RWMenuItem(Section, HighlightBrackets1, Save);
	MainIni.RWMenuItem(Section, UseWindowsFormat1, Save);
	MainIni.RWMenuItem(Section, UseThousandSeparator1, Save);

	Section := 'View';
	MainIni.RWMenuItem(Section, Chart1, Save);
	MainIni.RWMenuItem(Section, OrganizeFavorites1, Save);
	MainIni.RWMenuItem(Section, ViewFunctions1, Save);
	MainIni.RWMenuItem(Section, ViewErrors1, Save);
	MainIni.RWMenuItem(Section, ViewStatus1, Save);

	Favorites.Serialize(MainIni, 'Favorites', Save);

	s := Input.Text;
	MainIni.RWMultilineString('Options', 'Input', s, Save);
	if Save = False then
	begin
		Input.Text := s;
		Input.SelStart := Input.GetTextLen;
	end;
end;

procedure TfMain.InitMenu;
var
	i: SG;
begin
	i := Normal1.MenuIndex;
	while i < Result1.Count do
	begin
		if (Result1.Items[i].Tag = SG(Output.OutputType)) then
		begin
			Result1.Items[i].Checked := True;
			Break;
		end;
		Inc(i);
	end;

	i := Bin2.MenuIndex;
	while i < Base1.Count do
	begin
		if (Base1.Items[i].Tag = Output.Base) { or (i >= Bin2.MenuIndex + 4) } then
		begin
			Base1.Items[i].Checked := True;
			Break;
		end;
		Inc(i);
	end;

	i := SS1.MenuIndex;
	while i < XTimeFormat1.Count do
	begin
		if (XTimeFormat1.Items[i].MenuIndex = SG(Output.TimeFormat)) then
		begin
			XTimeFormat1.Items[i].Checked := True;
			Break;
		end;
		Inc(i);
	end;

	i := EnText1.MenuIndex;
	while i < TextLanguage1.Count do
	begin
		if (TextLanguage1.Items[i].Tag = SG(Output.Language)) then
		begin
			TextLanguage1.Items[i].Checked := True;
			Break;
		end;
		Inc(i);
	end;

	Common1.Items[Rad1.MenuIndex + U1(GoniometricFormat)].Checked := True;
	// MenuUpdate(Format1, Format2);
	UpdateIcons(MainMenu1, PanelTool);
end;

procedure TfMain.UseFavorite(RowIndex: SG);
var
	F: PCell;
begin
	F := Favorites.Get(RowIndex);
	Input.Text := F^[SG(foText)].Str;
	Input.SelStart := Input.GetTextLen;
end;

procedure TfMain.AppendFavorite(RowIndex: SG);
var
	F: PCell;
begin
	F := Favorites.Get(RowIndex);
	Input.Text := Input.Text + F^[SG(foText)].Str;
	Input.SelStart := Input.GetTextLen;
end;

procedure TfMain.HighlightBrackets;
var
	Brackets: array of TBracket;
	i: Integer;
begin
	SetLength(Brackets, 1024);
	CreateBracketGroups(Brackets);
	for i := 0 to Length(Brackets) - 1 do
	begin
		if Brackets[i].PosOpen = 0 then
			Continue;
		Input.SelStart := Brackets[i].PosOpen - 1;
		Input.SelLength := 1;
		Input.SelAttributes.Color := Brackets[i].Color;
		Input.SelAttributes.Style := [fsBold];
		if Brackets[i].PosClose = 0 then
			Continue;
		Input.SelStart := Brackets[i].PosClose - 1;
		Input.SelLength := 1;
		Input.SelAttributes.Color := Brackets[i].Color;
		Input.SelAttributes.Style := [fsBold];
	end;
end;

procedure TfMain.FormCreate(Sender: TObject);
// var
// i, j: SG;
// MenuItem, MenuItem2: TMenuItem;
// F: PFunction;
begin
{$IFOPT d-}
	SetExceptionMask([exInvalidOp, exDenormalized, exZeroDivide, exOverflow, exUnderflow, exPrecision]
		);
{$ENDIF}
	if not Assigned(fFunctions) then
		fFunctions := TfFunctions.Create(Self);

	// Input.DoubleBuffered := True;
	Input.OnChange := nil;
	DeleteIndex := -1;
	try
		RWOptions(False);
	finally
		Input.OnChange := InputChange;
	end;
	UndoIndex := 0;
	SetLength(Undos, 1);
	Undos[UndoIndex] := Input.Text;
	UndoCount := 1;

	MenuCreate(Input1, PopupMenuInput);
	MenuSet(PopupMenuInput);
	MenuCreate(Result1, PopupMenuResult);
	MenuSet(PopupMenuResult);
	InitMenu;

	Input.SelectAll;
	if OrganizeFavorites1.Checked then
		OrganizeFavorites1Click(Sender);
	Calc;
	if Chart1.Checked then
		Chart1Click(Sender);
	if ViewFunctions1.Checked then
		ViewFunctions1Click(Sender);
end;

{
	procedure StrToStr(const SS: string; const BaseS: Byte;
	var SD: string; const BaseD: Byte);
	var i, x, n, k: SG;
	begin
	SD := '';
	if BaseS < 2 then Exit;
	if BaseD < 2 then Exit;

	n := 0; k := 1;
	for i := Length(SS) downto 1 do
	begin
	case SS[i] of
	'0'..'9': x := Ord(SS[i]) - Ord('0');
	'A'..'Z': x := Ord(SS[i]) - Ord('A') + 10;
	'a'..'z': x := Ord(SS[i]) - Ord('a') + 10 + 26;
	'-': x := 62;
	'*': x := 63;
	end;
	n := n + k * x;
	k := k * BaseS;
	repeat
	if k < BaseD then Break;
	if k > 1 then k := k div BaseD;
	SD := CharTab[n mod BaseD] + SD;
	n := n div BaseD;
	until False;
	end;
	if n > 0 then
	SD := CharTab[n mod BaseD] + SD;
	end;

	function StrToNum(const s: string; const Base: Byte): Int64;
	var i: SG;
	begin
	Result := 0;
	if (Base < 2) or (Base > MaxNumericBase) then Exit;
	for i := 1 to Length(s) do
	begin
	Result := Result * Base;
	case s[i] of
	'0'..'9': Inc(Result, Ord(s[i]) - Ord('0'));
	'A'..'Z': Inc(Result, Ord(s[i]) - Ord('A') + 10);
	'a'..'z': Inc(Result, Ord(s[i]) - Ord('a') + 10 + 26);
	'-': Result := 62;
	'*': Result := 63;
	end;
	end;
	end;
}

procedure TfMain.Calc;
begin
	if UseWindowsFormat1.Checked then
		Output.OutputFormat := ofDisplay
	else
		Output.OutputFormat := ofIO;
	UseThousandSeparator := UseThousandSeparator1.Checked;
	try
		{$include Messages.dsk}
		if (UpperCase(Copy(Input.Text, 1, 7)) = 'DADUSKA')
		{$ifdef UNICODE}
		or (UpperCase(Copy(Input.Text, 1, 7), loUserLocale) = 'DDUKA') {$endif}
		then
		begin
			ParserMessages.Clear;
			EditResult.Text := 'miluje Petka!'
{$IFDEF UNICODE} + CharSpace + Char($263A) + CharSpace + Char($2665){$ENDIF};
		end
		else if UpperCase(Copy(Input.Text, 1, 7)) = 'FTOZ' then
		begin
			ParserMessages.Clear;
			EditResult.Text := 'je nejlep ptel!'
{$IFDEF UNICODE} + CharSpace + Char($263A){$ENDIF};
		end
		else
		begin
			CurrentValue := CalcCore(Input.Text, UseWindowsFormat1.Checked);
			DrawOutput;
		end;
		EditErrors.Text := ParserMessages.ToString;
		EditErrors.ShowHint := True;
		EditErrors.Hint := NToS(ParserMessages.Count) + ' message' + Plural(ParserMessages.Count) + '.';
		EditErrors.Update;
		// ResetStyle;
		Input.ShowHint := True;
		if Input.GetTextLen = 0 then
		begin
			Input.Hint := 'Ctrl+I Indent' + FullSep + 'Ctrl+L Left Alignment' + FullSep +
				'Ctrl+E Center Alignment' + FullSep + 'Ctrl+R Right Alignment' { + FullSep +
				'Ctrl+M New Line' + FullSep + 'Ctrl+J New Line' } ;
		end
		else
			Input.Hint := 'Text Size: ' + NToS(Input.GetTextLen);
		// UnResetStyle;
		Highlight;
	finally
		UseThousandSeparator := True;
	end;

	if Assigned(fChart) then
	begin
		fChart.Draw;
	end;
end;

procedure TfMain.InputChange(Sender: TObject);
begin
	// if DeleteIndex <> -1 then Exit;
	if Input.Text <> Undos[UndoIndex] then
	begin
		Inc(UndoIndex);
		SetLength(Undos, UndoIndex + 1);
		Undos[UndoIndex] := Input.Text;
		UndoCount := UndoIndex + 1;
		InitUndoRedo;
	end;

	Calc;
end;

procedure TfMain.FormResize(Sender: TObject);
var
	n: SG;
begin
	EditResult.SetBounds(EditResult.Left, ClientHeight - FormBorder - EditResult.Height,
		ClientWidth - 2 * EditResult.Left, EditResult.Height);
	// ButtonCopyResult.Top := ;
	EditStatus.SetBounds(EditStatus.Left, EditResult.Top - FormBorder - EditStatus.Height,
		ClientWidth - EditStatus.Left - EditResult.Left, EditStatus.Height);
	n := EditStatus.Top - 2 * FormBorder;
	Input.SetBounds(Input.Left, PanelTool.Height + Input.Left, ClientWidth - 2 * Input.Left, Max
			(19, n div 2));
	EditErrors.SetBounds(EditErrors.Left, Input.Top + Input.Height,
		ClientWidth - 2 * EditErrors.Left, n div 2 - PanelTool.Height);
end;

procedure TfMain.FormShow(Sender: TObject);
begin
	InitUndoRedo;
end;

procedure TfMain.HighlightBrackets1Click(Sender: TObject);
begin
	HighlightBrackets1.Checked := not HighlightBrackets1.Checked;
	Highlight;
end;

procedure TfMain.CopyResult1Click(Sender: TObject);
begin
	Clipboard.SetTextBuf(PChar(EditResult.Text));
end;

procedure TfMain.Paste1Click(Sender: TObject);
var
	Buffer: string;
	NewLength: SG;
begin
	SetLength(Buffer, 64 * KB);
	NewLength := Clipboard.GetTextBuf(PChar(Buffer), 64 * KB);
	SetLength(Buffer, NewLength);
	Input.Text := Buffer;
	Input.SelStart := Input.GetTextLen;
end;

procedure TfMain.FormDestroy(Sender: TObject);
begin
	FormFree(TForm(fChart));
	FormFree(TForm(fTableForm));
	FormFree(TForm(fFunctions));
	MenuFree(PopupMenuInput.Items);
	MenuFree(PopupMenuResult.Items);
end;

procedure TfMain.CurBase1Click(Sender: TObject);
begin
	Output.Base := TMenuItem(Sender).Tag;
	Output.OutputType := otNumber;
	DrawOutput;
	InitMenu;
end;

procedure TfMain.ResultToInput1Click(Sender: TObject);
begin
	Input.Text := EditResult.Text;
	Input.SelStart := Input.GetTextLen;
end;

procedure TfMain.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
	RWOptions(True);
end;

{
	procedure TfMain.MenuItemClick(Sender: TObject);
	var
	F: PFunction;
	s: string;
	i: SG;
	SelStart: SG;
	begin
	F := PFunction(Namespace.Get(TMenuItem(Sender).Tag));

	s := F.Name;
	if F.ArgCount > 0 then
	s := s + '(';
	SelStart := Input.SelStart + Length(s);
	for i := 1 to F.ArgCount - 1 do
	s := s + ';';
	if F.ArgCount > 0 then
	s := s + ')';

	Input.SelText := s;
	Input.SelStart := SelStart;
	end; }

procedure TfMain.Rad1Click(Sender: TObject);
begin
	GoniometricFormat := TGoniometricFormat(TMenuItem(Sender).Tag);
	InputChange(Sender);
	InitMenu;
end;

procedure TfMain.Chart1Click(Sender: TObject);
begin
	if not Assigned(fChart) then
		fChart := TfChart.Create(Self);
	fChart.Visible := not fChart.Visible;
end;

procedure OnApply(Value: S8);
begin
	fMain.Output.Base := Value;
	fMain.Output.OutputType := otNumber;
	fMain.InputChange(nil);
	fMain.InitMenu;
end;

procedure TfMain.Custom1Click(Sender: TObject);
begin
	GetNumber('Numeric Base', Output.Base, 2, 10, MaxNumericBase, OnApply);
end;

procedure TfMain.UseWindowsFormat1Click(Sender: TObject);
begin
	UseWindowsFormat1.Checked := not UseWindowsFormat1.Checked;
	Calc;
end;

procedure TfMain.UseThousandSeparator1Click(Sender: TObject);
begin
	UseThousandSeparator1.Checked := not UseThousandSeparator1.Checked;
	Calc;
end;

procedure TfMain.AddToFavorites1Click(Sender: TObject);
var
	s: string;
	F: PCell;
begin
	if GetStr('Add Favorite Name', s, 'New', 0) then
	begin
		F := Favorites.Add;
		SetLength(F^, Length(FavoriteOptions));
		F^[SG(foName)].Str := s;
		F^[SG(foText)].Str := Input.Text;
		F^[SG(foCreated)].Str := DateTimeToS(Now, 0, ofIO);
		fTableForm.FormShow(Sender);
	end;
end;

procedure TfMain.LanguageText1Click(Sender: TObject);
begin
	Output.Language := TNumLanguage(TMenuItem(Sender).Tag);
	Output.OutputType := otText;
	DrawOutput;
	InitMenu;
end;

procedure TfMain.Normal1Click(Sender: TObject);
begin
	Output.OutputType := TOutputType(TMenuItem(Sender).Tag);
	DrawOutput;
	InitMenu;
end;

procedure TfMain.PopupMenuInputPopup(Sender: TObject);
begin
	MenuUpdate(Input1, PopupMenuInput.Items);
end;

procedure TfMain.Extended80bit1Click(Sender: TObject);
begin
	TMenuItem(Sender).Checked := True;
	Output.Precision := TMenuItem(Sender).Tag;
	DrawOutput;
end;

procedure TfMain.ViewErrors1Click(Sender: TObject);
begin
	ViewErrors1.Checked := not ViewErrors1.Checked;
	EditErrors.Visible := ViewErrors1.Checked;
end;

procedure TfMain.ViewFunctions1Click(Sender: TObject);
begin
	fFunctions.Visible := not fFunctions.Visible;
	ViewFunctions1.Checked := fFunctions.Visible;
end;

procedure TfMain.ViewStatus1Click(Sender: TObject);
begin
	ViewStatus1.Checked := not ViewStatus1.Checked;
	EditStatus.Visible := ViewStatus1.Checked;
end;

function SuperColor(const Id: SG): TColor;
begin
	Result := SpectrumColor((510 * Id + 255 * (Id div 3) + 128 * (Id div 6)) mod (MaxSpectrum + 1))
end;

procedure TfMain.CreateBracketGroups(out Brackets: array of TBracket);
var
	i: SG;
	OpenBracket: PBracket;
	Id: SG;
	Stack: TStack;
	j: SG;
begin
	Id := 0;
	Stack := TStack.Create;
	j := 0;
	try
		for i := 1 to Length(Input.Text) do
		begin
			case Input.Text[i] of
			'(', '[', '{':
				begin
					Brackets[Id].PosOpen := j + 1;
					Brackets[Id].Color := MixColors(clWindowText, SuperColor(Id));
					Stack.Push(@Brackets[Id]);
					Inc(Id);
				end;
			')', ']', '}':
				begin
					OpenBracket := Stack.Pop;
					if OpenBracket <> nil then
					begin
						OpenBracket.PosClose := j + 1;
					end;
				end;
			CharLF:
				Dec(j);
			end;
			Inc(j);
		end;
	finally
		Stack.Free;
	end;
end;

procedure TfMain.Highlight;
begin
	ResetStyle;
	try
		if SyntaxHighlight1.Checked then
			HighlightErrors(Input.Text);
		if HighlightBrackets1.Checked then
			HighlightBrackets;
	finally
		UnResetStyle;
	end;
end;

procedure TfMain.HighlightErrors(const InputStr: string);
const
	clError = clGrayText;
var
	i, j: SG;
	RichIndex: SG;
	LineX, LineY: UG;
	Me: PParserMessage;
	CompileMes: TData;
begin
	LineX := 0;
	LineY := 0;
	i := 1;
	RichIndex := 0;
	while i <= Length(InputStr) do
	begin
		CompileMes := ParserMessages.Messages;
		if CompileMes.Count > 0 then
		begin
			Me := CompileMes.GetFirst;
			for j := 0 to CompileMes.Count - 1 do
			begin
				if LineY = Me.Line then
				begin
					if (LineX = Me.X0) then
					begin
						Input.SelStart := RichIndex;
						Input.SelLength := Me.X1 - Me.X0;
						if Pos('unused chars', Me.Text) <> 0 then
							Input.SelAttributes.Style := [fsStrikeOut]
						else
							Input.SelAttributes.Style := [];
						Input.SelAttributes.Color := clError;
						// Break;
					end;
					{ if (Me.X0 = Me.X1) and (LineX = Me.X0) then
						begin
						Bmp.Bar(x, y, x, y + Bmp.Canvas.TextHeight('W') - 1, clError, ef16);
						Bmp.Bar(x - 3, y + Bmp.Canvas.TextHeight('W'), x, y + Bmp.Canvas.TextHeight('W') - 1, clError, ef16);
						end; }
				end;
				Inc(SG(Me), CompileMes.ItemMemSize);
			end;
		end;
		if i > Length(InputStr) then
		begin

		end
		else
		begin
			if (InputStr[i] = CharCR) then
			begin
				if InputStr[i] = CharCR then
					if InputStr[i + 1] = CharLF then
						Inc(i);
				// Dec(i);
				Inc(LineY);
				LineX := 0;
			end
			else
			begin
				Inc(LineX);
			end;
		end;
		Inc(RichIndex);
		Inc(i);
	end;
end;

procedure TfMain.Time1Click(Sender: TObject);
begin
	Time1.Checked := not Time1.Checked;
end;

procedure TfMain.DrawOutput;
var
	s: string;
begin
	EditResult.Lines.BeginUpdate;
	try
		EditResult.Text := '';
		s := OutputToStr(CurrentValue, Output);
		if (Output.OutputType = otNumber) and (Output.Base <> 10) then
			s := s + FullSep + '(' + NToS(Output.Base) + ')';

		EditResult.Text := s;
	finally
		EditResult.Lines.EndUpdate;
	end;
	EditStatus.Text :=
	// 'Output Numeric Base: ' + NToS(CurBase) +
		Translate('Calc Time: ') + NToS(RoundDivS8(1000000 * CalcTime, PerformanceFrequency), 6)
		+ ' s' + ListSeparator + Translate('Input Text Size: ') + NToS(Input.GetTextLen)
		+ ListSeparator + Translate('Bracket Depth: ') + NToS(MaxBracketDepth)
		+ ListSeparator + Translate('Tree Depth: ') + NToS(TreeDepth) + ListSeparator +
		Translate('Node Count: ') + NToS
		(NodeCount)
{$IFOPT d+} + ListSeparator + Translate('Tree Size: ') + BToStr(TreeSize){$ENDIF};
	EditStatus.Update;
end;

procedure TfMain.SS1Click(Sender: TObject);
begin
	Output.TimeFormat := TDisplay(TMenuItem(Sender).MenuIndex);
	Output.OutputType := otTime;
	DrawOutput;
	InitMenu;
end;

procedure TfMain.SyntaxHighlight1Click(Sender: TObject);
begin
	SyntaxHighlight1.Checked := not SyntaxHighlight1.Checked;
	Highlight;
end;

procedure TfMain.ChangePrecision1Click(Sender: TObject);
begin
	if Output.Precision >= 2 then
		Output.Precision := 0
	else
		Inc(Output.Precision);
	Precision1.Items[Output.Precision].Click;
end;

procedure TfMain.Copy2Click(Sender: TObject);
begin
	Clipboard.SetTextBuf(PChar(Input.Text));
end;

procedure TfMain.PopupMenuResultPopup(Sender: TObject);
begin
	MenuUpdate(Result1, PopupMenuResult.Items);
end;

procedure TfMain.CopyChart1Click(Sender: TObject);
begin
	if Assigned(fChart) then
		fChart.Chart.CopyToClipboardBitmap;
end;

procedure TfMain.OrganizeFavorites1Click(Sender: TObject);
begin
	if not Assigned(fTableForm) then
	begin
		fTableForm := TfTableForm.Create(Favorites, 'Favorites', False);
		fTableForm.AddAction('Use', UseFavorite);
		fTableForm.AddAction('Append', AppendFavorite);
		fTableForm.OnHide := FavoritesHide;
	end;
	fTableForm.Visible := not fTableForm.Visible;
	OrganizeFavorites1.Checked := fTableForm.Visible;
	// FreeAndNil(fTableForm);
end;

var
	LSelStart: SG;
	LLength: SG;
	LWidth: SG;
	LHeight: SG;

procedure TfMain.ResetStyle;
begin
	LSelStart := Input.SelStart;
	LLength := Input.SelLength;
	LWidth := Input.Width;
	LHeight := Input.Height;
	// Input.Hide;
	Input.OnChange := nil;

	Input.SetBounds(Input.Left, Input.Top, 0, 0);
	Input.SelectAll;
	{ GetAttributes(Format);
		Format.dwEffects := Format.dwEffects and (not CFE_BOLD);
		SetAttributes(Format); }
	Input.SelAttributes.Style := [];
	Input.SelAttributes.Color := clWindowText;
	// Input.SelAttributes.Style := [fsBold];
end;

procedure TfMain.UnResetStyle;
begin
	Input.SetBounds(Input.Left, Input.Top, LWidth, LHeight);
	// Input.Show;
	Input.SelStart := LSelStart;
	Input.SelLength := LLength;
	Input.OnChange := InputChange;
end;

procedure TfMain.InputKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
	if (ssCtrl in Shift) and (Key = VK_SPACE) then
	begin
		AvailableFunctionList1Click(Sender);
	end;
end;

procedure TfMain.AvailableFunctionList1Click(Sender: TObject);
var
	i: SG;
	F: PFunction;
	Txt: string;
	Prefix: string;
	c: Char;

	ListCount: SG;
	List: TArrayOfKey;
begin
	DeleteIndex := Input.SelStart;
	Txt := Input.Text;
	DeleteLength := 0;
	while DeleteIndex >= 1 do
	begin
		c := Txt[DeleteIndex];
		if not(CharType(c, StdCharTable) in [ctLetter, ctNumber]) then
			Break;
		Prefix := c + Prefix;
		Dec(DeleteIndex);
		Inc(DeleteLength);
	end;
	Prefix := UpperCase(Prefix);

	ListCount := 0;
	SetLength(List, ListCount);
	for i := 0 to Namespace.Capacity - 1 do
	begin
		F := PFunction(Namespace.Get(i));
		if (F <> nil) and (F.Name <> '') then
		begin
			if StartStr(Prefix, UpperCase(F.Name)) then
			begin
				SetLength(List, ListCount + 1);
				List[ListCount] := i;
				Inc(ListCount);
			end;
		end;
	end;

	if fAvailableFunctions = nil then
	begin
		fAvailableFunctions := TfFunctions.Create(Self);
		fAvailableFunctions.Caption := Translate('Available Function List');
	end;
	if ListCount = 0 then
		fAvailableFunctions.KeyIndexes := Namespace.GetUsedKeyIndexes
	else
		fAvailableFunctions.KeyIndexes := List;
	fAvailableFunctions.DViewFunctions.DeselectAll;
	fAvailableFunctions.DViewFunctions.SelectRow(0);

	fAvailableFunctions.BorderStyle := bsSizeToolWin;
	fAvailableFunctions.Left := GetClientOrigin.X + Input.Left;
	fAvailableFunctions.Top := GetClientOrigin.Y + Input.Top + Input.Height;
	fAvailableFunctions.ShowModal;
end;

procedure TfMain.PanelToolResize(Sender: TObject);
begin
	IconsResize(PanelTool);
end;

procedure TfMain.ActionUndoRedoExecute(Sender: TObject);
var
	i: SG;
begin
	i := UndoIndex + TComponent(Sender).Tag;
	if i >= UndoCount then
		Exit
	else if i < 0 then
		Exit;

	UndoIndex := i;
	InitUndoRedo;
	Input.OnChange := nil;
	try
		Input.Text := Undos[UndoIndex];
		Input.SelStart := Input.GetTextLen;
		Calc;
	finally
		Input.OnChange := InputChange;
	end;
end;

procedure TfMain.InitUndoRedo;
begin
	Redo1.Enabled := UndoIndex + 1 < UndoCount;
	Undo1.Enabled := UndoIndex > 0;
	UpdateIcons(MainMenu1, PanelTool);
end;

procedure TfMain.FavoritesHide(Sender: TObject);
begin
	OrganizeFavorites1.Checked := False;
end;

initialization

{$IFOPT d-}
Randomize;
{$ENDIF}
ParserMessages := TParserMessages.Create;
{$IFOPT d+}
CalcTest;
{$ENDIF}

finalization

FreeAndNil(ParserMessages);

end.
