// * File:     CmdCalc\uFunctions.pas
// * Created:  2001-08-01
// * Modified: 2009-12-27
// * Version:  1.3.47.75
// * Author:   David Safranek (Safrad)
// * E-Mail:   safrad at email.cz
// * Web:      http://safrad.own.cz

unit uFunctions;

interface

uses
	uTypes, uDForm, uHashTable,
	Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
	Dialogs, uDImage, uDView, uDWinControl;

type
	TfFunctions = class(TDForm)
		DViewFunctions: TDView;
		procedure FormCreate(Sender: TObject);
		procedure DViewFunctionsGetData(Sender: TObject; var Data: String;
			ColIndex, RowIndex: Integer; Rect: TRect);
		procedure FormHide(Sender: TObject);
		procedure DViewFunctionsKeyDown(Sender: TObject; var Key: Word;
			Shift: TShiftState);
		procedure DViewFunctionsCellClick(Sender: TObject; ColumnIndex,
			RowIndex: Integer; Shift: TShiftState);
	private
		{ Private declarations }
		FKeyIndexes: TArrayOfKey;
		procedure RWOptions(const Save: BG);
		procedure SetKeyIndexes(const Value: TArrayOfKey);
		procedure FunctionHelp;
	public
		{ Public declarations }
		property KeyIndexes: TArrayOfKey read FKeyIndexes write SetKeyIndexes;
	end;

var
	fFunctions: TfFunctions;

implementation

{$R *.dfm}

uses uDIniFile, uOutputFormat, uNamespace, uAPI, uStrings, uMain, uDictionary;

procedure TfFunctions.FormCreate(Sender: TObject);
begin
	DViewFunctions.AddColumn('Group', DViewFunctions.CellWidth('Goniometric'));
	DViewFunctions.AddColumn('Name', DViewFunctions.CellWidth('VarianceCoef'));
	DViewFunctions.AddColumn('Arguments', DViewFunctions.CellWidth('Any'));
	DViewFunctions.AddColumn('Description', 256);

	RWOptions(False);
	KeyIndexes := Namespace.GetUsedKeyIndexes;
	if Assigned(Dictionary) then
		Dictionary.TranslateForm(Self);
end;

procedure TfFunctions.DViewFunctionsGetData(Sender: TObject;
	var Data: String; ColIndex, RowIndex: Integer; Rect: TRect);
var F: PFunction;
begin
	F := PFunction(Namespace.Get(KeyIndexes[RowIndex]));
	if F = nil then Exit;
	case ColIndex of
	0: Data := F.Group;
	1: Data := F.Name;
	2:
	begin
		if F.ArgCount = -1 then
			Data := 'any'
		else
			Data := NToS(F.ArgCount);
	end;
	3:
	begin
		Data := F.Description;
		if Pos('//', Data) <> 0 then
		begin
			DViewFunctions.Bitmap.Canvas.Font.Color := clBlue;
			DViewFunctions.Bitmap.Canvas.Font.Style := [fsUnderline];
		end;
	end;
	end;
end;

procedure TfFunctions.FormHide(Sender: TObject);
begin
	if Name = 'fFunctions' then
		fMain.ViewFunctions1.Checked := False;
	RWOptions(True);
end;

procedure TfFunctions.RWOptions(const Save: BG);
begin
	MainIni.RWFormPos(Self, Save);
	DViewFunctions.Serialize(MainIni, Save);
end;

procedure TfFunctions.DViewFunctionsKeyDown(Sender: TObject; var Key: Word;
	Shift: TShiftState);
var
	F: PFunction;
	s, s2: string;
	i: SG;
	SelLen: SG;
begin
	if Key = VK_ESCAPE then
	begin
		Close;
	end
	else if Key = VK_F1 then
		FunctionHelp
	else if Key = VK_RETURN then
	begin
		F := PFunction(Namespace.Get(KeyIndexes[DViewFunctions.ActualRow]));

		if fMain.DeleteIndex <> -1 then
		begin
			s := fMain.Input.Text;
			Delete(s, fMain.DeleteIndex + 1, fMain.DeleteLength);
//			fMain.Input.Text := s;
		end;

		s2 := F.Name;
		if F.ArgCount > 0 then
			s2 := s2 + '(';
		SelLen := Length(s2);
		for i := 1 to F.ArgCount - 1 do
			s2 := s2 + ';';
		if F.ArgCount > 0 then
			s2 := s2 + ')';
		Insert(s2, s, fMain.DeleteIndex + 1);

		fMain.Input.Text := s;
		fMain.Input.SelStart := fMain.DeleteIndex + 0 + SelLen;
		if BorderStyle = bsSizeToolWin then
			Close;
	end;
end;

procedure TfFunctions.SetKeyIndexes(const Value: TArrayOfKey);
begin
	FKeyIndexes := Value;
	DViewFunctions.RowCount := Length(Value);
	DViewFunctions.DataChanged;
end;

function WebAddr(const Text: string): string;
var
	i: SG;
begin
	i := Pos('//', Text);
	if i = 0 then
	begin
		Result := Text;
	end;
	while i > 1 do
	begin
		if CharInSet(Text[i - 1], Space) then Break;
		Dec(i);
	end;
	Result := Copy(Text, i, MaxInt)
end;

procedure TfFunctions.FunctionHelp;
var
	Data: string;
begin
	if DViewFunctions.Where = vaRow then
	begin
		Data := PFunction(Namespace.Get(KeyIndexes[DViewFunctions.ActualRow])).Description;
		if Pos('//', Data) <> 0 then
		begin
			APIOpen(WebAddr(Data));
		end;
	end;
end;

procedure TfFunctions.DViewFunctionsCellClick(Sender: TObject; ColumnIndex,
	RowIndex: Integer; Shift: TShiftState);
begin
	if (ssLeft in Shift) and (ColumnIndex = 3) then
	begin
		FunctionHelp;
	end;
end;

end.
