// * File:     Boggle\uCubes.pas
// * Created:  2009-07-07
// * Modified: 2010-08-17
// * Version:  1.1.47.21
// * Author:   David Safranek (Safrad)
// * E-Mail:   safrad at email.cz
// * Web:      http://safrad.own.cz

unit uCubes;

interface

uses uTypes, uDFile;

const
	CubeSides = 6;

type
	TCube = array[0..CubeSides - 1] of string;

	TCubes = class(TDFile)
		FCubes: array of TCube;
		FCount: SG;
	protected
		procedure RWData(const Write: BG); override;
	public
		function Get(const Index: SG): TCube;
		property Count: SG read FCount;
	end;

implementation

uses
	SysUtils,
	uMath, uCSVFile,
	uMain;

{ TCubes }

function TCubes.Get(const Index: SG): TCube;
begin
	Result := FCubes[Index];
end;

procedure TCubes.RWData(const Write: BG);
var
	Line: TArrayOfString;
	NewSize: SG;
	i: SG;
	CSVFile: TCSVFile;
begin
	if Write then Exit;

	FCount := 0;
	SetLength(FCubes, 0);
	CSVFile := TCSVFile.Create(CubeSides);
	try
		if CSVFile.Open(FileName) then
		begin
			while not CSVFile.EOF do
			begin
				Line := CSVFile.ReadLine;
				if Length(Line) >= CubeSides then
				begin
					NewSize := FCount + 1;
					if AllocByExp(Length(FCubes), NewSize) then
						SetLength(FCubes, NewSize);

					for i := 0 to CubeSides - 1 do
						FCubes[FCount][i] := Line[i];
					Inc(FCount);
				end;
			end;
		end;
		CSVFile.Close;
	finally
		FreeAndNil(CSVFile);
	end;
	SetLength(FCubes, FCount);
	fMain.ShowBoard;
end;

end.
