// * File:     Boggle\uMain.pas
// * Created:  2003-03-02
// * Modified: 2010-11-13
// * Version:  1.1.47.21
// * Author:   David Safranek (Safrad)
// * E-Mail:   safrad at email.cz
// * Web:      http://safrad.own.cz

unit uMain;

interface

uses
	uTypes,
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
	StdCtrls, uDButton, ExtCtrls, uDForm, uDEdit, uDImage, ComCtrls, uDTimer,
	Menus, uDWinControl, Dialogs;

type
	TfMain = class(TDForm)
		DImage: TDImage;
		StatusBar: TStatusBar;
		Timer: TDTimer;
		MainMenu1: TMainMenu;
		File1: TMenuItem;
		Options1: TMenuItem;
		Help1: TMenuItem;
		GameTime1: TMenuItem;
		SelectCubes1: TMenuItem;
		NewGame1: TMenuItem;
		Manual1: TMenuItem;
		Settings1: TMenuItem;
		Edit1: TMenuItem;
		Copy1: TMenuItem;
		AbortGame1: TMenuItem;
		CopyBoardAsImage1: TMenuItem;
		GUISettings1: TMenuItem;
		procedure TimerTimer(Sender: TObject);
		procedure GameTime1Click(Sender: TObject);
		procedure FormCreate(Sender: TObject);
		procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
		procedure SelectCubes1Click(Sender: TObject);
		procedure NewGame1Click(Sender: TObject);
		procedure Manual1Click(Sender: TObject);
		procedure Settings1Click(Sender: TObject);
		procedure Copy1Click(Sender: TObject);
		procedure AbortGame1Click(Sender: TObject);
		procedure CopyBoardAsImage1Click(Sender: TObject);
		procedure FormDestroy(Sender: TObject);
		procedure DImageFill(Sender: TObject);
		procedure GUISettings1Click(Sender: TObject);
	private
		{ Private declarations }
		procedure BoggleOptionChanged(const OptionIndex: SG);
		procedure GUIOptionChanged(const OptionIndex: SG);
		procedure ShowTime;
		procedure RWOptions(const Save: BG);
		procedure DrawBoard(Sender: TObject);
		procedure DrawBoardDirect(Sender: TObject);
	public
		{ Public declarations }
		procedure ShowBoard;
	end;

var
	fMain: TfMain;

implementation

{$R *.DFM}

uses
	Math, ClipBrd,
	uFiles, uMath, uStrings, uMsg, uOutputFormat, uCSVFile, uDBitmap, uWave, uGetTime, uDIniFile,
	uAPI, uOptions, ufOptions,
	uSystem, uGraph, uSounds, uColor, uDelayedCall, uDrawStyle, uDictionary,
	uCubes;

const
	DefaultGameTime = 3 * Minute;

type
	TBoggleOption = (boGameTime, boCubesFileName, boWidth, boHeight);
	TGUIOption = (goBackground, goCubeBackground, goCubeText, goKeepAspectRatio, goShowCubeId,
		goDelayedDisplay);

var
	BoggleOptions: array [TBoggleOption] of TOption = (
		(
			Typ: vsTime; Default: DefaultGameTime; Minimum: 0; Maximum: Day - 1), (Typ: vsFileName;
			DefaultStr: 'Cubes' + PathDelim + 'English 1986 (easy).csv'), (Typ: vsSpin; Default: 4;
			Minimum: 1; Maximum: 64), (Typ: vsSpin; Default: 4; Minimum: 1; Maximum: 64));
	GUIOptions: array [TGUIOption] of TOption = (
		(
			Typ: vsColor; Default: clAppworkspace), (Typ: vsColor; Default: clWindow), (Typ: vsColor;
			Default: clWindowText), (Typ: vsCheck; Default: 1), (Typ: vsCheck; Default: 0),
		(Typ: vsCheck; Default: 1));

var
	BoggleParams: array [TBoggleOption] of TParam;
	GUIParams: array [TGUIOption] of TParam;

type
	TTemplate = record
		Name: string;
		Params: array [TBoggleOption] of TParam;
	end;

const
	BoggleTemplates: array [0 .. 1] of TTemplate =
		((Name: 'English'; Params: ((Num: DefaultGameTime), (Str: 'Cubes' + PathDelim +
						'English 1986 (easy).csv'), (Num: 4), (Num: 4))), (Name: 'Masters';
			Params: ((Num: DefaultGameTime), (Str: 'Cubes' + PathDelim + 'English Masters.csv'), (Num: 5)
					, (Num: 5))));

var
	Cubes: TCubes;
	RemainTime: S4;

type
	TSquare = record
		CubeIndex: SG;
		CubeSide: SG;
	end;

var
	Squares: array of TSquare;
	SquareCount: SG;
	XCount: SG;
	YCount: SG;

function RandomUnusedCubeIndex(var Used: array of BG): SG;
var
	CubeIndex: SG;
begin
	if Cubes.Count < SquareCount then
	begin
		CubeIndex := Random(Cubes.Count);
	end
	else
	begin
		repeat
			CubeIndex := Random(Cubes.Count);
		until (Used[CubeIndex] = False);
		Used[CubeIndex] := True;
	end;

	Result := CubeIndex;
end;

procedure Generate;
var
	i: SG;
	Used: array of BG;
begin
	if Cubes.Count = 0 then
		Exit;
	SetLength(Used, Cubes.Count);
	for i := 0 to SquareCount - 1 do
	begin
		Squares[i].CubeIndex := RandomUnusedCubeIndex(Used);
		Squares[i].CubeSide := Random(CubeSides);
	end;
end;

function GetSquareString(const Square: TSquare): string;
var
	Cube: TCube;
begin
	if Square.CubeIndex >= Cubes.Count then
	begin
		Result := '?';
	end
	else
	begin
		Cube := Cubes.Get(Square.CubeIndex);
		if Square.CubeSide >= Length(Cube) then
		begin
			Result := '?';
		end
		else
		begin
			Result := Cube[Square.CubeSide];
		end;
	end;
end;

{ TfMain }

procedure TfMain.BoggleOptionChanged(const OptionIndex: SG);
begin
	case TBoggleOption(OptionIndex) of
	boGameTime:
		begin
			Timer.Reset;
			RemainTime := BoggleParams[boGameTime].Num;
			ShowTime;
			ShowBoard;
		end;
	boCubesFileName:
		begin
			Cubes.FileName := ExpandDir(BoggleParams[boCubesFileName].Str);
			{ if Visible then
				case CubeCount of
				16:
				begin
				if (BoggleParams[boWidth].Num <> 4) or (BoggleParams[boHeight].Num <> 4) then
				BoggleParams[boWidth].Num := 4;
				BoggleParams[boHeight].Num := 4;
				OptionChanged(2);
				end;
				25:
				begin
				BoggleParams[boWidth].Num := 5;
				BoggleParams[boHeight].Num := 5;
				OptionChanged(2);
				end;
				end; }
			ShowBoard;
		end;
	boWidth, boHeight:
		begin
			XCount := BoggleParams[boWidth].Num;
			YCount := BoggleParams[boHeight].Num;
			SquareCount := XCount * YCount;
			SetLength(Squares, 0);
			SetLength(Squares, SquareCount);
			Generate;
			ShowBoard;
		end;
	else
		raise Exception.Create('Invalid option index.');
	end;
end;

procedure TfMain.DrawBoardDirect(Sender: TObject);
var
	Bmp: TDBitmap;
	x, y: SG;
	w, h: SG;
	ox, oy: SG;
	R, R2: TRect;
	s: string;
	SquareSize, BorderSize: SG;
	Layer: SG;
begin
	Bmp := DImage.Bitmap;
	if Bmp.Data = nil then
		Exit;

	Bmp.FormBitmap(GUIParams[goBackground].Num);

	if (XCount = 0) or (YCount = 0) then
		Exit;

	SquareSize := Min(Bmp.Width div XCount, Bmp.Height div YCount);
	if GUIParams[goKeepAspectRatio].Bool then
	begin
		w := SquareSize * XCount;
		h := SquareSize * YCount;
	end
	else
	begin
		w := Bmp.Width;
		h := Bmp.Height;
	end;
	ox := (Bmp.Width - w) div 2;
	oy := (Bmp.Height - h) div 2;

	Bmp.Canvas.Brush.Style := bsClear;
	Bmp.Canvas.Font.Style := [fsBold];
	Bmp.Canvas.Font.Name := 'Arial';
	BorderSize := Max(1, SquareSize div 8);
	for Layer := 0 to 2 do
	begin
		case Layer of
		1:
			begin
				if (GUIParams[goShowCubeId].Bool = False) or (SquareSize < 40) then
					Continue;
				Bmp.Canvas.Font.Size := 8;
				Bmp.Canvas.Font.Color := NegMonoColor(GUIParams[goCubeBackground].Num);
			end;
		2:
			begin
				Bmp.Canvas.Font.Color := GUIParams[goCubeText].Num;
			end;
		end;

		for y := 0 to YCount - 1 do
		begin
			for x := 0 to XCount - 1 do
			begin
				R.Left := RoundDiv(x * w, XCount) + ox;
				R.Top := RoundDiv(y * h, YCount) + oy;
				R.Right := RoundDiv((x + 1) * w, XCount) - 1 + ox;
				R.Bottom := RoundDiv((y + 1) * h, YCount) - 1 + oy;
				// XD2 := XD1 + RoundDiv(Bmp.Width, XCount);
				// YD2 := YD1 + RoundDiv(Bmp.Height, YCount);
				case Layer of
				0:
					begin
						Bmp.Bar(R, GUIParams[goCubeBackground].Num, ef16);
						Bmp.Border(R, clWhite, clBlack, BorderSize, ef08);
					end;
				1:
					begin
						s := NToS(Squares[x + y * XCount].CubeIndex) + '.' + NToS
							(Squares[x + y * XCount].CubeSide);
						DrawCuttedText(Bmp.Canvas, R, taLeftJustify, tlTop, s, True, 0);
					end;
				2:
					begin
						s := GetSquareString(Squares[x + y * XCount]);
						R2 := R;
						InflateRect(R2, -BorderSize, -BorderSize);
						IdealFont(s, Bmp.Canvas, R2, Bmp.Canvas.Font);
						DrawCuttedText(Bmp.Canvas, R, taCenter, tlCenter, s, True, IdealShadow(Bmp.Canvas));
						// Bmp.Canvas.TextOut((XD2 + XD1 - TextWidth + 1) div 2, (YD2 + YD1 - Bmp.Canvas.TextHeight(s) + 1) div 2, s);
					end;
				end;
			end;
		end;
	end;
	if NewGame1.Checked = False then
	begin
		// Bmp.Bar(clWhite, efNeg);
		Bmp.Bar(clAppworkspace, ef08);
		// Bmp.GBlur(8, True, True, nil, False);
	end;
end;

procedure TfMain.ShowTime;
begin
	StatusBar.Panels[0].Text := Translate('Remain time') + ': ' + MsToStr
		(RemainTime + Second div 2, diMSD, 0);
end;

procedure TfMain.TimerTimer(Sender: TObject);
begin
	DelayedTimer;
	if NewGame1.Checked and (RemainTime > 0) then
	begin
		Dec(RemainTime, Timer.Interval);
		if RemainTime <= 0 then
		begin
			RemainTime := 0;
			AbortGame1Click(Sender);
		end;
		ShowTime;
	end;
end;

procedure TfMain.GameTime1Click(Sender: TObject);
begin
	OptionClick(BoggleOptions[boGameTime], 0, BoggleParams[boGameTime], BoggleOptionChanged);
end;

procedure TfMain.RWOptions(const Save: BG);
begin
	MainIni.RWFormPos(Self, Save);
	uOptions.RWOptions(POptions(@BoggleOptions), Length(BoggleOptions), PParams(@BoggleParams),
		MainIni, 'Boggle Options', Save);
	uOptions.RWOptions(POptions(@GUIOptions), Length(GUIOptions), PParams(@GUIParams), MainIni,
		'GUI Options', Save);
end;

procedure DrawBoardProc;
begin
	if Assigned(fMain) then
		fMain.DrawBoard(nil);
end;

procedure TfMain.FormCreate(Sender: TObject);
begin
	RegisterDelayedCall(32, nil);
	RegisterDelayedCall(0, DrawBoardProc);
	// OpenDialog1.Filter := GetFileNameFilter('Comma Separated Values', ['csv']) + '|' + AllFiles;
	AddSounds(['Game Over'], [GetWinSoundFileName(wsAsterisk)]);
	Cubes := TCubes.Create;

	MainIni.RegisterRW(RWOptions);
	BoggleOptionChanged(0);
	BoggleOptionChanged(1);
	BoggleOptionChanged(2);
	GUIOptionChanged(0);
end;

procedure TfMain.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
	if NewGame1.Checked then
		CanClose := Confirmation('Abort Game?', [mbYes, mbNo]) = mbYes;
end;

procedure TfMain.SelectCubes1Click(Sender: TObject);
begin
	OptionClick(BoggleOptions[boCubesFileName], 1, BoggleParams[boCubesFileName],
		BoggleOptionChanged);
end;

procedure TfMain.NewGame1Click(Sender: TObject);
begin
	NewGame1.Checked := True;
	Generate;
	RemainTime := BoggleParams[boGameTime].Num;
	Timer.Reset;
	ShowBoard;
end;

procedure TfMain.Manual1Click(Sender: TObject);
begin
	APIOpen('http://en.wikipedia.org/wiki/Boggle');
end;

procedure TfMain.Settings1Click(Sender: TObject);
begin
	ShowOptions('Settings', POptions(@BoggleOptions), Length(BoggleOptions), PParams(@BoggleParams),
		BoggleOptionChanged, @BoggleTemplates, Length(BoggleTemplates));
end;

procedure TfMain.Copy1Click(Sender: TObject);
var
	x, y: SG;
	s: string;
begin
	s := '';
	for y := 0 to YCount - 1 do
	begin
		for x := 0 to XCount - 1 do
		begin
			s := s + GetSquareString(Squares[x + y * XCount]) + CharTab;
		end;
		s := DelLastChar(s);
		s := s + LineSep;
	end;
	Clipboard.SetTextBuf(PChar(s));
end;

procedure TfMain.ShowBoard;
begin
	StatusBar.Panels[1].Text := NToS(Cubes.Count) + CharSpace + Translate
		('cube' + Plural(Cubes.Count) + CharSpace + 'placed on') + CharSpace + NToS(XCount)
		+ CharTimes + NToS(YCount) + CharSpace + Translate('board') + '.';
	DelayedCall(0);
end;

procedure TfMain.AbortGame1Click(Sender: TObject);
begin
	PlaySound(2);
	NewGame1.Checked := False;
	ShowBoard;
end;

procedure TfMain.CopyBoardAsImage1Click(Sender: TObject);
begin
	DImage.ToClipboard;
end;

procedure TfMain.FormDestroy(Sender: TObject);
begin
	MainIni.UnregisterRW(RWOptions);
	FreeAndNil(Cubes);
end;

procedure TfMain.DImageFill(Sender: TObject);
begin
	DrawBoardDirect(Sender);
end;

procedure TfMain.DrawBoard(Sender: TObject);
begin
	DImage.Repaint;
end;

procedure TfMain.GUISettings1Click(Sender: TObject);
begin
	ShowOptions('Settings', POptions(@GUIOptions), Length(GUIOptions), PParams(@GUIParams),
		GUIOptionChanged);
end;

procedure TfMain.GUIOptionChanged(const OptionIndex: SG);
begin
	ShowBoard;
	SetDelayedCallEnabled(GUIParams[goDelayedDisplay].Bool);
end;

initialization

InitOptionNames(TypeInfo(TBoggleOption), BoggleOptions);
InitOptionNames(TypeInfo(TGUIOption), GUIOptions);

end.
