// * File:     BMI\uMain.pas
// * Created:  2007-05-15
// * Modified: 2009-09-18
// * Version:  1.0.47.15
// * Author:   David Safranek (Safrad)
// * E-Mail:   safrad at email.cz
// * Web:      http://safrad.own.cz

unit uMain;

interface

uses
	uParserMsg,
	Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
	Dialogs, StdCtrls, ExtCtrls;

type
	TfMain = class(TForm)
		EditHeight: TLabeledEdit;
		EditWeight: TLabeledEdit;
		EditBMI: TLabeledEdit;
		procedure EditHeightChange(Sender: TObject);
		procedure EditWeightChange(Sender: TObject);
		procedure EditBMIChange(Sender: TObject);
		procedure FormCreate(Sender: TObject);
		procedure FormDestroy(Sender: TObject);
	private
		{ Private declarations }
		Messages: TParserMessages;
		FormHeight, FormWeight, FormBMI: Extended;
		procedure CalcBMI;
		procedure CalcWeight;
	public
		{ Public declarations }
	end;

var
	fMain: TfMain;

implementation

{$R *.dfm}
uses uInputFormat, uDEdit, uStrings;

procedure TfMain.CalcBMI;
begin
	EditBMI.OnChange := nil;
	try
		if FormHeight <> 0 then
		begin
			FormBMI := FormWeight / Sqr(FormHeight / 100);
			EditBMI.Text := FloatToStr(FormBMI);
		end
		else
			EditBMI.Text := NAStr;
	finally
		EditBMI.OnChange := EditBMIChange;
		SetDesign(TDEdit(EditBMI), nil);
	end;
end;

procedure TfMain.CalcWeight;
begin
	EditWeight.OnChange := nil;
	try
		if FormHeight <> 0 then
		begin
			FormWeight := FormBMI * Sqr(FormHeight / 100);
			EditWeight.Text := FloatToStr(FormWeight);
		end
		else
			EditWeight.Text := NAStr;
	finally
		EditWeight.OnChange := EditWeightChange;
		SetDesign(TDEdit(EditWeight), nil);
	end;
end;

procedure TfMain.EditHeightChange(Sender: TObject);
begin
	Messages.Clear;
	FormHeight := StrToValE(TEdit(EditHeight).Text, True, 0, 180, MaxInt, Messages);
	SetDesign(TDEdit(EditHeight), Messages);
	CalcBMI;
end;

procedure TfMain.EditWeightChange(Sender: TObject);
begin
	Messages.Clear;
	FormWeight := StrToValE(TEdit(EditWeight).Text, True, 0, 75, MaxInt, Messages);
	SetDesign(TDEdit(EditWeight), Messages);
	CalcBMI;
end;

procedure TfMain.EditBMIChange(Sender: TObject);
begin
	Messages.Clear;
	FormBMI := StrToValE(TEdit(EditBMI).Text, True, 0, 22.5, MaxInt, Messages);
	SetDesign(TDEdit(EditBMI), Messages);
	CalcWeight;
end;

procedure TfMain.FormCreate(Sender: TObject);
begin
	Messages := TParserMessages.Create;
	EditHeightChange(Sender);
	EditWeightChange(Sender);
	CalcBMI;
end;

procedure TfMain.FormDestroy(Sender: TObject);
begin
	FreeAndNil(Messages);
end;

end.
