// * File:     Backup\Backup.dpr
// * Created:  2008-07-26
// * Modified: 2011-01-17
// * Version:  1.0.47.16
// * Author:   David Safranek (Safrad)
// * E-Mail:   safrad at email.cz
// * Web:      http://safrad.own.cz

program Backup;

uses
	SysUtils,
	Windows,
	uTypes,
	uMsg,
	uLog,
	uFiles,
	uOutputFormat,
	uStrings,
	uDIniFile,
	uParams,
	uPack in 'uPack.pas';

{$APPTYPE CONSOLE}

function NewestDir(const Dir: string): string;
var
	FileNames: TFileNames;
	FilesCount: SG;
	i: SG;
	DateTime, NewestDateTime: TFileTime;
begin
	FilesCount := 0;
	ReadDir(FileNames, FilesCount, Dir, [], False, True, False, True);
	Result := '';
	for i := 0 to FilesCount -1 do
	begin
		DateTime := GetFileCreated(Dir + FileNames[i]);
		if U8(DateTime) > U8(NewestDateTime) then
		begin
			NewestDateTime := DateTime;
			Result := Dir + FileNames[i];
		end;
	end;
end;

var
	BackupParamDir: string;
	BackupDir: string;
	LastBackupDir: string;
	NowDate: TDateTime;

procedure SetOutputFolder(const Value: string);
begin
	BackupParamDir := CorrectDirF(Value);
	if CompareWithLastBackup then
		LastBackupDir := NewestDir(BackupParamDir);
	MainLogAdd('LastBackupDir: ' + LastBackupDir, mlInformation);
	NowDate := Now();
	BackupDir := BackupParamDir + DateToS(Trunc(NowDate), ofIO) + '_' + ReplaceF(TimeToS(Frac(NowDate), 0, ofIO), ':', '_') + SysUtils.PathDelim;
	MainLogAdd('BackupDir: ' + BackupDir, mlInformation);
end;

procedure LoadEnvironment;
var
	IniFile: TDIniFile;
	IniSection: PIniSection;
	i: SG;
begin
	IniFile := TDIniFile.Create(AppDataDir + 'Environment.ini');
	try
		IniSection := IniFile.GetSection('Environment');
		SetLength(Environment, IniSection.KeyCount);
		for i := 0 to IniSection.KeyCount - 1 do
		begin
			Environment[i].Name := IniSection.Keys[i].Name;
			Environment[i].Value := IniSection.Keys[i].Value;
			if LowerCase(Environment[i].Name) = 'output' then
			begin
				SetOutputFolder(Environment[i].Value);
			end;
		end;
	finally
		IniFile.Free;
	end;
end;

procedure SetInputScript(const Value: string);
begin
	NewFileOrDir(BackupDir);
	ParseConfiguration(Value, BackupDir, LastBackupDir);
end;

procedure SetHide(const Value: string);
begin
	Hidden := Value <> '0';
end;

begin
	RegisterParam('Output', 'Output foder for backup (i.e. D:\backup\)', SetOutputFolder);
	RegisterParam('Input', 'Input script (i.e. weekly.txt)', SetInputScript);
	RegisterParam('Hide', 'Hide all console windows', SetHide);
	InitializeLog;
	LoadEnvironment;
	ReadCommandLine(GetCommandLine);
	if ParamCount = 0 then
	begin
		Warning('No parameter specified. (Backup.exe -Output=D:\backup\ -Input=weekly.txt');
		HelpParams();
	end;
	FreeAndNil(MainLog);
end.
